/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PasswordHasher;
import org.apache.derby.iapi.sql.dictionary.UserDescriptor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.StringUtil;

public abstract class AuthenticationServiceBase
implements AuthenticationService,
ModuleControl,
ModuleSupportable,
PropertySetCallback {
    protected UserAuthenticator authenticationScheme;
    private AccessFactory store;
    public static final String AuthenticationTrace = null;
    protected static final int SECMEC_USRSSBPWD = 8;

    protected void setAuthenticationService(UserAuthenticator userAuthenticator) {
        this.authenticationScheme = userAuthenticator;
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        this.store = (AccessFactory)Monitor.getServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        PropertyFactory propertyFactory = (PropertyFactory)Monitor.getServiceModule(this, "org.apache.derby.iapi.services.property.PropertyFactory");
        if (propertyFactory != null) {
            propertyFactory.addPropertySetNotification(this);
        }
    }

    public void stop() {
    }

    public boolean authenticate(String string2, Properties properties) throws SQLException {
        if (properties == (Properties)null) {
            return false;
        }
        String string3 = properties.getProperty("user");
        if (string3 != null && string3.length() > 128) {
            return false;
        }
        return this.authenticationScheme.authenticateUser(string3, properties.getProperty("password"), string2, properties);
    }

    public String getSystemCredentialsDatabaseName() {
        return null;
    }

    public String getProperty(String string2) {
        String string3 = null;
        TransactionController transactionController = null;
        try {
            transactionController = this.getTransaction();
            string3 = PropertyUtil.getServiceProperty(transactionController, string2, null);
            if (transactionController != null) {
                transactionController.commit();
                transactionController = null;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return string3;
    }

    protected TransactionController getTransaction() throws StandardException {
        if (this.store == null) {
            return null;
        }
        return this.store.getTransaction(ContextService.getFactory().getCurrentContextManager());
    }

    Properties getDatabaseProperties() throws StandardException {
        Properties properties = null;
        TransactionController transactionController = this.getTransaction();
        if (transactionController != null) {
            try {
                properties = transactionController.getProperties();
            }
            finally {
                transactionController.commit();
            }
        }
        return properties;
    }

    protected String getServiceName() {
        if (this.store == null) {
            return null;
        }
        return Monitor.getServiceName(this.store);
    }

    public String getDatabaseProperty(String string2) {
        String string3 = null;
        TransactionController transactionController = null;
        try {
            if (this.store != null) {
                transactionController = this.store.getTransaction(ContextService.getFactory().getCurrentContextManager());
            }
            string3 = PropertyUtil.getDatabaseProperty(transactionController, string2);
            if (transactionController != null) {
                transactionController.commit();
                transactionController = null;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return string3;
    }

    public String getSystemProperty(String string2) {
        boolean bl = false;
        bl = Boolean.valueOf(this.getDatabaseProperty("derby.database.propertiesOnly"));
        if (bl) {
            return null;
        }
        return PropertyUtil.getSystemProperty(string2);
    }

    public void init(boolean bl, Dictionary dictionary) {
    }

    public boolean validate(String string2, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (string2.startsWith("derby.user.")) {
            return true;
        }
        String string3 = (String)((Object)serializable);
        boolean bl = "NATIVE::LOCAL".equals(string3);
        if ("derby.authentication.provider".equals(string2)) {
            String string4;
            DataDictionary dataDictionary;
            UserDescriptor userDescriptor;
            if (string3 != null && string3.startsWith("NATIVE:") && !bl) {
                throw StandardException.newException("XCY05.S.3");
            }
            String string5 = (String)dictionary.get("derby.authentication.provider");
            if (string5 != null && string5.startsWith("NATIVE:")) {
                throw StandardException.newException("XCY05.S.2");
            }
            if (bl && (userDescriptor = (dataDictionary = AuthenticationServiceBase.getDataDictionary()).getUser(string4 = dataDictionary.getAuthorizationDatabaseOwner())) == null) {
                throw StandardException.newException("XCY05.S.3");
            }
        }
        if ("derby.authentication.native.passwordLifetimeMillis".equals(string2) && this.parsePasswordLifetime(string3) == null) {
            throw StandardException.newException("4251J", "derby.authentication.native.passwordLifetimeMillis");
        }
        if ("derby.authentication.native.passwordLifetimeThreshold".equals(string2) && this.parsePasswordThreshold(string3) == null) {
            throw StandardException.newException("4251J", "derby.authentication.native.passwordLifetimeThreshold");
        }
        return false;
    }

    protected Long parsePasswordLifetime(String string2) {
        try {
            long l = Long.parseLong(string2);
            if (l < 0L) {
                l = 0L;
            }
            return new Long(l);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Double parsePasswordThreshold(String string2) {
        try {
            double d = Double.parseDouble(string2);
            if (d <= 0.0) {
                return null;
            }
            return new Double(d);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Serviceable apply(String string2, Serializable serializable, Dictionary dictionary) {
        return null;
    }

    public Serializable map(String string2, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (!string2.startsWith("derby.user.")) {
            return null;
        }
        String string3 = (String)dictionary.get("derby.authentication.provider");
        if (string3 != null && StringUtil.SQLEqualsIgnoreCase(string3, "LDAP")) {
            return null;
        }
        String string4 = (String)((Object)serializable);
        if (string4 != null) {
            String string5 = string2.substring("derby.user.".length());
            string4 = this.hashUsingDefaultAlgorithm(string5, string4, dictionary);
        }
        return string4;
    }

    protected final boolean requireAuthentication(Properties properties) {
        String string2 = PropertyUtil.getPropertyFromSet(properties, "derby.connection.requireAuthentication");
        if (Boolean.valueOf(string2).booleanValue()) {
            return true;
        }
        return PropertyUtil.nativeAuthenticationEnabled(properties);
    }

    protected String hashPasswordSHA1Scheme(String string2) {
        if (string2 == null) {
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        messageDigest.reset();
        byte[] byArray = null;
        byArray = AuthenticationServiceBase.toHexByte(string2);
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        String string3 = "3b60" + StringUtil.toHexString(byArray2, 0, byArray2.length);
        return string3;
    }

    private static byte[] toHexByte(String string2) {
        byte[] byArray = new byte[string2.length() * 2];
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            int n = (c & 0xF0) >>> 4;
            int n2 = c & 0xF;
            byArray[i] = (byte)n;
            byArray[i + 1] = (byte)n2;
        }
        return byArray;
    }

    String hashUsingDefaultAlgorithm(String string2, String string3, Dictionary dictionary) throws StandardException {
        if (string3 == null) {
            return null;
        }
        PasswordHasher passwordHasher = AuthenticationServiceBase.getDataDictionary().makePasswordHasher(dictionary);
        if (passwordHasher != null) {
            return passwordHasher.hashAndEncode(string2, string3);
        }
        return this.hashPasswordSHA1Scheme(string3);
    }

    private static DataDictionary getDataDictionary() {
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        return languageConnectionContext.getDataDictionary();
    }

    protected String substitutePassword(String string2, String string3, Properties properties, boolean bl) {
        byte[] byArray;
        MessageDigest messageDigest = null;
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        messageDigest.reset();
        byte[] byArray3 = null;
        byte[] byArray4 = AuthenticationServiceBase.toHexByte(string2);
        String string4 = properties.getProperty("drdaSecTokenIn");
        String string5 = properties.getProperty("drdaSecTokenOut");
        byte[] byArray5 = StringUtil.fromHexString(string4, 0, string4.length());
        byte[] byArray6 = StringUtil.fromHexString(string5, 0, string5.length());
        String string6 = null;
        if (!bl) {
            byArray3 = AuthenticationServiceBase.toHexByte(string3);
            messageDigest.update(byArray3);
            byArray = messageDigest.digest();
            string6 = "3b60" + StringUtil.toHexString(byArray, 0, byArray.length);
        } else {
            string6 = string3;
        }
        messageDigest.update(byArray4);
        messageDigest.update(AuthenticationServiceBase.toHexByte(string6));
        byArray = messageDigest.digest();
        messageDigest.update(byArray);
        messageDigest.update(byArray6);
        messageDigest.update(byArray5);
        messageDigest.update(byArray4);
        messageDigest.update(byArray2);
        byte[] byArray7 = messageDigest.digest();
        return StringUtil.toHexString(byArray7, 0, byArray7.length);
    }
}

