/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class BinaryArithmeticOperatorNode
extends BinaryOperatorNode {
    public void init(Object object, Object object2) {
        super.init(object, object2, "org.apache.derby.iapi.types.NumberDataValue", "org.apache.derby.iapi.types.NumberDataValue");
    }

    public void setNodeType(int n) {
        String string2 = null;
        String string3 = null;
        switch (n) {
            case 40: {
                string2 = "/";
                string3 = "divide";
                break;
            }
            case 46: {
                string2 = "-";
                string3 = "minus";
                break;
            }
            case 48: {
                string2 = "+";
                string3 = "plus";
                break;
            }
            case 49: {
                string2 = "*";
                string3 = "times";
                break;
            }
            case 194: {
                string2 = "mod";
                string3 = "mod";
                break;
            }
        }
        this.setOperator(string2);
        this.setMethodName(string3);
        super.setNodeType(n);
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List list) throws StandardException {
        super.bindExpression(fromList, subqueryList, list);
        TypeId typeId = this.leftOperand.getTypeId();
        TypeId typeId2 = this.rightOperand.getTypeId();
        DataTypeDescriptor dataTypeDescriptor = this.leftOperand.getTypeServices();
        DataTypeDescriptor dataTypeDescriptor2 = this.rightOperand.getTypeServices();
        if (typeId.isStringTypeId() && typeId2.isNumericTypeId()) {
            boolean bl = dataTypeDescriptor.isNullable() || dataTypeDescriptor2.isNullable();
            int n = dataTypeDescriptor2.getPrecision();
            int n2 = dataTypeDescriptor2.getScale();
            int n3 = dataTypeDescriptor2.getMaximumWidth();
            if (typeId2.isDecimalTypeId()) {
                int n4 = dataTypeDescriptor.getMaximumWidth();
                n2 += n4;
                n3 = (n += 2 * n4) + 3;
            }
            this.leftOperand = (ValueNode)this.getNodeFactory().getNode(60, this.leftOperand, new DataTypeDescriptor(typeId2, n, n2, bl, n3), this.getContextManager());
            ((CastNode)this.leftOperand).bindCastNodeOnly();
        } else if (typeId2.isStringTypeId() && typeId.isNumericTypeId()) {
            boolean bl = dataTypeDescriptor.isNullable() || dataTypeDescriptor2.isNullable();
            int n = dataTypeDescriptor.getPrecision();
            int n5 = dataTypeDescriptor.getScale();
            int n6 = dataTypeDescriptor.getMaximumWidth();
            if (typeId.isDecimalTypeId()) {
                int n7 = dataTypeDescriptor2.getMaximumWidth();
                n5 += n7;
                n6 = (n += 2 * n7) + 3;
            }
            this.rightOperand = (ValueNode)this.getNodeFactory().getNode(60, this.rightOperand, new DataTypeDescriptor(typeId, n, n5, bl, n6), this.getContextManager());
            ((CastNode)this.rightOperand).bindCastNodeOnly();
        }
        this.setType(this.leftOperand.getTypeCompiler().resolveArithmeticOperation(this.leftOperand.getTypeServices(), this.rightOperand.getTypeServices(), this.operator));
        return this;
    }
}

