/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;

public class NextSequenceNode
extends ValueNode {
    private TableName sequenceName;
    private SequenceDescriptor sequenceDescriptor;

    public void init(Object object) throws StandardException {
        this.sequenceName = (TableName)object;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List list, boolean bl) throws StandardException {
        if (this.sequenceDescriptor != null) {
            return this;
        }
        CompilerContext compilerContext = this.getCompilerContext();
        if ((compilerContext.getReliability() & 0x4000) != 0) {
            throw StandardException.newException("42XAH");
        }
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(this.sequenceName.getSchemaName());
        this.sequenceDescriptor = this.getDataDictionary().getSequenceDescriptor(schemaDescriptor, this.sequenceName.getTableName());
        if (this.sequenceDescriptor == null) {
            throw StandardException.newException("42X94", (Object)"SEQUENCE", (Object)this.sequenceName.getFullTableName());
        }
        this.setType(this.sequenceDescriptor.getDataType());
        if (compilerContext.isReferenced(this.sequenceDescriptor)) {
            throw StandardException.newException("42XAI", this.sequenceName.getFullTableName());
        }
        compilerContext.addReferencedSequence(this.sequenceDescriptor);
        NextSequenceNode nextSequenceNode = this;
        this.getCompilerContext().createDependency(this.sequenceDescriptor);
        if (this.isPrivilegeCollectionRequired()) {
            this.getCompilerContext().addRequiredUsagePriv(this.sequenceDescriptor);
        }
        return nextSequenceNode;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        String string2 = this.sequenceDescriptor.getUUID().toString();
        int n = this.sequenceDescriptor.getDataType().getNull().getTypeFormatId();
        methodBuilder.pushThis();
        methodBuilder.push(string2);
        methodBuilder.push(n);
        methodBuilder.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getCurrentValueAndAdvance", "org.apache.derby.iapi.types.NumberDataValue", 2);
    }

    public void generateConstant(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        switch (this.getTypeServices().getJDBCTypeId()) {
            case 4: {
                methodBuilder.push(1);
                break;
            }
        }
    }

    public String toString() {
        return "";
    }

    protected boolean isEquivalent(ValueNode valueNode) throws StandardException {
        return false;
    }
}

