/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.impl.sql.compile.Token;

public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        super("");
        this.specialConstructor = true;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String string2) {
        super(string2);
        this.specialConstructor = false;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String string2 = "";
        int n = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (n < this.expectedTokenSequences[i].length) {
                n = this.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                string2 = string2 + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                string2 = string2 + "...";
            }
            string2 = string2 + this.eol + "    ";
        }
        String string3 = "Encountered \"";
        Token token = this.currentToken.next;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                string3 = string3 + " ";
            }
            if (token.kind == 0) {
                string3 = string3 + this.tokenImage[0];
                break;
            }
            string3 = string3 + this.add_escapes(token.image);
            token = token.next;
        }
        string3 = string3 + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn;
        return string3;
    }

    protected String add_escapes(String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        block11: for (int i = 0; i < string2.length(); ++i) {
            switch (string2.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block11;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block11;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block11;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block11;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block11;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block11;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block11;
                }
                default: {
                    char c = string2.charAt(i);
                    if (c < ' ' || c > '~') {
                        String string3 = "0000" + Integer.toString(c, 16);
                        stringBuffer.append("\\u" + string3.substring(string3.length() - 4, string3.length()));
                        continue block11;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

