/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

public class TableName
extends QueryTreeNode {
    String tableName;
    String schemaName;
    private boolean hasSchema;

    public void init(Object object, Object object2) {
        this.hasSchema = object != null;
        this.schemaName = (String)object;
        this.tableName = (String)object2;
    }

    public void init(Object object, Object object2, Object object3, Object object4) {
        this.init(object, object2);
        this.setBeginOffset((Integer)object3);
        this.setEndOffset((Integer)object4);
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean hasSchema() {
        return this.hasSchema;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string2) {
        this.schemaName = string2;
    }

    public String getFullTableName() {
        if (this.schemaName != null) {
            return this.schemaName + "." + this.tableName;
        }
        return this.tableName;
    }

    public String toString() {
        if (this.hasSchema) {
            return this.getFullTableName();
        }
        return this.tableName;
    }

    public boolean equals(TableName tableName) {
        if (tableName == null) {
            return false;
        }
        String string2 = this.getFullTableName();
        if (string2 == null) {
            return true;
        }
        if (this.schemaName == null || tableName.getSchemaName() == null) {
            return this.tableName.equals(tableName.getTableName());
        }
        return string2.equals(tableName.getFullTableName());
    }

    public boolean equals(String string2, String string3) {
        String string4 = this.getFullTableName();
        if (string4 == null) {
            return true;
        }
        if (this.schemaName == null || string2 == null) {
            return this.tableName.equals(string3);
        }
        return string4.equals(string2 + "." + string3);
    }

    public void bind(DataDictionary dataDictionary) throws StandardException {
        this.schemaName = this.getSchemaDescriptor(this.schemaName).getSchemaName();
    }

    public int hashCode() {
        return this.getFullTableName().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TableName)) {
            return false;
        }
        TableName tableName = (TableName)object;
        return this.getFullTableName().equals(tableName.getFullTableName());
    }
}

