/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication;

import java.util.Date;
import org.apache.derby.iapi.error.ErrorStringBuilder;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;

public class ReplicationLogger {
    private final boolean verbose = PropertyUtil.getSystemBoolean("derby.replication.verbose", true);
    private final String dbname;

    public ReplicationLogger(String string2) {
        this.dbname = string2;
    }

    public void logError(String string2, Throwable throwable) {
        if (this.verbose) {
            Monitor.logTextMessage("R001", new Date());
            if (string2 != null) {
                Monitor.logTextMessage(string2, this.dbname);
            }
            if (throwable != null) {
                ErrorStringBuilder errorStringBuilder = new ErrorStringBuilder(Monitor.getStream().getHeader());
                errorStringBuilder.stackTrace(throwable);
                Monitor.logMessage(errorStringBuilder.get().toString());
                errorStringBuilder.reset();
            }
            Monitor.logTextMessage("R002");
        }
    }

    public void logText(String string2, boolean bl) {
        if (this.verbose) {
            if (bl) {
                Monitor.logTextMessage("R001", new Date());
                Monitor.logMessage(string2);
                Monitor.logTextMessage("R002");
            } else {
                Monitor.logTextMessage("R013", new Date(), string2);
            }
        }
    }
}

