/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.assembler.exceptions;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.assembler.assemblers.AssemblerGroup;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.JenaException;
import org.apache.jena.vocabulary.RDFS;

public class AssemblerException
extends JenaException {
    protected final Resource root;
    protected List<AssemblerGroup.Frame> doing = new ArrayList<AssemblerGroup.Frame>();

    public AssemblerException(Resource root, String string2, Throwable t) {
        super(string2, t);
        this.root = root;
    }

    public AssemblerException(Resource root, String message) {
        super(message);
        this.root = root;
    }

    public Resource getRoot() {
        return this.root;
    }

    public AssemblerException pushDoing(AssemblerGroup.Frame frame) {
        this.doing.add(frame);
        return this;
    }

    protected static String nice(Resource r) {
        String rString = r.asNode().toString(r.getModel());
        return r.isAnon() ? rString + AssemblerException.getLabels(r) : rString;
    }

    private static String getLabels(Resource r) {
        Model m = r.getModel();
        String labels = "";
        String prefix = "labels: ";
        StmtIterator it = r.listProperties(RDFS.label);
        while (it.hasNext()) {
            String label = it.nextStatement().getObject().asNode().toString(m, true);
            labels = labels + prefix + label;
            prefix = ", ";
        }
        return labels.equals("") ? AssemblerException.getIncomingProperty(r) : " [" + labels + "]";
    }

    private static String getIncomingProperty(Resource r) {
        String incomings = "";
        String prefix = "";
        StmtIterator it = r.getModel().listStatements(null, null, r);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            incomings = incomings + prefix + AssemblerException.nice(s.getPredicate()) + " of " + AssemblerException.nice(s.getSubject());
            prefix = ", ";
        }
        return incomings.equals("") ? "" : " [" + incomings + "]";
    }

    protected static String nice(RDFNode r) {
        return r.isLiteral() ? r.asNode().toString() : AssemblerException.nice((Resource)r);
    }

    public List<AssemblerGroup.Frame> getDoing() {
        return this.doing;
    }

    @Override
    public String toString() {
        String parent = super.toString();
        String frame = this.frameStrings();
        return frame.equals("") ? parent : parent + "\n  doing:\n" + frame;
    }

    protected String frameStrings() {
        StringBuilder result = new StringBuilder();
        for (AssemblerGroup.Frame aDoing : this.doing) {
            result.append("    ").append(aDoing.toString()).append("\n");
        }
        return result.toString();
    }
}

