/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.io.File;
import java.nio.file.Paths;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.base.Sys;

public class IRILib {
    private static char[] uri_reserved = new char[]{'!', '*', '\"', '\'', '(', ')', ';', ':', '@', '&', '=', '+', '$', ',', '/', '?', '%', '#', '[', ']'};
    private static char[] uri_non_chars = new char[]{'<', '>', '{', '}', '|', '\\', '`', '^', ' ', '\n', '\r', '\t', '\u00a3'};
    private static char[] charsComponent = new char[]{'!', '*', '\"', '\'', '(', ')', ';', ':', '@', '&', '=', '+', '$', ',', '/', '?', '%', '#', '[', ']', '{', '}', '|', '\\', '`', '^', ' ', '<', '>', '\n', '\r', '\t', '\u00a3'};
    private static char[] charsFilename = new char[]{'!', '*', '\"', '\'', '(', ')', ';', '@', '&', '=', '+', '$', ',', '?', '%', '#', '[', ']', '{', '}', '|', '\\', '`', '^', ' ', '<', '>', '\n', '\r', '\t'};
    private static char[] charsPath = new char[]{'!', '*', '\"', '\'', '(', ')', ';', '@', '&', '=', '+', '$', ',', '?', '%', '#', '[', ']', '{', '}', '|', '\\', '`', '^', ' ', '<', '>', '\n', '\r', '\t'};
    static final String cwd;
    static final String cwdURL;

    public static String fileToIRI(File f) {
        return IRILib.filenameToIRI(f.getAbsolutePath());
    }

    public static String filenameToIRI(String fn) {
        if (fn == null) {
            return cwdURL;
        }
        if (fn.length() == 0) {
            return cwdURL;
        }
        if (fn.startsWith("file:")) {
            return IRILib.normalizeFilenameURI(fn);
        }
        return IRILib.plainFilenameToURL(fn);
    }

    public static String IRIToFilename(String iri) {
        if (!iri.startsWith("file:")) {
            throw new AtlasException("Not a file: URI: " + iri);
        }
        String fn = iri.startsWith("file:///") ? iri.substring("file://".length()) : iri.substring("file:".length());
        return IRILib.decode(fn);
    }

    private static String plainFilenameToURL(String fn) {
        boolean trailingSlash = fn.endsWith("/");
        if (Sys.isWindows && fn.length() >= 3 && fn.charAt(0) == '/' && IRILib.windowsDrive(fn, 1)) {
            fn = fn.substring(1);
        }
        fn = Paths.get(fn, new String[0]).toAbsolutePath().normalize().toString();
        if (trailingSlash && !fn.endsWith("/")) {
            fn = fn + "/";
        }
        if (Sys.isWindows) {
            if (IRILib.windowsDrive(fn, 0)) {
                fn = "/" + fn;
            }
            fn = fn.replace('\\', '/');
        }
        fn = IRILib.encodeFileURL(fn);
        return "file://" + fn;
    }

    private static boolean windowsDrive(String fn, int i) {
        return fn.length() >= 2 + i && fn.charAt(1 + i) == ':' && IRILib.isA2Z(fn.charAt(i));
    }

    private static boolean isA2Z(char ch) {
        return 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z';
    }

    private static String normalizeFilenameURI(String fn) {
        if (!fn.startsWith("file:/")) {
            String fn2 = fn.substring("file:".length());
            return IRILib.plainFilenameToURL(fn2);
        }
        if (fn.startsWith("file:///")) {
            return fn;
        }
        if (fn.startsWith("file://")) {
            String fn2 = fn.substring("file:/".length());
            return IRILib.plainFilenameToURL(fn2);
        }
        String fn2 = fn.substring("file:".length());
        return IRILib.plainFilenameToURL(fn2);
    }

    public static String encodeUriComponent(String string2) {
        String encStr = StrUtils.encodeHex(string2, '%', charsComponent);
        return encStr;
    }

    public static String encodeFileURL(String string2) {
        String encStr = StrUtils.encodeHex(string2, '%', charsFilename);
        return encStr;
    }

    public static String encodeUriPath(String uri) {
        uri = StrUtils.encodeHex(uri, '%', charsPath);
        return uri;
    }

    public static String decode(String string2) {
        return StrUtils.decodeHex(string2, '%');
    }

    public static String encodeNonASCII(String string2) {
        if (!IRILib.containsNonASCII(string2)) {
            return string2;
        }
        byte[] bytes = StrUtils.asUTF8bytes(string2);
        StringBuilder sw = new StringBuilder();
        for (byte b : bytes) {
            if (b > 0) {
                sw.append((char)b);
                continue;
            }
            int hi = (b & 0xF0) >> 4;
            int lo = b & 0xF;
            sw.append('%');
            sw.append(Chars.hexDigitsUC[hi]);
            sw.append(Chars.hexDigitsUC[lo]);
        }
        return sw.toString();
    }

    public static boolean containsNonASCII(String string2) {
        for (int i = 0; i < string2.length(); ++i) {
            char ch = string2.charAt(i);
            if (ch < '\u007f') continue;
            return true;
        }
        return false;
    }

    static {
        String x = new File(".").getAbsolutePath();
        cwd = x = x.substring(0, x.length() - 1);
        cwdURL = IRILib.plainFilenameToURL(cwd);
    }
}

