/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;

public class DynamicGraph<T> {
    private static final boolean DEBUG = false;
    private List<T> m_nodesReady = Lists.newArrayList();
    private List<T> m_nodesRunning = Lists.newArrayList();
    private List<T> m_nodesFinished = Lists.newArrayList();
    private Comparator<? super T> m_nodeComparator = null;
    private ListMultiMap<T, T> m_dependedUpon = Maps.newListMultiMap();
    private ListMultiMap<T, T> m_dependingOn = Maps.newListMultiMap();

    public void setComparator(Comparator<? super T> c) {
        this.m_nodeComparator = c;
    }

    public void addNode(T node) {
        this.m_nodesReady.add(node);
    }

    public void addEdge(T from, T to) {
        this.m_dependingOn.put(to, from);
        this.m_dependedUpon.put(from, to);
    }

    public List<T> getFreeNodes() {
        List result = Lists.newArrayList();
        for (T m : this.m_nodesReady) {
            List du = (List)this.m_dependedUpon.get(m);
            if (!this.m_dependedUpon.containsKey(m)) {
                result.add(m);
                continue;
            }
            if (this.getUnfinishedNodes(du).size() != 0) continue;
            result.add(m);
        }
        if (result != null && !result.isEmpty() && this.m_nodeComparator != null) {
            Collections.sort(result, this.m_nodeComparator);
            DynamicGraph.ppp("Nodes after sorting:" + result.get(0));
        }
        return result;
    }

    private Collection<? extends T> getUnfinishedNodes(List<T> nodes) {
        Set result = Sets.newHashSet();
        for (T node : nodes) {
            if (!this.m_nodesReady.contains(node) && !this.m_nodesRunning.contains(node)) continue;
            result.add(node);
        }
        return result;
    }

    public void setStatus(Collection<T> nodes, Status status) {
        for (T n : nodes) {
            this.setStatus(n, status);
        }
    }

    public void setStatus(T node, Status status) {
        this.removeNode(node);
        switch (status) {
            case READY: {
                this.m_nodesReady.add(node);
                break;
            }
            case RUNNING: {
                this.m_nodesRunning.add(node);
                break;
            }
            case FINISHED: {
                this.m_nodesFinished.add(node);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void removeNode(T node) {
        if (!this.m_nodesReady.remove(node) && !this.m_nodesRunning.remove(node)) {
            this.m_nodesFinished.remove(node);
        }
    }

    public int getNodeCount() {
        int result = this.m_nodesReady.size() + this.m_nodesRunning.size() + this.m_nodesFinished.size();
        return result;
    }

    public int getNodeCountWithStatus(Status status) {
        switch (status) {
            case READY: {
                return this.m_nodesReady.size();
            }
            case RUNNING: {
                return this.m_nodesRunning.size();
            }
            case FINISHED: {
                return this.m_nodesFinished.size();
            }
        }
        throw new IllegalArgumentException();
    }

    private static void ppp(String string2) {
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[DynamicGraph ");
        result.append("\n  Ready:" + this.m_nodesReady);
        result.append("\n  Running:" + this.m_nodesRunning);
        result.append("\n  Finished:" + this.m_nodesFinished);
        result.append("\n  Edges:\n");
        for (Map.Entry es : this.m_dependingOn.entrySet()) {
            result.append("     " + es.getKey() + "\n");
            for (Object t : (List)es.getValue()) {
                result.append("        " + t + "\n");
            }
        }
        result.append("]");
        return result.toString();
    }

    private String getName(T t) {
        String s = t.toString();
        int n1 = s.lastIndexOf(46) + 1;
        int n2 = s.indexOf(40);
        return s.substring(n1, n2);
    }

    public String toDot() {
        String color;
        String FREE = "[style=filled color=yellow]";
        String RUNNING = "[style=filled color=green]";
        String FINISHED = "[style=filled color=grey]";
        StringBuilder result = new StringBuilder("digraph g {\n");
        List<T> freeNodes = this.getFreeNodes();
        for (T n : this.m_nodesReady) {
            color = freeNodes.contains(n) ? FREE : "";
            result.append("  " + this.getName(n) + color + "\n");
        }
        for (T n : this.m_nodesRunning) {
            color = freeNodes.contains(n) ? FREE : RUNNING;
            result.append("  " + this.getName(n) + color + "\n");
        }
        for (T n : this.m_nodesFinished) {
            result.append("  " + this.getName(n) + FINISHED + "\n");
        }
        result.append("\n");
        for (Object k : this.m_dependingOn.keySet()) {
            List nodes = (List)this.m_dependingOn.get(k);
            for (Object n : nodes) {
                String dotted = this.m_nodesFinished.contains(k) ? "style=dotted" : "";
                result.append("  " + this.getName(k) + " -> " + this.getName(n) + " [dir=back " + dotted + "]\n");
            }
        }
        result.append("}\n");
        return result.toString();
    }

    public ListMultiMap<T, T> getEdges() {
        return this.m_dependingOn;
    }

    public static enum Status {
        READY,
        RUNNING,
        FINISHED;

    }
}

