/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import com.occamlab.te.CtlErrorHandler;
import com.occamlab.te.SetupOptions;
import com.occamlab.te.index.Index;
import com.occamlab.te.util.Misc;
import com.occamlab.te.util.XMLParserUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class Generator {
    private static final Logger LOGR = Logger.getLogger(Generator.class.getName());
    private static String suiteDefaultResult = "Pass";

    public static void setSuiteDefaultResult(String resultName) {
        suiteDefaultResult = resultName.equals("BestPractice") ? "BestPractice" : "Pass";
    }

    public static String getSuiteDefaultResult() {
        return suiteDefaultResult;
    }

    public static Index generateDocXsl(SetupOptions opts) throws Exception {
        return Generator.generateXsl(opts, "com/occamlab/te/generate_dxsl.xsl", true);
    }

    public static Index generateXsl(SetupOptions opts) throws Exception {
        return Generator.generateXsl(opts, "com/occamlab/te/generate_xsl.xsl", false);
    }

    private static Index generateXsl(SetupOptions opts, String generatorStylesheetResource, boolean docMode) throws Exception {
        Index masterIndex = new Index();
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema ctl_schema = sf.newSchema(new StreamSource(Misc.getResourceURL("com/occamlab/te/schemas/ctl.xsd")));
        Validator ctl_validator = ctl_schema.newValidator();
        CtlErrorHandler validation_eh = new CtlErrorHandler();
        ctl_validator.setErrorHandler(validation_eh);
        Processor processor = new Processor(false);
        processor.setConfigurationProperty("http://saxon.sf.net/feature/linenumbering", Boolean.TRUE);
        XsltCompiler generatorCompiler = processor.newXsltCompiler();
        XsltExecutable generatorXsltExecutable = generatorCompiler.compile(new StreamSource(Misc.getResourceURL(generatorStylesheetResource)));
        XsltTransformer generatorTransformer = generatorXsltExecutable.load();
        ArrayList<File> sources = new ArrayList<File>();
        File f = Misc.getResourceAsFile("com/occamlab/te/scripts/parsers.ctl");
        if (f.exists()) {
            sources.add(f.getParentFile());
        }
        sources.addAll(opts.getSources());
        ArrayList<File> sourceFiles = new ArrayList<File>();
        ArrayList<File> workDirs = new ArrayList<File>();
        for (File source : sources) {
            File workingDir;
            LOGR.log(Level.FINE, "Processing CTL source files in {0}", source.getAbsolutePath());
            Object encodedName = Generator.createEncodedName(source);
            if (docMode) {
                encodedName = (String)encodedName + "d";
            }
            if (!(workingDir = new File(opts.getWorkDir(), (String)encodedName)).exists() && !workingDir.mkdir()) {
                LOGR.log(Level.WARNING, "Unable to create working directory at {0}", workingDir.getAbsolutePath());
            }
            if (source.isDirectory()) {
                String[] children = source.list();
                for (int i = 0; i < children.length; ++i) {
                    File file;
                    String lowerName = children[i].toLowerCase();
                    if (!lowerName.endsWith(".ctl") && !lowerName.endsWith(".xml") || !(file = new File(source, children[i])).isFile()) continue;
                    sourceFiles.add(file);
                    String basename = children[i].substring(0, children[i].length() - 4);
                    File subdir = new File(workingDir, basename);
                    subdir.mkdir();
                    workDirs.add(subdir);
                }
                continue;
            }
            sourceFiles.add(source);
            workDirs.add(workingDir);
        }
        SAXParser parser = XMLParserUtils.createXIncludeAwareSAXParser(false);
        File generatorStylesheet = Misc.getResourceAsFile(generatorStylesheetResource);
        for (int i = 0; i < sourceFiles.size(); ++i) {
            File sourceFile = (File)sourceFiles.get(i);
            File workingDir = (File)workDirs.get(i);
            File indexFile = new File(workingDir, "index.xml");
            Index index = null;
            boolean regenerate = true;
            if (generatorStylesheet == null) {
                regenerate = true;
            } else if (indexFile.isFile()) {
                try {
                    if (indexFile.lastModified() > generatorStylesheet.lastModified()) {
                        index = new Index(indexFile);
                        regenerate = index.outOfDate();
                    }
                }
                catch (Exception e) {
                    regenerate = true;
                }
            }
            if (regenerate) {
                boolean validationErrors = false;
                if (opts.isValidate()) {
                    int old_count = validation_eh.getErrorCount();
                    LOGR.log(Level.CONFIG, "Validating " + sourceFile);
                    ctl_validator.validate(new StreamSource(sourceFile));
                    boolean bl = validationErrors = validation_eh.getErrorCount() > old_count;
                }
                if (!validationErrors) {
                    Misc.deleteDirContents(workingDir);
                    InputSource input = new InputSource(new FileInputStream(sourceFile));
                    input.setSystemId(sourceFile.toURI().toString());
                    XMLReader reader = parser.getXMLReader();
                    reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    SAXSource ctlSource = new SAXSource(reader, input);
                    generatorTransformer.setSource(ctlSource);
                    Serializer generatorSerializer = new Serializer();
                    generatorSerializer.setOutputFile(indexFile);
                    generatorTransformer.setDestination(generatorSerializer);
                    XdmAtomicValue av = new XdmAtomicValue(workingDir.getAbsolutePath());
                    generatorTransformer.setParameter(new QName("outdir"), av);
                    generatorTransformer.transform();
                    index = new Index(indexFile);
                }
            }
            masterIndex.add(index);
        }
        int error_count = validation_eh.getErrorCount();
        if (error_count > 0) {
            String msg = error_count + " validation error" + (error_count == 1 ? "" : "s");
            int warning_count = validation_eh.getWarningCount();
            if (warning_count > 0) {
                msg = msg + " and " + warning_count + " warning" + (warning_count == 1 ? "" : "s");
            }
            msg = msg + " detected.";
            throw new Exception(msg);
        }
        return masterIndex;
    }

    public static String createEncodedName(File source) {
        String fileURI = source.toURI().toString();
        String userDirURI = new File(System.getProperty("user.dir")).toURI().toString();
        fileURI = fileURI.replace(userDirURI, "");
        return fileURI.substring(fileURI.lastIndexOf(58) + 1).replace("%20", "-").replace('/', '_');
    }
}

