/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem;

import java.util.ConcurrentModificationException;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem.HashCommon;
import org.apache.jena.mem.TripleBunch;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;

public class ArrayBunch
implements TripleBunch {
    protected int size = 0;
    protected Triple[] elements = new Triple[5];
    protected volatile int changes = 0;

    @Override
    public boolean containsBySameValueAs(Triple t2) {
        int i = this.size;
        while (i > 0) {
            if (!t2.matches(this.elements[--i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Triple t2) {
        int i = this.size;
        while (i > 0) {
            if (!t2.equals(this.elements[--i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void add(Triple t2) {
        if (this.size == this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = t2;
        ++this.changes;
    }

    protected void grow() {
        Triple[] newElements = new Triple[this.size + 4];
        System.arraycopy(this.elements, 0, newElements, 0, this.size);
        this.elements = newElements;
    }

    @Override
    public void remove(Triple t2) {
        ++this.changes;
        for (int i = 0; i < this.size; ++i) {
            if (!t2.equals(this.elements[i])) continue;
            this.elements[i] = this.elements[--this.size];
            return;
        }
    }

    @Override
    public ExtendedIterator<Triple> iterator() {
        return this.iterator(new HashCommon.NotifyEmpty(){

            @Override
            public void emptied() {
            }
        });
    }

    @Override
    public ExtendedIterator<Triple> iterator(final HashCommon.NotifyEmpty container) {
        return new NiceIterator<Triple>(){
            protected final int initialChanges;
            protected int i;
            {
                this.initialChanges = ArrayBunch.this.changes;
                this.i = ArrayBunch.this.size;
            }

            @Override
            public boolean hasNext() {
                return 0 < this.i;
            }

            @Override
            public Triple next() {
                if (ArrayBunch.this.changes != this.initialChanges) {
                    throw new ConcurrentModificationException();
                }
                if (this.i == 0) {
                    this.noElements("no elements left in ArrayBunch iteration");
                }
                return ArrayBunch.this.elements[--this.i];
            }

            @Override
            public void forEachRemaining(Consumer<? super Triple> action) {
                while (0 < this.i--) {
                    action.accept(ArrayBunch.this.elements[this.i]);
                }
                if (ArrayBunch.this.changes != this.initialChanges) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public void remove() {
                if (ArrayBunch.this.changes != this.initialChanges) {
                    throw new ConcurrentModificationException();
                }
                int last = --ArrayBunch.this.size;
                ArrayBunch.this.elements[this.i] = ArrayBunch.this.elements[last];
                ArrayBunch.this.elements[last] = null;
                if (ArrayBunch.this.size == 0) {
                    container.emptied();
                }
            }
        };
    }

    @Override
    public Spliterator<Triple> spliterator() {
        return new Spliterator<Triple>(){
            protected final int initialChanges;
            int i;
            {
                this.initialChanges = ArrayBunch.this.changes;
                this.i = ArrayBunch.this.size;
            }

            @Override
            public boolean tryAdvance(Consumer<? super Triple> action) {
                if (0 < this.i) {
                    action.accept(ArrayBunch.this.elements[--this.i]);
                    if (ArrayBunch.this.changes != this.initialChanges) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
                return false;
            }

            @Override
            public void forEachRemaining(Consumer<? super Triple> action) {
                while (0 < this.i--) {
                    action.accept(ArrayBunch.this.elements[this.i]);
                }
                if (ArrayBunch.this.changes != this.initialChanges) {
                    throw new ConcurrentModificationException();
                }
            }

            @Override
            public Spliterator<Triple> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return this.i;
            }

            @Override
            public long getExactSizeIfKnown() {
                return this.i;
            }

            @Override
            public int characteristics() {
                return 1345;
            }
        };
    }
}

