/*
 * Decompiled with CFR 0.152.
 */
package com.galdosinc.glib.gml.bbox;

import com.galdosinc.glib.gml.bbox.BoundingBoxException;
import com.galdosinc.glib.gml.coord.CoordinateException;
import com.galdosinc.glib.gml.coord.CoordinateTupleLinkedList;
import com.galdosinc.glib.gml.coord.CoordinateTupleList;
import com.galdosinc.glib.gml.coord.CoordinateUtils;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public class BoundingBox {
    private boolean padded_;
    private static final double PADDING_CONSTANT = 1.0E-6;
    private static final double[] EMPTY_BOX_COORDINATES = new double[0];
    private double[] lowerLeft_d;
    private double[] upperRight_d;

    public BoundingBox(double[] lowerLeft, double[] upperRight) {
        this.lowerLeft_d = CoordinateUtils.cloneCoordinateArray(lowerLeft, 0, lowerLeft.length);
        this.upperRight_d = CoordinateUtils.cloneCoordinateArray(upperRight, 0, upperRight.length);
    }

    public BoundingBox() {
        this.initialize();
    }

    public int getDimension() {
        return this.lowerLeft_d.length;
    }

    public BoundingBox(CoordinateTupleList coTupleList) throws BoundingBoxException {
        this();
        this.compute(coTupleList);
    }

    public BoundingBox(Element boxElement) throws BoundingBoxException {
        this();
        if (!boxElement.getLocalName().equals("Box") && !boxElement.getLocalName().equals("Envelope") || boxElement.getNamespaceURI().equals("http://www.opengis.net/gml")) {
            throw new BoundingBoxException("The passed element " + boxElement.getLocalName() + " is neither gml:Box nor gml:Envelope");
        }
        CoordinateTupleLinkedList coTupleList = new CoordinateTupleLinkedList();
        try {
            Object coReaderObject = CoordinateUtils.readAllCoordinatesFromGeometry(boxElement, coTupleList);
        }
        catch (CoordinateException ce) {
            throw new BoundingBoxException("Could not instantiate a bounding box.", ce);
        }
        this.compute(coTupleList);
    }

    public static BoundingBox generateFromGmlObject(Element gmlObject) throws BoundingBoxException {
        CoordinateTupleLinkedList coTupleList = new CoordinateTupleLinkedList();
        try {
            CoordinateUtils.readAllCoordinatesBlindly(gmlObject, coTupleList);
        }
        catch (CoordinateException ce) {
            throw new BoundingBoxException("Could not compute the bounding box of GML object " + gmlObject.getLocalName(), ce);
        }
        BoundingBox bbox = new BoundingBox(coTupleList);
        return bbox;
    }

    private void initialize() {
        this.lowerLeft_d = EMPTY_BOX_COORDINATES;
        this.upperRight_d = EMPTY_BOX_COORDINATES;
    }

    public boolean isEmpty() {
        return this.lowerLeft_d.length == 0;
    }

    public void union(BoundingBox bbox) throws BoundingBoxException {
        if (this.padded_) {
            throw new BoundingBoxException("The bounding box was padded because it was a point and now it is invalid to use it in bbox unions.");
        }
        if (bbox.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.setBoundingBox(bbox);
            return;
        }
        if (this.getDimension() != bbox.getDimension()) {
            throw new BoundingBoxException("Cannot union bounding boxes of different dimensions " + this.getDimension() + " and " + bbox.getDimension());
        }
        this.internalUnion(bbox.getLowerLeftTuple());
        this.internalUnion(bbox.getUpperRight());
    }

    public void union(double[] otherPoint) throws BoundingBoxException {
        if (this.padded_) {
            throw new BoundingBoxException("The bounding box was padded because it was a point and now it is invalid to use it in bbox unions.");
        }
        this.internalUnion(otherPoint);
    }

    private void internalUnion(double[] otherPoint) {
        int ii;
        for (ii = 0; ii < otherPoint.length; ++ii) {
            if (!(this.lowerLeft_d[ii] > otherPoint[ii])) continue;
            this.lowerLeft_d[ii] = otherPoint[ii];
        }
        for (ii = 0; ii < otherPoint.length; ++ii) {
            if (!(this.upperRight_d[ii] < otherPoint[ii])) continue;
            this.upperRight_d[ii] = otherPoint[ii];
        }
    }

    public void setBoundingBox(BoundingBox bbox) throws BoundingBoxException {
        this.padded_ = false;
        if (bbox.isEmpty()) {
            this.initialize();
            return;
        }
        int otherBoxDim = bbox.getDimension();
        if (this.getDimension() != otherBoxDim) {
            this.lowerLeft_d = CoordinateUtils.cloneCoordinateArray(bbox.getLowerLeftTuple(), 0, otherBoxDim);
            this.upperRight_d = CoordinateUtils.cloneCoordinateArray(bbox.getUpperRight(), 0, otherBoxDim);
        } else {
            CoordinateUtils.coordinateArrayCopy(bbox.getLowerLeftTuple(), 0, this.lowerLeft_d, 0, otherBoxDim);
            CoordinateUtils.coordinateArrayCopy(bbox.getUpperRight(), 0, this.upperRight_d, 0, otherBoxDim);
        }
    }

    public double[] getLowerLeftTuple() {
        return this.lowerLeft_d;
    }

    public double[] getUpperRight() {
        return this.upperRight_d;
    }

    public double getMinX() {
        return this.lowerLeft_d[0];
    }

    public double getMinY() {
        return this.lowerLeft_d[1];
    }

    public double getMaxX() {
        return this.upperRight_d[0];
    }

    public double getMaxY() {
        return this.upperRight_d[1];
    }

    private void compute(CoordinateTupleList coTupleList) {
        if (coTupleList.getCoordinateTupleCount() == 0) {
            return;
        }
        List seqList = coTupleList.asSequentialAccessList(true);
        Iterator coIter = seqList.iterator();
        int dim = coTupleList.getDimension();
        if (dim == -1) {
            dim = 0;
        }
        this.lowerLeft_d = new double[dim];
        this.upperRight_d = new double[dim];
        double[] firstTuple = (double[])coIter.next();
        CoordinateUtils.coordinateArrayCopy(firstTuple, 0, this.lowerLeft_d, 0, dim);
        CoordinateUtils.coordinateArrayCopy(firstTuple, 0, this.upperRight_d, 0, dim);
        while (coIter.hasNext()) {
            double[] nextTuple = (double[])coIter.next();
            this.internalUnion(nextTuple);
        }
    }

    public void pad() {
        if (CoordinateUtils.coordinateArraysEqual(this.lowerLeft_d, this.upperRight_d)) {
            this.padded_ = true;
            int ii = 0;
            while (ii < this.upperRight_d.length) {
                int n = ii++;
                this.upperRight_d[n] = this.upperRight_d[n] + 1.0E-6;
            }
        }
    }

    public BoundingBox cloneBBox() {
        return new BoundingBox(this.getLowerLeftTuple(), this.getUpperRight());
    }
}

