/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.dom.DOMSender;
import net.sf.saxon.dom.DOMWriter;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMObjectModel
implements ExternalObjectModel,
Serializable {
    public boolean isRecognizedNode(Object object) {
        return object instanceof Node && !(object instanceof NodeOverNodeInfo);
    }

    public boolean isRecognizedNodeClass(Class nodeClass) {
        return Node.class.isAssignableFrom(nodeClass) && !NodeOverNodeInfo.class.isAssignableFrom(nodeClass);
    }

    public boolean isRecognizedNodeListClass(Class nodeClass) {
        return NodeList.class.isAssignableFrom(nodeClass);
    }

    public Receiver getDocumentBuilder(Result result) throws XPathException {
        if (result instanceof DOMResult) {
            DOMWriter emitter = new DOMWriter();
            Node root = ((DOMResult)result).getNode();
            if (root == null) {
                try {
                    DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
                    Document out = docBuilder.newDocument();
                    ((DOMResult)result).setNode(out);
                    emitter.setNode(out);
                }
                catch (ParserConfigurationException e) {
                    throw new XPathException(e);
                }
            } else {
                emitter.setNode(root);
            }
            return emitter;
        }
        return null;
    }

    public boolean sendSource(Source source, Receiver receiver, PipelineConfiguration pipe) throws XPathException {
        if (source instanceof DOMSource) {
            Node startNode = ((DOMSource)source).getNode();
            DOMSender driver = new DOMSender();
            driver.setStartNode(startNode);
            driver.setReceiver(receiver);
            driver.setPipelineConfiguration(pipe);
            driver.setSystemId(source.getSystemId());
            driver.send();
            return true;
        }
        return false;
    }

    public NodeInfo unravel(Source source, Configuration config) {
        Node dsnode;
        if (source instanceof DOMSource && !((dsnode = ((DOMSource)source).getNode()) instanceof NodeOverNodeInfo)) {
            Document dom = dsnode.getNodeType() == 9 ? (Document)dsnode : dsnode.getOwnerDocument();
            DocumentWrapper docWrapper = new DocumentWrapper((Node)dom, source.getSystemId(), config);
            return docWrapper.wrap(dsnode);
        }
        return null;
    }

    public NodeInfo wrapOrUnwrapNode(Node node, Configuration config) throws XPathException {
        if (node instanceof NodeOverNodeInfo) {
            return ((NodeOverNodeInfo)node).getUnderlyingNodeInfo();
        }
        DocumentInfo doc = this.wrapDocument(node, "", config);
        return this.wrapNode(doc, node);
    }

    public Value convertObjectToXPathValue(Object object, Configuration config) throws XPathException {
        if (object instanceof NodeList && !(object instanceof Node)) {
            NodeList list = (NodeList)object;
            int len = list.getLength();
            Item[] nodes = new NodeInfo[len];
            for (int i = 0; i < len; ++i) {
                if (list.item(i) instanceof NodeOverNodeInfo) {
                    nodes[i] = ((NodeOverNodeInfo)list.item(i)).getUnderlyingNodeInfo();
                    continue;
                }
                DocumentInfo doc = this.wrapDocument(list.item(i), "", config);
                NodeInfo node = this.wrapNode(doc, list.item(i));
                nodes[i] = node;
            }
            return new SequenceExtent(nodes);
        }
        return null;
    }

    public Object convertXPathValueToObject(Value value, Class target, XPathContext context) throws XPathException {
        Item item;
        boolean allowDOM;
        boolean requireDOM = Node.class.isAssignableFrom(target) || target == NodeList.class || target.isArray() && Node.class.isAssignableFrom(target.getComponentType());
        boolean bl = allowDOM = target == Object.class || target.isAssignableFrom(ArrayList.class) || target.isAssignableFrom(HashSet.class) || target.isArray() && target.getComponentType() == Object.class;
        if (!requireDOM && !allowDOM) {
            return null;
        }
        ArrayList<Object> nodes = new ArrayList<Object>(20);
        SequenceIterator iter = value.iterate();
        while ((item = iter.next()) != null) {
            if (item instanceof VirtualNode) {
                Object o = ((VirtualNode)item).getUnderlyingNode();
                if (o instanceof Node) {
                    nodes.add(o);
                    continue;
                }
                if (!requireDOM) continue;
                XPathException err = new XPathException("Extension function required class " + target.getName() + "; supplied value of class " + item.getClass().getName() + " could not be converted");
                throw err;
            }
            if (requireDOM) {
                if (item instanceof NodeInfo) {
                    nodes.add(NodeOverNodeInfo.wrap((NodeInfo)item));
                    continue;
                }
                XPathException err = new XPathException("Extension function required class " + target.getName() + "; supplied value of class " + item.getClass().getName() + " could not be converted");
                throw err;
            }
            return null;
        }
        if (nodes.size() == 0 && !requireDOM) {
            return null;
        }
        if (Node.class.isAssignableFrom(target)) {
            if (nodes.size() != 1) {
                XPathException err = new XPathException("Extension function requires a single DOM Node; supplied value contains " + nodes.size() + " nodes");
                throw err;
            }
            return nodes.get(0);
        }
        if (target == NodeList.class) {
            return new DOMNodeList(nodes);
        }
        if (target.isArray() && target.getComponentType() == Node.class) {
            Node[] array = new Node[nodes.size()];
            nodes.toArray(array);
            return array;
        }
        if (target.isAssignableFrom(ArrayList.class)) {
            return nodes;
        }
        if (target.isAssignableFrom(HashSet.class)) {
            return new HashSet(nodes);
        }
        return null;
    }

    public DocumentInfo wrapDocument(Object node, String baseURI, Configuration config) {
        if (node instanceof DocumentOverNodeInfo) {
            return (DocumentInfo)((DocumentOverNodeInfo)node).getUnderlyingNodeInfo();
        }
        if (node instanceof NodeOverNodeInfo) {
            return ((NodeOverNodeInfo)node).getUnderlyingNodeInfo().getDocumentRoot();
        }
        if (node instanceof Node) {
            if (((Node)node).getNodeType() == 9) {
                Document doc = (Document)node;
                return new DocumentWrapper((Node)doc, baseURI, config);
            }
            if (((Node)node).getNodeType() == 11) {
                DocumentFragment doc = (DocumentFragment)node;
                return new DocumentWrapper((Node)doc, baseURI, config);
            }
            Document doc = ((Node)node).getOwnerDocument();
            return new DocumentWrapper((Node)doc, baseURI, config);
        }
        throw new IllegalArgumentException("Unknown node class " + node.getClass());
    }

    public NodeInfo wrapNode(DocumentInfo document, Object node) {
        return ((DocumentWrapper)document).wrap((Node)node);
    }

    public Object convertToNodeList(SequenceExtent extent) {
        try {
            DOMNodeList nodeList = DOMNodeList.checkAndMake(extent);
            return nodeList;
        }
        catch (XPathException e) {
            return null;
        }
    }
}

