/*
 * Decompiled with CFR 0.152.
 */
package com.galdosinc.glib.gml.schema;

import com.galdosinc.glib.gml.schema.SchemaErrorHandler;
import com.galdosinc.glib.xml.QName;
import com.galdosinc.glib.xml.XmlUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DomSchemaErrorHandler
implements SchemaErrorHandler {
    public static final String SCHEMA_VALIDATION_REPORT_NS_URI = "http://www.galdosinc.com/xml/schema/validation/report";
    private boolean errorsReported = false;
    private List schemaErrors = new ArrayList();
    private Map elementErrors = new HashMap();

    @Override
    public void error(String message) {
        this.schemaErrors.add(message);
        this.errorsReported = true;
    }

    @Override
    public void error(String namespaceUri, String localName, String message) {
        QName qName = new QName(namespaceUri, localName);
        ArrayList<String> elementErrorList = (ArrayList<String>)this.elementErrors.get(qName);
        if (elementErrorList == null) {
            elementErrorList = new ArrayList<String>();
            this.elementErrors.put(qName, elementErrorList);
        }
        elementErrorList.add(message);
        this.errorsReported = true;
    }

    @Override
    public boolean hasErrors() {
        return this.errorsReported;
    }

    public Element toDomElement() {
        return this.toDomDocument().getDocumentElement();
    }

    public Document toDomDocument() {
        Document document = XmlUtils.getJaxpDocBuilder().newDocument();
        Element validationResult = document.createElementNS(SCHEMA_VALIDATION_REPORT_NS_URI, "SchemaValidationReport");
        validationResult.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", SCHEMA_VALIDATION_REPORT_NS_URI);
        document.appendChild(validationResult);
        this.addErrors(document, validationResult, this.schemaErrors);
        for (QName qName : this.elementErrors.keySet()) {
            Element elementResult = document.createElementNS(SCHEMA_VALIDATION_REPORT_NS_URI, "ElementReport");
            validationResult.appendChild(elementResult);
            elementResult.setAttributeNS(SCHEMA_VALIDATION_REPORT_NS_URI, "namespaceUri", qName.getNamespaceUri());
            elementResult.setAttributeNS(SCHEMA_VALIDATION_REPORT_NS_URI, "name", qName.getLocalName());
            this.addErrors(document, elementResult, (List)this.elementErrors.get(qName));
        }
        return document;
    }

    private void addErrors(Document document, Element parent, List errors) {
        for (String message : errors) {
            Element errorElement = document.createElementNS(SCHEMA_VALIDATION_REPORT_NS_URI, "Error");
            parent.appendChild(errorElement);
            errorElement.appendChild(document.createTextNode(message));
        }
    }
}

