/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ArithmeticExpression10;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.NegateExpression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.UntypedAtomicConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class ArithmeticExpression
extends BinaryExpression {
    private Calculator calculator;
    private boolean simplified = false;

    public ArithmeticExpression(Expression p0, int operator, Expression p1) {
        super(p0, operator, p1);
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        AtomicValue val;
        if (this.simplified) {
            return this;
        }
        this.simplified = true;
        Expression e = super.simplify(visitor);
        if (e == this && visitor.getStaticContext().isInBackwardsCompatibleMode()) {
            return new ArithmeticExpression10(this.operand0, this.operator, this.operand1);
        }
        if (this.operator == 199 && Literal.isAtomic(this.operand1) && (val = (AtomicValue)((Literal)this.operand1).getValue()) instanceof NumericValue) {
            return new Literal(((NumericValue)val).negate());
        }
        return e;
    }

    public Calculator getCalculator() {
        return this.calculator;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression oldOp0 = this.operand0;
        Expression oldOp1 = this.operand1;
        this.operand0 = visitor.typeCheck(this.operand0, contextItemType);
        this.operand1 = visitor.typeCheck(this.operand1, contextItemType);
        SequenceType atomicType = SequenceType.OPTIONAL_ATOMIC;
        RoleLocator role0 = new RoleLocator(1, Token.tokens[this.operator], 0, null);
        role0.setSourceLocator(this);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, atomicType, false, role0, visitor);
        ItemType itemType0 = this.operand0.getItemType(th);
        if (itemType0 instanceof EmptySequenceTest) {
            return new Literal(EmptySequence.getInstance());
        }
        AtomicType type0 = (AtomicType)itemType0.getPrimitiveItemType();
        if (type0.getFingerprint() == 631) {
            this.operand0 = new UntypedAtomicConverter(this.operand0, BuiltInAtomicType.DOUBLE, true);
            type0 = BuiltInAtomicType.DOUBLE;
        } else if (!(this.operand0 instanceof UntypedAtomicConverter) && th.relationship(type0, BuiltInAtomicType.UNTYPED_ATOMIC) != 4) {
            this.operand0 = new UntypedAtomicConverter(this.operand0, BuiltInAtomicType.DOUBLE, false);
            type0 = (AtomicType)this.operand0.getItemType(th);
        }
        RoleLocator role1 = new RoleLocator(1, Token.tokens[this.operator], 1, null);
        role1.setSourceLocator(this);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, atomicType, false, role1, visitor);
        ItemType itemType1 = this.operand1.getItemType(th);
        if (itemType1 instanceof EmptySequenceTest) {
            return new Literal(EmptySequence.getInstance());
        }
        AtomicType type1 = (AtomicType)itemType1.getPrimitiveItemType();
        if (type1.getFingerprint() == 631) {
            this.operand1 = new UntypedAtomicConverter(this.operand1, BuiltInAtomicType.DOUBLE, true);
            type1 = BuiltInAtomicType.DOUBLE;
        } else if (!(this.operand1 instanceof UntypedAtomicConverter) && th.relationship(type1, BuiltInAtomicType.UNTYPED_ATOMIC) != 4) {
            this.operand1 = new UntypedAtomicConverter(this.operand1, BuiltInAtomicType.DOUBLE, false);
            type1 = (AtomicType)this.operand1.getItemType(th);
        }
        if (this.operand0 != oldOp0) {
            this.adoptChildExpression(this.operand0);
        }
        if (this.operand1 != oldOp1) {
            this.adoptChildExpression(this.operand1);
        }
        if (Literal.isEmptySequence(this.operand0) || Literal.isEmptySequence(this.operand1)) {
            return new Literal(EmptySequence.getInstance());
        }
        if (type0.isExternalType() || type1.isExternalType()) {
            XPathException de = new XPathException("Arithmetic operators are not defined for external objects");
            de.setLocator(this);
            de.setErrorCode("XPTY0004");
            throw de;
        }
        if (this.operator == 199) {
            if (this.operand1 instanceof Literal && ((Literal)this.operand1).getValue() instanceof NumericValue) {
                NumericValue nv = (NumericValue)((Literal)this.operand1).getValue();
                return new Literal(nv.negate());
            }
            NegateExpression ne = new NegateExpression(this.operand1);
            ne.setBackwardsCompatible(false);
            return visitor.typeCheck(ne, contextItemType);
        }
        boolean mustResolve = !type0.equals(BuiltInAtomicType.ANY_ATOMIC) && !type1.equals(BuiltInAtomicType.ANY_ATOMIC) && !type0.equals(BuiltInAtomicType.NUMERIC) && !type1.equals(BuiltInAtomicType.NUMERIC);
        this.calculator = Calculator.getCalculator(type0.getFingerprint(), type1.getFingerprint(), ArithmeticExpression.mapOpCode(this.operator), mustResolve);
        if (this.calculator == null) {
            XPathException de = new XPathException("Arithmetic operator is not defined for arguments of types (" + type0.getDescription() + ", " + type1.getDescription() + ")");
            de.setLocator(this);
            de.setErrorCode("XPTY0004");
            throw de;
        }
        try {
            if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
                return new Literal(Value.asValue(this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext())));
            }
        }
        catch (XPathException err) {
            // empty catch block
        }
        return this;
    }

    public Expression copy() {
        ArithmeticExpression ae = new ArithmeticExpression(this.operand0.copy(), this.operator, this.operand1.copy());
        ae.calculator = this.calculator;
        return ae;
    }

    public static AtomicValue compute(AtomicValue value0, int operator, AtomicValue value1, XPathContext context) throws XPathException {
        int p0 = value0.getPrimitiveType().getFingerprint();
        int p1 = value1.getPrimitiveType().getFingerprint();
        Calculator calculator = Calculator.getCalculator(p0, p1, operator, false);
        return calculator.compute(value0, value1, context);
    }

    public static int mapOpCode(int op) {
        switch (op) {
            case 15: {
                return 0;
            }
            case 16: 
            case 199: {
                return 1;
            }
            case 17: {
                return 2;
            }
            case 18: {
                return 3;
            }
            case 50: {
                return 5;
            }
            case 19: {
                return 4;
            }
        }
        throw new IllegalArgumentException();
    }

    public ItemType getItemType(TypeHierarchy th) {
        AtomicType resultType;
        ItemType t2;
        if (this.calculator == null) {
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        ItemType t1 = this.operand0.getItemType(th);
        if (!(t1 instanceof AtomicType)) {
            t1 = t1.getAtomizedItemType();
        }
        if (!((t2 = this.operand1.getItemType(th)) instanceof AtomicType)) {
            t2 = t2.getAtomizedItemType();
        }
        if ((resultType = this.calculator.getResultType((AtomicType)t1.getPrimitiveItemType(), (AtomicType)t2.getPrimitiveItemType())).equals(BuiltInAtomicType.ANY_ATOMIC) && (this.operator == 15 || this.operator == 16) && (th.isSubType(t2, BuiltInAtomicType.NUMERIC) || th.isSubType(t1, BuiltInAtomicType.NUMERIC))) {
            resultType = BuiltInAtomicType.NUMERIC;
        }
        return resultType;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        AtomicValue v0 = (AtomicValue)this.operand0.evaluateItem(context);
        if (v0 == null) {
            return null;
        }
        AtomicValue v1 = (AtomicValue)this.operand1.evaluateItem(context);
        if (v1 == null) {
            return null;
        }
        try {
            return this.calculator.compute(v0, v1, context);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(context);
            throw e;
        }
    }
}

