<?xml version="1.0" encoding="UTF-8"?>
<!-- Usage: Run this stylesheet against the WCS 1.1.1 ATS (XHTML format) to generate a complete ETS suite (CTL) -->
<!-- 1. Need to loop over ctl:methods.
      2. Some ctl:methods seem to be missing, e.g. SOAP. Can XML, SOAP etc be generated using ctl:method, ctl:header, and ctl:body? Check with
          Steven then Chuck/Richard. 
          GET with KVP uses ctl:param
          POST with XML or SOAP uses ctl:body with
           <soap:Envelope>
             <soap:header>
               <soap:body>
                 <wcs:GetCoverage service="wcs"...............>
                   DomSubset
                 </wcs:GetCoverage>
              </soap:body>
            <soap:Envelope>
          Only the section in soap:body is used for XML POST
      3. Get the URL from user input - Done. 
          This is strictly only for KVP GET for GetCapabiilities. Other URL and encodings supported are from GetCapabilities response.
      4. How to set ids so that id of initialrequest can be used
      5. How send initialrequest and parse it for the parts to be extracted
      6. How to parse the response to check for validity. Put the request into a variable. Need to add a validator for the test.
      7. Need to review ATS variables. Which ones can be extracted from a response
         and which ones need user input.
      8. Need to add ctl:fail. Done
      9. Can output have xmlns in package indented? Don't think so.
     10. Do xsl: elements have to have xmlns values? Yes. They are generated by XSLT for output from xsl:element.
     11. Use ats relative location instead of hardwired path. This partly depends on how the links are used in execution.
     12. Suggestion from Carla: Have the CTL structured so that the form pops up while the main part
           of the script is being compiled. Matt agrees, and let user know what is happening but don't need to say loading script.
          This is not possible. The only alternative offered is to rerun tests which works from the compiled intermediate style sheet.
          This is useful for Steven/Vincent but not for Carla.
     13. Extract the form from WCS 1.0.0 ETS for input form ideas. Done. Review with Matt. Matt likes staged tests, eg ask for URL first,
           and based on URL ask relevant questions probably excluding irrelevant questions. Label first is nice, but in invisible table.
           Try to indicate that URL is first of two input pages and that tests are run after second page. Try to keep each form to one
           screen. Keep two input screens even if item 12. can't be done. It is ok to only use one screen if no additional parameters are
           required for that server.
           Invisible table is done.
     14. Review the Shared Aspects.
     15. Make sure that skipped tests are counted as 'untested'. There should be a summary of what concepts were tested and
          which were skipped. Does the script control the iconized summary? How are skipped tests shown?
     16. Check the test type for Basic or Capability. Basic ones should cause the remaining tests in that section to be skipped. Don't do any
           tests if the URL is no good.   Done testing for good URL. Steven: do all tests.
     17. How to avoid freeze up if the URL is not responding? Krisha's AIC job hung which caused the WCS to hang. Only the cached results
           were being returned. This sounds like a bug in the WCS regarding monitoring of partially written files.
     18. Need to review acceptance test to make sure all criteria are being used.
     19. For tests which pass multiple values for one parameter, does the order of the parameters matter?
     20. The specification is not online in html form which is needed for anchor links. The schemas are not online where they are supposed to be.
     21. Vincent: http://mercedes:8080/wcsgenx/wcs?, http://goliath:8080/steve/wcs   http://goliath:8080/wcs/wcs http://ogcdemo.pcigeomatics.com:8181/dted/wcs?  http://ogcdemo.pcigeomatics.com:8181/swe/wcs  http://tigana:8080/wcsgenx/wcs? http://tigana:80/wcs/wcs?  
           Reference Implementation: http://gridlock.openplans.org:8080/geoserver-wcs/wcs
           George Mason University: http://data.laits.gmu.edu:8080/cgi-bin/wcs110?  
           Frank Warmerdam MapServer: http://198.202.74.215/cgi-bin/wcs_demo
           Geomatys: http://demo.geomatys.fr/seagis/WS/wcs?
     22. How should the test for updateSequence not supported be handled so that the tests are skipped not failed? Also need message for skipped http methods.
     23. Need to add code to test for required elements in response.
     24. Should allow for alternate response when all URLs for all operations are the same WCS 8.3.2.2.
     25. How do updateSequence values get added to a XML encoded request?
     26. Is it identifier or identifiers in the DescribeCoverage request and is it different between KVP and XML encoding?
     27. Starting with table 24 there should be some extract to verify that the elements are present.
     28. Some tests should be repeated for each identifier found, e.g. table 94. Search for 'be repeated'.
     29. The ctl:links could be improved by creating an html version of the specifications and adding anchors.
     30. The web site implementation of the tests has a tree list of the results with the test name. Each encoding of the test has the same
           name in the tree list. The whole ETS could be restructed to have each test only called once with a unique name. That way each node in 
           the tree list has a unique name.
      31. To use the schema validator outside of the request parsing context is somewhat fiddly: you need to define a "helper" test that calls a function 
            that invokes the validator.
           
            There are examples in the common.xml package within the CSW test suite:
                <https://svn.opengeospatial.org:8443/ogc-projects/cite/trunk/csw/2.0.2/ets/ctl/common.xml>
            It's also possible to define validators that are configured with specific schemas.
            Once these supporting tests are declared, you can call them like so:
               <ctl:call-test name="ctl:XMLValidatingParser.CSW">
                 <ctl:with-param name="doc">
                   <xsl:copy-of select="$response//content/*"/>
                 </ctl:with-param>
               </ctl:call-test>
              You'd need to set up ancillary tests like this.  - Richard
 
-->

<!--

NOTE:Tthe transformation of the ATS to the ETS using this xsl document works with XMLSpy2004 but not with XMLSpy2008.

-->

<xsl:transform version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ctlxsl="output.xsl"
  xmlns:html="http://www.w3.org/1999/xhtml">

	<xsl:output method="xml" indent="yes" version="1.1" encoding="UTF-8"/>
	<xsl:namespace-alias stylesheet-prefix="ctlxsl" result-prefix="xsl"/>

	<!-- Create the root package -->
	<xsl:template match="/">
	    <ctl:package
		  xmlns:ctl="http://www.occamlab.com/ctl"
		  xmlns:ctlp="http://www.occamlab.com/te/parsers"
		  xmlns:tep="http://teamengine.sourceforge.net/parsers"
		  xmlns:saxon="http://saxon.sf.net/"
		  xmlns:xi="http://www.w3.org/2001/XInclude"
		  xmlns:xlink="http://www.w3.org/1999/xlink"
		  xmlns:xsd="http://www.w3.org/2001/XMLSchema"
		  xmlns:fn="http://www.w3.org/2005/02/xpath-functions"
		  xmlns:ows="http://www.opengis.net/ows/1.1"
		  xmlns:wcs="http://schemas.opengis.net/wcs/1.1.1">
			<xsl:call-template name="suite"/>
			<xsl:for-each select="//html:div[@class='section']">
				<xsl:apply-templates select=".">
				</xsl:apply-templates>
			</xsl:for-each>
		</ctl:package>
	</xsl:template>

	<!-- TEST MODULES -->
	<!-- Test for each section -->
	<xsl:template match="html:div[@class='section']">
	   <xsl:param name="url" />
		<xsl:variable name="module-id" select=".//html:h2[1]/html:a/@id"/>
        <xsl:variable name="module-name" select=".//html:h2[1]/text()"/>
		<ctl:package>
		  <xsl:element name="ctl:test">
		    <xsl:attribute name="name"><xsl:value-of select="concat('wcs:',$module-id, '-main')"/></xsl:attribute>
			<ctl:param name ="url" />
			<ctl:assertion>All assertions for "<xsl:value-of select="$module-id"/>" conformance are satisfied.</ctl:assertion>
			<ctl:comment>Test driver for the <xsl:value-of select="$module-id"/> module.</ctl:comment>
            <xsl:element name="ctl:link">
			  <xsl:attribute name="title">
			    <xsl:value-of  select="concat(number(substring-before($module-name, '. ') - 2),  '. ', substring-after(normalize-space($module-name), '. '))"/>
			  </xsl:attribute>
			  <xsl:value-of select="concat('http://www.opengeospatial.org/standards/wcs#',$module-id)"/>
			</xsl:element>
			
			<!-- Generate a call for each test case -->
			<ctl:code>
			     
			  <!-- from the GetCapabilities, which http methods are supported and what are their URLs -->
			  <ctl:comment>From the GetCapabilities, which http methods are supported and what are their URLs</ctl:comment>
			  <!-- Do a http get GetCapabilities for Operations Metadata -->
        <ctlxsl:variable name="result1">
		    <ctl:request>
				  <ctl:url>
				    <ctlxsl:value-of select="$url"/>
				  </ctl:url>
				  <ctl:method>GET</ctl:method>
				  <ctl:param name="service">WCS</ctl:param>
				  <ctl:param name="request">GetCapabilities</ctl:param>
				  <ctl:param name="sections">OperationsMetadata,Contents</ctl:param>
				  <ctlp:XMLValidatingParser xmlns:ctlp="http://www.occamlab.com/te/parsers">
							<ctlp:schemas>
							    <!-- FIXME: needs updating for a web location -->
								<ctlp:schema type="resource">xsd/ogc/wcs/1.1.1/wcsGetCapabilities.xsd</ctlp:schema>
							</ctlp:schemas>
						</ctlp:XMLValidatingParser>
			    </ctl:request>
			  </ctlxsl:variable>

			  <ctlxsl:variable name="version-number" select="$result1/*[local-name()='Capabilities'][@version]/@version"/>
			    
			  <ctlxsl:choose>
			    <ctlxsl:when test="$version-number = '1.1.1'">
			      <ctl:message select="concat('The service metadata document version number is ', $version-number, '.')"/>
			    </ctlxsl:when>
			    <ctlxsl:otherwise>
			      <ctl:message select="concat('&#10;', ' ')"/>
			      <ctl:message select="concat('The service metadata document has version ', $version-number, ' but expected to find 1.1.1 as the highest protocol supported. See OGC 06-121r3 subclause 7.3.2.')"/>
			      <ctl:message select="concat('&#10;', ' ')"/>
			      <ctl:fail/>
			    </ctlxsl:otherwise>
			  </ctlxsl:choose>
			  
        <!-- keep these as one line to avoid whitespace problems -->
			  <xsl:element name="xsl:variable"><xsl:attribute name="name">EqualUpdateSequenceValue</xsl:attribute><xsl:element name="xsl:value-of"><xsl:attribute name="select">$result1/*[local-name()='Capabilities'][@updateSequence]/@updateSequence</xsl:attribute></xsl:element></xsl:element>
			  <ctlxsl:variable name="http-get">GET</ctlxsl:variable>
			  <ctlxsl:variable name="http-xml">XML</ctlxsl:variable>
			  <ctlxsl:variable name="http-soap">SOAP</ctlxsl:variable>
			  
			  <!-- parse the Operations Metadata $module-id for the http method URLs-->
			  <!-- Capabilities/OperationsMetadata/$module-id/DCP/HTTP/ows:Get/@xlink:href -->
			  <xsl:element name="xsl:variable"><xsl:attribute name="name">url-get</xsl:attribute><xsl:element name="xsl:value-of"><xsl:attribute name="select">$result1/*[local-name()='Capabilities']/*[local-name()='OperationsMetadata']/*[@name='<xsl:value-of select="$module-id"/>']/*[local-name()='DCP']/*[local-name()='HTTP']/*[local-name()='Get']/@xlink:href</xsl:attribute></xsl:element></xsl:element>
			  <!-- Capabilities/OperationsMetadata/$module-id/DCP/HTTP/ows:Post/@xlink:href -->
			  <xsl:element name="xsl:variable"><xsl:attribute name="name">url-xml</xsl:attribute><xsl:element name="xsl:value-of"><xsl:attribute name="select">$result1/*[local-name()='Capabilities']/*[local-name()='OperationsMetadata']/*[@name='<xsl:value-of select="$module-id"/>']/*[local-name()='DCP']/*[local-name()='HTTP']/*[local-name()='Post']/@xlink:href</xsl:attribute></xsl:element></xsl:element>
			  <!-- Capabilities/OperationsMetadata/$module-id/DCP/HTTP/ows:Post/ows:Constraint[@name='PostEncoding']/AllowedValues/Value/text()='XML' -->
			  <xsl:element name="xsl:variable"><xsl:attribute name="name">xml-supported</xsl:attribute><xsl:element name="xsl:value-of"><xsl:attribute name="select">$result1/*[local-name()='Capabilities']/*[local-name()='OperationsMetadata']/*[@name='<xsl:value-of select="$module-id"/>']/*[local-name()='DCP']/*[local-name()='HTTP']/*[local-name()='Post']/*[local-name()='Constraint'][@name='PostEncoding']/*[local-name()='AllowedValues']/*[local-name()='Value']/text()='XML'</xsl:attribute></xsl:element></xsl:element>
			  <xsl:element name="xsl:variable"><xsl:attribute name="name">xml-supported-alternate</xsl:attribute><xsl:element name="xsl:value-of"><xsl:attribute name="select">$result1/*[local-name()='Capabilities']/*[local-name()='OperationsMetadata']/*[local-name()='Constraint'][@name='PostEncoding']/*[local-name()='AllowedValues']/*[local-name()='Value']/text()='XML'</xsl:attribute></xsl:element></xsl:element>
			  <!-- Capabilities/OperationsMetadata/$module-id/DCP/HTTP/ows:Post/ows:Constraint[@name='PostEncoding']/AllowedValues/Value/text()='SOAP' -->
			  <xsl:element name="xsl:variable"><xsl:attribute name="name">soap-supported</xsl:attribute><xsl:element name="xsl:value-of"><xsl:attribute name="select">$result1/*[local-name()='Capabilities']/*[local-name()='OperationsMetadata']/*[@name='<xsl:value-of select="$module-id"/>']/*[local-name()='DCP']/*[local-name()='HTTP']/*[local-name()='Post']/*[local-name()='Constraint'][@name='PostEncoding']/*[local-name()='AllowedValues']/*[local-name()='Value']/text()='SOAP'</xsl:attribute></xsl:element></xsl:element>
			  <!-- Capabilities/OperationsMetadata/GetCoverage/Parameter[@name='store']/AllowedValues/Value/text()='True' -->
			  <xsl:element name="xsl:variable"><xsl:attribute name="name">store-supported</xsl:attribute><xsl:element name="xsl:value-of"><xsl:attribute name="select">$result1/*[local-name()='Capabilities']/*[local-name()='OperationsMetadata']/*[@name='GetCoverage']/*[local-name()='Parameter'][@name='store']/*[local-name()='AllowedValues']/*[local-name()='Value']/text()='True'</xsl:attribute></xsl:element></xsl:element>
			  <!-- Test if the Sections parameter is supported by checking for the presence of the ServiceProvider element which was not requested -->
			  <!-- Capabilities/ServiceProvider -->
			  <xsl:element name="xsl:variable"><xsl:attribute name="name">sections-supported</xsl:attribute><xsl:element name="xsl:value-of"><xsl:attribute name="select">$result1/*[local-name()='Capabilities'] and not($result1/*[local-name()='Capabilities']/*[local-name()='ServiceProvider'])</xsl:attribute></xsl:element></xsl:element>
			  
			  <xsl:element name="xsl:variable"><xsl:attribute name="name">identifier1</xsl:attribute><xsl:element name="xsl:value-of"><xsl:attribute name="select">$result1/*[local-name()='Capabilities']/*[local-name()='Contents']/*[local-name()='CoverageSummary'][1]/*[local-name()='Identifier']</xsl:attribute></xsl:element></xsl:element>
			  <xsl:element name="xsl:variable"><xsl:attribute name="name">identifier2</xsl:attribute><xsl:element name="xsl:value-of"><xsl:attribute name="select">$result1/*[local-name()='Capabilities']/*[local-name()='Contents']/*[local-name()='CoverageSummary'][2]/*[local-name()='Identifier']</xsl:attribute></xsl:element></xsl:element>
			  <xsl:element name="xsl:variable"><xsl:attribute name="name">identifier3</xsl:attribute><xsl:element name="xsl:value-of"><xsl:attribute name="select">$result1/*[local-name()='Capabilities']/*[local-name()='Contents']/*[local-name()='CoverageSummary'][3]/*[local-name()='Identifier']</xsl:attribute></xsl:element></xsl:element>
	
			  <ctlxsl:if test="string-length($version-number) = 0 and string-length($url-get) = 0 and string-length($identifier1) = 0">
				  <ctl:message>The server seems to have a problem with handling the GetCapabilities sections parameter. No tests will be performed.</ctl:message>
				  <ctl:fail/>
			  </ctlxsl:if>
			  
			  <!-- Need to prompt for the minimal, maximal and bogus update sequence values if appropriate -->
			  <xsl:if test="$module-id = 'GetCapabilities'">
			    <ctl:message select = "concat('The EqualUpdateSequence value is ', $EqualUpdateSequenceValue, '.')"/>
			  </xsl:if>
			  <ctl:message select = "concat('The URL for KVP encoding is ', $url-get, '.')"/>
			  <ctl:message select = "concat('The URL for XML encoding is ', $url-xml, '.')"/>
			  <ctlxsl:choose>
			    <ctlxsl:when test="$xml-supported = 'true' or $xml-supported-alternate = 'true'">
            <ctl:message>XML encoding is supported.</ctl:message>
          </ctlxsl:when>
          <ctlxsl:otherwise>
            <ctl:message>XML encoding is not supported.</ctl:message>
          </ctlxsl:otherwise>
        </ctlxsl:choose>
			  <ctlxsl:if test = "$soap-supported = 'true'">
			    <ctl:message>No tests using SOAP encoding will be performed. The tests for SOAP encoding are not implemented.</ctl:message>
			  </ctlxsl:if>
			  <xsl:if test="$module-id = 'GetCoverage'">
			    <ctl:message select = "concat('store supported is ', $store-supported = 'true', '.')"/>
			  </xsl:if>
			  <xsl:if test="$module-id = 'GetCapabilities'">
			    <ctl:message select = "concat('sections-supported: ', $sections-supported, '.')"/>
			  </xsl:if>
			  <xsl:if test="$module-id = 'DescribeCoverage' or $module-id = 'GetCoverage'">
			    <ctl:message select = "concat('Identifier1 is ', $identifier1, '.')"/>
			    <ctl:message select = "concat('Identifier2 is ', $identifier2, '.')"/>
			    <ctl:message select = "concat('Identifier3 is ', $identifier3, '.')"/>
			  </xsl:if>
			  	        
			  <xsl:choose>
			  <xsl:when test="$module-id = 'GetCapabilities'">
			  
			    <ctlxsl:variable name = "update-values">
				  <ctlxsl:if test = "string-length($EqualUpdateSequenceValue) &gt; 0">
			      <ctl:form xmlns:ctl="http://www.occamlab.com/ctl">
			        <h3>Update Sequence Values for WCS 1.1.1</h3>
				    <p>This WCS service
				    <ctlxsl:if test = "string-length($EqualUpdateSequenceValue) &gt; 0">supports</ctlxsl:if>
				    <ctlxsl:if test = "string-length($EqualUpdateSequenceValue) = 0">does NOT support</ctlxsl:if>
				    updateSequence in GetCapabilities requests. Please enter values for the minimal value,
				          the maximal value and a bogus, well-formed but non-existant, value for the updateSequence.</p>
                    <blockquote>   <!-- used for indentation -->
			          <table border="0" cellpadding="5">
				        <tr>
				          <td align="left">Minimal Value</td>
					      <td align="left">
						      <input type="text" name="MinimalValue" size="15" value="0" />
					      </td>
				        </tr>
				        <tr>
				          <td align="left">Maximal Value</td>
					      <td align="left">
						      <input type="text" name="MaximalValue" size="15" value="1399999999999" />
					      </td>
				        </tr>
				        <tr>
				          <td align="left">Bogus Value</td>
					      <td align="left">
						      <input type="text" name="BogusValue" size="15" value="bogus" />
					      </td>
				        </tr>
			          </table>
		              <table border="0" cellpadding="5">
		                <tr>
		                  <td align="center"><input type="submit" value="Submit" /></td>
                        </tr>
	                  </table>
		            </blockquote>
                  </ctl:form>
                  </ctlxsl:if>
                </ctlxsl:variable>
                <ctlxsl:variable name = "MinimalUpdateSequenceValue">
                  <ctlxsl:value-of select = "$update-values/values/value[@key='MinimalValue']"/>
                </ctlxsl:variable>
			    <ctlxsl:variable name = "MaximalUpdateSequenceValue">
			      <ctlxsl:value-of select = "$update-values/values/value[@key='MaximalValue']"/>
			    </ctlxsl:variable>
			    <ctlxsl:variable name = "BogusUpdateSequenceValue">
			      <ctlxsl:value-of select = "$update-values/values/value[@key='BogusValue']"/>
			    </ctlxsl:variable>
			    
			  </xsl:when>
			  <xsl:otherwise>
			    <ctlxsl:variable name = "MinimalUpdateSequenceValue">0</ctlxsl:variable>
			    <ctlxsl:variable name = "MaximalUpdateSequenceValue">0</ctlxsl:variable>
			    <ctlxsl:variable name = "BogusUpdateSequenceValue">0</ctlxsl:variable>
			  </xsl:otherwise>
			  </xsl:choose>
			  
			  <!-- Each test case -->
			  <ctl:comment>Call the test for each applicable http method with its appropriate URL</ctl:comment>
			  <ctlxsl:if test="string-length($version-number) != 0 or string-length($url-get) != 0 or string-length($identifier1) != 0">
			  <xsl:for-each select="./html:div[@class='list-of-tables']/html:dl/html:dt">
			    <xsl:variable name="test-name" select="substring-after(./html:a/@href,'_')"/>

 			    <!-- Skip a test if the protocol is not supported, or if the test uses UpdateSequence which is not supported by the server,
                or if the test uses a Bogus Sections parameter with is not supported by the server -->
			    <xsl:element name="xsl:variable"><xsl:attribute name="name">UpdateSequenceOk</xsl:attribute><xsl:element name="xsl:value-of"><xsl:attribute name="select">string-length($EqualUpdateSequenceValue) > 0 or not(contains('<xsl:value-of select="$test-name"/>', 'UpdateSequence'))</xsl:attribute></xsl:element></xsl:element>
			    <!--<xsl:element name="ctl:message"><xsl:attribute name="select">concat('UpdateSequenceOk: ', $UpdateSequenceOk, '.')</xsl:attribute></xsl:element>-->
			    <xsl:element name="xsl:variable"><xsl:attribute name="name">BogusSectionsOk</xsl:attribute><xsl:element name="xsl:value-of"><xsl:attribute name="select">$sections-supported = 'true' or not(contains('<xsl:value-of select="$test-name"/>', 'Sections_Bogus'))</xsl:attribute></xsl:element></xsl:element>
			    <xsl:element name="xsl:variable"><xsl:attribute name="name">StoreOk</xsl:attribute><xsl:element name="xsl:value-of"><xsl:attribute name="select">$store-supported = 'true' or not(contains('<xsl:value-of select="$test-name"/>', 'Store_True'))</xsl:attribute></xsl:element></xsl:element>
			    <xsl:choose>
			      <xsl:when test="(contains($test-name, 'RangeSubset') and (contains($test-name, 'Multiple_Identifiers') or contains($test-name, 'Field_Identifiers'))) or contains($test-name, 'TemporalSubset')">
			        <ctlxsl:variable name="describe-min-result2">
			          <ctlxsl:choose>
			            <ctlxsl:when test="$url-get">
			              <ctl:call-function name="wcs:describe-coverage-minimal-request">
						          <ctl:with-param name="url" select="$url-get"/>
						          <ctl:with-param name="http-method" select="$http-get"/>
						          <ctl:with-param name="identifier" select="$identifier1"/>
					          </ctl:call-function>
			            </ctlxsl:when>
			            <ctlxsl:when test="$url-xml">
			              <ctl:call-function name="wcs:describe-coverage-minimal-request">
						          <ctl:with-param name="url" select="$url-xml"/>
						          <ctl:with-param name="http-method" select="$http-xml"/>
						          <ctl:with-param name="identifier" select="$identifier1"/>
					          </ctl:call-function>
			            </ctlxsl:when>
			          </ctlxsl:choose>
				      </ctlxsl:variable>
				      <xsl:choose>
				        <xsl:when test="not(contains($test-name, 'TemporalSubset'))">
					        <ctlxsl:variable name="FieldIdentifier2Ok">
					          <ctlxsl:value-of select="not($describe-min-result2/*[local-name()='ExceptionReport']) and not(string-length($describe-min-result2/*[local-name()='CoverageDescriptions']/*[local-name()='CoverageDescription']/*[local-name()='Range']/*[local-name()='Field']/*[local-name()='Identifier'][2]) = 0)"/>
					        </ctlxsl:variable>
					        <ctlxsl:variable name="TemporalSubsetOk">true</ctlxsl:variable>
					      </xsl:when>
					      <xsl:otherwise>
					        <ctlxsl:variable name="FieldIdentifier2Ok">true</ctlxsl:variable>
					        <ctlxsl:variable name="TemporalSubsetOk">
					          <ctlxsl:value-of select="not($describe-min-result2/*[local-name()='ExceptionReport']) and not(string-length($describe-min-result2/*[local-name()='CoverageDescriptions']/*[local-name()='CoverageDescription']/*[local-name()='Domain']/*[local-name()='TemporalDomain']) = 0)"/>
					        </ctlxsl:variable>
					      </xsl:otherwise>
					    </xsl:choose>
			      </xsl:when>
			      <xsl:otherwise>
			        <ctlxsl:variable name="FieldIdentifier2Ok">true</ctlxsl:variable>
			        <ctlxsl:variable name="TemporalSubsetOk">true</ctlxsl:variable>
			      </xsl:otherwise>
			    </xsl:choose>
			    
			    <!-- Call the test for each applicable http method with its appropriate URL -->
			    <!-- Generate the KVP encoding test -->
			    <ctlxsl:choose>
			      <ctlxsl:when test = "$url-get and $UpdateSequenceOk = 'true' and $BogusSectionsOk = 'true' and $TemporalSubsetOk = 'true' and $StoreOk = 'true' and $FieldIdentifier2Ok = 'true'">
				      <xsl:element name="ctl:call-test">
				        <xsl:attribute name="name"><xsl:value-of select="concat('wcs:',$module-id,'_',$test-name)"/></xsl:attribute>
  				        <ctl:with-param name="url" select="$url-get" />
				        <ctl:with-param name="http-method" select="$http-get" />
				        <xsl:if test="$module-id = 'GetCapabilities' and not(starts-with($test-name, 'Response'))">
				          <ctl:with-param name="EqualUpdateSequenceValue" select="$EqualUpdateSequenceValue"/>
				          <ctl:with-param name="BogusUpdateSequenceValue" select="$BogusUpdateSequenceValue" />
				          <ctl:with-param name="MinimalUpdateSequenceValue" select="$MinimalUpdateSequenceValue" />
				          <ctl:with-param name="MaximalUpdateSequenceValue" select="$MaximalUpdateSequenceValue" />
				        </xsl:if>
				        <xsl:if test="$module-id = 'DescribeCoverage' or $module-id = 'GetCoverage'">
				          <ctl:with-param name="identifier1" select="$identifier1" />
				          <ctl:with-param name="identifier2" select="$identifier2" />
					        <ctl:with-param name="identifier3" select="$identifier3" />
					      </xsl:if>
				      </xsl:element>
				  </ctlxsl:when>
				  <ctlxsl:otherwise>
				    <xsl:element name="ctl:message">
				      <xsl:attribute name="select">concat('Test wcs:', '<xsl:value-of select="$module-id"/>', '_', '<xsl:value-of select="$test-name"/>', ' with KVP encoding skipped.')</xsl:attribute>
				    </xsl:element>
				  </ctlxsl:otherwise>
				</ctlxsl:choose>
				
				<!-- Generate the XML encoding tests -->
        <xsl:if test="($module-id != 'GetCapabilities' or not(contains($test-name, 'Response'))) and not(contains($test-name, 'KVP_Syntax'))">
							<!-- The GetCapabilities Response tests only use an initial request case -->
				  <ctlxsl:choose>
				    <ctlxsl:when test = "($xml-supported = 'true' or $xml-supported-alternate = 'true') and $UpdateSequenceOk = 'true' and $BogusSectionsOk = 'true' and $TemporalSubsetOk = 'true' and $StoreOk = 'true' and $FieldIdentifier2Ok = 'true'">
				      <xsl:element name="ctl:call-test">
				        <xsl:attribute name="name"><xsl:value-of select="concat('wcs:', $module-id, '_', $test-name)"/></xsl:attribute>
				        <ctl:with-param name="url" select="$url-xml" />
				        <ctl:with-param name="http-method" select="$http-xml" />
				        <xsl:if test="$module-id = 'GetCapabilities' and not(starts-with($test-name, 'Response'))">
				          <ctl:with-param name="EqualUpdateSequenceValue" select="$EqualUpdateSequenceValue"/>
				          <ctl:with-param name="BogusUpdateSequenceValue" select="$BogusUpdateSequenceValue" />
				          <ctl:with-param name="MinimalUpdateSequenceValue" select="$MinimalUpdateSequenceValue" />
				          <ctl:with-param name="MaximalUpdateSequenceValue" select="$MaximalUpdateSequenceValue" />
				        </xsl:if>
				        <xsl:if test="$module-id = 'DescribeCoverage' or $module-id = 'GetCoverage'">
				          <ctl:with-param name="identifier1" select="$identifier1" />
				          <ctl:with-param name="identifier2" select="$identifier2" />
				          <ctl:with-param name="identifier3" select="$identifier3" />
				        </xsl:if>
				      </xsl:element>
		        </ctlxsl:when>
				    <ctlxsl:otherwise>
				      <xsl:element name="ctl:message">
				        <xsl:attribute name="select">concat('Test wcs:', '<xsl:value-of select="$module-id"/>', '_', '<xsl:value-of select="$test-name"/>', ' with POST XML encoding skipped.')</xsl:attribute>
				      </xsl:element>
				    </ctlxsl:otherwise>
				  </ctlxsl:choose>
				</xsl:if>
				
				<!-- Generate the SOAP encoding tests -->
				<!--<xsl:element name="xsl:if">
				  <xsl:attribute name="test">$soap-supported = 'true'</xsl:attribute>
				  <xsl:element name="ctl:call-test">
				    <xsl:attribute name="name">
				      <xsl:value-of select="concat('wcs:', $module-id, '_', $test-name)"/>
				    </xsl:attribute>
				    <ctl:with-param name="url" select="$url-xml" />
				    <ctl:with-param name="http-method" select="$http-soap" />
				    <xsl:if test="$module-id = 'GetCapabilities' and not(starts-with($test-name, 'Response'))">
				      <ctl:with-param name="EqualUpdateSequenceValue" select="$EqualUpdateSequenceValue"/>
				      <ctl:with-param name="BogusUpdateSequenceValue" select="$BogusUpdateSequenceValue" />
				      <ctl:with-param name="MinimalUpdateSequenceValue" select="$MinimalUpdateSequenceValue" />
				      <ctl:with-param name="MaximalUpdateSequenceValue" select="$MaximalUpdateSequenceValue" />
				    </xsl:if>
                    <ctl:with-param name="identifier1" select="$identifier1" />
				    <ctl:with-param name="identifier2" select="$identifier2" />
				    <ctl:with-param name="identifier3" select="$identifier3" />
				  </xsl:element>
				</xsl:element>
				<xsl:element name="xsl:if">
				  <xsl:attribute name="test">$soap-supported = 'false'</xsl:attribute>
				  <xsl:element name="ctl:message">
				    <xsl:attribute name="select">concat('Test wcs:', '<xsl:value-of select="$module-id"/>', '_', '<xsl:value-of select="$test-name"/>', ' with POST SOAP encoding skipped.')</xsl:attribute>
				  </xsl:element>
				</xsl:element>-->
				
			  </xsl:for-each>
			  </ctlxsl:if>
			</ctl:code>
		  </xsl:element>
		  
		  <!-- Apply the template for each test case -->
		  <xsl:for-each select=".//html:div[@class='atc']/html:table">
			<xsl:apply-templates select=".">
			</xsl:apply-templates>
		  </xsl:for-each>
	    </ctl:package>
	</xsl:template>

	<!-- Test for an abstract test case -->
	<xsl:template match="html:div[@class='atc']/html:table">
	    <!-- extract parts of the abstract test case -->
		<xsl:variable name="module-id" select="../..//html:h2[@class='title']/html:a/@id"/>
		<xsl:variable name="test-id" select=".//@id"/>
		<xsl:variable name="assertion" select=".//html:tbody/html:tr[@class='purpose']/html:td"/>
		<!-- extract the method parts of the abstract test case -->
		<xsl:variable name="method-service"
                             select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='service']/html:td"/>
		<xsl:variable name="method-request" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='request']/html:td"/>
		<xsl:variable name="method-sections" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='sections']/html:td"/>
		<xsl:variable name="method-acceptversions" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='acceptversions']/html:td"/>
		<xsl:variable name="method-updatesequence" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='updatesequence']/html:td"/>
		<xsl:variable name="method-initialrequestcase" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='initialrequestcase']/html:td"/>
		<xsl:variable name="method-extract" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='extract']/html:td"/>
		<xsl:variable name="method-acceptformats" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='acceptformats']/html:td"/>
		<xsl:variable name="method-version" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='version']/html:td"/>
		<xsl:variable name="method-identifier" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='identifier']/html:td"/>
		<xsl:variable name="method-domainSubset" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='domainSubset']/html:td"/>
		<xsl:variable name="method-temporalSubset" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='temporalSubset']/html:td"/>
		<xsl:variable name="method-beginTime" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='beginTime']/html:td"/>
		<xsl:variable name="method-endTime" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='endTime']/html:td"/>
		<xsl:variable name="method-timeResolution" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='timeResolution']/html:td"/>
		<xsl:variable name="method-frame" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='frame']/html:td"/>
		<xsl:variable name="method-fieldIdentifier" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='fieldIdentifier']/html:td"/>
		<xsl:variable name="method-interpolationMethod" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='interpolationMethod']/html:td"/>
		<xsl:variable name="method-axisIdentifier" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='axisIdentifier']/html:td"/>
		<xsl:variable name="method-axisKey" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='axisKey']/html:td"/>
		<xsl:variable name="method-format" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='format']/html:td"/>
		<xsl:variable name="method-store" select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='store']/html:td"/>
		<xsl:variable name="method-validator" select=".//html:tbody/html:tr[@class='method']/html:td/html:a[@class='validator']/@href"/>
		<xsl:variable name="method-locator" select="substring-before(substring-after(.//html:tbody/html:tr[@class='method']/html:td, 'locator set to'), '.')"/>
		<xsl:variable name="method-response-extract" select=".//html:tbody/html:tr[@class='method']/html:td/html:a[@class='response-extract']"/>
		<xsl:variable name="test-type" select=".//html:tbody/html:tr[@class='type']/html:td"/>
		<xsl:variable name="caption" select=".//html:caption"/>
		
		<xsl:element name="ctl:test">
			<xsl:attribute name="name">
			  <xsl:value-of select="concat('wcs:', $test-id)"/>
			</xsl:attribute>
			<ctl:param name="url" />
			<ctl:param name="http-method" />
			<xsl:if test="$module-id = 'GetCapabilities' and not(contains($test-id, 'Response'))">
			  <ctl:param name="EqualUpdateSequenceValue" />
			  <ctl:param name="BogusUpdateSequenceValue" />
			  <ctl:param name="MinimalUpdateSequenceValue" />
			  <ctl:param name="MaximalUpdateSequenceValue" />
			</xsl:if>
			<xsl:if test="$module-id = 'DescribeCoverage' or $module-id = 'GetCoverage'">
			  <ctl:param name="identifier1" />
			  <ctl:param name="identifier2" />
			  <ctl:param name="identifier3" />
			</xsl:if>
			<xsl:element name="ctl:assertion"><xsl:value-of select="$assertion"/></xsl:element>
			<xsl:element name="ctl:comment"><xsl:value-of select="$caption"/></xsl:element>
            
            <!-- build the references -->
            <xsl:for-each select=".//html:tbody/html:tr[@class='reference']/html:td/html:ol/html:li">
			   <xsl:apply-templates select="." />
			</xsl:for-each>
			
            <!-- The test case code -->
			<ctl:code>
			<xsl:if test="not(contains($test-id, 'Response'))">
			  <ctlxsl:choose>
			    <ctlxsl:when test="$http-method = 'GET'">
			      <ctl:message>Using KVP encoding.</ctl:message>
			    </ctlxsl:when>
			    <ctlxsl:when test="$http-method = 'XML'">
			      <ctl:message>Using XML encoding.</ctl:message>
			    </ctlxsl:when>
			    <ctlxsl:when test="$http-method = 'SOAP'">
			      <ctl:message>Using SOAP encoding.</ctl:message>
			    </ctlxsl:when>
			    <ctlxsl:otherwise>
			      <ctl:message select="concat('Using ', $http-method, ' encoding.')"/>
			    </ctlxsl:otherwise>
			  </ctlxsl:choose>
			</xsl:if>
			  <xsl:if test="$method-updatesequence">
		        <xsl:choose>
			      <xsl:when test="$method-updatesequence = 'Variable: EqualUpdateSequenceValue'">
			        <ctl:message select="concat('EqualUpdateSequenceValue is |', $EqualUpdateSequenceValue, '|')"/>
			      </xsl:when>
			      <xsl:when test="$method-updatesequence = 'SetupVariable: BogusUpdateSequenceValue'">
			        <ctl:message select="concat('BogusUpdateSequenceValue is |', $BogusUpdateSequenceValue, '|')"/>
			      </xsl:when>
			      <xsl:when test="$method-updatesequence = 'SetupVariable: LowestUpdateSequenceValue'">
			        <ctl:message select="concat('MinimalUpdateSequenceValue is |', $MinimalUpdateSequenceValue, '|')"/>
			      </xsl:when>
			      <xsl:when test="$method-updatesequence = 'SetupVariable: HighestUpdateSequenceValue'">
			        <ctl:message select="concat('MaximalUpdateSequenceValue is |', $MaximalUpdateSequenceValue, '|')"/>
			      </xsl:when>
		        </xsl:choose>
			  </xsl:if>
			  
				<xsl:variable name="describe-skip-initial" select="contains($method-initialrequestcase, 'getcapabilities:acceptversions') and contains($module-id, 'DescribeCoverage')"/>
				<xsl:choose>
				   <!-- There is no initial test case or it is not used -->
				  <xsl:when test="not($method-initialrequestcase) or contains($method-initialrequestcase, 'updatesequence:novalue') or $describe-skip-initial = 'true'">
				    <ctlxsl:variable name = "result">
				      <ctl:request xmlns:ctl="http://www.occamlab.com/ctl">
				        <ctl:url>
				          <ctlxsl:value-of select = "$url"/>
				        </ctl:url>
				        <ctl:method>
				          <ctlxsl:choose>
				            <ctlxsl:when test = "$http-method = 'GET'">GET</ctlxsl:when>
				            <ctlxsl:otherwise>POST</ctlxsl:otherwise>
				          </ctlxsl:choose>
				        </ctl:method>
				        
				        <!-- Encode the request parameters in KVP -->
				        <ctlxsl:if test = "$http-method = 'GET'">
				          <ctl:param name="service"><xsl:value-of select="$method-service"/></ctl:param>
				          <ctl:param name="request"><xsl:value-of select="$method-request"/></ctl:param>
				        <xsl:if test="$method-sections">
					      <ctl:param name="sections"><xsl:value-of select="$method-sections"/></ctl:param>
				        </xsl:if>
				        <xsl:if test="$method-acceptversions">
					      <ctl:param name="acceptversions"><xsl:value-of select="$method-acceptversions"/></ctl:param>
				        </xsl:if>
				        <xsl:if test="$method-updatesequence">
				          <xsl:choose>
							<xsl:when test="$method-updatesequence = '&lt;Empty string&gt;'">
							  <ctl:param name="updateSequence"/>
							</xsl:when>
							<xsl:when test="$method-updatesequence = 'Variable: EqualUpdateSequenceValue'">
							  <ctl:param name="updateSequence"><ctlxsl:value-of select = "$EqualUpdateSequenceValue"/></ctl:param>
							</xsl:when>
							<xsl:when test="$method-updatesequence = 'SetupVariable: BogusUpdateSequenceValue'">
							  <ctl:param name="updateSequence"><ctlxsl:value-of select = "$BogusUpdateSequenceValue"/></ctl:param>
							</xsl:when>
							<xsl:when test="$method-updatesequence = 'SetupVariable: LowestUpdateSequenceValue'">
							  <ctl:param name="updateSequence"><ctlxsl:value-of select = "$MinimalUpdateSequenceValue"/></ctl:param>
							</xsl:when>
							<xsl:when test="$method-updatesequence = 'SetupVariable: HighestUpdateSequenceValue'">
							  <ctl:param name="updateSequence"><ctlxsl:value-of select = "$MaximalUpdateSequenceValue"/></ctl:param>
							</xsl:when>
							<xsl:otherwise>
							  <ctl:param name="updateSequence"><xsl:value-of select="$method-updatesequence"/></ctl:param>
							</xsl:otherwise>
						  </xsl:choose>
				        </xsl:if>
				        <xsl:if test="$method-acceptformats">
					      <ctl:param name="acceptformats"><xsl:value-of select="$method-acceptformats"/></ctl:param>
				        </xsl:if>
				        <xsl:if test="$method-version">
					      <ctl:param name="version"><xsl:value-of select="$method-version"/></ctl:param>
				        </xsl:if>
				        <xsl:if test="$method-identifier">
				          <xsl:choose>
						    <xsl:when test="$method-identifier = '&lt;Empty string&gt;'">
						      <ctl:param name="identifiers"/>
						    </xsl:when>
						    <xsl:when test="$method-identifier = 'Variable: Identifier'">
						      <ctl:param name="identifiers"><ctlxsl:value-of select = "$identifier1"/></ctl:param>
						    </xsl:when>
						    <xsl:when test="$method-identifier = 'Bogus, Variable: Identifier'">
						      <ctl:param name="identifiers"><ctlxsl:value-of select = "concat('Bogus,', $identifier1)"/></ctl:param>
						    </xsl:when>
						    <xsl:when test="$method-identifier = 'Variables: Identifier1, Identifier2, Identifier3'">
						      <ctl:param name="identifiers"><ctlxsl:value-of select = "concat($identifier1, ',', $identifier2, ',', $identifier3)"/></ctl:param>
						    </xsl:when>
						    <xsl:otherwise>
						      <ctl:param name="identifiers"><xsl:value-of select="$method-identifier"/></ctl:param>
						    </xsl:otherwise>
						  </xsl:choose>
				        </xsl:if>
				        <xsl:if test="$method-domainSubset">
					      <ctl:param name="domainSubset"><xsl:value-of select="$method-domainSubset"/></ctl:param>
				        </xsl:if>
				        </ctlxsl:if>
				        
				        <!-- Encode the parameters in XML/SOAP -->
				        <ctlxsl:if test = "$http-method = 'XML' or $http-method = 'SOAP'">
				          <!--<xsl:element name="xsl:if">
				            <xsl:attribute name="test">$http-method = 'SOAP'</xsl:attribute>
				            <ctl:header>
				              SOAPAction: "yes"
				            </ctl:header>				            
				          </xsl:element>-->
				          <ctl:body>
				          <!--<xsl:element name="xsl:if">
				            <xsl:attribute name="test">$http-method='SOAP'</xsl:attribute>
				          <xsl:text disable-output-escaping="yes">&lt;SOAP-ENV:Envelope
  xmlns:SOAP-ENV=&quot;http://schemas.xmlsoap.org/soap/envelope/&quot;
  SOAP-ENV:encodingStyle=&quot;http://schemas.xmlsoap.org/soap/encoding/&quot;&gt;
   &lt;SOAP-ENV:Body&gt;</xsl:text>
					     </xsl:element>-->
				            <!-- Operation parent element -->
				            <xsl:text disable-output-escaping="yes">&#10;                              &lt;</xsl:text>
				            <xsl:value-of select="$method-request"/>
				            <xsl:text disable-output-escaping="yes"> xmlns=&quot;http://www.opengis.net/wcs/1.1.1&quot; xmlns:ows=&quot;http://www.opengis.net/ows/1.1&quot; xmlns:xsi=&quot;http://www.w3.org/2001/XMLSchema-instance&quot; xsi:schemaLocation=&quot;http://www.opengis.net/wcs/1.1.1 http://schemas.opengis.net/wcs/1.1.1/wcsAll.xsd&quot; service = &quot;</xsl:text>
				            <xsl:value-of select="$method-service"/>
				            <xsl:text disable-output-escaping="yes">&quot;</xsl:text>
				            <xsl:if test="$method-version">
				              <xsl:text disable-output-escaping="yes"> version =&quot;</xsl:text>
				              <xsl:choose>
								<xsl:when test="$method-version">
								  <xsl:value-of select="$method-version"/>
								</xsl:when>
								<xsl:otherwise>
								  <xsl:text disable-output-escaping="yes">1.1.1</xsl:text>
								</xsl:otherwise>
							  </xsl:choose>
				              <xsl:text disable-output-escaping="yes">&quot;</xsl:text>
				            </xsl:if>
				            <xsl:if test="$method-updatesequence">
				              <xsl:text disable-output-escaping="yes"> updateSequence =</xsl:text>
				              <xsl:choose>
							    <xsl:when test="$method-updatesequence = '&lt;Empty string&gt;'">
							      <xsl:text disable-output-escaping="yes">&quot;&quot;</xsl:text>
							    </xsl:when>
							    <xsl:when test="$method-updatesequence = 'Variable: EqualUpdateSequenceValue'">
							      <xsl:text disable-output-escaping="yes">&quot;</xsl:text>{$EqualUpdateSequenceValue}<xsl:text disable-output-escaping="yes">&quot;</xsl:text>
							    </xsl:when>
							    <xsl:when test="$method-updatesequence = 'SetupVariable: BogusUpdateSequenceValue'">
							      <xsl:text disable-output-escaping="yes">&quot;</xsl:text>{$BogusUpdateSequenceValue}<xsl:text disable-output-escaping="yes">&quot;</xsl:text>
							    </xsl:when>
							    <xsl:when test="$method-updatesequence = 'SetupVariable: LowestUpdateSequenceValue'">
							      <xsl:text disable-output-escaping="yes">&quot;</xsl:text>{$MinimalUpdateSequenceValue}<xsl:text disable-output-escaping="yes">&quot;</xsl:text>
							    </xsl:when>
							    <xsl:when test="$method-updatesequence = 'SetupVariable: HighestUpdateSequenceValue'">
							      <xsl:text disable-output-escaping="yes">&quot;</xsl:text>{$MaximalUpdateSequenceValue}<xsl:text disable-output-escaping="yes">&quot;</xsl:text>
							    </xsl:when>
							    <xsl:otherwise>
							      <xsl:text disable-output-escaping="yes">&quot;</xsl:text><xsl:value-of select="$method-updatesequence"/><xsl:text disable-output-escaping="yes">&quot;</xsl:text>
							    </xsl:otherwise>
						      </xsl:choose>
				            </xsl:if>
				        
				            <xsl:text disable-output-escaping="yes">&gt;</xsl:text>
				            
				            <!-- Child elements -->
				            <xsl:if test="$method-acceptversions">
				              <xsl:text disable-output-escaping="yes">&#10;                                &lt;ows:AcceptVersions&gt;</xsl:text>
				              <xsl:call-template name="process-values">
				                <xsl:with-param name="values" select="$method-acceptversions"/>
				                <xsl:with-param name="attribute">ows:Version</xsl:with-param>
				              </xsl:call-template>
				              <xsl:text disable-output-escaping="yes">&#10;                                &lt;/ows:AcceptVersions&gt;</xsl:text>
				            </xsl:if>
				            
				            <xsl:if test="$method-sections">
				              <xsl:text disable-output-escaping="yes">&#10;                                &lt;ows:Sections&gt;</xsl:text>
				              <xsl:call-template name="process-values">
				                <xsl:with-param name="values" select="$method-sections"/>
				                <xsl:with-param name="attribute">ows:Section</xsl:with-param>
				              </xsl:call-template>
				              <xsl:text disable-output-escaping="yes">&#10;                                &lt;/ows:Sections&gt;</xsl:text>
				            </xsl:if>
	
				            <xsl:if test="$method-acceptformats">
				              <xsl:text disable-output-escaping="yes">&#10;                                &lt;ows:AcceptFormats&gt;</xsl:text>
				              <xsl:call-template name="process-values">
				                <xsl:with-param name="values" select="$method-acceptformats"/>
				                <xsl:with-param name="attribute">ows:OutputFormat</xsl:with-param>
				              </xsl:call-template>
				              <xsl:text disable-output-escaping="yes">&#10;                                &lt;/ows:AcceptFormats&gt;</xsl:text>
				            </xsl:if>

				            <xsl:if test="$method-identifier">
				              <xsl:text disable-output-escaping="yes">&lt;Identifier&gt;</xsl:text>
				              <xsl:choose>
							    <xsl:when test="$method-identifier = '&lt;Empty string&gt;'">
							      <xsl:text disable-output-escaping="yes"></xsl:text>
							    </xsl:when>
							    <xsl:when test="$method-identifier = 'Variable: Identifier'">
							      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>xsl:value-of select=&quot;$identifier1&quot;/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
							    </xsl:when>
							    <xsl:when test="$method-identifier = 'Bogus, Variable: Identifier'">
							      <xsl:text disable-output-escaping="yes"></xsl:text>Bogus<xsl:text disable-output-escaping="yes">&lt;/Identifier&gt;</xsl:text>
							      <xsl:text disable-output-escaping="yes">&lt;Identifier&gt;&lt;</xsl:text>xsl:value-of select=&quot;$identifier1&quot;/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
							    </xsl:when>
							    <xsl:when test="$method-identifier = 'Variables: Identifier1, Identifier2, Identifier3'">
							      <xsl:text disable-output-escaping="yes">&lt;</xsl:text>xsl:value-of select=&quot;$identifier1&quot;/<xsl:text disable-output-escaping="yes">&gt;&lt;/Identifier&gt;</xsl:text>
							      <xsl:text disable-output-escaping="yes">&lt;Identifier&gt;&lt;</xsl:text>xsl:value-of select=&quot;$identifier2&quot;/<xsl:text disable-output-escaping="yes">&gt;&lt;/Identifier&gt;</xsl:text>
							      <xsl:text disable-output-escaping="yes">&lt;Identifier&gt;&lt;</xsl:text>xsl:value-of select=&quot;$identifier3&quot;/<xsl:text disable-output-escaping="yes">&gt;</xsl:text>
							    </xsl:when>
							    <xsl:otherwise>
							      <xsl:text disable-output-escaping="yes"></xsl:text><xsl:value-of select="$method-identifier"/><xsl:text disable-output-escaping="yes"></xsl:text>
							    </xsl:otherwise>
						      </xsl:choose>
						      <xsl:text disable-output-escaping="yes">&lt;/Identifier&gt;</xsl:text>
				            </xsl:if>
				            
				            <!-- End the request element -->
   				            <xsl:text disable-output-escaping="yes">&#10;                              &lt;/</xsl:text>
   				            <xsl:value-of select="$method-request"/>
   				            <xsl:text disable-output-escaping="yes">&gt;&#10;                            </xsl:text>
   				            <!--<xsl:element name="xsl:if">
				            <xsl:attribute name="test">$http-method='SOAP'</xsl:attribute>
   				            <xsl:text disable-output-escaping="yes">&lt;/SOAP-ENV:Body&gt;
&lt;/SOAP-ENV:Envelope&gt;</xsl:text>
</xsl:element>-->
				          </ctl:body>
				        </ctlxsl:if>
				        
				        <xsl:if test="$method-validator">
				          <ctlp:XMLValidatingParser xmlns:ctlp="http://www.occamlab.com/te/parsers">
	                  <ctlp:schemas>
	                    <xsl:choose>
						            <xsl:when test="starts-with($method-validator, 'http:')">
						              <ctlp:schema type="url"><xsl:value-of select="$method-validator"/></ctlp:schema>
						            </xsl:when>
						            <xsl:when test="starts-with($method-validator, 'file:./resources/')">
						              <ctlp:schema type="resource"><xsl:value-of select="substring($method-validator, 18)"/></ctlp:schema>
						            </xsl:when>
						            <xsl:when test="starts-with($method-validator, 'file:')">
						              <ctlp:schema type="file"><xsl:value-of select="substring($method-validator, 6)"/></ctlp:schema>
						            </xsl:when>
						            <xsl:otherwise>
						              <cltp:schema type="file"><xsl:value-of select="$method-validator"/></cltp:schema>
						            </xsl:otherwise>
						          </xsl:choose>
                    </ctlp:schemas>
                  </ctlp:XMLValidatingParser>
                </xsl:if>
				      </ctl:request> 
				    </ctlxsl:variable>
				  
				    <!-- There should be a validator and a parsed result -->
				    <xsl:choose>
				      <xsl:when test="$method-validator">
				        <xsl:choose>
				          <xsl:when test="$method-updatesequence = 'Variable: EqualUpdateSequenceValue'">
				            <ctlxsl:if test = "string-length($result)!=0">
				              <ctl:message>Parse error in test. Perhaps the response conforms to the wrong schema.</ctl:message>
				              <ctl:fail/>
				            </ctlxsl:if>
				          </xsl:when>
				          <xsl:otherwise>
				            <ctlxsl:if test = "string-length($result)=0">
				              <ctl:message>Parse error in test. Perhaps the response conforms to the wrong schema.</ctl:message>
				              <ctl:fail/>
				            </ctlxsl:if>
				          </xsl:otherwise>
						</xsl:choose>
				      </xsl:when>
				      <xsl:otherwise>
				        <ctl:fail/>
				      </xsl:otherwise>
				    </xsl:choose>
				  </xsl:when>
				  
				  <!-- There is an initial request case from which some values are extracted -->
	              <xsl:otherwise>
	                <xsl:choose>
	                  <xsl:when test="contains($method-initialrequestcase, 'getcapabilities:acceptversions')">
	                    <ctlxsl:variable name = "get-result">
	                        <ctl:call-function name="wcs:get-capabilities-accept-versions">
	                          <ctl:with-param name="url" select="$url" />
	                        </ctl:call-function>
	                    </ctlxsl:variable>
	                    <ctlxsl:if test="$get-result/*[local-name()='ExceptionReport']">
	                      <ctl:message select="concat('A GetCapabilities AcceptVersions initial test case failed. The error is ', $get-result/*[local-name()='ExceptionReport']/*[local-name()='Exception']/*[local-name()='ExceptionText'])"/>
	                      <ctl:fail/>
	                    </ctlxsl:if>
	                    <xsl:if test="$method-response-extract">
	                      <xsl:for-each select=".//html:tbody/html:tr[@class='method']/html:td/html:a[@class='response-extract']">
	                        <xsl:variable name="condition">
	                          <xsl:call-template name="expand-xpath" >
	                            <xsl:with-param name="xpath" select="./@title"/>
	                          </xsl:call-template>
	                        </xsl:variable>
	                        <xsl:element name="xsl:if">
	                          <xsl:choose>
	                            <xsl:when test = "./@type = 'negative'">
	                              <xsl:attribute name="test">$get-result<xsl:value-of select="$condition"/></xsl:attribute>
	                            </xsl:when>
	                            <xsl:otherwise>
	                              <xsl:attribute name="test">not($get-result<xsl:value-of select="$condition"/>)</xsl:attribute>
	                            </xsl:otherwise>
	                          </xsl:choose>
	                          <xsl:choose>
	                            <xsl:when test = "not(./@type = 'no-fail')">
	                              <ctl:message>    </ctl:message>
	                              <ctl:message>Test failed because an element is missing from the response.</ctl:message>
	                              <ctl:message>extraction is $get-result<xsl:value-of select="$condition"/></ctl:message>
					              <ctl:message>response-extract is <xsl:element name="xsl:value-of"><xsl:attribute name="select">$get-result<xsl:value-of select="$condition"/></xsl:attribute></xsl:element></ctl:message>
	                              <ctl:fail/>
	                            </xsl:when>
	                            <xsl:otherwise>
	                              <ctl:message>    </ctl:message>
	                              <ctl:message>Could not extract an element from the response, but this is not a failure.</ctl:message>
	                              <ctl:message>extraction is $get-result<xsl:value-of select="$condition"/></ctl:message>
					                      <ctl:message>response-extract is <xsl:element name="xsl:value-of"><xsl:attribute name="select">$get-result<xsl:value-of select="$condition"/></xsl:attribute></xsl:element></ctl:message>
	                            </xsl:otherwise>
	                          </xsl:choose>
	                        </xsl:element>
			              </xsl:for-each>
	                    </xsl:if>
	                    <xsl:if test="not($method-response-extract) and not($method-validator)">
	                      <ctl:message>Test failed by default because there is insufficient detail in the pass condition.</ctl:message>
	                      <ctl:fail/>
	                    </xsl:if>
	                  </xsl:when>
	                  <xsl:when test="contains($method-initialrequestcase, 'describecoverage:multipleidentifiers')">
	                    <ctlxsl:variable name = "describe-result">
	                        <ctl:call-function name="wcs:describe-coverage-multiple-identifiers">
	                          <ctl:with-param name="url" select="$url" />
	                          <ctl:with-param name="http-method" select="$http-method" />
	                          <ctl:with-param name="identifier1" select="$identifier1" />
	                          <ctl:with-param name="identifier2" select="$identifier2" />
	                          <ctl:with-param name="identifier3" select="$identifier3" />
	                        </ctl:call-function>
	                    </ctlxsl:variable>
	                    <ctlxsl:if test="$describe-result/*[local-name()='ExceptionReport']">
	                      <ctl:message select="concat('A DescribeCoverage MultipleIdentifiers initial test case failed. The error is ', $describe-result/*[local-name()='ExceptionReport']/*[local-name()='Exception']/*[local-name()='ExceptionText'])"/>
	                      <ctl:fail/>
	                    </ctlxsl:if>
	                    <xsl:if test="$method-extract">
	                      <xsl:variable name="condition1">
	                        <xsl:choose>
	                          <xsl:when test = "substring-before($method-extract, ' and ')">
	                            <xsl:call-template name="expand-xpath" >
	                              <xsl:with-param name="xpath" select="concat('CoverageDescriptions/CoverageDescription/', substring-before($method-extract, ' and '), '/')"/>
	                            </xsl:call-template>
	                          </xsl:when>
	                          <xsl:otherwise>
	                            <xsl:call-template name="expand-xpath" >
	                              <xsl:with-param name="xpath" select="concat('CoverageDescriptions/CoverageDescription/', $method-extract, '/')"/>
	                            </xsl:call-template>
	                          </xsl:otherwise>
	                        </xsl:choose>
	                      </xsl:variable>
	                      <xsl:choose>
	                        <xsl:when test = "$condition1">
	                          <xsl:element name = "xsl:for-each">
	                            <xsl:attribute name = "select">$describe-result<xsl:value-of select="$condition1"/></xsl:attribute>
	                            <ctlxsl:variable name = "value" select = "."/>
	                            <xsl:choose>
	                              <xsl:when test = "contains($condition1, 'InterpolationMethod') and not(contains($test-id, 'XML'))">
	                                <ctlxsl:if test = "not(contains('nearest, linear, quadratic, cubic, name', $value)) and not(./*[@codespace])">
	                                  <ctl:message><ctlxsl:value-of select = "$value"/> should be one of nearest, linear, quadratic, cubic, none.</ctl:message>
	                                  <ctl:fail/>
	                                </ctlxsl:if>
	                              </xsl:when>
	                              <xsl:otherwise>
	                                <!-- Fixme: we can test for XML validity and URL escaped-ness? See item 31 at the top. -->
	                              </xsl:otherwise>
	                            </xsl:choose>
	                          </xsl:element>
	                        </xsl:when>
	                        <xsl:otherwise>
	                          <ctl:message>    </ctl:message>
	                          <ctl:message>Test failed because an element is missing from the response.</ctl:message>
	                          <ctl:fail/>
	                        </xsl:otherwise>
	                      </xsl:choose>
	                      <xsl:if test = "substring-after($method-extract, ' and ')">
	                        <xsl:variable name="condition2">
	                          <xsl:call-template name="expand-xpath" >
	                            <xsl:with-param name="xpath" select="concat('CoverageDescriptions/CoverageDescription/', substring-after($method-extract, ' and '), '/')"/>
	                          </xsl:call-template>
	                        </xsl:variable>
	                        <xsl:choose>
	                          <xsl:when test = "not($condition2)">
	                            <ctl:message>    </ctl:message>
	                            <ctl:message>Test failed because an element is missing from the response.</ctl:message>
	                            <ctl:message>extraction is $describe-result<xsl:value-of select="$condition2"/></ctl:message>
	                            <ctl:message>extract is <xsl:element name="xsl:value-of"><xsl:attribute name="select">$describe-result<xsl:value-of select="$condition2"/></xsl:attribute></xsl:element></ctl:message>
	                          </xsl:when>
	                          <xsl:otherwise>
	                            <xsl:if test = "contains($condition2, 'InterpolationMethod') and not(contains($test-id, 'XML'))">
	                              <xsl:element name="xsl:if">
	                                <xsl:attribute name="test">not(contains('nearest, linear, quadratic, cubic, name', <xsl:value-of select="$condition2"/>))</xsl:attribute>
	                                <ctl:message>$describe-result<xsl:value-of select = "$condition2"/> should be one of nearest, linear, quadratic, cubic, none.</ctl:message>
	                                <ctl:fail/>
	                              </xsl:element>
	                            </xsl:if>
	                          </xsl:otherwise>
	                        </xsl:choose>
	                      </xsl:if>
	                    </xsl:if>
	                    <xsl:if test="not($method-extract)">
	                      <ctl:message>Missing an extract clause for a describecoverage:multipleidentifiers initial request case</ctl:message>
	                      <ctl:fail/>
	                    </xsl:if>
	                  </xsl:when>
	                  <xsl:when test="contains($method-initialrequestcase, 'describecoverage:minimalrequest') or contains($method-initialrequestcase, 'describecoverage:response:interpolationmethods')">
	                    <ctlxsl:variable name = "describe-min-result">
	                        <ctl:call-function name="wcs:describe-coverage-minimal-request">
	                          <ctl:with-param name="url" select="$url" />
	                          <ctl:with-param name="http-method" select="$http-method" />
	                          <ctl:with-param name="identifier" select="$identifier1" />
	                        </ctl:call-function>
	                    </ctlxsl:variable>
	                    <ctlxsl:choose>
	                      <ctlxsl:when test="$describe-min-result/*[local-name()='ExceptionReport']">
	                        <ctl:message select="concat('A DescribeCoverage MinimalRequest initial test case failed. The error is ', $describe-min-result/*[local-name()='ExceptionReport']/*[local-name()='Exception']/*[local-name()='ExceptionText'])"/>
	                        <ctl:fail/>
	                      </ctlxsl:when>
	                    <ctlxsl:otherwise>
	                    <xsl:for-each select=".//html:tbody/html:tr[@class='method']/html:td/html:table/html:tbody/html:tr[@class='extract']">
	                      <xsl:choose>
	                        <xsl:when test="not(contains(./html:td[2], ' Identifier')) and not(contains(./html:td[2], 'BoundingBox'))">
	                          <xsl:element name = "xsl:variable">
	                            <xsl:attribute name = "name">
	                              <xsl:choose>
	                                <xsl:when test = "substring-before(substring-after(./html:td[2], 'Variable: '), ' ')" >
	                                  <xsl:value-of select="substring-before(substring-after(./html:td[2], 'Variable: '), ' ')" />
	                                </xsl:when>
	                                <xsl:otherwise>
	                                  <xsl:value-of select="substring-after(./html:td[2], 'Variable: ')" />
	                                </xsl:otherwise>
	                              </xsl:choose>
	                            </xsl:attribute>
							                <xsl:text disable-output-escaping="yes">&lt;xsl:value-of select = &quot;$describe-min-result</xsl:text>
	                            <xsl:call-template name="expand-xpath" >
	                              <xsl:with-param name="xpath" select="concat('CoverageDescriptions/CoverageDescription/', ./html:td[1], '/')"/>
	                            </xsl:call-template>
	                            <xsl:text disable-output-escaping="yes">&quot;/&gt;</xsl:text>
	                          </xsl:element>
	                        </xsl:when>
	                        <xsl:when test="contains(./html:td[2], 'BoundingBox')">
	                          <ctlxsl:variable name="BoundingBoxCRS">
	                            <ctlxsl:choose>
                                <ctlxsl:when test="$describe-min-result/*[local-name()='CoverageDescriptions']/*[local-name()='CoverageDescription']/*[local-name()='Domain']/*[local-name()='SpatialDomain']/*[local-name()='BoundingBox']">
                                  <ctlxsl:value-of select="$describe-min-result/*[local-name()='CoverageDescriptions']/*[local-name()='CoverageDescription']/*[local-name()='Domain']/*[local-name()='SpatialDomain']/*[local-name()='BoundingBox']/@crs"/>
                                </ctlxsl:when>
                                <ctlxsl:when test="$describe-min-result/*[local-name()='CoverageDescriptions']/*[local-name()='CoverageDescription']/*[local-name()='Domain']/*[local-name()='SpatialDomain']/*[local-name()='WGS84BoundingBox']">urn:ogc:def:crs:OGC:2:84</ctlxsl:when>
                              </ctlxsl:choose>
	                          </ctlxsl:variable>
	                          <ctlxsl:variable name="BoundingBoxLowerCorner">
	                            <ctlxsl:choose>
                                <ctlxsl:when test="$describe-min-result/*[local-name()='CoverageDescriptions']/*[local-name()='CoverageDescription']/*[local-name()='Domain']/*[local-name()='SpatialDomain']/*[local-name()='BoundingBox']">
                                  <ctlxsl:value-of select="$describe-min-result/*[local-name()='CoverageDescriptions']/*[local-name()='CoverageDescription']/*[local-name()='Domain']/*[local-name()='SpatialDomain']/*[local-name()='BoundingBox']//*[local-name()='LowerCorner']"/>
                                </ctlxsl:when>
                                <ctlxsl:when test="$describe-min-result/*[local-name()='CoverageDescriptions']/*[local-name()='CoverageDescription']/*[local-name()='Domain']/*[local-name()='SpatialDomain']/*[local-name()='WGS84BoundingBox']">
                                  <ctlxsl:value-of select="$describe-min-result/*[local-name()='CoverageDescriptions']/*[local-name()='CoverageDescription']/*[local-name()='Domain']/*[local-name()='SpatialDomain']/*[local-name()='WGS84BoundingBox']/*[local-name()='LowerCorner']"/>
                                </ctlxsl:when>
                              </ctlxsl:choose>
	                          </ctlxsl:variable>
	                          <ctlxsl:variable name="BoundingBoxUpperCorner">
	                            <ctlxsl:choose>
                                <ctlxsl:when test="$describe-min-result/*[local-name()='CoverageDescriptions']/*[local-name()='CoverageDescription']/*[local-name()='Domain']/*[local-name()='SpatialDomain']/*[local-name()='BoundingBox']">
                                  <ctlxsl:value-of select="$describe-min-result/*[local-name()='CoverageDescriptions']/*[local-name()='CoverageDescription']/*[local-name()='Domain']/*[local-name()='SpatialDomain']/*[local-name()='BoundingBox']/*[local-name()='UpperCorner']"/>
                                </ctlxsl:when>
                                <ctlxsl:when test="$describe-min-result/*[local-name()='CoverageDescriptions']/*[local-name()='CoverageDescription']/*[local-name()='Domain']/*[local-name()='SpatialDomain']/*[local-name()='WGS84BoundingBox']">
                                  <ctlxsl:value-of select="$describe-min-result/*[local-name()='CoverageDescriptions']/*[local-name()='CoverageDescription']/*[local-name()='Domain']/*[local-name()='SpatialDomain']/*[local-name()='WGS84BoundingBox']/*[local-name()='UpperCorner']"/>
                                </ctlxsl:when>
                              </ctlxsl:choose>
	                          </ctlxsl:variable>
	                          <ctlxsl:variable name="LowerCornerX" select="substring-before($BoundingBoxLowerCorner, ' ')"/>
		                        <ctlxsl:variable name="LowerCornerY" select="substring-after($BoundingBoxLowerCorner, ' ')"/>
		                        <ctlxsl:variable name="UpperCornerX" select="substring-before($BoundingBoxUpperCorner, ' ')"/>
		                        <ctlxsl:variable name="UpperCornerY" select="substring-after($BoundingBoxUpperCorner, ' ')"/>
		                        <ctlxsl:variable name="LengthX" select="$UpperCornerX - $LowerCornerX"/>
		                        <ctlxsl:variable name="LengthY" select="$UpperCornerY - $LowerCornerY"/>
		                        <ctlxsl:variable name="DeltaX" select="$LengthX * 0.025"/>
		                        <ctlxsl:variable name="DeltaY" select="$LengthY * 0.025"/>
	                        </xsl:when>
	                      </xsl:choose>
	                    </xsl:for-each>
	                    <!-- Fixme: GridBaseCRS and GridOffsets should not be required. Remove when Steven has fixed the problem. -->
	                    <ctlxsl:variable name="GridBaseCRS" select="$describe-min-result/*[local-name()='CoverageDescriptions']/*[local-name()='CoverageDescription']/*[local-name()='Domain']/*[local-name()='SpatialDomain']/*[local-name()='GridCRS']/*[local-name()='GridBaseCRS']"/>
	                    <ctlxsl:variable name="GridOffsets" select="$describe-min-result/*[local-name()='CoverageDescriptions']/*[local-name()='CoverageDescription']/*[local-name()='Domain']/*[local-name()='SpatialDomain']/*[local-name()='GridCRS']/*[local-name()='GridOffsets']"/>
                        <ctlxsl:variable name="get-coverage-result">
                        <ctl:request>
	                      <ctl:url>
		                    <ctlxsl:value-of select="$url"/>
		                  </ctl:url>
		                  <ctl:method>
			                <ctlxsl:choose>
				              <ctlxsl:when test = "$http-method = 'GET'">GET</ctlxsl:when>
				              <ctlxsl:otherwise>POST</ctlxsl:otherwise>
				            </ctlxsl:choose>
		                  </ctl:method>
		                  <xsl:if test="$method-service != 'WCS' or $method-request != 'GetCoverage' or $method-version != '1.1.1'">
		                    <ctl:message>Unexpected service, request or version.</ctl:message>
		                    <ctl:fail/>
		                  </xsl:if>
		                  <ctlxsl:choose>
				                <ctlxsl:when test = "$http-method = 'GET'">
		                      <ctl:param name="service">WCS</ctl:param>
		                      <ctl:param name="request">GetCoverage</ctl:param>
		                      <ctl:param name="version">1.1.1</ctl:param>
		                      <xsl:choose>
		                        <xsl:when test = "not($method-identifier)"/>
		                        <xsl:when test = "$method-identifier = '&lt;Empty string&gt;'">
		                          <ctl:param name="identifier"/>
		                        </xsl:when>
		                        <xsl:when test= "$method-identifier = 'Bogus'">
		                          <ctl:param name="identifier">Bogus</ctl:param>
		                        </xsl:when>
		                        <xsl:otherwise>
		                          <ctl:param name="identifier">
		                            <ctlxsl:value-of select = "$identifier1"/>
		                          </ctl:param>
		                        </xsl:otherwise>
		                      </xsl:choose>
		                      <xsl:if test="$method-domainSubset">
		                        <xsl:choose>
		                          <xsl:when test="starts-with($method-domainSubset, 'Variable: ') and not(contains($method-domainSubset, '. Each')) and not(contains($method-domainSubset, 'with'))">
		                            <ctl:param name = "BoundingBox">
		                              <ctlxsl:value-of select="concat($LowerCornerX, ',', $LowerCornerY, ',', $UpperCornerX, ',', $UpperCornerY,  ',', $BoundingBoxCRS)"/>
		                            </ctl:param>
		                          </xsl:when>
		                          <xsl:when test="contains($method-domainSubset, 'increased by the length')">
		                            <ctl:param name = "BoundingBox">
		                            <ctlxsl:value-of select="concat($LowerCornerX + $LengthX + $DeltaX, ',', $LowerCornerY + $LengthY + $DeltaY, ',', $UpperCornerX + $LengthX + $DeltaX, ',', $UpperCornerY + $LengthY + $DeltaY,  ',', $BoundingBoxCRS)"/>
		                            </ctl:param>
		                          </xsl:when>
		                          <xsl:when test="contains($method-domainSubset, 'LowerCorner coordinate is reduced') and contains($method-domainSubset, 'UpperCorner coordinate is increased')">
		                            <ctl:param name = "BoundingBox">
		                            <ctlxsl:value-of select="concat($LowerCornerX - $DeltaX, ',', $LowerCornerY - $DeltaY, ',', $UpperCornerX + $DeltaX, ',', $UpperCornerY + $DeltaY,  ',', $BoundingBoxCRS)"/>
		                            </ctl:param>
		                          </xsl:when>
		                          <xsl:when test="contains($method-domainSubset, 'LowerCorner coordinate is increased') and contains($method-domainSubset, 'UpperCorner coordinate is decreased')">
		                            <ctl:param name = "BoundingBox">
		                            <ctlxsl:value-of select="concat($LowerCornerX + $DeltaX, ',', $LowerCornerY + $DeltaY, ',', $UpperCornerX - $DeltaX, ',', $UpperCornerY - $DeltaY,  ',', $BoundingBoxCRS)"/>
		                            </ctl:param>
		                          </xsl:when>
		                          <xsl:when test="contains($method-domainSubset, 'LowerCorner coordinate is increased') and contains($method-domainSubset, 'UpperCorner coordinate is also increased')">
		                            <ctl:param name = "BoundingBox">
		                            <ctlxsl:value-of select="concat($LowerCornerX + $DeltaX, ',', $LowerCornerY + $DeltaY, ',', $UpperCornerX + $DeltaX, ',', $UpperCornerY + $DeltaY,  ',', $BoundingBoxCRS)"/>
		                            </ctl:param>
		                          </xsl:when>
		                          <xsl:when test="contains($method-domainSubset, 'LowerCorner coordinate is -1e20') and contains($method-domainSubset, 'UpperCorner coordinate is +1e20')">
		                            <ctl:param name = "BoundingBox"><ctlxsl:value-of select="concat('-1e20,-1e20,1e20,1e20,', $BoundingBoxCRS)"/></ctl:param>
		                          </xsl:when>
		                          <xsl:when test="contains($method-domainSubset, 'GeographicBoundingBox') and contains($method-domainSubset, 'Longitude of +179.5')">
		                            <ctl:param name="BoundingBox">179.5,10,-179.5,20,urn:ogc:def:crs:OGC:2:84</ctl:param>
		                          </xsl:when>
		                          <xsl:otherwise>
		                            <ctl:param name = "BoundingBox"><xsl:value-of select="$method-domainSubset"/></ctl:param>
		                          </xsl:otherwise>
		                        </xsl:choose>
		                      </xsl:if>
		                      <!-- Fixme: use method-frame -->
		                      <xsl:if test="$method-temporalSubset or $method-beginTime or $method-endTime">
		                        <ctl:param name = "TimeSequence">
		                          <xsl:choose>
		                            <xsl:when test="starts-with($method-temporalSubset, 'Variable: ')">
		                              <xsl:element name = "xsl:value-of">
		                                <xsl:attribute name = "select">$<xsl:value-of select="substring-after($method-temporalSubset, 'Variable: ')"/></xsl:attribute>
		                              </xsl:element>
		                            </xsl:when>
		                            <xsl:when test="$method-temporalSubset">
		                              <xsl:value-of select="$method-temporalSubset"/>
		                            </xsl:when>
		                            <xsl:when test="$method-beginTime or $method-endTime">
		                              <xsl:choose>
		                                <xsl:when test="contains($method-beginTime, '- 1Y')">
		                                  <ctlxsl:value-of select="concat(number(substring($TimePosition, 1, 4)) - 1, substring($TimePosition, 5))"/>
		                                </xsl:when>
		                                <xsl:when test="contains($method-beginTime, '- 2M')">
		                                  <ctlxsl:value-of select="concat(substring($TimePosition, 1, 5), format-number(max((number(substring($TimePosition, 6, 2)) - 2, 1)), '00'), substring($TimePosition, 8))"/>
		                                </xsl:when>
		                                <xsl:when test="contains($method-beginTime, '- 10D')">
		                                  <ctlxsl:value-of select="concat(substring($TimePosition, 1, 8), max((number(substring($TimePosition, 9, 2)) - 10, 1)), substring($TimePosition, 11))"/>
		                                </xsl:when>
		                                <xsl:otherwise>
		                                  <xsl:value-of select="$method-beginTime"/>
		                                </xsl:otherwise>
		                              </xsl:choose>
		                              <ctlxsl:value-of select="'/'"/>
		                              <xsl:choose>
		                                <xsl:when test="contains($method-endTime, '+ 1Y')">
		                                  <ctlxsl:value-of select="concat(number(substring($TimePosition, 1, 4)) + 1, substring($TimePosition, 5))"/>
		                                </xsl:when>
		                                <xsl:when test="contains($method-endTime, '+ 2M')">
		                                  <ctlxsl:value-of select="concat(substring($TimePosition, 1, 5), format-number(min((number(substring($TimePosition, 6, 2)) + 2, 12)), '00'), substring($TimePosition, 8))"/>
		                                </xsl:when>
		                                <xsl:when test="contains($method-endTime, '+ 10D')">
		                                  <ctlxsl:value-of select="concat(substring($TimePosition, 1, 8), min((number(substring($TimePosition, 9, 2)) + 10, 28)), substring($TimePosition, 11))"/>
		                                </xsl:when>
		                                <xsl:otherwise>
		                                  <xsl:value-of select="$method-endTime"/>
		                                </xsl:otherwise>
		                              </xsl:choose>
		                              <xsl:if test="$method-timeResolution">
		                                <xsl:value-of select="concat('/', $method-timeResolution)"/>
		                              </xsl:if>
		                            </xsl:when>
		                          </xsl:choose>
		                        </ctl:param>
		                      </xsl:if>
		                      <xsl:if test="$method-fieldIdentifier">
		                        <xsl:text disable-output-escaping="yes">&lt;ctl:param name=&quot;RangeSubset&quot;&gt;</xsl:text>
		                        <xsl:choose>
		                          <xsl:when test= "$method-fieldIdentifier = 'Bogus'">Bogus</xsl:when>
		                          <xsl:when test="contains($method-fieldIdentifier, 'FieldIdentifier1, FieldIdentifier1')">
		                            <ctlxsl:value-of select="concat($FieldIdentifier, ',', $FieldIdentifier)"/>
		                          </xsl:when>
		                          <xsl:when test="contains($method-fieldIdentifier, 'FieldIdentifier1, FieldIdentifier2')">
		                            <ctlxsl:if test="string-length($FieldIdentifier2) = 0">
		                              <ctl:message>FieldIdentifier2 is not found. Need to skip test.</ctl:message>
		                            </ctlxsl:if>
		                            <ctlxsl:value-of select="concat($FieldIdentifier1, ',', $FieldIdentifier2)"/>
		                          </xsl:when>
		                          <xsl:when test="contains($method-fieldIdentifier, 'FieldIdentifier, Bogus')">
		                            <ctlxsl:value-of select="concat($FieldIdentifier, ',Bogus')"/>
		                          </xsl:when>
		                          <xsl:when test="contains($method-fieldIdentifier, 'FieldIdentifier')">
		                            <xsl:choose>
		                              <xsl:when test="contains($method-interpolationMethod, 'Variable')">
		                                <ctlxsl:value-of select="concat($FieldIdentifier,':',$InterpolationMethod)"/>
		                              </xsl:when>
		                              <xsl:when test="contains($method-interpolationMethod, 'Empty string')">
		                                <ctlxsl:value-of select="concat($FieldIdentifier, ':')"/>
		                              </xsl:when>
		                              <xsl:when test="contains($method-interpolationMethod, 'Bogus')">
		                                <ctlxsl:value-of select="concat($FieldIdentifier, ':Bogus')"/>
		                              </xsl:when>
		                              <xsl:when test="contains($method-axisKey, 'AxisKey3')">
		                                <ctlxsl:value-of select="concat($FieldIdentifier, '[', $AxisIdentifier, '[', $AxisKey1, ',', $AxisKey2, ',', $AxisKey3, ']]')"/>
		                              </xsl:when>
		                              <xsl:when test="contains($method-axisKey, 'AxisKey2')">
		                                <ctlxsl:value-of select="concat($FieldIdentifier, '[', $AxisIdentifier, '[', $AxisKey1, ',', $AxisKey2, ']]')"/>
		                              </xsl:when>
		                              <xsl:when test="contains($method-axisKey, 'AxisKey')">
		                                <ctlxsl:value-of select="concat($FieldIdentifier, '[', $AxisIdentifier, '[', $AxisKey, ']]')"/>
		                              </xsl:when>
		                              <xsl:when test="contains($method-axisKey, 'Bogus')">
		                                <ctlxsl:value-of select="concat($FieldIdentifier, '[', $AxisIdentifier, '[Bogus]]')"/>
		                              </xsl:when>
		                              <xsl:when test="$method-axisIdentifier">
		                                <ctlxsl:value-of select="concat($FieldIdentifier, '[', $AxisIdentifier, ']')"/>
		                              </xsl:when>
		                              <xsl:when test="contains($method-fieldIdentifier, '&quot;')">
		                                <xsl:if test="contains($method-fieldIdentifier, 'FieldIdentifier2')">
		                                  <ctlxsl:if test="string-length($FieldIdentifier2) = 0">
		                                    <ctl:message>FieldIdentifier2 is not found. Need to skip test.</ctl:message>
		                                  </ctlxsl:if>
		                                </xsl:if>
		                                <xsl:element name="xsl:value-of">
		                                  <xsl:attribute name = "select">
		                                    <xsl:text disable-output-escaping="yes">concat(</xsl:text>
		                                    <xsl:call-template name="range-subset-kvp">
		                                      <xsl:with-param name="range" select="substring-after($method-fieldIdentifier, 'Variable: ')"/>
		                                    </xsl:call-template>
		                                    <xsl:text disable-output-escaping="yes">)</xsl:text>
		                                  </xsl:attribute>
		                                </xsl:element>
		                              </xsl:when>
		                              <xsl:otherwise>
		                                <ctlxsl:value-of select="$FieldIdentifier"/>
		                              </xsl:otherwise>
		                            </xsl:choose>
		                          </xsl:when>
		                          <xsl:otherwise>
		                            <xsl:value-of select = "$method-fieldIdentifier"/>
		                          </xsl:otherwise>
		                        </xsl:choose>
		                        <xsl:text disable-output-escaping="yes">&lt;/ctl:param&gt;</xsl:text>
		                      </xsl:if>
		                      <xsl:if test="$method-format">
		                        <ctl:param name = "Format">
		                          <xsl:choose>
		                            <xsl:when test="starts-with($method-format, 'Variable: ')">
		                              <xsl:element name = "xsl:value-of">
		                                <xsl:attribute name = "select">$<xsl:value-of select="substring-after($method-format, 'Variable: ')"/></xsl:attribute>
		                              </xsl:element>
		                            </xsl:when>
		                            <xsl:when test="contains($method-format, 'Empty string')"/>
		                            <xsl:otherwise>
		                              <xsl:value-of select="$method-format"/>
		                            </xsl:otherwise>
		                          </xsl:choose>
		                        </ctl:param>
		                      </xsl:if>
		                      <!-- Fixme: GridBaseCRS and GridOffsets should not be required. Remove when Steven has fixed the problem. -->
		                      <!--<ctlxsl:if test="contains($url, 'mercedes') or contains($url, 'pcigeomatics')">
		                        <ctl:param name="GridBaseCRS"><ctlxsl:value-of select = "$GridBaseCRS"/></ctl:param>
		                        <ctl:param name="GridOffsets"><ctlxsl:value-of select = "concat(substring-before($GridOffsets, ' '), ',', substring-after($GridOffsets, ' '))"/></ctl:param>
		                      </ctlxsl:if>-->
		                      <xsl:if test="$method-store">
		                        <ctl:param name = "Store">
		                          <xsl:value-of select="$method-store"/>
		                        </ctl:param>
		                      </xsl:if>
		                    </ctlxsl:when>
		                    <ctlxsl:otherwise>
		                      <xsl:if test="not(contains($test-id, 'KVP_Syntax'))">
		                        <ctl:body>
                                <GetCoverage xmlns="http://www.opengis.net/wcs/1.1.1" xmlns:ows11="http://www.opengis.net/ows/1.1" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:wcs="http://schemas.opengis.net/wcs/1.1.1" xmlns:gml="http://www.opengis.net/gml" xsi:schemaLocation="http://www.opengis.net/wcs/1.1.1 http://schemas.opengis.net/wcs/1.1.1/wcsAll.xsd" service = "WCS" version ="1.1.1" >
                                  <xsl:choose>
                                    <xsl:when test = "not($method-identifier)"/>
		                                <xsl:when test = "$method-identifier = '&lt;Empty string&gt;'">
		                                  <ows11:Identifier/>
		                                </xsl:when>
		                                <xsl:when test= "$method-identifier = 'Bogus'">
		                                  <ows11:Identifier>Bogus</ows11:Identifier>
		                                </xsl:when>
		                                <xsl:otherwise>
		                                  <ows11:Identifier><ctlxsl:value-of select="$identifier1"/></ows11:Identifier>
		                                </xsl:otherwise>
		                              </xsl:choose>
		                              <xsl:if test="$method-domainSubset or $method-temporalSubset">
		                                <DomainSubset>
		                                <xsl:choose>
		                                  <xsl:when test="starts-with($method-domainSubset, 'Variable: ') and not(contains($method-domainSubset, '. Each')) and not(contains($method-domainSubset, 'with'))">
		                                      <xsl:text disable-output-escaping="yes">&lt;ows11:BoundingBox crs=&quot;</xsl:text>{$BoundingBoxCRS}<xsl:text disable-output-escaping="yes">&quot;&gt;</xsl:text>
		                                        <ows11:LowerCorner><ctlxsl:value-of select="$BoundingBoxLowerCorner"/></ows11:LowerCorner>
		                                        <ows11:UpperCorner><ctlxsl:value-of select="$BoundingBoxUpperCorner"/></ows11:UpperCorner>
		                                      <xsl:text disable-output-escaping="yes">&lt;/ows11:BoundingBox&gt;</xsl:text>
		                                  </xsl:when>
		                                  <xsl:when test="contains($method-domainSubset, 'increased by the length')">
		                                      <xsl:text disable-output-escaping="yes">&lt;ows11:BoundingBox crs=&quot;</xsl:text>{$BoundingBoxCRS}<xsl:text disable-output-escaping="yes">&quot;&gt;</xsl:text>
		                                      <ows11:LowerCorner><ctlxsl:value-of select="concat($LowerCornerX + $LengthX + $DeltaX, ' ', $LowerCornerY + $LengthY + $DeltaY)"/></ows11:LowerCorner>
		                                      <ows11:UpperCorner><ctlxsl:value-of select="concat($UpperCornerX + $LengthX + $DeltaX, ' ', $UpperCornerY + $LengthY + $DeltaY)"/></ows11:UpperCorner>
		                                      <xsl:text disable-output-escaping="yes">&lt;/ows11:BoundingBox&gt;</xsl:text>
		                                  </xsl:when>
		                                  <xsl:when test="contains($method-domainSubset, 'LowerCorner coordinate is reduced') and contains($method-domainSubset, 'UpperCorner coordinate is increased')">
		                                      <xsl:text disable-output-escaping="yes">&lt;ows11:BoundingBox crs=&quot;</xsl:text>{$BoundingBoxCRS}<xsl:text disable-output-escaping="yes">&quot;&gt;</xsl:text>
		                                      <ows11:LowerCorner><ctlxsl:value-of select="concat($LowerCornerX - $DeltaX, ' ', $LowerCornerY - $DeltaY)"/></ows11:LowerCorner>
		                                      <ows11:UpperCorner><ctlxsl:value-of select="concat($UpperCornerX + $DeltaX, ' ', $UpperCornerY + $DeltaY)"/></ows11:UpperCorner>
		                                      <xsl:text disable-output-escaping="yes">&lt;/ows11:BoundingBox&gt;</xsl:text>
		                                  </xsl:when>
		                                  <xsl:when test="contains($method-domainSubset, 'LowerCorner coordinate is increased') and contains($method-domainSubset, 'UpperCorner coordinate is decreased')">
		                                      <xsl:text disable-output-escaping="yes">&lt;ows11:BoundingBox crs=&quot;</xsl:text>{$BoundingBoxCRS}<xsl:text disable-output-escaping="yes">&quot;&gt;</xsl:text>
		                                      <ows11:LowerCorner><ctlxsl:value-of select="concat($LowerCornerX + $DeltaX, ' ', $LowerCornerY + $DeltaY)"/></ows11:LowerCorner>
		                                      <ows11:UpperCorner><ctlxsl:value-of select="concat($UpperCornerX - $DeltaX, ' ', $UpperCornerY - $DeltaY)"/></ows11:UpperCorner>
		                                      <xsl:text disable-output-escaping="yes">&lt;/ows11:BoundingBox&gt;</xsl:text>
		                                  </xsl:when>
		                                  <xsl:when test="contains($method-domainSubset, 'LowerCorner coordinate is increased') and contains($method-domainSubset, 'UpperCorner coordinate is also increased')">
		                                      <xsl:text disable-output-escaping="yes">&lt;ows11:BoundingBox crs=&quot;</xsl:text>{$BoundingBoxCRS}<xsl:text disable-output-escaping="yes">&quot;&gt;</xsl:text>
		                                      <ows11:LowerCorner><ctlxsl:value-of select="concat($LowerCornerX + $DeltaX, ' ', $LowerCornerY + $DeltaY)"/></ows11:LowerCorner>
		                                      <ows11:UpperCorner><ctlxsl:value-of select="concat($UpperCornerX + $DeltaX, ' ', $UpperCornerY + $DeltaY)"/></ows11:UpperCorner>
		                                      <xsl:text disable-output-escaping="yes">&lt;/ows11:BoundingBox&gt;</xsl:text>
		                                  </xsl:when>
		                                  <xsl:when test="contains($method-domainSubset, 'LowerCorner coordinate is -1e20') and contains($method-domainSubset, 'UpperCorner coordinate is +1e20')">
		                                      <xsl:text disable-output-escaping="yes">&lt;ows11:BoundingBox crs=&quot;</xsl:text>{$BoundingBoxCRS}<xsl:text disable-output-escaping="yes">&quot;&gt;</xsl:text>
		                                      <ows11:LowerCorner>-1e20 -1e20</ows11:LowerCorner>
		                                      <ows11:UpperCorner>1e20 1e20</ows11:UpperCorner>
		                                      <xsl:text disable-output-escaping="yes">&lt;/ows11:BoundingBox&gt;</xsl:text>
		                                  </xsl:when>
		                                  <xsl:when test="contains($method-domainSubset, 'GeographicBoundingBox') and contains($method-domainSubset, 'Longitude of +179.5')">
		                                      <xsl:text disable-output-escaping="yes">&lt;ows11:BoundingBox crs=&quot;</xsl:text>{$BoundingBoxCRS}<xsl:text disable-output-escaping="yes">&quot;&gt;</xsl:text>
		                                      <ows11:LowerCorner>179.5 10</ows11:LowerCorner>
		                                      <ows11:UpperCorner>-179.5 20</ows11:UpperCorner>
		                                      <xsl:text disable-output-escaping="yes">&lt;/ows11:BoundingBox&gt;</xsl:text>
		                                  </xsl:when>
		                                  <xsl:otherwise>
		                                      <BoundingBox><xsl:value-of select="$method-domainSubset"/></BoundingBox>
		                                  </xsl:otherwise>
		                                </xsl:choose>
		                                <!-- Fixme: use $method-frame -->
		                                <xsl:if test="$method-temporalSubset or $method-beginTime or $method-endTime">
		                                  <TemporalSubset>
		                                  <gml:timePosition>
		                                  <xsl:choose>
		                                    <xsl:when test="starts-with($method-temporalSubset, 'Variable: ')">
		                                      <xsl:element name = "xsl:value-of">
		                                        <xsl:attribute name = "select">$<xsl:value-of select="substring-after($method-temporalSubset, 'Variable: ')"/></xsl:attribute>
		                                      </xsl:element>
		                                    </xsl:when>
		                                    <xsl:when test="$method-temporalSubset">
		                                      <xsl:value-of select="$method-temporalSubset"/>
		                                    </xsl:when>
		                                    <xsl:when test="$method-beginTime or $method-endTime">
		                                      <xsl:choose>
		                                        <xsl:when test="contains($method-beginTime, '- 1Y')">
		                                          <ctlxsl:value-of select="concat(number(substring($TimePosition, 1, 4)) - 1, substring($TimePosition, 5))"/>
		                                        </xsl:when>
		                                        <xsl:when test="contains($method-beginTime, '- 2M')">
		                                          <ctlxsl:value-of select="concat(substring($TimePosition, 1, 5), format-number(max((number(substring($TimePosition, 6, 2)) - 2, 1)), '00'), substring($TimePosition, 8))"/>
		                                        </xsl:when>
		                                        <xsl:when test="contains($method-beginTime, '- 10D')">
		                                          <ctlxsl:value-of select="concat(substring($TimePosition, 1, 8), max((number(substring($TimePosition, 9, 2)) - 10, 1)), substring($TimePosition, 11))"/>
		                                        </xsl:when>
		                                        <xsl:otherwise>
		                                          <xsl:value-of select="$method-beginTime"/>
		                                        </xsl:otherwise>
		                                      </xsl:choose>
		                                      <ctlxsl:value-of select="'/'"/>
		                                      <xsl:choose>
		                                        <xsl:when test="contains($method-endTime, '+ 1Y')">
		                                          <ctlxsl:value-of select="concat(number(substring($TimePosition, 1, 4)) + 1, substring($TimePosition, 5))"/>
		                                        </xsl:when>
		                                        <xsl:when test="contains($method-endTime, '+ 2M')">
		                                          <ctlxsl:value-of select="concat(substring($TimePosition, 1, 5), format-number(min((number(substring($TimePosition, 6, 2)) + 2, 12)), '00'), substring($TimePosition, 8))"/>
		                                        </xsl:when>
		                                        <xsl:when test="contains($method-endTime, '+ 10D')">
		                                          <ctlxsl:value-of select="concat(substring($TimePosition, 1, 8), min((number(substring($TimePosition, 9, 2)) + 10, 28)), substring($TimePosition, 11))"/>
		                                        </xsl:when>
		                                        <xsl:otherwise>
		                                          <xsl:value-of select="$method-endTime"/>
		                                        </xsl:otherwise>
		                                      </xsl:choose>
		                                      <xsl:if test="$method-timeResolution">
		                                        <xsl:value-of select="concat('/', $method-timeResolution)"/>
		                                      </xsl:if>
		                                    </xsl:when>
		                                  </xsl:choose>
		                                  </gml:timePosition>
		                                  </TemporalSubset>
		                                </xsl:if>
		                                </DomainSubset>
		                              </xsl:if>
		                              <xsl:if test="$method-fieldIdentifier">
		                              <!-- Build the Range Subset -->
		                                <RangeSubset>
		                                  <FieldSubset>
		                                    <xsl:choose> <!-- choose the field identifiers -->
		                                      <xsl:when test= "$method-fieldIdentifier = 'Bogus'">
                                            <ows11:Identifier>Bogus</ows11:Identifier>
		                                      </xsl:when>
		                                      <xsl:when test="contains($method-fieldIdentifier, 'FieldIdentifier1, FieldIdentifier1')">
		                                        <ows11:Identifier><ctlxsl:value-of select="$FieldIdentifier"/></ows11:Identifier>
		                                        <ows11:Identifier><ctlxsl:value-of select="$FieldIdentifier"/></ows11:Identifier>
		                                      </xsl:when>
		                                      <xsl:when test="contains($method-fieldIdentifier, 'FieldIdentifier1, FieldIdentifier2')">
		                                         <ctl:message>FieldIdentifier2 is not found. Need to skip test.</ctl:message>
		                                         <ctl:message select="concat('Length is ', string-length($FieldIdentifier2))"/>
		                                        <ows11:Identifier><ctlxsl:value-of select="$FieldIdentifier1"/></ows11:Identifier>
		                                        <ows11:Identifier><ctlxsl:value-of select="$FieldIdentifier2"/></ows11:Identifier>
		                                      </xsl:when>
		                                      <xsl:when test="contains($method-fieldIdentifier, 'FieldIdentifier, Bogus')">
		                                        <ows11:Identifier><ctlxsl:value-of select="$FieldIdentifier"/></ows11:Identifier>
		                                        <ows11:Identifier>Bogus</ows11:Identifier>
		                                      </xsl:when>
		                                      <xsl:when test="contains($method-fieldIdentifier, 'FieldIdentifier')">
		                                        <ows11:Identifier><ctlxsl:value-of select="$FieldIdentifier"/></ows11:Identifier>
		                                      </xsl:when>
		                                      <xsl:otherwise>
		                                        <ows11:Identifier><xsl:value-of select="$method-fieldIdentifier"/></ows11:Identifier>
		                                      </xsl:otherwise>
		                                    </xsl:choose>
		                                    <xsl:choose> <!-- choose the interpolation method -->
		                                      <xsl:when test="contains($method-interpolationMethod, 'Variable')">
		                                       <InterpolationType><ctlxsl:value-of select="$InterpolationMethod"/></InterpolationType>
		                                      </xsl:when>
		                                      <xsl:when test="contains($method-interpolationMethod, 'Empty string')">
		                                        <InterpolationType/>
		                                      </xsl:when>
		                                      <xsl:when test="contains($method-interpolationMethod, 'Bogus')">
		                                        <InterpolationType>Bogus</InterpolationType>
		                                      </xsl:when>
		                                    </xsl:choose>
		                                    <xsl:if test="$method-axisIdentifier">
		                                      <AxisSubset>
		                                        <xsl:choose> <!-- choose the Axis subsets -->
		                                          <xsl:when test="contains($method-axisKey, 'AxisKey3')">
		                                            <Identifier><ctlxsl:value-of select="$AxisIdentifier"/></Identifier>
		                                            <Key><ctlxsl:value-of select="$AxisKey1"/></Key>
		                                            <Key><ctlxsl:value-of select="$AxisKey2"/></Key>
		                                            <Key><ctlxsl:value-of select="$AxisKey3"/></Key>
		                                          </xsl:when>
		                                          <xsl:when test="contains($method-axisKey, 'AxisKey2')">
		                                            <Identifier><ctlxsl:value-of select="$AxisIdentifier"/></Identifier>
		                                            <Key><ctlxsl:value-of select="$AxisKey1"/></Key>
		                                            <Key><ctlxsl:value-of select="$AxisKey2"/></Key>
		                                          </xsl:when>
		                                          <xsl:when test="contains($method-axisKey, 'AxisKey')">
		                                            <Identifier><ctlxsl:value-of select="$AxisIdentifier"/></Identifier>
		                                            <Key><ctlxsl:value-of select="$AxisKey"/></Key>
		                                          </xsl:when>
		                                          <xsl:when test="contains($method-axisKey, 'Bogus')">
		                                            <Identifier><ctlxsl:value-of select="$AxisIdentifier"/></Identifier>
		                                            <Key>Bogus</Key>
		                                          </xsl:when>
		                                          <xsl:when test="$method-axisIdentifier">
		                                            <Identifier><ctlxsl:value-of select="$AxisIdentifier"/></Identifier>
		                                          </xsl:when>
		                                        </xsl:choose>
		                                      </AxisSubset>
		                                    </xsl:if>
		                                  </FieldSubset>
		                                </RangeSubset>
		                              </xsl:if>
		                              <xsl:choose>
		                                <xsl:when test="$method-format and not($method-store)">
		                                  <xsl:choose>
		                                    <xsl:when test="$method-format = 'Variable: SupportedFormat'">
		                                      <xsl:text disable-output-escaping="yes">&lt;Output format=&quot;</xsl:text>{$SupportedFormat}<xsl:text disable-output-escaping="yes">&quot;/&gt;</xsl:text>
		                                    </xsl:when>
		                                    <xsl:when test="contains($method-format, 'Empty string')">
		                                      <xsl:text disable-output-escaping="yes">&lt;Output format=&quot;</xsl:text><xsl:text disable-output-escaping="yes">&quot;/&gt;</xsl:text>
		                                    </xsl:when>
		                                    <xsl:otherwise>
		                                      <xsl:text disable-output-escaping="yes">&lt;Output format=&quot;</xsl:text><xsl:value-of select="$method-format"/><xsl:text disable-output-escaping="yes">&quot;/&gt;</xsl:text>
		                                    </xsl:otherwise>
		                                  </xsl:choose>
		                                </xsl:when>
		                                <xsl:when test="$method-format and $method-store">
		                                <xsl:choose>
		                                    <xsl:when test="$method-format = 'Variable: SupportedFormat'">
		                                      <xsl:text disable-output-escaping="yes">&lt;Output format=&quot;</xsl:text>{$SupportedFormat}<xsl:text disable-output-escaping="yes">&quot; store=&quot;</xsl:text><xsl:value-of select="$method-store"/><xsl:text disable-output-escaping="yes">&quot;/&gt;</xsl:text>
		                                    </xsl:when>
		                                    <xsl:when test="contains($method-format, 'Empty string')">
		                                      <xsl:text disable-output-escaping="yes">&lt;Output format=&quot;</xsl:text><xsl:text disable-output-escaping="yes">&quot; store=&quot;</xsl:text><xsl:value-of select="$method-store"/><xsl:text disable-output-escaping="yes">&quot;/&gt;</xsl:text>
		                                    </xsl:when>
		                                    <xsl:otherwise>
		                                      <xsl:text disable-output-escaping="yes">&lt;Output format=&quot;</xsl:text><xsl:value-of select="$method-format"/><xsl:text disable-output-escaping="yes">&quot; store=&quot;</xsl:text><xsl:value-of select="$method-store"/><xsl:text disable-output-escaping="yes">&quot;/&gt;</xsl:text>
		                                    </xsl:otherwise>
		                                  </xsl:choose>
		                                </xsl:when>
		                              </xsl:choose>
		                               <!-- Fixme: GridBaseCRS and GridOffsets should not be required. Remove when Steven has fixed the problem. -->
		                               <!-- <ctlxsl:if test="contains($url, 'mercedes') or contains($url, 'pcigeomatics')">
		                                 <GridBaseCRS><ctlxsl:value-of select="$GridBaseCRS"/></GridBaseCRS>
		                                 <GridOffsets><ctlxsl:value-of select="$GridOffsets"/></GridOffsets>
		                               </ctlxsl:if> -->
                              </GetCoverage>
                            </ctl:body>
                          </xsl:if>
		                    </ctlxsl:otherwise>
		                  </ctlxsl:choose>
		                
		                <!-- Need to validate that response is multipart MIME for KVP or XML or SOAP with attachments for SOAP -->
		                <xsl:if test="$method-validator">
				              <ctlp:XMLValidatingParser xmlns:ctlp="http://www.occamlab.com/te/parsers" ignoreErrors="false" ignoreWarnings="false">
	                      <ctlp:schemas>
	                        <xsl:choose>
						                <xsl:when test="starts-with($method-validator, 'http:')">
						                  <ctlp:schema type="url"><xsl:value-of select="$method-validator"/></ctlp:schema>
						                </xsl:when>
						                <xsl:when test="starts-with($method-validator, 'file:./resources/')">
						                  <ctlp:schema type="resource"><xsl:value-of select="substring($method-validator, 18)"/></ctlp:schema>
						                </xsl:when>
						                <xsl:when test="starts-with($method-validator, 'file:')">
						                  <ctlp:schema type="file"><xsl:value-of select="substring($method-validator, 6)"/></ctlp:schema>
						                </xsl:when>
						                <xsl:otherwise>
						                  <cltp:schema type="file"><xsl:value-of select="$method-validator"/></cltp:schema>
						                </xsl:otherwise>
						              </xsl:choose>
                        </ctlp:schemas>
                      </ctlp:XMLValidatingParser>
                    </xsl:if>
                    <xsl:if test="not($method-validator)">
		                  <ctlxsl:choose>
				                <ctlxsl:when test = "$http-method = 'GET' or $http-method = 'XML'">
				                  <ctlp:HTTPParser xmlns:ctlp="http://www.occamlab.com/te/parsers">
				                    <ctlp:parse>
				                      <ctlp:NullParser part="2"/>
				                    </ctlp:parse>
		                        <!-- <ctlp:parse part="1" mime="text/xml"></ctlp:parse>
		                        <ctlp:parse part="2" mime="image"></ctlp:parse> -->
		                      </ctlp:HTTPParser>
		                    </ctlxsl:when>
		                    <ctlxsl:otherwise>
		                      <ctlp:XMLValidatingParser xmlns:ctlp="http://www.occamlab.com/te/parsers">
		                        <!-- Fixme: Need something soapy -->
		                        <ctlp:schemas>
		                          <ctlp:schema type="resource">xsd/ogc/wcs/1.1.1/wcsDescribeCoverage.xsd</ctlp:schema>
		                        </ctlp:schemas>
		                      </ctlp:XMLValidatingParser>
		                    </ctlxsl:otherwise>
		                  </ctlxsl:choose>
		                </xsl:if>
		              </ctl:request>
		              </ctlxsl:variable>
		              <xsl:choose>
		                <!-- Table 63 is a special case, the response is not defined in the specification. This likely means that a realistic antimeridian bounding box test is not practicable. -->
		                <xsl:when test="contains($test-id, 'OutsideBoundingBox') or contains($test-id, 'AntimeridianBoundingBox')"/>
		                <xsl:when test="not($method-validator)">
		                  <ctlxsl:choose>
		                    <ctlxsl:when test="$http-method = 'GET' or $http-method = 'XML'">
		                      <ctlxsl:if test="$get-coverage-result/response/status/@code != 200">
		                        <ctl:message select="concat('Error: Returned a status code of ', $get-coverage-result/response/status/@code)"/>
		                        <ctl:fail/>
		                      </ctlxsl:if>
		                      <ctlxsl:if test="$get-coverage-result/response/headers/header[@Name='Content-Type']/@Name != $SupportedFormat">
		                        <ctl:message select="concat('Error: Returned a format of ',  $get-coverage-result/response/content-type, ' but expected ', $SupportedFormat)"/>
		                        <ctl:fail/>
		                      </ctlxsl:if>
		                      <ctlxsl:if test="$get-coverage-result/response/content/*[local-name()='ExceptionReport']">
		                        <ctl:message select="concat('Error: ', $get-coverage-result/response/content/*[local-name()='ExceptionReport']/*[local-name()='Exception']/*[local-name()='ExceptionText'])"/>
		                        <ctl:fail/>
		                      </ctlxsl:if>
		                    </ctlxsl:when>
		                  </ctlxsl:choose>
		                </xsl:when>
		                <xsl:when test="$method-validator">
		                  <xsl:if test="$method-locator">
		                    <xsl:element name="xsl:if">
		                      <xsl:attribute name="test">not(contains('<xsl:value-of select="$method-locator"/>',$get-coverage-result/response/content/*[local-name()='ExceptionReport']/*[local-name()='Exception'][@name='locator']/@locator))</xsl:attribute>
		                      <ctl:message>Error: Expected an exception with locator <xsl:value-of select="$method-locator"/> but found
		                        <ctlxsl:value-of select="$get-coverage-result/response/content/*[local-name()='ExceptionReport']/*[local-name()='Exception'][@name='locator']/@locator"/>
		                      </ctl:message>
		                      <ctl:fail/>
		                    </xsl:element>
		                  </xsl:if>
		                </xsl:when>
		              </xsl:choose>
		              </ctlxsl:otherwise>
		              </ctlxsl:choose>
	             </xsl:when>
	                  <xsl:otherwise>
			            <xsl:element name="ctl:message"><xsl:value-of select="concat('initial request case is ', $method-initialrequestcase)"/></xsl:element>
				        <ctl:fail />
				      </xsl:otherwise>
				    </xsl:choose>
			      </xsl:otherwise>
			    </xsl:choose>
			</ctl:code>
		</xsl:element>
	</xsl:template>
	
	<!-- Test case references -->
	<xsl:template match=".//html:tbody/html:tr[@class='reference']/html:td/html:ol/html:li">
	  <xsl:variable name="link-title" select="." />
      <xsl:variable name="link-link" select=".//html:a/@href" />
	  <xsl:element name="ctl:link">
	     <xsl:attribute name="title"><xsl:number/><xsl:value-of select="concat( ': ', $link-title)"/></xsl:attribute>
	     <xsl:value-of select="concat('http://www.opengeospatial.org/standards/wcs', $link-link)"/>
	  </xsl:element>
	</xsl:template>
	
	<!-- Template to format the body of an XML request -->
	<!-- Takes a comma separated list of values and the xml attribute name -->
	<xsl:template name="process-values">
	  <xsl:param name="values"/>
	  <xsl:param name="attribute"/>
	  <xsl:choose>
	    <xsl:when test="not(contains($values, ','))">
		  <xsl:text disable-output-escaping="yes">&#10;                                  &lt;</xsl:text>
		  <xsl:value-of select="$attribute"/>
		  <xsl:text disable-output-escaping="yes">&gt;</xsl:text>
		  <xsl:value-of select="$values"/>
		  <xsl:text disable-output-escaping="yes">&lt;/</xsl:text>
		  <xsl:value-of select="$attribute"/>
		  <xsl:text disable-output-escaping="yes">&gt;                              </xsl:text>
		</xsl:when>
		<xsl:otherwise>
		  <xsl:text disable-output-escaping="yes">&#10;                                  &lt;</xsl:text>
		  <xsl:value-of select="$attribute"/>
		  <xsl:text disable-output-escaping="yes">&gt;</xsl:text>
		  <xsl:value-of select="substring-before($values, ',')"/>
		  <xsl:text disable-output-escaping="yes">&lt;/</xsl:text>
		  <xsl:value-of select="$attribute"/>
		  <xsl:text disable-output-escaping="yes">&gt;</xsl:text>
	      <xsl:call-template name="process-values">
            <xsl:with-param name="values" select="substring-after($values, ',')"/>
	        <xsl:with-param name="attribute" select="$attribute"/>
	      </xsl:call-template>
	    </xsl:otherwise>
       </xsl:choose>
	</xsl:template>
	
	<xsl:template name="expand-xpath">
	  <xsl:param name="xpath"/>
	  <xsl:choose>
	    <xsl:when test="contains($xpath, '//')">
	      <xsl:value-of select="$xpath"/>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:variable name="node" select="substring-before($xpath, '/')" />
	      <xsl:choose>
	        <xsl:when test="substring($node, 1, 1)  != '*' and substring($node, 1, 1) != '@' and substring($node, 1, 4) != 'text'">
		      <xsl:text disable-output-escaping="yes">/*[local-name()='</xsl:text>
		      <xsl:value-of select="$node"/>
		      <xsl:text disable-output-escaping="yes">']</xsl:text>
		    </xsl:when>
		    <xsl:otherwise>
		      <xsl:text disable-output-escaping="yes">/</xsl:text>
		      <xsl:value-of select="$node"/>
		    </xsl:otherwise>
	      </xsl:choose>
	      <xsl:if test="substring-after($xpath, '/')">
	        <xsl:call-template name="expand-xpath">
              <xsl:with-param name="xpath" select="substring-after($xpath, '/')"/>
	        </xsl:call-template>
	      </xsl:if>
	    </xsl:otherwise>
	  </xsl:choose>
	</xsl:template>
	
	<xsl:template name="range-subset-kvp">
	  <xsl:param name="range"/>
	  <xsl:choose>
	    <xsl:when test="not($range)"/>
	    <xsl:otherwise>
	      <xsl:variable name="token">
	        <xsl:choose>
	          <xsl:when test="starts-with($range, '&quot;,')">
	            <xsl:value-of select="substring($range, 1, 3)" />
	          </xsl:when>
	          <xsl:when test="contains($range, ',')">
	            <xsl:value-of select="substring-before($range, ',')" />
	          </xsl:when>
	          <xsl:otherwise>
	            <xsl:value-of select="$range"/>
	          </xsl:otherwise>
	        </xsl:choose>
	      </xsl:variable>
      	<xsl:choose>
      	  <xsl:when test="substring($token, 1, 1) = '&quot;'">
      	    <xsl:text disable-output-escaping="yes">'</xsl:text><xsl:value-of select="substring($token, 2, 1)"/><xsl:text disable-output-escaping="yes">'</xsl:text>
      	  </xsl:when>
      	  <xsl:otherwise>
      	    <xsl:text disable-output-escaping="yes">$</xsl:text><xsl:value-of select="$token"/>
      	  </xsl:otherwise>
      	</xsl:choose>
      	<xsl:if test="$token != $range">
      	  <xsl:text disable-output-escaping="yes">,</xsl:text>
	        <xsl:call-template name="range-subset-kvp">
            <xsl:with-param name="range" select="substring(substring-after($range, $token), 3)"/>
	        </xsl:call-template>
	      </xsl:if>
	    </xsl:otherwise>
	  </xsl:choose>
	</xsl:template>


	<!-- Suite / test driver -->
	<xsl:template name="suite">
		<xsl:variable name="title" select="html:html/html:head/html:title"/>
		
        <!-- function get-capabilities-accept-versions	-->
	    <ctl:function name="wcs:get-capabilities-accept-versions" xmlns:ctl="http://www.occamlab.com/ctl" >
	      <ctl:param name="url" />
	      <ctl:return>Returns the response from a WCS GetCapabilities request with the AcceptVersions parameter having a value of 1.1.1 </ctl:return>
	      <ctl:code>
		    <ctl:request>
		      <ctl:url>
				  <ctlxsl:value-of select="$url"/>
		      </ctl:url>
		      <ctl:method>GET</ctl:method>
		      <ctl:param name="service">WCS</ctl:param>
		      <ctl:param name="request">GetCapabilities</ctl:param>
		      <ctl:param name="acceptversions">1.1.1</ctl:param>
		      <ctlp:XMLValidatingParser xmlns:ctlp="http://www.occamlab.com/te/parsers">
		        <ctlp:schemas>
		          <ctlp:schema type="resource">xsd/ogc/wcs/1.1.1/wcsGetCapabilities.xsd</ctlp:schema>
		        </ctlp:schemas>
		      </ctlp:XMLValidatingParser>
		    </ctl:request>
	      </ctl:code>
	    </ctl:function>
	    
	    <!-- function wcs:describe-coverage-multiple-identifiers -->
	    <ctl:function name="wcs:describe-coverage-multiple-identifiers" xmlns:ctl="http://www.occamlab.com/ctl" >
	      <ctl:param name="url" />
	      <ctl:param name="http-method" />
	      <ctl:param name="identifier1" />
	      <ctl:param name="identifier2" />
	      <ctl:param name="identifier3" />
	      <ctl:return>Returns the response from a WCS DescribeCoverage request with multiple coverage identifiers</ctl:return>
	      <ctl:code>
	        <ctl:request>
	          <ctl:url>
		          <ctlxsl:value-of select="$url"/>
		        </ctl:url>
		        <ctl:method>
			        <ctlxsl:choose>
				        <ctlxsl:when test = "$http-method = 'GET'">GET</ctlxsl:when>
				        <ctlxsl:otherwise>POST</ctlxsl:otherwise>
				      </ctlxsl:choose>
		        </ctl:method>
		        <ctlxsl:choose>
				      <ctlxsl:when test = "$http-method = 'GET'">
		            <ctl:param name="service">WCS</ctl:param>
		            <ctl:param name="request">DescribeCoverage</ctl:param>
		            <ctl:param name="version">1.1.1</ctl:param>
		            <ctl:param name="identifiers">
		              <ctlxsl:value-of select = "concat($identifier1, ',', $identifier2, ',', $identifier3)"/>
		             </ctl:param>
		           </ctlxsl:when>
		           <ctlxsl:otherwise>
		             <ctl:body>
                   <DescribeCoverage xmlns="http://www.opengis.net/wcs/1.1.1" xmlns:ows11="http://www.opengis.net/ows/1.1" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.opengis.net/wcs/1.1.1 http://schemas.opengis.net/wcs/1.1.1/wcsAll.xsd" service = "WCS" version ="1.1.1">
                     <Identifier><ctlxsl:value-of select="$identifier1"/></Identifier>
                     <Identifier><ctlxsl:value-of select="$identifier2"/></Identifier>
                     <Identifier><ctlxsl:value-of select="$identifier3"/></Identifier>
                   </DescribeCoverage>
                 </ctl:body>
		           </ctlxsl:otherwise>
		         </ctlxsl:choose>
		        <ctlp:XMLValidatingParser xmlns:ctlp="http://www.occamlab.com/te/parsers">
		          <ctlp:schemas>
		            <ctlp:schema type="resource">xsd/ogc/wcs/1.1.1/wcsDescribeCoverage.xsd</ctlp:schema>
		          </ctlp:schemas>
		        </ctlp:XMLValidatingParser>
	        </ctl:request>
	      </ctl:code>
	    </ctl:function>
	    
	    <!-- function wcs:describe-coverage-minimal-request -->
	    <ctl:function name="wcs:describe-coverage-minimal-request" xmlns:ctl="http://www.occamlab.com/ctl">
	      <ctl:param name="url" />
	      <ctl:param name="http-method" />
	      <ctl:param name="identifier" />
	      <ctl:return>Returns the response from a WCS DescribeCoverage minimal request.</ctl:return>
	      <ctl:code>
	        <ctl:request>
	          <ctl:url>
		          <ctlxsl:value-of select="$url"/>
		        </ctl:url>
		        <ctl:method>
			        <ctlxsl:choose>
				        <ctlxsl:when test = "$http-method = 'GET'">GET</ctlxsl:when>
				        <ctlxsl:otherwise>POST</ctlxsl:otherwise>
				      </ctlxsl:choose>
		        </ctl:method>
		        <ctlxsl:choose>
				      <ctlxsl:when test = "$http-method = 'GET'">
		            <ctl:param name="service">WCS</ctl:param>
		            <ctl:param name="request">DescribeCoverage</ctl:param>
		            <ctl:param name="version">1.1.1</ctl:param>
		            <ctl:param name="identifiers">
		              <ctlxsl:value-of select = "$identifier"/>
		             </ctl:param>
		          </ctlxsl:when>
		          <ctlxsl:otherwise>
		            <ctl:body>
                  <DescribeCoverage xmlns="http://www.opengis.net/wcs/1.1.1" xmlns:ows11="http://www.opengis.net/ows/1.1" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.opengis.net/wcs/1.1.1 http://schemas.opengis.net/wcs/1.1.1/wcsAll.xsd" service = "WCS" version ="1.1.1">
                    <Identifier><ctlxsl:value-of select="$identifier"/></Identifier>
                  </DescribeCoverage>
                </ctl:body>
		          </ctlxsl:otherwise>
		        </ctlxsl:choose>
	        </ctl:request>
	      </ctl:code>
	    </ctl:function>
	    
	    <!-- wcs:describe-coverage-response-interpolation-methods -->
	    <ctl:function name="wcs:describe-coverage-response-interpolation-methods" xmlns:ctl="http://www.occamlab.com/ctl">
	      <ctl:param name="url" />
	      <ctl:param name="http-method" />
	      <ctl:return>Returns the response from a WCS DescribeCoverage response with interpolation methods.</ctl:return>
	      <ctl:code>
	      </ctl:code>
	    </ctl:function>
		
		<ctl:suite name="wcs:suite">
		  <ctl:title>Web Coverage Service (WCS) 1.1.1</ctl:title>
		  <ctl:description>Validates that a WCS server meets the requirements in the specification.</ctl:description>
		  <ctl:link>docs/wcs/1.1.1/</ctl:link>
		  <ctl:starting-test>wcs:Main</ctl:starting-test>
		</ctl:suite>
	   <ctl:test name="wcs:Main">
		  <ctl:assertion>The Implementation Under Test (IUT) satisfies all applicable
		       assertions. There are 177 tests in total. Depending on the capabilities
		       of the server, some tests are skipped. These are recorded in the
		       detailed results for each type of request.</ctl:assertion>
		  <ctl:code>
			
			<!-- User entry of initial URL which supports http get encoding of GetCapabilities -->
			<ctlxsl:variable name = "form-values">
			    <ctl:form xmlns:ctl="http://www.occamlab.com/ctl">
			      <h3>Web Coverage Service 1.1.1</h3>
				  <p>This executable test suite tests the conformance of a WCS 1.1.1 server to the specification  OGC 07-067r2 which includes corrigendum 1.</p>
                  <blockquote>   <!-- used for indentation -->
			        <table border="0" cellpadding="5">
				      <tr>
				        <td align="center">URL</td>
					    <td align="center">
						    <input id="url" type="text" name="url" size="100" value="http://gridlock.openplans.org:8080/geoserver-wcs/wcs" />
					    </td>
				      </tr>
			        </table>
			        <p>The URL of the WCS for HTTP GET (KVP) encoding of GetCapabilities.</p>
			        </blockquote>
			        <blockquote>
		            <table border="0" cellpadding="5">
		              <tr>
		                <td align="center"><input type="submit" value="Next" /></td>
                      </tr>
	                </table>
		          </blockquote>
		          <p><font size="1">ETS revision 12 (Feb 29, 2008)</font></p>
                </ctl:form>
            </ctlxsl:variable>
            
            <!-- Get the URL from the form -->
            <ctlxsl:variable name = "url">
				    <!--<ctlxsl:choose>
				      <ctlxsl:when test = "contains($form-values/values/value[@key='url'], '?')">
				        <ctlxsl:value-of select = "substring-before($form-values/values/value[@key='url'], '?')"/>
				      </ctlxsl:when>
				      <ctlxsl:otherwise>-->
				        <ctlxsl:value-of select = "$form-values/values/value[@key='url']"/>
				      <!--</ctlxsl:otherwise>
				    </ctlxsl:choose>-->
			      </ctlxsl:variable>
            
            <!-- Do a basic http get GetCapabilities to verify that a server is at this URL -->
            <ctlxsl:variable name = "result">
		      <ctl:request>
				<ctl:url>
				  <ctlxsl:value-of select = "$url"/>
				</ctl:url>
				<ctl:method>GET</ctl:method>
				<ctl:param name="service">WCS</ctl:param>
				<ctl:param name="request">GetCapabilities</ctl:param>
			  </ctl:request>
			</ctlxsl:variable>
			<ctlxsl:if test = "string-length($result)=0">
			  <ctl:message select="concat('No response from URL: ', $url, '. Perhaps this is not the correct address or the server is down. No tests will be performed.')" />
			  <ctl:fail/>
			</ctlxsl:if>
			
			<!-- Call the tests for each section -->
			<ctlxsl:if test = "string-length($result) &gt; 0">
			  <ctl:message select="concat('WCS 1.1.1 URL is ', $url, '.')"/>
			  <xsl:for-each select="//html:div[@class='section']">
				  <xsl:variable name="module-id" select=".//html:h2[@class='title']/html:a/@id"/>
				  <xsl:element name="ctl:call-test">
					  <xsl:attribute name="name"><xsl:value-of select="concat('wcs:',$module-id, '-main')"/></xsl:attribute>
					  <ctl:with-param name="url" select="$url" />
				  </xsl:element>
			  </xsl:for-each>
			</ctlxsl:if>
		  </ctl:code>
	   </ctl:test>
	</xsl:template>

    

</xsl:transform>
