/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.config;

import com.occamlab.te.SetupOptions;
import com.occamlab.te.index.ProfileEntry;
import com.occamlab.te.index.SuiteEntry;
import com.occamlab.te.util.DomUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Config {
    private static final Logger LOGR = Logger.getLogger(Config.class.getName());
    private File baseDir = SetupOptions.getBaseConfigDirectory();
    private File scriptsDir;
    private File resourcesDir;
    private File usersDir;
    private List<String> organizationList;
    private Map<String, List<String>> standardMap;
    private Map<String, List<String>> versionMap;
    private Map<String, List<String>> revisionMap;
    private Map<String, List<String>> conformanceClassMap;
    private Map<String, SuiteEntry> suites;
    private Map<String, List<ProfileEntry>> profiles;
    private Map<String, List<File>> sources;
    private Map<String, String> webdirs;
    private Map<String, File> resources;

    public Config() {
        File configFileExternal = new File(this.baseDir, "config.xml");
        NodeList organizationNodes = null;
        try {
            organizationNodes = this.getOrganizations(configFileExternal);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGR.log(Level.SEVERE, String.format("Could not parse config file from path: %s.", configFileExternal.getAbsolutePath()), e);
            return;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setExpandEntityReferences(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            try {
                this.resourcesDir = this.getScriptsDir();
            }
            catch (Exception e) {
                LOGR.log(Level.WARNING, "Could not get directory for scripts. TE_BASE not set.");
            }
            this.organizationList = new ArrayList<String>();
            this.standardMap = new HashMap<String, List<String>>();
            this.versionMap = new HashMap<String, List<String>>();
            this.revisionMap = new HashMap<String, List<String>>();
            this.conformanceClassMap = new HashMap<String, List<String>>();
            this.suites = new HashMap<String, SuiteEntry>();
            this.profiles = new HashMap<String, List<ProfileEntry>>();
            this.sources = new HashMap<String, List<File>>();
            this.webdirs = new HashMap<String, String>();
            this.resources = new HashMap<String, File>();
            for (int i = 0; i < organizationNodes.getLength(); ++i) {
                Node organizationEl = organizationNodes.item(i);
                String organization = DomUtils.getElementByTagName(organizationEl, "name").getTextContent();
                this.organizationList.add(organization);
                ArrayList<String> standardList = new ArrayList<String>();
                for (Element standardEl : DomUtils.getElementsByTagName(organizationEl, "standard")) {
                    String standard = DomUtils.getElementByTagName(standardEl, "name").getTextContent();
                    standardList.add(standard);
                    this.standardMap.put(organization, standardList);
                    ArrayList<String> versionList = new ArrayList<String>();
                    for (Element versionEl : DomUtils.getElementsByTagName(standardEl, "version")) {
                        String version = DomUtils.getElementByTagName(versionEl, "name").getTextContent();
                        versionList.add(version);
                        String verKey = organization + "_" + standard;
                        this.versionMap.put(verKey, versionList);
                        SuiteEntry suite = new SuiteEntry();
                        Element suiteEl = DomUtils.getElementByTagName(versionEl, "suite");
                        String suiteNamespaceUri = DomUtils.getElementByTagName(suiteEl, "namespace-uri").getTextContent();
                        String suitePrefix = DomUtils.getElementByTagName(suiteEl, "prefix").getTextContent();
                        String suiteLocalName = DomUtils.getElementByTagName(suiteEl, "local-name").getTextContent();
                        suite.setQName(new QName(suiteNamespaceUri, suiteLocalName, suitePrefix));
                        suite.setTitle(DomUtils.getElementByTagName(suiteEl, "title").getTextContent());
                        Element descEl = DomUtils.getElementByTagName(suiteEl, "description");
                        if (descEl != null) {
                            suite.setDescription(descEl.getTextContent());
                        }
                        for (Element element : DomUtils.getElementsByTagName(suiteEl, "link")) {
                            String value = element.getTextContent();
                            if ("data".equals(element.getAttribute("linkType"))) {
                                suite.setDataLink(value);
                                continue;
                            }
                            if (value.startsWith("data/")) {
                                suite.setDataLink(value);
                                continue;
                            }
                            suite.setLink(value);
                        }
                        ArrayList<String> revisionList = new ArrayList<String>();
                        for (Element el : DomUtils.getChildElements(versionEl)) {
                            if (!el.getNodeName().equals("revision")) continue;
                            String revision = DomUtils.getElementByTagName(el, "name").getTextContent();
                            revisionList.add(revision);
                            String revKey = verKey + "_" + version;
                            this.revisionMap.put(revKey, revisionList);
                            String key = revKey + "_" + revision;
                            this.suites.put(key, suite);
                            ArrayList<File> list = new ArrayList<File>();
                            for (Element sourceEl : DomUtils.getElementsByTagName(el, "source")) {
                                if (this.getScriptsDir() == null) {
                                    list.add(new File(sourceEl.getTextContent()));
                                    continue;
                                }
                                list.add(new File(this.getScriptsDir(), sourceEl.getTextContent()));
                            }
                            this.sources.put(key, list);
                            for (Element resourcesEl : DomUtils.getElementsByTagName(el, "resources")) {
                                if (this.resourcesDir == null) {
                                    this.resources.put(key, new File(this.baseDir, resourcesEl.getTextContent()));
                                    continue;
                                }
                                this.resources.put(key, new File(this.resourcesDir, resourcesEl.getTextContent()));
                            }
                            for (Element webdirEl : DomUtils.getElementsByTagName(el, "webdir")) {
                                this.webdirs.put(key, webdirEl.getTextContent());
                            }
                            ArrayList<ProfileEntry> profileList = new ArrayList<ProfileEntry>();
                            for (Element profileEl : DomUtils.getElementsByTagName(el, "profile")) {
                                ProfileEntry profile = new ProfileEntry();
                                String namespaceUri = DomUtils.getElementByTagName(profileEl, "namespace-uri").getTextContent();
                                String prefix = DomUtils.getElementByTagName(profileEl, "prefix").getTextContent();
                                String localName = DomUtils.getElementByTagName(profileEl, "local-name").getTextContent();
                                profile.setQName(new QName(namespaceUri, localName, prefix));
                                profile.setBaseSuite(suite.getQName());
                                profile.setTitle(DomUtils.getElementByTagName(profileEl, "title").getTextContent());
                                profileList.add(profile);
                            }
                            this.profiles.put(key, profileList);
                        }
                        ArrayList<String> arrayList = new ArrayList<String>();
                        Element conformanceClasses = DomUtils.getElementByTagName(suiteEl, "BasicConformanceClasses");
                        if (null == conformanceClasses) continue;
                        for (Element ccElement : DomUtils.getChildElements(conformanceClasses)) {
                            if (!ccElement.getNodeName().equals("conformanceClass")) continue;
                            String confClass = ccElement.getTextContent();
                            arrayList.add(confClass);
                        }
                        this.conformanceClassMap.put(suiteLocalName, arrayList);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGR.log(Level.SEVERE, "Could not extract infos from config file.", e);
        }
    }

    public File getScriptsDir() {
        if (null == this.scriptsDir) {
            File dir = new File(this.baseDir, "scripts");
            if (!dir.exists() && !dir.mkdir()) {
                throw new RuntimeException("Failed to create directory at " + dir.getAbsolutePath());
            }
            this.scriptsDir = dir;
        }
        return this.scriptsDir;
    }

    public File getUsersDir() {
        if (null == this.usersDir) {
            File dir = new File(this.baseDir, "users");
            if (!dir.exists() && !dir.mkdir()) {
                throw new RuntimeException("Failed to create directory at " + dir.getAbsolutePath());
            }
            this.usersDir = dir;
        }
        return this.usersDir;
    }

    private NodeList getOrganizations(File configFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setExpandEntityReferences(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = null;
        NodeList organizations = null;
        if (configFile.exists()) {
            doc = db.parse(configFile);
            Element configElem = (Element)doc.getElementsByTagName("config").item(0);
            organizations = configElem.getElementsByTagName("organization");
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream configFileStream = cl.getResourceAsStream("config.xml");
            try {
                doc = db.parse(configFileStream);
                organizations = doc.getElementsByTagName("organization");
            }
            catch (IllegalArgumentException e) {
                LOGR.log(Level.SEVERE, "Could not parse config file from class path.", e);
            }
        }
        return organizations;
    }

    public List<String> getOrganizationList() {
        return this.organizationList;
    }

    public Map<String, List<String>> getRevisionMap() {
        return this.revisionMap;
    }

    public Map<String, List<String>> getConformanceClassMap() {
        return this.conformanceClassMap;
    }

    public Map<String, List<File>> getSources() {
        return this.sources;
    }

    public Map<String, List<String>> getStandardMap() {
        return this.standardMap;
    }

    public Map<String, SuiteEntry> getSuites() {
        return this.suites;
    }

    public Map<String, List<ProfileEntry>> getProfiles() {
        return this.profiles;
    }

    public Map<String, List<String>> getVersionMap() {
        return this.versionMap;
    }

    public Map<String, String> getWebDirs() {
        return this.webdirs;
    }

    public Map<String, File> getResources() {
        return this.resources;
    }
}

