/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.Iterator;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.rdf.model.impl.NodeIteratorImpl;
import org.apache.jena.rdf.model.impl.ResIteratorImpl;
import org.apache.jena.rdf.model.impl.StmtIteratorImpl;
import org.apache.jena.util.iterator.WrappedIterator;

public final class IteratorFactory {
    private IteratorFactory() {
    }

    public static StmtIterator asStmtIterator(Iterator<Triple> i, ModelCom m4) {
        return new StmtIteratorImpl((Iterator<Statement>)WrappedIterator.create(i).mapWith(t2 -> m4.asStatement((Triple)t2)));
    }

    public static ResIterator asResIterator(Iterator<Node> i, ModelCom m4) {
        return new ResIteratorImpl(WrappedIterator.create(i).mapWith(o -> (Resource)m4.asRDFNode((Node)o)), null);
    }

    public static NodeIterator asRDFNodeIterator(Iterator<Node> i, ModelCom m4) {
        return new NodeIteratorImpl(WrappedIterator.create(i).mapWith(o -> m4.asRDFNode((Node)o)), null);
    }

    static Resource asResource(Node n, ModelCom m4) {
        return IteratorFactory.asResource(n, Resource.class, m4);
    }

    static Property asProperty(Node n, ModelCom m4) {
        return (Property)IteratorFactory.asResource(n, Property.class, m4);
    }

    static Literal asLiteral(Node n, ModelCom m4) {
        return m4.getNodeAs(n, Literal.class);
    }

    static <X extends RDFNode> Resource asResource(Node n, Class<X> cl, ModelCom m4) {
        return (Resource)m4.getNodeAs(n, cl);
    }
}

