/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.parsers.xml;

import com.occamlab.te.parsers.xml.FileSchemaSupplier;
import com.occamlab.te.parsers.xml.InMemorySchemaSupplier;
import com.occamlab.te.parsers.xml.UrlSchemaSupplier;
import java.io.File;
import java.net.URL;
import javax.xml.transform.Source;

public interface SchemaSupplier {
    public Source makeSource();

    public static SchemaSupplier makeSupplier(Object schemaObject) {
        if (schemaObject instanceof File) {
            return new FileSchemaSupplier((File)schemaObject);
        }
        if (schemaObject instanceof URL) {
            return new UrlSchemaSupplier((URL)schemaObject);
        }
        if (schemaObject instanceof char[]) {
            return new InMemorySchemaSupplier((char[])schemaObject);
        }
        throw new IllegalArgumentException("Unknown schema reference: " + schemaObject.toString());
    }
}

