/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.multipart;

import com.sun.jersey.core.header.ContentDisposition;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.core.header.MediaTypes;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.BodyPartEntity;
import java.text.ParseException;
import javax.ws.rs.core.MediaType;

public class FormDataBodyPart
extends BodyPart {
    private final boolean fileNameFix;

    public FormDataBodyPart() {
        this(false);
    }

    public FormDataBodyPart(boolean fileNameFix) {
        this.fileNameFix = fileNameFix;
    }

    public FormDataBodyPart(MediaType mediaType) {
        super(mediaType);
        this.fileNameFix = false;
    }

    public FormDataBodyPart(Object entity, MediaType mediaType) {
        super(entity, mediaType);
        this.fileNameFix = false;
    }

    public FormDataBodyPart(String name, String value) {
        super(value, MediaType.TEXT_PLAIN_TYPE);
        this.fileNameFix = false;
        this.setName(name);
    }

    public FormDataBodyPart(String name, Object entity, MediaType mediaType) {
        super(entity, mediaType);
        this.fileNameFix = false;
        this.setName(name);
    }

    public FormDataBodyPart(FormDataContentDisposition fdcd, String value) {
        super(value, MediaType.TEXT_PLAIN_TYPE);
        this.fileNameFix = false;
        this.setFormDataContentDisposition(fdcd);
    }

    public FormDataBodyPart(FormDataContentDisposition fdcd, Object entity, MediaType mediaType) {
        super(entity, mediaType);
        this.fileNameFix = false;
        this.setFormDataContentDisposition(fdcd);
    }

    public FormDataContentDisposition getFormDataContentDisposition() {
        return (FormDataContentDisposition)this.getContentDisposition();
    }

    public void setFormDataContentDisposition(FormDataContentDisposition cd2) {
        super.setContentDisposition(cd2);
    }

    @Override
    public ContentDisposition getContentDisposition() {
        String scd;
        if (this.cd == null && (scd = this.getHeaders().getFirst("Content-Disposition")) != null) {
            try {
                this.cd = new FormDataContentDisposition(scd, this.fileNameFix);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Error parsing content disposition: " + scd, ex);
            }
        }
        return this.cd;
    }

    @Override
    public void setContentDisposition(ContentDisposition cd2) {
        if (!(cd2 instanceof FormDataContentDisposition)) {
            throw new IllegalArgumentException();
        }
        super.setContentDisposition(cd2);
    }

    public String getName() {
        FormDataContentDisposition fdcd = this.getFormDataContentDisposition();
        if (fdcd == null) {
            return null;
        }
        return fdcd.getName();
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name can not be null.");
        }
        if (this.getFormDataContentDisposition() == null) {
            FormDataContentDisposition contentDisposition = FormDataContentDisposition.name(name).build();
            super.setContentDisposition(contentDisposition);
        } else {
            FormDataContentDisposition _cd = ((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name(name).fileName(this.cd.getFileName())).creationDate(this.cd.getCreationDate())).modificationDate(this.cd.getModificationDate())).readDate(this.cd.getReadDate())).size(this.cd.getSize())).build();
            super.setContentDisposition(_cd);
        }
    }

    public String getValue() {
        if (!MediaTypes.typeEquals(MediaType.TEXT_PLAIN_TYPE, this.getMediaType())) {
            throw new IllegalStateException("Media type is not text/plain");
        }
        if (this.getEntity() instanceof BodyPartEntity) {
            return this.getEntityAs(String.class);
        }
        return (String)this.getEntity();
    }

    public <T> T getValueAs(Class<T> clazz) {
        return this.getEntityAs(clazz);
    }

    public void setValue(String value) {
        if (!MediaType.TEXT_PLAIN_TYPE.equals(this.getMediaType())) {
            throw new IllegalStateException("Media type is not text/plain");
        }
        this.setEntity(value);
    }

    public void setValue(MediaType mediaType, Object value) {
        this.setMediaType(mediaType);
        this.setEntity(value);
    }

    public boolean isSimple() {
        return MediaType.TEXT_PLAIN_TYPE.equals(this.getMediaType());
    }
}

