/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Arrays;
import java.util.Properties;
import net.sf.saxon.event.HTMLTagHashSet;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.tinytree.CharSlice;
import net.sf.saxon.trans.XPathException;

public class HTMLIndenter
extends ProxyReceiver {
    private int level = 0;
    private int indentSpaces = 3;
    private char[] indentChars = new char[]{'\n', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private boolean sameLine = false;
    private boolean isInlineTag = false;
    private boolean inFormattedTag = false;
    private boolean afterInline = false;
    private boolean afterFormatted = true;
    private int[] propertyStack = new int[20];
    protected static String[] inlineTags = new String[]{"tt", "i", "b", "u", "s", "strike", "big", "small", "em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "acronym", "a", "img", "applet", "object", "font", "basefont", "br", "script", "map", "q", "sub", "sup", "span", "bdo", "iframe", "input", "select", "textarea", "label", "button", "ins", "del"};
    private static HTMLTagHashSet inlineTable = new HTMLTagHashSet(101);
    protected static final int IS_INLINE = 1;
    protected static final int IS_FORMATTED = 2;
    private static HTMLTagHashSet formattedTable;
    protected static String[] formattedTags;

    protected int classifyTag(int nameCode) {
        int r = 0;
        String tag = this.getNamePool().getDisplayName(nameCode);
        if (inlineTable.contains(tag)) {
            r |= 1;
        }
        if (formattedTable.contains(tag)) {
            r |= 2;
        }
        return r;
    }

    public void setOutputProperties(Properties props) {
        String s2 = props.getProperty("{http://saxon.sf.net/}indent-spaces");
        if (s2 == null) {
            this.indentSpaces = 3;
        } else {
            try {
                this.indentSpaces = Integer.parseInt(s2);
            }
            catch (NumberFormatException err) {
                this.indentSpaces = 3;
            }
        }
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        int tagProps = this.classifyTag(nameCode);
        if (this.level >= this.propertyStack.length) {
            int[] p2 = new int[this.level * 2];
            System.arraycopy(this.propertyStack, 0, p2, 0, this.propertyStack.length);
            this.propertyStack = p2;
        }
        this.propertyStack[this.level] = tagProps;
        this.isInlineTag = (tagProps & 1) != 0;
        boolean bl = this.inFormattedTag = this.inFormattedTag || (tagProps & 2) != 0;
        if (!(this.isInlineTag || this.inFormattedTag || this.afterInline || this.afterFormatted)) {
            this.indent();
        }
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
        ++this.level;
        this.sameLine = true;
        this.afterInline = false;
        this.afterFormatted = false;
    }

    public void endElement() throws XPathException {
        boolean thisFormatted;
        --this.level;
        boolean thisInline = (this.propertyStack[this.level] & 1) != 0;
        boolean bl = thisFormatted = (this.propertyStack[this.level] & 2) != 0;
        if (!(thisInline || thisFormatted || this.afterInline || this.sameLine || this.afterFormatted || this.inFormattedTag)) {
            this.indent();
            this.afterInline = false;
            this.afterFormatted = false;
        } else {
            this.afterInline = thisInline;
            this.afterFormatted = thisFormatted;
        }
        this.nextReceiver.endElement();
        this.inFormattedTag = this.inFormattedTag && !thisFormatted;
        this.sameLine = false;
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.inFormattedTag || (properties & 0x100) != 0) {
            this.nextReceiver.characters(chars, locationId, properties);
        } else {
            int lastNL = 0;
            for (int i = 0; i < chars.length(); ++i) {
                if (chars.charAt(i) != '\n' && (i - lastNL <= 120 || chars.charAt(i) != ' ')) continue;
                this.sameLine = false;
                this.nextReceiver.characters(chars.subSequence(lastNL, i), locationId, properties);
                this.indent();
                for (lastNL = i + 1; lastNL < chars.length() && chars.charAt(lastNL) == ' '; ++lastNL) {
                }
            }
            if (lastNL < chars.length()) {
                this.nextReceiver.characters(chars.subSequence(lastNL, chars.length()), locationId, properties);
            }
        }
        this.afterInline = false;
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        this.indent();
        this.nextReceiver.comment(chars, locationId, properties);
    }

    private void indent() throws XPathException {
        int spaces = this.level * this.indentSpaces;
        if (spaces + 1 >= this.indentChars.length) {
            int increment = 5 * this.indentSpaces;
            if (spaces + 1 > this.indentChars.length + increment) {
                increment += spaces + 1;
            }
            char[] c2 = new char[this.indentChars.length + increment];
            System.arraycopy(this.indentChars, 0, c2, 0, this.indentChars.length);
            Arrays.fill(c2, this.indentChars.length, c2.length, ' ');
            this.indentChars = c2;
        }
        this.nextReceiver.characters(new CharSlice(this.indentChars, 0, spaces + 1), 0, 0);
        this.sameLine = false;
    }

    static {
        for (int j = 0; j < inlineTags.length; ++j) {
            inlineTable.add(inlineTags[j]);
        }
        formattedTable = new HTMLTagHashSet(23);
        formattedTags = new String[]{"pre", "script", "style", "textarea", "xmp"};
        for (int i = 0; i < formattedTags.length; ++i) {
            formattedTable.add(formattedTags[i]);
        }
    }
}

