/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.index;

import com.occamlab.te.index.TemplateEntry;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class TestEntry
extends TemplateEntry {
    private static final Logger LOGR = Logger.getLogger(TestEntry.class.getName());
    private int defaultResult = 1;
    private int result = 1;
    private String context;
    private String type;
    private String assertion;
    private boolean isConformanceClass;
    private boolean isBasic;

    public TestEntry() {
    }

    TestEntry(Element test) {
        super(test);
        if (this.usesContext()) {
            this.setContext(test.getElementsByTagName("context").item(0).getTextContent());
        }
        this.setType(test.getElementsByTagName("type").item(0).getTextContent());
        this.setAssertion(test.getElementsByTagName("assertion").item(0).getTextContent());
        String defaultResultName = test.getElementsByTagName("defaultResult").item(0).getTextContent();
        this.setDefaultResult(defaultResultName.equals("BestPractice") ? 0 : 1);
        this.setResult(this.getDefaultResult());
        this.isConformanceClass = Boolean.parseBoolean(test.getAttribute("isConformanceClass"));
        this.isBasic = Boolean.parseBoolean(test.getAttribute("isBasic"));
    }

    public boolean isConformanceClass() {
        return this.isConformanceClass;
    }

    public boolean isBasic() {
        return this.isBasic;
    }

    public int getDefaultResult() {
        return this.defaultResult;
    }

    public void setDefaultResult(int defaultResult) {
        this.defaultResult = defaultResult;
    }

    public int getResult() {
        return this.result;
    }

    public void setResult(int result) {
        if (LOGR.isLoggable(Level.FINE)) {
            LOGR.fine(String.format("Setting test result for %s: %d", this.getQName(), result));
        }
        this.result = result;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAssertion() {
        return this.assertion;
    }

    public void setAssertion(String assertion) {
        this.assertion = assertion;
    }

    @Override
    public String toString() {
        return super.toString() + "[result=" + this.result + "]";
    }
}

