/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.TailIterator;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.GroundedIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Value;

public class SubsequenceIterator
implements SequenceIterator,
LastPositionFinder,
LookaheadIterator {
    private SequenceIterator base;
    private int position = 0;
    private int min;
    private int max;
    private Item nextItem = null;
    private Item current = null;

    private SubsequenceIterator(SequenceIterator base, int min2, int max) throws XPathException {
        this.base = base;
        this.min = min2;
        if (min2 < 1) {
            min2 = 1;
        }
        this.max = max;
        if (max < min2) {
            this.nextItem = null;
            return;
        }
        int i = 1;
        while (i++ <= min2) {
            this.nextItem = base.next();
            if (this.nextItem != null) continue;
        }
        this.current = this.nextItem;
    }

    public static SequenceIterator make(SequenceIterator base, int min2, int max) throws XPathException {
        if (base instanceof ArrayIterator) {
            return ((ArrayIterator)base).makeSliceIterator(min2, max);
        }
        if (max == Integer.MAX_VALUE) {
            return TailIterator.make(base, min2);
        }
        if (base instanceof GroundedIterator && min2 > 4) {
            GroundedValue value = ((GroundedIterator)base).materialize();
            value = value.subsequence(min2 - 1, max - min2 + 1);
            return ((Value)((Object)value)).iterate();
        }
        return new SubsequenceIterator(base, min2, max);
    }

    public boolean hasNext() {
        return this.nextItem != null;
    }

    public Item next() throws XPathException {
        if (this.nextItem == null) {
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = this.nextItem;
        ++this.position;
        this.nextItem = this.base.position() < this.max ? this.base.next() : null;
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new SubsequenceIterator(this.base.getAnother(), this.min, this.max);
    }

    public int getProperties() {
        int p = 4;
        return p |= this.base.getProperties() & 2;
    }

    public int getLastPosition() throws XPathException {
        int lastBase = ((LastPositionFinder)this.base).getLastPosition();
        int z = Math.min(lastBase, this.max);
        return Math.max(z - this.min + 1, 0);
    }
}

