/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

public class StringLength
extends SystemFunction {
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        return this.simplifyArguments(visitor);
    }

    public int getIntrinsicDependencies() {
        int d = super.getIntrinsicDependencies();
        if (this.argument.length == 0) {
            d |= 2;
        }
        return d;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        if (this.argument.length == 0) {
            return this;
        }
        return Literal.makeLiteral((Value)((Object)this.evaluateItem(visitor.getStaticContext().makeEarlyEvaluationContext())));
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        if (this.argument.length == 0 && contextItemType == null) {
            XPathException err = new XPathException("The context item for string-length() is undefined");
            err.setErrorCode("XPDY0002");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        return super.typeCheck(visitor, contextItemType);
    }

    public Item evaluateItem(XPathContext c) throws XPathException {
        AtomicValue sv;
        if (this.argument.length == 0) {
            Item contextItem = c.getContextItem();
            if (contextItem == null) {
                this.dynamicError("The context item for string-length() is not set", "XPDY0002", c);
                return null;
            }
            sv = StringValue.makeStringValue(contextItem.getStringValueCS());
        } else {
            sv = (AtomicValue)this.argument[0].evaluateItem(c);
        }
        if (sv == null) {
            return Int64Value.ZERO;
        }
        if (sv instanceof StringValue) {
            return Int64Value.makeIntegerValue(((StringValue)sv).getStringLength());
        }
        CharSequence s2 = sv.getStringValueCS();
        return Int64Value.makeIntegerValue(StringValue.getStringLength(s2));
    }
}

