/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection.internal.hashmap;

import com.github.andrewoma.dexx.collection.Function;
import com.github.andrewoma.dexx.collection.KeyFunction;
import com.github.andrewoma.dexx.collection.Pair;
import com.github.andrewoma.dexx.collection.internal.hashmap.HashMap1;
import com.github.andrewoma.dexx.collection.internal.hashmap.HashTrieMap;
import java.util.Collections;
import java.util.Iterator;

public class CompactHashMap<K, V> {
    protected static final CompactHashMap EMPTY = new CompactHashMap();

    public Iterator<Pair<K, V>> iterator(KeyFunction<K, V> kf) {
        return Collections.emptyList().iterator();
    }

    public int size() {
        return 0;
    }

    public static <K, V> CompactHashMap<K, V> empty() {
        return EMPTY;
    }

    public <U> void forEach(Function<Pair<K, V>, U> f, KeyFunction<K, V> keyFunction) {
    }

    public V get(K key, KeyFunction<K, V> keyFunction) {
        return this.get0(key, this.computeHash(key), 0, keyFunction);
    }

    public CompactHashMap<K, V> put(K key, V value, KeyFunction<K, V> keyFunction) {
        assert (key.equals(keyFunction.key(value)));
        return this.updated0(key, this.computeHash(key), 0, value, null, keyFunction);
    }

    public CompactHashMap<K, V> remove(K key, KeyFunction<K, V> keyFunction) {
        return this.removed0(key, this.computeHash(key), 0, keyFunction);
    }

    protected int elemHashCode(K key) {
        return key.hashCode();
    }

    protected final int improve(int hashCode) {
        int h2 = hashCode + ~(hashCode << 9);
        h2 ^= h2 >>> 14;
        h2 += h2 << 4;
        return h2 ^ h2 >>> 10;
    }

    protected int computeHash(K key) {
        return this.improve(this.elemHashCode(key));
    }

    protected V get0(K key, int hash, int level, KeyFunction<K, V> keyFunction) {
        return null;
    }

    protected CompactHashMap<K, V> updated0(K key, int hash, int level, V value, Pair<K, V> kv, KeyFunction<K, V> keyFunction) {
        return new HashMap1<K, V>(key, hash, value, kv);
    }

    protected CompactHashMap<K, V> removed0(K key, int hash, int level, KeyFunction<K, V> keyFunction) {
        return this;
    }

    protected static <K, V> HashTrieMap<K, V> makeHashTrieMap(int hash0, CompactHashMap<K, V> elem0, int hash1, CompactHashMap<K, V> elem1, int level, int size) {
        int index0 = hash0 >>> level & 0x1F;
        int index1 = hash1 >>> level & 0x1F;
        if (index0 != index1) {
            int bitmap = 1 << index0 | 1 << index1;
            Object[] elems = new Object[2];
            if (index0 < index1) {
                elems[0] = CompactHashMap.unwrap(elem0);
                elems[1] = CompactHashMap.unwrap(elem1);
            } else {
                elems[0] = CompactHashMap.unwrap(elem1);
                elems[1] = CompactHashMap.unwrap(elem0);
            }
            return new HashTrieMap(bitmap, elems, size);
        }
        Object[] elems = new Object[1];
        int bitmap = 1 << index0;
        elems[0] = CompactHashMap.makeHashTrieMap(hash0, elem0, hash1, elem1, level + 5, size);
        return new HashTrieMap(bitmap, elems, size);
    }

    protected static <K, V> Object unwrap(CompactHashMap<K, V> hashMap) {
        if (hashMap instanceof HashMap1) {
            return ((HashMap1)hashMap).value;
        }
        return hashMap;
    }

    protected CompactHashMap<K, V> wrap(Object object, KeyFunction<K, V> keyFunction) {
        if (object instanceof CompactHashMap) {
            return (CompactHashMap)object;
        }
        Object value = object;
        K key = keyFunction.key(value);
        return new HashMap1<K, Object>(key, this.computeHash(key), value, null);
    }
}

