/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.util;

import com.occamlab.te.util.DomUtils;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Soap12MessageBuilder {
    public static final String SOAP_ENVELOPE = "Envelope";
    public static final String SOAP_HEADER = "Header";
    public static final String SOAP_BODY = "Body";
    public static final String SOAP_NS_URI = "http://www.w3.org/2003/05/soap-envelope";
    public static final String SOAP_ADDRESSING_URI = "http://schemas.xmlsoap.org/ws/2003/03/addressing";
    private static final String XMLNS = "xmlns";
    private static final String SOAP_ENV = "soap-env";
    public static final String WSA_URI = "http://schemas.xmlsoap.org/ws/2003/03/addressing";
    public static final String SCHEMA_INSTANCE_URI = "www.w3.org/2001/XMLSchema-instance";
    public static final String SCHEMA_URI = "www.w3.org/2001/XMLSchema";
    public static final String XSD = "xsd";
    public static final String XSI = "xsi";
    public static final String MUST_UNDERSTAND = "mustUnderstand";
    public static final String ZERO = "0";
    public static final String TYPE = "type";
    public static final String STRING = "string";
    public static final String BLOCK = "block";
    public static final String RELY = "rely";
    public static final String ROLE = "role";
    public static final String ROLE_NEXT_SC = "next";
    public static final String ROLE_NONE_SC = "none";
    public static final String ROLE_ULTIMATE_RECEIVER_SC = "ultimateReceiver";
    public static final String ROLE_NEXT = "http://www.w3.org/2003/05/soap-envelope/role/next";
    public static final String ROLE_NONE = "http://www.w3.org/2003/05/soap-envelope/role/none";
    public static final String ROLE_ULTIMATE_RECEIVER = "http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver";

    public static Document getSoapMessage(List headerBlocks, Element i_body) throws Exception {
        Node importedNode;
        Document soapDocument = DomUtils.createDocument(null);
        Element envelope = soapDocument.createElementNS(SOAP_NS_URI, "soap-env:Envelope");
        soapDocument.appendChild(envelope);
        NodeList children = null;
        if (headerBlocks.size() > 0) {
            Element header = soapDocument.createElementNS(SOAP_NS_URI, "soap-env:Header");
            envelope.appendChild(header);
            for (int j = 0; j < headerBlocks.size(); ++j) {
                NamedNodeMap blockAttributes = ((Node)headerBlocks.get(j)).getAttributes();
                children = ((Node)headerBlocks.get(j)).getChildNodes();
                if (children.getLength() <= 0) continue;
                for (int i = 0; i < children.getLength(); ++i) {
                    if (children.item(i).getNodeType() != 1) continue;
                    importedNode = soapDocument.importNode(children.item(i), true);
                    for (int k = 0; k <= blockAttributes.getLength() - 1; ++k) {
                        Attr attribute = (Attr)blockAttributes.item(k);
                        String attributeName = attribute.getName();
                        if (attributeName.equals(RELY) || attributeName.equals(MUST_UNDERSTAND)) {
                            ((Element)importedNode).setAttributeNS(SOAP_NS_URI, "soap-env:" + attributeName, attribute.getValue());
                            continue;
                        }
                        if (!attributeName.equals(ROLE)) continue;
                        String value = attribute.getValue();
                        if (value.equals(ROLE_NEXT_SC)) {
                            ((Element)importedNode).setAttributeNS(SOAP_NS_URI, "soap-env:role", ROLE_NEXT);
                            continue;
                        }
                        if (value.equals(ROLE_NONE_SC)) {
                            ((Element)importedNode).setAttributeNS(SOAP_NS_URI, "soap-env:role", ROLE_NONE);
                            continue;
                        }
                        if (value.equals(ROLE_ULTIMATE_RECEIVER_SC)) {
                            ((Element)importedNode).setAttributeNS(SOAP_NS_URI, "soap-env:role", ROLE_ULTIMATE_RECEIVER);
                            continue;
                        }
                        ((Element)importedNode).setAttributeNS(SOAP_NS_URI, "soap-env:" + attributeName, value);
                    }
                    header.appendChild(importedNode);
                }
            }
        }
        Element body = soapDocument.createElementNS(SOAP_NS_URI, "soap-env:Body");
        envelope.appendChild(body);
        children = i_body.getChildNodes();
        if (children.getLength() > 0) {
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                Document newSoapDocument = DomUtils.createDocument((Element)children.item(i));
                importedNode = soapDocument.importNode(newSoapDocument.getDocumentElement(), true);
                body.appendChild(importedNode);
            }
        }
        return soapDocument;
    }
}

