/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.XmlMethodSelector;

public class ClassMethodMap {
    private Map<Object, List<ITestNGMethod>> m_classMap = Maps.newHashMap();
    private Map<ITestClass, Set<Object>> m_beforeClassMethods = Maps.newHashMap();
    private Map<ITestClass, Set<Object>> m_afterClassMethods = Maps.newHashMap();

    public ClassMethodMap(List<ITestNGMethod> methods, XmlMethodSelector xmlMethodSelector) {
        for (ITestNGMethod m3 : methods) {
            if (xmlMethodSelector != null && !xmlMethodSelector.includeMethod(null, m3, true)) continue;
            Object instance = m3.getInstance();
            List<ITestNGMethod> l = this.m_classMap.get(instance);
            if (l == null) {
                l = Lists.newArrayList();
                this.m_classMap.put(instance, l);
            }
            l.add(m3);
        }
    }

    public synchronized boolean removeAndCheckIfLast(ITestNGMethod m3, Object instance) {
        List<ITestNGMethod> l = this.m_classMap.get(instance);
        if (l != null) {
            l.remove(m3);
            for (ITestNGMethod tm : l) {
                if (!tm.getEnabled() || !tm.getTestClass().equals(m3.getTestClass())) continue;
                return false;
            }
            return true;
        }
        throw new AssertionError((Object)"l should not be null");
    }

    private Class<?> getMethodClass(ITestNGMethod m3) {
        return m3.getTestClass().getRealClass();
    }

    public Map<ITestClass, Set<Object>> getInvokedBeforeClassMethods() {
        return this.m_beforeClassMethods;
    }

    public Map<ITestClass, Set<Object>> getInvokedAfterClassMethods() {
        return this.m_afterClassMethods;
    }

    public void clear() {
        for (Set<Object> instances : this.m_beforeClassMethods.values()) {
            instances.clear();
            instances = null;
        }
        for (Set<Object> instances : this.m_afterClassMethods.values()) {
            instances.clear();
            Object var2_2 = null;
        }
        this.m_beforeClassMethods.clear();
        this.m_afterClassMethods.clear();
    }
}

