/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wcs20;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.TextFragmentValue;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.opengis.cite.wcs20.GeometryTransformer;

public class Utils {
    private static GeometryTransformer geometryTransformer;
    private static DecimalFormat df;

    public static boolean checkCoordinatesWithCrsTransformation(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        String string = Utils.getStringvalue(object);
        String string2 = Utils.getStringvalue(object2);
        String string3 = Utils.getStringvalue(object3);
        String string4 = Utils.getStringvalue(object4);
        String string5 = Utils.getStringvalue(object5);
        String string6 = Utils.getStringvalue(object6);
        String string7 = Utils.getStringvalue(object7);
        geometryTransformer = new GeometryTransformer(string7, string6);
        List<Double> list = Utils.createXyList(string5);
        return Utils.containsWithTransformation(string, string2, list) && Utils.containsWithTransformation(string3, string4, list);
    }

    private static List<Double> createXyList(String string) {
        String[] stringArray = string.split(" ");
        ArrayList<Double> arrayList = new ArrayList<Double>(stringArray.length);
        for (String string2 : stringArray) {
            arrayList.add(Double.parseDouble(string2));
        }
        return arrayList;
    }

    private static boolean containsWithTransformation(String string, String string2, List<Double> list) {
        Point point = Utils.createPoint(string, string2);
        Point point2 = geometryTransformer.transform(point);
        String string3 = df.format(point2.getX());
        String string4 = df.format(point2.getY());
        return Utils.contains(string3, list) && Utils.contains(string4, list);
    }

    private static boolean contains(String string, List<Double> list) {
        return list.stream().anyMatch(d -> df.format(d).equals(string));
    }

    private static Point createPoint(String string, String string2) {
        Coordinate coordinate = new Coordinate(Double.parseDouble(string), Double.parseDouble(string2));
        Coordinate[] coordinateArray = new Coordinate[]{coordinate};
        CoordinateArraySequence coordinateArraySequence = new CoordinateArraySequence(coordinateArray);
        Point point = new Point(coordinateArraySequence, geometryTransformer.getGeometryFactory());
        return point;
    }

    private static String getStringvalue(Object object) {
        if (object instanceof ArrayList) {
            Object e;
            ArrayList arrayList = (ArrayList)object;
            if (arrayList.size() > 0 && (e = arrayList.get(0)) instanceof NodeInfo) {
                String string = ((NodeInfo)e).getStringValue();
                return string;
            }
        } else if (object instanceof TextFragmentValue) {
            return ((TextFragmentValue)object).getStringValue();
        }
        return null;
    }

    static {
        df = new DecimalFormat("#.############");
    }
}

