/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wcs20;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.CoordinateTransformFactory;
import org.locationtech.proj4j.ProjCoordinate;
import org.opengis.cite.wcs20.exception.UnknownCrsException;

public class GeometryTransformer {
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private final CoordinateTransform transformer;

    public GeometryTransformer(String string, String string2) {
        CoordinateTransformFactory coordinateTransformFactory = new CoordinateTransformFactory();
        CRSFactory cRSFactory = new CRSFactory();
        this.transformer = coordinateTransformFactory.createTransform(cRSFactory.createFromName(this.getCodeWithAuthority(string)), cRSFactory.createFromName(this.getCodeWithAuthority(string2)));
    }

    public Geometry transform(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        if (geometry instanceof Point) {
            return this.transform((Point)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.transform((Polygon)geometry);
        }
        if (geometry instanceof LineString) {
            return this.transform((LineString)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.transform((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Unsupported geometry type: " + geometry.getClass());
    }

    public Point transform(Point point) {
        Coordinate coordinate = point.getCoordinate();
        Coordinate coordinate2 = this.transform(coordinate);
        return this.geometryFactory.createPoint(coordinate2);
    }

    public LineString transform(LineString lineString) {
        Coordinate[] coordinateArray = lineString.getCoordinates();
        Coordinate[] coordinateArray2 = this.transform(coordinateArray);
        return this.geometryFactory.createLineString(coordinateArray2);
    }

    public Polygon transform(Polygon polygon) {
        Coordinate[] coordinateArray = polygon.getExteriorRing().getCoordinates();
        Coordinate[] coordinateArray2 = this.transform(coordinateArray);
        LinearRing linearRing = this.geometryFactory.createLinearRing(coordinateArray2);
        LinearRing[] linearRingArray = new LinearRing[polygon.getNumInteriorRing()];
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            LinearRing linearRing2 = polygon.getInteriorRingN(i);
            Coordinate[] coordinateArray3 = this.transform(linearRing2.getCoordinates());
            linearRingArray[i] = this.geometryFactory.createLinearRing(coordinateArray3);
        }
        return this.geometryFactory.createPolygon(linearRing, linearRingArray);
    }

    public Geometry transform(GeometryCollection geometryCollection) {
        if (geometryCollection instanceof MultiPoint) {
            return this.transform((MultiPoint)geometryCollection);
        }
        if (geometryCollection instanceof MultiLineString) {
            return this.transform((MultiLineString)geometryCollection);
        }
        if (geometryCollection instanceof MultiPolygon) {
            return this.transform((MultiPolygon)geometryCollection);
        }
        throw new IllegalArgumentException("Unsupported geometry type: " + geometryCollection.getClass());
    }

    public MultiPoint transform(MultiPoint multiPoint) {
        Point[] pointArray = new Point[multiPoint.getNumGeometries()];
        for (int i = 0; i < multiPoint.getNumGeometries(); ++i) {
            Geometry geometry = multiPoint.getGeometryN(i);
            pointArray[i] = this.transform((Point)geometry);
        }
        return this.geometryFactory.createMultiPoint(pointArray);
    }

    public MultiLineString transform(MultiLineString multiLineString) {
        LineString[] lineStringArray = new LineString[multiLineString.getNumGeometries()];
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            Geometry geometry = multiLineString.getGeometryN(i);
            lineStringArray[i] = this.transform((LineString)geometry);
        }
        return this.geometryFactory.createMultiLineString(lineStringArray);
    }

    public MultiPolygon transform(MultiPolygon multiPolygon) {
        Polygon[] polygonArray = new Polygon[multiPolygon.getNumGeometries()];
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            Geometry geometry = multiPolygon.getGeometryN(i);
            polygonArray[i] = this.transform((Polygon)geometry);
        }
        return this.geometryFactory.createMultiPolygon(polygonArray);
    }

    private Coordinate[] transform(Coordinate[] coordinateArray) {
        List<Coordinate> list = Arrays.stream(coordinateArray).map(coordinate -> this.transform((Coordinate)coordinate)).collect(Collectors.toList());
        return list.toArray(new Coordinate[list.size()]);
    }

    private Coordinate transform(Coordinate coordinate) {
        ProjCoordinate projCoordinate = new ProjCoordinate(coordinate.x, coordinate.y, coordinate.z);
        ProjCoordinate projCoordinate2 = new ProjCoordinate();
        this.transformer.transform(projCoordinate, projCoordinate2);
        return new Coordinate(projCoordinate2.x, projCoordinate2.y, projCoordinate2.z);
    }

    public int getSrid(String string) {
        try {
            if (string.startsWith("http://www.opengis.net/def/crs/")) {
                return Integer.parseInt(string.substring(string.lastIndexOf("/") + 1));
            }
            if (string.startsWith("urn:ogc:def:crs:")) {
                return Integer.parseInt(string.substring(string.lastIndexOf(":") + 1));
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new UnknownCrsException(String.format("Could not parse srid from crs '%s', crs is not supported.", string));
        }
        throw new UnknownCrsException(String.format("Could not parse srid from crs '%s', crs is not supported.", string));
    }

    public String getCodeWithAuthority(String string) {
        if (string.startsWith("urn:ogc:def:crs:EPSG") || string.startsWith("http://www.opengis.net/def/crs/EPSG")) {
            int n = this.getSrid(string);
            return String.format("EPSG:%s", n);
        }
        if (string.startsWith("EPSG:")) {
            return string;
        }
        throw new UnknownCrsException(String.format("CRS %s is not supported, only OGC URNs (starting with urn:ogc:def:crs:epsg) and OGC http-URIs (starting with http://www.opengis.net/def/crs/epsg) with EPSG auhority are supported.", string));
    }

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }
}

