/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.PlanarGraph;
import org.locationtech.jts.geomgraph.index.EdgeSetIntersector;
import org.locationtech.jts.geomgraph.index.SegmentIntersector;
import org.locationtech.jts.geomgraph.index.SimpleMCSweepLineIntersector;
import org.locationtech.jts.util.Assert;

public class GeometryGraph
extends PlanarGraph {
    private Geometry parentGeom;
    private Map lineEdgeMap = new HashMap();
    private BoundaryNodeRule boundaryNodeRule = null;
    private boolean useBoundaryDeterminationRule = true;
    private int argIndex;
    private Collection boundaryNodes;
    private boolean hasTooFewPoints = false;
    private Coordinate invalidPoint = null;
    private PointOnGeometryLocator areaPtLocator = null;
    private final PointLocator ptLocator = new PointLocator();

    public static int determineBoundary(BoundaryNodeRule boundaryNodeRule, int boundaryCount) {
        return boundaryNodeRule.isInBoundary(boundaryCount) ? 1 : 0;
    }

    private EdgeSetIntersector createEdgeSetIntersector() {
        return new SimpleMCSweepLineIntersector();
    }

    public GeometryGraph(int argIndex, Geometry parentGeom) {
        this(argIndex, parentGeom, BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE);
    }

    public GeometryGraph(int argIndex, Geometry parentGeom, BoundaryNodeRule boundaryNodeRule) {
        this.argIndex = argIndex;
        this.parentGeom = parentGeom;
        this.boundaryNodeRule = boundaryNodeRule;
        if (parentGeom != null) {
            this.add(parentGeom);
        }
    }

    public boolean hasTooFewPoints() {
        return this.hasTooFewPoints;
    }

    public Coordinate getInvalidPoint() {
        return this.invalidPoint;
    }

    public Geometry getGeometry() {
        return this.parentGeom;
    }

    public BoundaryNodeRule getBoundaryNodeRule() {
        return this.boundaryNodeRule;
    }

    public Collection getBoundaryNodes() {
        if (this.boundaryNodes == null) {
            this.boundaryNodes = this.nodes.getBoundaryNodes(this.argIndex);
        }
        return this.boundaryNodes;
    }

    public Coordinate[] getBoundaryPoints() {
        Collection coll = this.getBoundaryNodes();
        Coordinate[] pts = new Coordinate[coll.size()];
        int i = 0;
        for (Node node : coll) {
            pts[i++] = node.getCoordinate().copy();
        }
        return pts;
    }

    public Edge findEdge(LineString line) {
        return (Edge)this.lineEdgeMap.get(line);
    }

    public void computeSplitEdges(List edgelist) {
        for (Edge e : this.edges) {
            e.eiList.addSplitEdges(edgelist);
        }
    }

    private void add(Geometry g2) {
        if (g2.isEmpty()) {
            return;
        }
        if (g2 instanceof MultiPolygon) {
            this.useBoundaryDeterminationRule = false;
        }
        if (g2 instanceof Polygon) {
            this.addPolygon((Polygon)g2);
        } else if (g2 instanceof LineString) {
            this.addLineString((LineString)g2);
        } else if (g2 instanceof Point) {
            this.addPoint((Point)g2);
        } else if (g2 instanceof MultiPoint) {
            this.addCollection((MultiPoint)g2);
        } else if (g2 instanceof MultiLineString) {
            this.addCollection((MultiLineString)g2);
        } else if (g2 instanceof MultiPolygon) {
            this.addCollection((MultiPolygon)g2);
        } else if (g2 instanceof GeometryCollection) {
            this.addCollection((GeometryCollection)g2);
        } else {
            throw new UnsupportedOperationException(g2.getClass().getName());
        }
    }

    private void addCollection(GeometryCollection gc) {
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g2 = gc.getGeometryN(i);
            this.add(g2);
        }
    }

    private void addPoint(Point p) {
        Coordinate coord = p.getCoordinate();
        this.insertPoint(this.argIndex, coord, 0);
    }

    private void addPolygonRing(LinearRing lr, int cwLeft, int cwRight) {
        if (lr.isEmpty()) {
            return;
        }
        Coordinate[] coord = CoordinateArrays.removeRepeatedPoints(lr.getCoordinates());
        if (coord.length < 4) {
            this.hasTooFewPoints = true;
            this.invalidPoint = coord[0];
            return;
        }
        int left = cwLeft;
        int right = cwRight;
        if (Orientation.isCCW(coord)) {
            left = cwRight;
            right = cwLeft;
        }
        Edge e = new Edge(coord, new Label(this.argIndex, 1, left, right));
        this.lineEdgeMap.put(lr, e);
        this.insertEdge(e);
        this.insertPoint(this.argIndex, coord[0], 1);
    }

    private void addPolygon(Polygon p) {
        this.addPolygonRing(p.getExteriorRing(), 2, 0);
        for (int i = 0; i < p.getNumInteriorRing(); ++i) {
            LinearRing hole = p.getInteriorRingN(i);
            this.addPolygonRing(hole, 0, 2);
        }
    }

    private void addLineString(LineString line) {
        Coordinate[] coord = CoordinateArrays.removeRepeatedPoints(line.getCoordinates());
        if (coord.length < 2) {
            this.hasTooFewPoints = true;
            this.invalidPoint = coord[0];
            return;
        }
        Edge e = new Edge(coord, new Label(this.argIndex, 0));
        this.lineEdgeMap.put(line, e);
        this.insertEdge(e);
        Assert.isTrue(coord.length >= 2, "found LineString with single point");
        this.insertBoundaryPoint(this.argIndex, coord[0]);
        this.insertBoundaryPoint(this.argIndex, coord[coord.length - 1]);
    }

    public void addEdge(Edge e) {
        this.insertEdge(e);
        Coordinate[] coord = e.getCoordinates();
        this.insertPoint(this.argIndex, coord[0], 1);
        this.insertPoint(this.argIndex, coord[coord.length - 1], 1);
    }

    public void addPoint(Coordinate pt) {
        this.insertPoint(this.argIndex, pt, 0);
    }

    public SegmentIntersector computeSelfNodes(LineIntersector li, boolean computeRingSelfNodes) {
        return this.computeSelfNodes(li, computeRingSelfNodes, false);
    }

    public SegmentIntersector computeSelfNodes(LineIntersector li, boolean computeRingSelfNodes, boolean isDoneIfProperInt) {
        SegmentIntersector si = new SegmentIntersector(li, true, false);
        si.setIsDoneIfProperInt(isDoneIfProperInt);
        EdgeSetIntersector esi = this.createEdgeSetIntersector();
        boolean isRings = this.parentGeom instanceof LinearRing || this.parentGeom instanceof Polygon || this.parentGeom instanceof MultiPolygon;
        boolean computeAllSegments = computeRingSelfNodes || !isRings;
        esi.computeIntersections(this.edges, si, computeAllSegments);
        this.addSelfIntersectionNodes(this.argIndex);
        return si;
    }

    public SegmentIntersector computeEdgeIntersections(GeometryGraph g2, LineIntersector li, boolean includeProper) {
        SegmentIntersector si = new SegmentIntersector(li, includeProper, true);
        si.setBoundaryNodes(this.getBoundaryNodes(), g2.getBoundaryNodes());
        EdgeSetIntersector esi = this.createEdgeSetIntersector();
        esi.computeIntersections(this.edges, g2.edges, si);
        return si;
    }

    private void insertPoint(int argIndex, Coordinate coord, int onLocation) {
        Node n = this.nodes.addNode(coord);
        Label lbl = n.getLabel();
        if (lbl == null) {
            n.label = new Label(argIndex, onLocation);
        } else {
            lbl.setLocation(argIndex, onLocation);
        }
    }

    private void insertBoundaryPoint(int argIndex, Coordinate coord) {
        Node n = this.nodes.addNode(coord);
        Label lbl = n.getLabel();
        int boundaryCount = 1;
        int loc = -1;
        loc = lbl.getLocation(argIndex, 0);
        if (loc == 1) {
            ++boundaryCount;
        }
        int newLoc = GeometryGraph.determineBoundary(this.boundaryNodeRule, boundaryCount);
        lbl.setLocation(argIndex, newLoc);
    }

    private void addSelfIntersectionNodes(int argIndex) {
        for (Edge e : this.edges) {
            int eLoc = e.getLabel().getLocation(argIndex);
            Iterator eiIt = e.eiList.iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei = (EdgeIntersection)eiIt.next();
                this.addSelfIntersectionNode(argIndex, ei.coord, eLoc);
            }
        }
    }

    private void addSelfIntersectionNode(int argIndex, Coordinate coord, int loc) {
        if (this.isBoundaryNode(argIndex, coord)) {
            return;
        }
        if (loc == 1 && this.useBoundaryDeterminationRule) {
            this.insertBoundaryPoint(argIndex, coord);
        } else {
            this.insertPoint(argIndex, coord, loc);
        }
    }

    public int locate(Coordinate pt) {
        if (this.parentGeom instanceof Polygonal && this.parentGeom.getNumGeometries() > 50) {
            if (this.areaPtLocator == null) {
                this.areaPtLocator = new IndexedPointInAreaLocator(this.parentGeom);
            }
            return this.areaPtLocator.locate(pt);
        }
        return this.ptLocator.locate(pt, this.parentGeom);
    }
}

