/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import com.occamlab.te.TECore;
import com.occamlab.te.util.DomUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.FormView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SwingForm
extends JFrame
implements HyperlinkListener {
    static final long serialVersionUID = 7907599307261079944L;
    public static final String CTL_NS = "http://www.occamlab.com/ctl";
    private static SwingForm mainForm = null;
    private static SwingForm popupForm = null;
    private static TECore core;
    private static String popupName;
    private JEditorPane jedit;
    private ArrayList<String> fileFields = new ArrayList();

    private SwingForm(String name) {
        this.setTitle(name);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)topPanel, "Center");
        this.jedit = new JEditorPane();
        this.jedit.setEditorKit(new CustomHTMLEditorKit());
        this.jedit.setEditable(false);
        this.jedit.addHyperlinkListener(this);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add((Component)this.jedit, "Center");
        topPanel.add((Component)scrollPane, "Center");
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    URL target = e.getURL();
                    if (target == null) {
                        target = new URL(new URL(SwingForm.core.opts.getBaseURI()), e.getDescription());
                    }
                    if (this == popupForm) {
                        pane.setPage(target);
                    } else {
                        if (popupForm == null) {
                            popupForm = new SwingForm(popupName);
                            popupForm.setSize(700, 500);
                            popupForm.setLocation(this.getX() + 30, this.getY() + 30);
                        }
                        SwingForm.popupForm.jedit.setPage(target);
                        popupForm.setVisible(true);
                    }
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                }
            }
        }
    }

    public static void create(String name, int width, int height, TECore core) {
        Invoker invoker = new Invoker();
        invoker.name = name;
        invoker.width = width;
        invoker.height = height;
        SwingForm.core = core;
        SwingUtilities.invokeLater(invoker);
    }

    public static void destroy() {
        if (popupForm != null) {
            popupForm.dispose();
            popupForm = null;
        }
        if (mainForm != null) {
            mainForm.dispose();
            mainForm = null;
        }
    }

    static {
        popupName = Thread.currentThread().getName();
    }

    private class CustomHTMLEditorKit
    extends HTMLEditorKit {
        static final long serialVersionUID = 5742710765916499050L;

        private CustomHTMLEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return new CustomViewFactory();
        }
    }

    private static class Invoker
    implements Runnable {
        String name;
        int width;
        int height;

        private Invoker() {
        }

        @Override
        public void run() {
            if (mainForm == null) {
                mainForm = new SwingForm(this.name);
            }
            Object html = core.getFormHtml();
            core.setFormHtml(null);
            int i = ((String)html).indexOf("<meta");
            if (i > 0) {
                html = ((String)html).substring(0, i + 1) + "blah" + ((String)html).substring(i + 5);
            }
            SwingForm.mainForm.jedit.setText((String)html);
            mainForm.setSize(this.width, this.height);
            mainForm.validate();
            mainForm.setVisible(true);
        }
    }

    private class CustomViewFactory
    extends HTMLEditorKit.HTMLFactory {
        private CustomViewFactory() {
        }

        @Override
        public View create(javax.swing.text.Element elem) {
            AttributeSet as = elem.getAttributes();
            HTML.Tag tag = (HTML.Tag)as.getAttribute(StyleConstants.NameAttribute);
            if (tag == HTML.Tag.INPUT) {
                String type = "";
                String name = "";
                Enumeration<?> e = as.getAttributeNames();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    if (key == HTML.Attribute.TYPE) {
                        type = as.getAttribute(key).toString();
                    }
                    if (key != HTML.Attribute.NAME) continue;
                    name = as.getAttribute(key).toString();
                }
                if (type.equalsIgnoreCase("submit")) {
                    return new CustomFormView(elem);
                }
                if (type.equalsIgnoreCase("file")) {
                    SwingForm.this.fileFields.add(name);
                }
            }
            return super.create(elem);
        }
    }

    private class CustomFormView
    extends FormView {
        public CustomFormView(javax.swing.text.Element elem) {
            super(elem);
        }

        @Override
        protected void submitData(String data) {
            if (SwingForm.this == popupForm) {
                return;
            }
            try {
                int amp;
                String kvps = data + "&=";
                int start = 0;
                int end = data.length();
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = db.newDocument();
                Element root = doc.createElement("values");
                doc.appendChild(root);
                do {
                    String value;
                    String key;
                    int eq = kvps.indexOf("=", start);
                    amp = kvps.indexOf("&", start);
                    if (amp > eq) {
                        key = kvps.substring(start, eq);
                        value = kvps.substring(eq + 1, amp);
                    } else {
                        key = kvps.substring(start, amp);
                        value = "";
                    }
                    Element valueElement = doc.createElement("value");
                    valueElement.setAttribute("key", key);
                    if (SwingForm.this.fileFields.contains(key)) {
                        File f = new File(URLDecoder.decode(value, StandardCharsets.UTF_8));
                        if (f != null) {
                            if (SwingForm.core.formParsers.containsKey(key)) {
                                Element child;
                                Element parser = SwingForm.core.formParsers.get(key);
                                URL url = f.toURI().toURL();
                                Element response = core.parse(url.openConnection(), parser, doc);
                                Element content = DomUtils.getElementByTagName(response, "content");
                                if (content != null && (child = DomUtils.getChildElement(content)) != null) {
                                    valueElement.appendChild(child);
                                }
                            } else {
                                Element fileEntry = doc.createElementNS(SwingForm.CTL_NS, "file-entry");
                                fileEntry.setAttribute("full-path", URLDecoder.decode(value, StandardCharsets.UTF_8).replace('\\', '/'));
                                valueElement.appendChild(fileEntry);
                            }
                        }
                    } else {
                        valueElement.appendChild(doc.createTextNode(URLDecoder.decode(value, StandardCharsets.UTF_8)));
                    }
                    root.appendChild(valueElement);
                } while ((start = amp + 1) < end);
                core.setFormResults(doc);
                if (popupForm != null) {
                    popupForm.setVisible(false);
                }
            }
            catch (Throwable t2) {
                t2.printStackTrace(System.out);
            }
            mainForm.setVisible(false);
        }
    }
}

