/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te;

import com.occamlab.te.CtlEarlReporter;
import com.occamlab.te.Engine;
import com.occamlab.te.RecordTestResult;
import com.occamlab.te.RecordedForm;
import com.occamlab.te.RecordedForms;
import com.occamlab.te.RuntimeOptions;
import com.occamlab.te.SwingForm;
import com.occamlab.te.TEClassLoader;
import com.occamlab.te.Test;
import com.occamlab.te.form.ImageHandler;
import com.occamlab.te.html.EarlToHtmlTransformation;
import com.occamlab.te.index.FunctionEntry;
import com.occamlab.te.index.Index;
import com.occamlab.te.index.ParserEntry;
import com.occamlab.te.index.ProfileEntry;
import com.occamlab.te.index.SuiteEntry;
import com.occamlab.te.index.TemplateEntry;
import com.occamlab.te.index.TestEntry;
import com.occamlab.te.saxon.ObjValue;
import com.occamlab.te.util.DomUtils;
import com.occamlab.te.util.IOUtils;
import com.occamlab.te.util.LogUtils;
import com.occamlab.te.util.Misc;
import com.occamlab.te.util.SoapUtils;
import com.occamlab.te.util.StringUtils;
import com.occamlab.te.util.TEPath;
import com.occamlab.te.util.URLConnectionUtils;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.S9APIUtils;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trans.XPathException;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TECore
implements Runnable {
    private static final Logger LOGR = Logger.getLogger(TECore.class.getName());
    public static final String SOAP_V_1_1 = "1.1";
    public static final String SOAP_V_1_2 = "1.2";
    Engine engine;
    Index index;
    public static int testCount = 0;
    int reTestCount = 0;
    public static int methodCount = 0;
    String testName = "";
    public static String nameOfTest = "";
    final RuntimeOptions opts;
    String testServletURL = null;
    volatile PrintStream out;
    boolean web = false;
    RecordedForms recordedForms;
    private String testPath;
    String fnPath = "";
    String indent = "";
    String contextLabel = "";
    String testType = "Mandatory";
    String defaultResultName = "Pass";
    int defaultResult = 1;
    ArrayList<String> media = new ArrayList();
    public File dirPath;
    Document prevLog = null;
    Document suiteLog = null;
    public static String pathURL = "";
    public static String assertionMsz = "";
    public static String messageTest = "";
    PrintWriter logger = null;
    volatile String formHtml;
    volatile Document formResults;
    Map<String, Element> formParsers = new HashMap<String, Element>();
    Map<Integer, Object> functionInstances = new HashMap<Integer, Object>();
    Map<String, Object> parserInstances = new HashMap<String, Object>();
    Map<String, Method> parserMethods = new HashMap<String, Method>();
    LinkedList<TestEntry> testStack = new LinkedList();
    volatile boolean threadComplete = false;
    volatile boolean stop = false;
    volatile ByteArrayOutputStream threadOutput;
    private Stack<String> fnCallStack;
    public static final int CONTINUE = -1;
    public static final int BEST_PRACTICE = 0;
    public static final int PASS = 1;
    public static final int NOT_TESTED = 2;
    public static final int SKIPPED = 3;
    public static final int WARNING = 4;
    public static final int INHERITED_FAILURE = 5;
    public static final int FAIL = 6;
    public static final String MSG_CONTINUE = "Inconclusive! Continue Test";
    public static final String MSG_BEST_PRACTICE = "Passed as Best Practice";
    public static final String MSG_PASS = "Passed";
    public static final String MSG_NOT_TESTED = "Not Tested";
    public static final String MSG_SKIPPED = "Skipped - Prerequisites not satisfied";
    public static final String MSG_WARNING = "Warning";
    public static final String MSG_INHERITED_FAILURE = "Failed - Inherited";
    public static final String MSG_FAIL = "Failed";
    public static final int MANDATORY = 0;
    public static final int MANDATORY_IF_IMPLEMENTED = 1;
    public static final int OPTIONAL = 2;
    static final String XSL_NS = "http://www.w3.org/1999/XSL/Transform";
    static final String CTL_NS = "http://www.occamlab.com/ctl";
    static final String TE_NS = "http://www.occamlab.com/te";
    static final String INDENT = "   ";
    static final net.sf.saxon.s9api.QName TECORE_QNAME = new net.sf.saxon.s9api.QName("te", "http://www.occamlab.com/te", "core");
    static final net.sf.saxon.s9api.QName TEPARAMS_QNAME = new net.sf.saxon.s9api.QName("te", "http://www.occamlab.com/te", "params");
    static final net.sf.saxon.s9api.QName LOCALNAME_QNAME = new net.sf.saxon.s9api.QName("local-name");
    static final net.sf.saxon.s9api.QName LABEL_QNAME = new net.sf.saxon.s9api.QName("label");
    static final String HEADER_BLOCKS = "header-blocks";
    private static Logger jlogger = Logger.getLogger("com.occamlab.te.TECore");
    public static DocumentBuilderFactory icFactory;
    public static javax.xml.parsers.DocumentBuilder icBuilder;
    public static Document doc;
    public static Element mainRootElement;
    public static DocumentBuilderFactory icFactoryClause;
    public static javax.xml.parsers.DocumentBuilder icBuilderClause;
    public static Document docClause;
    public static Element mainRootElementClause;
    public static String TESTNAME;
    public static int rootNo;
    public static String Clause;
    public static String Purpose;
    public static ArrayList<String> rootTestName;
    public Document userInputs = null;
    public Boolean supportHtmlReport = false;
    public final ImageHandler imageHandler;

    public TECore() {
        this.opts = null;
        this.imageHandler = null;
    }

    public TECore(Engine engine, Index index, RuntimeOptions opts) {
        this.engine = engine;
        this.index = index;
        this.opts = opts;
        this.recordedForms = new RecordedForms(opts.getRecordedForms());
        this.testPath = opts.getSessionId();
        this.out = System.out;
        this.imageHandler = new ImageHandler(opts.getLogDir(), opts.getSessionId());
        this.fnCallStack = new Stack();
    }

    public TestEntry getParentTest() {
        if (this.testStack.size() < 2) {
            return this.testStack.peek();
        }
        return this.testStack.get(1);
    }

    public String getParamsXML(List<String> params) throws Exception {
        Object paramsXML = "<params>";
        for (int i = 0; i < params.size(); ++i) {
            String param = params.get(i);
            String name = param.substring(0, param.indexOf(61));
            String value = param.substring(param.indexOf(61) + 1);
            if (params.get(i).indexOf(61) == 0) continue;
            paramsXML = (String)paramsXML + "<param local-name=\"" + name + "\" namespace-uri=\"\" prefix=\"\" type=\"xs:string\">";
            paramsXML = (String)paramsXML + "<value><![CDATA[" + value + "]]></value>";
            paramsXML = (String)paramsXML + "</param>";
        }
        paramsXML = (String)paramsXML + "</params>";
        return paramsXML;
    }

    XPathContext getXPathContext(TestEntry test, String sourcesName, XdmNode contextNode) throws Exception {
        XPathContextMajor context = null;
        if (test.usesContext() && contextNode != null) {
            XsltExecutable xe = this.engine.loadExecutable(test, sourcesName);
            Executable ex = xe.getUnderlyingCompiledStylesheet().getExecutable();
            context = new XPathContextMajor((Item)contextNode.getUnderlyingNode(), ex);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        block28: {
            try {
                TestEntry grandParent = new TestEntry();
                grandParent.setType("Mandatory");
                grandParent.setResult(-1);
                this.testStack.push(grandParent);
                String sessionId = this.opts.getSessionId();
                int mode = this.opts.getMode();
                ArrayList<String> params = this.opts.getParams();
                if (mode == 2) {
                    this.reexecute_test(sessionId);
                    break block28;
                }
                if (mode == 3) {
                    this.reexecute_test(sessionId);
                    break block28;
                }
                if (mode == 1) {
                    for (String testPath : this.opts.getTestPaths()) {
                        this.reexecute_test(testPath);
                    }
                    break block28;
                }
                if (mode == 0 || mode == 4) {
                    String testName = this.opts.getTestName();
                    if (!testName.isEmpty()) {
                        XdmNode contextNode = this.opts.getContextNode();
                        this.execute_test(testName, params, contextNode);
                    } else {
                        String suiteName = this.opts.getSuiteName();
                        ArrayList<String> profiles = this.opts.getProfiles();
                        if (!suiteName.isEmpty() || profiles.size() == 0) {
                            this.execute_suite(suiteName, params);
                        }
                        if (profiles.contains("*")) {
                            for (String profile : this.index.getProfileKeys()) {
                                try {
                                    this.execute_profile(profile, params, false);
                                }
                                catch (Exception e) {
                                    jlogger.log(Level.WARNING, e.getMessage(), e.getCause());
                                }
                            }
                        } else {
                            for (String profile : profiles) {
                                try {
                                    this.execute_profile(profile, params, true);
                                }
                                catch (Exception e) {
                                    jlogger.log(Level.WARNING, e.getMessage(), e.getCause());
                                }
                            }
                        }
                    }
                    break block28;
                }
                throw new Exception("Unsupported mode");
            }
            finally {
                if (!this.web) {
                    SwingForm.destroy();
                }
                if (this.opts.getLogDir() != null) {
                    LogUtils.createFullReportLog(this.opts.getLogDir().getAbsolutePath() + File.separator + this.opts.getSessionId());
                    File resultsDir = new File(this.opts.getLogDir(), this.opts.getSessionId());
                    if (this.supportHtmlReport.booleanValue()) {
                        Map<Object, Object> testInputMap = new HashMap();
                        testInputMap = this.extractTestInputs(this.userInputs, this.opts);
                        if (!new File(resultsDir, "testng").exists() && null != testInputMap) {
                            try {
                                File testLog = new File(resultsDir, "report_logs.xml");
                                CtlEarlReporter report = new CtlEarlReporter();
                                if (null != this.opts.getSourcesName()) {
                                    report.generateEarlReport(resultsDir, testLog, this.opts.getSourcesName(), testInputMap);
                                }
                            }
                            catch (IOException iox) {
                                throw new RuntimeException("Failed to serialize EARL results to " + iox);
                            }
                        }
                    }
                }
            }
        }
    }

    public void reexecute_test(String testPath) throws Exception {
        block10: {
            File deleteExistingTestngDir;
            File deleteExistingResultDir = new File(this.opts.getLogDir() + File.separator + testPath + File.separator + "result");
            if (deleteExistingResultDir.exists()) {
                Misc.deleteDir(deleteExistingResultDir);
            }
            if ((deleteExistingTestngDir = new File(this.opts.getLogDir() + File.separator + testPath + File.separator + "testng")).exists()) {
                Misc.deleteDir(deleteExistingTestngDir);
            }
            Document log = LogUtils.readLog(this.opts.getLogDir(), testPath);
            String testId = LogUtils.getTestIdFromLog(log);
            TestEntry test = this.index.getTest(testId);
            DocumentBuilder builder = this.engine.getBuilder();
            XdmNode paramsNode = LogUtils.getParamsFromLog(builder, log);
            XdmNode contextNode = LogUtils.getContextFromLog(builder, log);
            XPathContext context = this.getXPathContext(test, this.opts.getSourcesName(), contextNode);
            this.setTestPath(testPath);
            this.executeTest(test, paramsNode, context);
            if (!testPath.equals(this.opts.getSessionId())) break block10;
            this.suiteLog = LogUtils.readLog(this.opts.getLogDir(), testPath);
            ArrayList<String> params = this.opts.getParams();
            ArrayList<String> profiles = this.opts.getProfiles();
            if (profiles.contains("*")) {
                for (String profile : this.index.getProfileKeys()) {
                    try {
                        this.execute_profile(profile, params, false);
                    }
                    catch (Exception e) {
                        jlogger.log(Level.WARNING, e.getMessage(), e.getCause());
                    }
                }
            } else {
                for (String profile : profiles) {
                    try {
                        this.execute_profile(profile, params, true);
                    }
                    catch (Exception e) {
                        jlogger.log(Level.WARNING, e.getMessage(), e.getCause());
                    }
                }
            }
        }
    }

    public int execute_test(String testName, List<String> params, XdmNode contextNode) throws Exception {
        TestEntry test;
        if (LOGR.isLoggable(Level.FINE)) {
            String logMsg = String.format("Preparing test %s for execution, using params:%n %s", testName, params);
            LOGR.fine(logMsg);
        }
        if ((test = this.index.getTest(testName)) == null) {
            throw new Exception("Error: Test " + testName + " not found.");
        }
        XdmNode paramsNode = this.engine.getBuilder().build(new StreamSource(new StringReader(this.getParamsXML(params))));
        if (contextNode == null && test.usesContext()) {
            String contextNodeXML = "<context><value>" + test.getContext() + "</value></context>";
            contextNode = this.engine.getBuilder().build(new StreamSource(new StringReader(contextNodeXML)));
        }
        XPathContext context = this.getXPathContext(test, this.opts.getSourcesName(), contextNode);
        return this.executeTest(test, paramsNode, context);
    }

    public void execute_suite(String suiteName, List<String> params) throws Exception {
        SuiteEntry suite = null;
        if (suiteName == null || suiteName.isEmpty()) {
            Iterator<String> it = this.index.getSuiteKeys().iterator();
            if (!it.hasNext()) {
                throw new Exception("Error: No suites in sources.");
            }
            suite = this.index.getSuite(it.next());
            if (it.hasNext()) {
                throw new Exception("Error: Suite name must be specified since there is more than one suite in sources.");
            }
        } else {
            suite = this.index.getSuite(suiteName);
            if (suite == null) {
                throw new Exception("Error: Suite " + suiteName + " not found.");
            }
        }
        this.defaultResultName = suite.getDefaultResult();
        this.defaultResult = this.defaultResultName.equals("BestPractice") ? 0 : 1;
        this.testStack.peek().setDefaultResult(this.defaultResult);
        this.testStack.peek().setResult(this.defaultResult);
        ArrayList<String> kvps = new ArrayList<String>(params);
        Document form = suite.getForm();
        if (form != null) {
            Document results = (Document)this.form(form, suite.getId());
            for (Element value : DomUtils.getElementsByTagName(results, "value")) {
                kvps.add(value.getAttribute("key") + "=" + value.getTextContent());
            }
        }
        String name = suite.getPrefix() + ":" + suite.getLocalName();
        this.out.println("Testing suite " + name + " in " + this.getMode() + " with defaultResult of " + this.defaultResultName + " ...");
        RecordTestResult recordTestResult = new RecordTestResult();
        if (this.opts.getLogDir() != null) {
            recordTestResult.recordingStartCheck(suite);
            recordTestResult.recordingStartClause(suite);
        }
        this.setIndentLevel(1);
        int result = this.execute_test(suite.getStartingTest().toString(), kvps, null);
        recordTestResult.detailTestPath();
        this.reTestCount = 0;
        this.out.print("Suite " + suite.getPrefix() + ":" + suite.getLocalName() + " ");
        if (result == 6 || result == 5) {
            this.out.println(MSG_FAIL);
        } else if (result == 4) {
            this.out.println(MSG_WARNING);
        } else if (result == 0) {
            this.out.println(MSG_BEST_PRACTICE);
        } else {
            this.out.println(MSG_PASS);
        }
        if (this.opts.getLogDir() != null) {
            recordTestResult.saveRecordingClause(suite, this.dirPath);
            recordTestResult.saveRecordingData(suite, this.dirPath);
        }
    }

    public void execute_profile(String profileName, List<String> params, boolean required) throws Exception {
        ProfileEntry profile = this.index.getProfile(profileName);
        if (profile == null) {
            throw new Exception("Error: Profile " + profileName + " not found.");
        }
        SuiteEntry suite = this.index.getSuite(profile.getBaseSuite());
        if (suite == null) {
            throw new Exception("Error: The base suite (" + profile.getBaseSuite().toString() + ") for the profile (" + profileName + ") not found.");
        }
        String sessionId = this.opts.getSessionId();
        Document log = LogUtils.readLog(this.opts.getLogDir(), sessionId);
        if (log == null) {
            this.execute_suite(suite.getId(), params);
            log = LogUtils.readLog(this.opts.getLogDir(), sessionId);
        }
        this.suiteLog = log;
        String testId = LogUtils.getTestIdFromLog(log);
        List<String> baseParams = LogUtils.getParamListFromLog(this.engine.getBuilder(), log);
        TestEntry test = this.index.getTest(testId);
        if (suite.getStartingTest().equals(test.getQName())) {
            ArrayList<String> kvps = new ArrayList<String>();
            kvps.addAll(baseParams);
            kvps.addAll(params);
            Document form = profile.getForm();
            if (form != null) {
                Document results = (Document)this.form(form, profile.getId());
                for (Element value : DomUtils.getElementsByTagName(results, "value")) {
                    kvps.add(value.getAttribute("key") + "=" + value.getTextContent());
                }
            }
            this.setTestPath(sessionId + "/" + profile.getLocalName());
            String name = profile.getPrefix() + ":" + profile.getLocalName();
            this.out.println("\nTesting profile " + name + "...");
            Document baseLog = LogUtils.makeTestList(this.opts.getLogDir(), sessionId, profile.getExcludes());
            Element baseTest = DomUtils.getElement(baseLog);
            this.out.print("   Base tests from suite " + suite.getPrefix() + ":" + suite.getLocalName() + " ");
            String summary = "Not complete";
            if ("yes".equals(baseTest.getAttribute("complete"))) {
                int baseResult = Integer.parseInt(baseTest.getAttribute("result"));
                summary = TECore.getResultDescription(baseResult);
            }
            this.out.println(summary);
            this.setIndentLevel(1);
            String defaultResultName = profile.getDefaultResult();
            this.defaultResult = defaultResultName.equals("BestPractice") ? 0 : 1;
            this.out.println("\nExecuting profile " + name + " with defaultResult of " + defaultResultName + "...");
            int result = this.execute_test(profile.getStartingTest().toString(), kvps, null);
            this.out.print("Profile " + profile.getPrefix() + ":" + profile.getLocalName() + " ");
            summary = TECore.getResultDescription(result);
            this.out.println(summary);
        } else if (required) {
            throw new Exception("Error: Profile " + profileName + " is not a valid profile for session " + sessionId + ".");
        }
    }

    public XdmNode executeTemplate(TemplateEntry template, XdmNode params, XPathContext context) throws Exception {
        if (this.stop) {
            throw new Exception("Execution was stopped by the user.");
        }
        XsltExecutable executable = this.engine.loadExecutable(template, this.opts.getSourcesName());
        XsltTransformer xt = executable.load();
        XdmDestination dest = new XdmDestination();
        xt.setDestination(dest);
        if (template.usesContext() && context != null) {
            xt.setSource((NodeInfo)context.getContextItem());
        } else {
            xt.setSource(new StreamSource(new StringReader("<nil/>")));
        }
        xt.setParameter(TECORE_QNAME, new ObjValue(this));
        if (params != null) {
            xt.setParameter(TEPARAMS_QNAME, params);
        }
        if (LOGR.isLoggable(Level.FINE)) {
            LOGR.log(Level.FINE, "Executing TemplateEntry {0}" + template.getQName());
        }
        xt.transform();
        XdmNode ret = dest.getXdmNode();
        if (ret != null && LOGR.isLoggable(Level.FINE)) {
            LOGR.log(Level.FINE, "Output:\n" + ret.toString());
        }
        return ret;
    }

    static String getLabel(XdmNode n) {
        Object label = n.getAttributeValue(LABEL_QNAME);
        if (label == null) {
            XdmNode value = (XdmNode)n.axisIterator(Axis.CHILD).next();
            XdmItem childItem = null;
            try {
                childItem = value.axisIterator(Axis.CHILD).next();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (childItem == null) {
                XdmSequenceIterator it = value.axisIterator(Axis.ATTRIBUTE);
                label = it.hasNext() ? it.next().getStringValue() : "";
            } else if (childItem.isAtomicValue()) {
                label = childItem.getStringValue();
            } else if (childItem instanceof XdmNode) {
                XdmNode n2 = (XdmNode)childItem;
                label = n2.getNodeKind() == XdmNodeKind.ELEMENT ? "<" + n2.getNodeName().toString() + ">" : n2.toString();
            }
        }
        return label;
    }

    String getAssertionValue(String text, XdmNode paramsVar) {
        if (text.indexOf("$") < 0) {
            return text;
        }
        String newText = text;
        XdmNode params = (XdmNode)paramsVar.axisIterator(Axis.CHILD).next();
        XdmSequenceIterator it = params.axisIterator(Axis.CHILD);
        while (it.hasNext()) {
            String tagname;
            XdmNode n = (XdmNode)it.next();
            net.sf.saxon.s9api.QName qname = n.getNodeName();
            if (qname == null || !(tagname = qname.getLocalName()).equals("param")) continue;
            String name = n.getAttributeValue(LOCALNAME_QNAME);
            String label = TECore.getLabel(n);
            newText = StringUtils.replaceAll(newText, "{$" + name + "}", label);
        }
        newText = StringUtils.replaceAll(newText, "{$context}", this.contextLabel);
        return newText;
    }

    static String getResultDescription(int result) {
        if (result == -1) {
            return MSG_CONTINUE;
        }
        if (result == 0) {
            return MSG_BEST_PRACTICE;
        }
        if (result == 1) {
            return MSG_PASS;
        }
        if (result == 2) {
            return MSG_NOT_TESTED;
        }
        if (result == 3) {
            return MSG_SKIPPED;
        }
        if (result == 4) {
            return MSG_WARNING;
        }
        if (result == 5) {
            return MSG_INHERITED_FAILURE;
        }
        return MSG_FAIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeTest(TestEntry test, XdmNode params, XPathContext context) throws Exception {
        String logDir;
        File[] tpath;
        this.testType = test.getType();
        if (this.testPath == null) {
            this.testPath = this.opts.getSessionId();
        }
        this.defaultResult = test.getDefaultResult();
        this.defaultResultName = this.defaultResult == 0 ? "BestPractice" : "Pass";
        Document oldPrevLog = this.prevLog;
        this.prevLog = this.opts.getMode() == 2 ? this.readLog() : (this.opts.getMode() == 3 ? this.readLog() : null);
        String assertion = this.getAssertionValue(test.getAssertion(), params);
        this.out.println("******************************************************************************************************************************");
        this.out.print(this.indent + "Testing ");
        this.out.print(test.getName() + " type " + test.getType());
        if (rootTestName != null && rootTestName.size() > 0) {
            for (int i = 0; i < rootTestName.size(); ++i) {
                if (!test.getName().contains(rootTestName.get(i))) continue;
                ++methodCount;
            }
        }
        this.out.print(" in " + this.getMode() + " with defaultResult " + this.defaultResultName + " ");
        String testName = test.getName() + " type " + test.getType();
        System.setProperty("TestName", testName);
        this.out.println("(" + this.testPath + ")...");
        if (this.opts.getLogDir() != null && (tpath = new TEPath(logDir = this.opts.getLogDir() + "/" + this.testPath.split("/")[0])).isValid() && "True".equals(System.getProperty("Record"))) {
            this.dirPath = new File(logDir + "/test_data");
            if (!this.dirPath.exists() && !this.dirPath.mkdir()) {
                System.out.println("Failed to create Error Log!");
            }
        }
        if (this.reTestCount == 0 && this.getMode().contains("Retest")) {
            if (null != this.dirPath) {
                if (this.dirPath.isDirectory()) {
                    File[] files = this.dirPath.listFiles();
                    if (files != null && files.length > 0) {
                        for (File aFile : files) {
                            aFile.delete();
                        }
                    }
                    this.dirPath.delete();
                } else {
                    this.dirPath.delete();
                }
            }
            this.reTestCount = 1;
        }
        String oldIndent = this.indent;
        this.indent = this.indent + INDENT;
        if (test.usesContext()) {
            this.out.println(this.indent + "Context: " + test.getContext());
        }
        this.out.println(this.indent + "Assertion: " + assertion);
        assertionMsz = assertion;
        PrintWriter oldLogger = this.logger;
        if (this.opts.getLogDir() != null) {
            this.logger = this.createLog();
            this.logger.println("<log mode=\"" + this.opts.getMode() + "\">");
            this.logger.print("<starttest ");
            this.logger.print("local-name=\"" + test.getLocalName() + "\" ");
            this.logger.print("prefix=\"" + test.getPrefix() + "\" ");
            this.logger.print("namespace-uri=\"" + test.getNamespaceURI() + "\" ");
            this.logger.print("type=\"" + test.getType() + "\" ");
            this.logger.print("defaultResult=\"" + test.getDefaultResult() + "\" ");
            this.logger.print("path=\"" + this.testPath + "\" ");
            this.logger.println("file=\"" + test.getTemplateFile().getAbsolutePath() + "\">");
            this.logger.println("<assertion>" + StringUtils.escapeXML(assertion) + "</assertion>");
            if (params != null) {
                this.logger.println(params.toString());
                pathURL = params.toString();
            }
            if (test.usesContext()) {
                this.logger.print("<context label=\"" + StringUtils.escapeXML(this.contextLabel) + "\">");
                this.logger.print("<value>");
                this.logger.print(test.getContext());
                this.logger.print("</value>");
                this.logger.println("</context>");
            }
            this.logger.println("</starttest>");
            this.logger.flush();
        }
        test.setResult(-1);
        RecordTestResult recordTestResult = new RecordTestResult();
        recordTestResult.storeStartTestDetail(test, this.dirPath);
        try {
            this.testStack.push(test);
            this.executeTemplate(test, params, context);
            if (test.getResult() == -1) {
                test.setResult(this.defaultResult);
            }
        }
        catch (SaxonApiException e) {
            jlogger.log(Level.SEVERE, e.getMessage());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
            Date date = new Date();
            try {
                String path = System.getProperty("PATH") + "/error_log";
                File file = new File(path);
                if (!file.exists() && !file.mkdir()) {
                    System.out.println("Failed to create Error Log!");
                }
                if (!(file = new File(path, "log.txt")).exists()) {
                    try {
                        boolean bl = file.createNewFile();
                    }
                    catch (IOException ioe) {
                        System.out.println("Error while creating empty file: " + ioe);
                    }
                }
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8);
                BufferedWriter fbw = new BufferedWriter(writer);
                fbw.write(dateFormat.format(date) + " ERROR");
                fbw.newLine();
                fbw.write("Test Name : " + System.getProperty("TestName"));
                fbw.newLine();
                fbw.write("Failed to execute the extension function: ");
                e.printStackTrace(new PrintWriter(fbw));
                fbw.newLine();
                fbw.close();
            }
            catch (IOException exep) {
                System.out.println("Error: " + e.getMessage());
            }
            if (this.logger != null) {
                this.logger.println("<exception><![CDATA[" + e.getMessage() + "]]></exception>");
            }
            test.setResult(6);
        }
        finally {
            this.updateParentTestResult(test);
            this.testStack.pop();
            if (this.logger != null) {
                this.logger.println("<endtest result=\"" + test.getResult() + "\"/>");
                if (test.isConformanceClass()) {
                    this.logger.println("<conformanceClass name=\"" + test.getLocalName() + "\" isBasic=\"" + test.isBasic() + "\" result=\"" + test.getResult() + "\" />");
                    this.supportHtmlReport = true;
                }
                this.logger.println("</log>");
                this.logger.flush();
                this.logger.close();
            }
            if (this.opts.getLogDir() != null && this.testPath != null) {
                String logDir2 = this.opts.getLogDir() + "/" + this.testPath;
                this.addMissingInfo(logDir2, test);
            }
        }
        if ("True".equals(System.getProperty("Record"))) {
            mainRootElement.appendChild(RecordTestResult.getMethod());
        }
        assertionMsz = "";
        pathURL = "";
        messageTest = "";
        this.logger = oldLogger;
        this.prevLog = oldPrevLog;
        this.indent = oldIndent;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        this.out.println(this.indent + "Test " + test.getName() + " " + TECore.getResultDescription(test.getResult()));
        recordTestResult.storeFinalTestDetail(test, dateFormat, cal, this.dirPath);
        if (LOGR.isLoggable(Level.FINE)) {
            String msg = String.format("Executed test %s - Verdict: %s", test.getLocalName(), TECore.getResultDescription(test.getResult()));
            LOGR.log(Level.FINE, msg);
        }
        return test.getResult();
    }

    public void addMissingInfo(String dir, TestEntry test) {
        String logdir = dir + File.separator + "log.xml";
        DocumentBuilderFactory dbf = null;
        javax.xml.parsers.DocumentBuilder docBuilder = null;
        Document doc = null;
        File logfile = new File(logdir);
        try {
            dbf = DocumentBuilderFactory.newInstance();
            docBuilder = dbf.newDocumentBuilder();
            docBuilder.setErrorHandler(null);
            doc = docBuilder.parse(logfile);
        }
        catch (Exception e) {
            try {
                FileWriter fw = new FileWriter(logdir, true);
                BufferedWriter bw = new BufferedWriter(fw);
                PrintWriter out = new PrintWriter(bw);
                out.println("</log>");
                out.close();
                bw.close();
                doc = docBuilder.parse(logfile);
            }
            catch (Exception ex) {
                throw new RuntimeException("Unable to update missing information in " + logdir);
            }
        }
        NodeList nl = doc.getElementsByTagName("endtest");
        if (nl.getLength() == 0) {
            Element root = doc.getDocumentElement();
            this.appendEndTestElement(test, doc, root);
            this.appendConformanceClassElement(test, doc, root);
        }
        try {
            DOMSource source = new DOMSource(doc);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(logfile);
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to update missing information in " + logdir);
        }
    }

    private void appendEndTestElement(TestEntry test, Document doc, Element root) {
        Element endtest = doc.createElement("endtest");
        Attr resultAttribute = doc.createAttribute("result");
        resultAttribute.setValue(Integer.toString(test.getResult()));
        endtest.setAttributeNode(resultAttribute);
        root.appendChild(endtest);
    }

    private void appendConformanceClassElement(TestEntry test, Document doc, Element root) {
        if (test.isConformanceClass()) {
            Element conformanceClass = doc.createElement("conformanceClass");
            Attr nameAttribute = doc.createAttribute("name");
            nameAttribute.setValue(test.getLocalName());
            Attr isBasicAttribute = doc.createAttribute("isBasic");
            isBasicAttribute.setValue(Boolean.toString(test.isBasic()));
            Attr resultAttribute = doc.createAttribute("result");
            resultAttribute.setValue(Integer.toString(test.getResult()));
            conformanceClass.setAttributeNode(nameAttribute);
            conformanceClass.setAttributeNode(isBasicAttribute);
            conformanceClass.setAttributeNode(resultAttribute);
            root.appendChild(conformanceClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void callTest(XPathContext context, String localName, String namespaceURI, NodeInfo params, String callId) throws Exception {
        String key = "{" + namespaceURI + "}" + localName;
        TestEntry test = this.index.getTest(key);
        if (this.logger != null) {
            this.logger.println("<testcall path=\"" + this.testPath + "/" + callId + "\"/>");
            this.logger.flush();
        }
        if (this.opts.getMode() == 2) {
            Document doc = LogUtils.readLog(this.opts.getLogDir(), this.testPath + "/" + callId);
            int result = LogUtils.getResultFromLog(doc);
            if (result == -1) {
                throw new IllegalStateException("Error: 'continue' is not allowed when a test is called using 'call-test' instruction");
            }
            this.out.println(this.indent + "Test " + test.getName() + " " + TECore.getResultDescription(result));
            test.setResult(result);
            this.updateParentTestResult(test);
            return;
        }
        String oldTestPath = this.testPath;
        this.testPath = this.testPath + "/" + callId;
        int result = -1;
        try {
            result = this.executeTest(test, S9APIUtils.makeNode(params), context);
        }
        catch (Exception exception) {
        }
        finally {
            this.testPath = oldTestPath;
        }
        if (result == -1) {
            throw new IllegalStateException("Error: 'continue' is not allowed when a test is called using 'call-test' instruction");
        }
    }

    private void updateParentTestResult(TestEntry currTest) {
        TestEntry parentTest = this.getParentTest();
        if (null == parentTest) {
            return;
        }
        if (LOGR.isLoggable(Level.FINE)) {
            LOGR.log(Level.FINE, "Entered setParentTestResult with TestEntry {0} (result={1})", new Object[]{currTest.getQName(), currTest.getResult()});
            LOGR.log(Level.FINE, "Parent TestEntry is {0} (result={1})", new Object[]{parentTest.getQName(), parentTest.getResult()});
        }
        switch (currTest.getResult()) {
            case 5: 
            case 6: {
                parentTest.setResult(5);
                break;
            }
            case 3: {
                if (!currTest.getType().equalsIgnoreCase("Mandatory")) break;
                parentTest.setResult(5);
                break;
            }
            default: {
                parentTest.setResult(Integer.max(currTest.getResult(), parentTest.getResult()));
            }
        }
    }

    public NodeInfo executeXSLFunction(XPathContext context, FunctionEntry fe, NodeInfo params) throws Exception {
        String oldFnPath = this.fnPath;
        CRC32 crc = new CRC32();
        crc.update((fe.getPrefix() + fe.getId()).getBytes());
        this.fnPath = this.fnPath + Long.toHexString(crc.getValue()) + "/";
        XdmNode n = this.executeTemplate(fe, S9APIUtils.makeNode(params), context);
        this.fnPath = oldFnPath;
        if (n == null) {
            return null;
        }
        return n.getUnderlyingNode();
    }

    public Object callFunction(XPathContext context, String localName, String namespaceURI, NodeInfo params) throws Exception {
        String key = "{" + namespaceURI + "}" + localName;
        List<FunctionEntry> functions = this.index.getFunctions(key);
        NodeOverNodeInfo paramsNode = NodeOverNodeInfo.wrap(params);
        List<Element> paramElements = DomUtils.getElementsByTagName(paramsNode, "param");
        for (FunctionEntry fe : functions) {
            if (fe.isJava()) continue;
            boolean valid = true;
            for (Element el : paramElements) {
                String uri = el.getAttribute("namespace-uri");
                String name = el.getAttribute("local-name");
                String prefix = el.getAttribute("prefix");
                QName qname = new QName(uri, name, prefix);
                if (fe.getParams().contains(qname)) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            if (this.opts.getMode() == 4) {
                if (this.fnCallStack.contains(key)) {
                    return null;
                }
                this.fnCallStack.add(key);
                NodeInfo result = this.executeXSLFunction(context, fe, params);
                this.fnCallStack.pop();
                return result;
            }
            return this.executeXSLFunction(context, fe, params);
        }
        if (this.opts.getMode() == 4) {
            return null;
        }
        for (FunctionEntry fe : functions) {
            if (!fe.isJava()) continue;
            int argCount = paramElements.size();
            if (fe.getMinArgs() < argCount || fe.getMaxArgs() > argCount) continue;
            TEClassLoader cl = this.engine.getClassLoader(this.opts.getSourcesName());
            Method method = Misc.getMethod(fe.getClassName(), fe.getMethod(), cl, argCount);
            Class<?>[] types = method.getParameterTypes();
            Object[] args = new Object[argCount];
            for (int i = 0; i < argCount; ++i) {
                Element el = DomUtils.getElementByTagName(paramElements.get(i), "value");
                if (types[i].equals(String.class)) {
                    Map<QName, String> attrs = DomUtils.getAttributes(el);
                    if (attrs.size() > 0) {
                        args[i] = attrs.values().iterator().next();
                        continue;
                    }
                    args[i] = el.getTextContent();
                    continue;
                }
                if (types[i].toString().equals("char")) {
                    args[i] = Character.valueOf(el.getTextContent().charAt(0));
                    continue;
                }
                if (types[i].toString().equals("boolean")) {
                    args[i] = Boolean.parseBoolean(el.getTextContent());
                    continue;
                }
                if (types[i].toString().equals("byte")) {
                    args[i] = Byte.parseByte(el.getTextContent());
                    continue;
                }
                if (types[i].toString().equals("short")) {
                    args[i] = Short.parseShort(el.getTextContent());
                    continue;
                }
                if (types[i].toString().equals("int")) {
                    args[i] = Integer.parseInt(el.getTextContent());
                    continue;
                }
                if (types[i].toString().equals("long")) {
                    args[i] = Long.parseLong(el.getTextContent());
                    continue;
                }
                if (types[i].toString().equals("float")) {
                    args[i] = Float.valueOf(Float.parseFloat(el.getTextContent()));
                    continue;
                }
                if (types[i].toString().equals("double")) {
                    args[i] = Double.parseDouble(el.getTextContent());
                    continue;
                }
                if (Document.class.isAssignableFrom(types[i])) {
                    args[i] = DomUtils.createDocument(DomUtils.getChildElement(el));
                    continue;
                }
                if (NodeList.class.isAssignableFrom(types[i])) {
                    args[i] = el.getChildNodes();
                    continue;
                }
                if (Node.class.isAssignableFrom(types[i])) {
                    args[i] = el.getFirstChild();
                    continue;
                }
                throw new Exception("Error: Function " + key + " uses unsupported Java type " + types[i].toString());
            }
            try {
                Object instance = null;
                if (fe.isInitialized() && (instance = this.getFunctionInstance(fe.hashCode())) == null) {
                    try {
                        instance = Misc.makeInstance(fe.getClassName(), fe.getClassParams(), cl);
                        this.putFunctionInstance(fe.hashCode(), instance);
                    }
                    catch (Exception e) {
                        throw new XPathException(e);
                    }
                }
                return method.invoke(instance, args);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                String msg = "Error invoking function " + fe.getId() + "\n" + cause.getClass().getName();
                if (cause.getMessage() != null) {
                    msg = msg + ": " + cause.getMessage();
                }
                jlogger.log(Level.SEVERE, "InvocationTargetException", e);
                throw new Exception(msg, cause);
            }
        }
        throw new Exception("No function {" + namespaceURI + "}" + localName + " with a compatible signature.");
    }

    public void _continue() {
        this.testStack.peek().setResult(-1);
    }

    public void bestPractice() {
        if (this.testStack.peek().getResult() < 0) {
            this.testStack.peek().setResult(0);
        }
    }

    public void notTested() {
        if (this.testStack.peek().getResult() < 2) {
            this.testStack.peek().setResult(2);
        }
    }

    public void skipped() {
        if (this.testStack.peek().getResult() < 3) {
            this.testStack.peek().setResult(3);
        }
    }

    public void pass() {
        if (this.testStack.peek().getResult() < 1) {
            this.testStack.peek().setResult(1);
        }
    }

    public void warning() {
        if (this.testStack.peek().getResult() < 4) {
            this.testStack.peek().setResult(4);
        }
    }

    public void inheritedFailure() {
        if (this.testStack.peek().getResult() < 5) {
            this.testStack.peek().setResult(5);
        }
    }

    public void fail() {
        this.testStack.peek().setResult(6);
    }

    public String getResult() {
        return TECore.getResultDescription(this.testStack.getLast().getResult());
    }

    public String getMode() {
        return Test.getModeName(this.opts.getMode());
    }

    public void setContextLabel(String label) {
        this.contextLabel = label;
    }

    public String getFormHtml() {
        return this.formHtml;
    }

    public void setFormHtml(String html) {
        this.formHtml = html;
    }

    public Document getFormResults() {
        return this.formResults;
    }

    public void setFormResults(Document doc) {
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            if (this.userInputs == null) {
                this.userInputs = doc;
            }
            LOGR.info("Setting form results:\n " + sw.toString());
        }
        catch (Exception e) {
            LOGR.log(Level.SEVERE, "Failed to log the form results", e);
        }
        this.formResults = doc;
    }

    public Map<String, Element> getFormParsers() {
        return this.formParsers;
    }

    public Document readLog() throws Exception {
        return LogUtils.readLog(this.opts.getLogDir(), this.testPath);
    }

    public PrintWriter createLog() throws Exception {
        return LogUtils.createLog(this.opts.getLogDir(), this.testPath);
    }

    public static File getFile(NodeList fileNodes) {
        File file = null;
        for (int i = 0; i < fileNodes.getLength(); ++i) {
            Element e = (Element)fileNodes.item(i);
            String type = e.getAttribute("type");
            try {
                if (type.equals("url")) {
                    URL url = new URL(e.getTextContent());
                    file = new File(url.toURI());
                    continue;
                }
                if (type.equals("file")) {
                    file = new File(e.getTextContent());
                    continue;
                }
                if (type.equals("resource")) {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    file = new File(cl.getResource(e.getTextContent()).getFile());
                    continue;
                }
                System.out.println("Incorrect file reference:  Unknown type!");
                continue;
            }
            catch (Exception exception) {
                System.err.println("Error getting file. " + exception.getMessage());
                jlogger.log(Level.SEVERE, "Error getting file. " + exception.getMessage(), e);
                return null;
            }
        }
        return file;
    }

    public NodeList soap_request(Document ctlRequest, String id) throws Throwable {
        Element request = (Element)ctlRequest.getElementsByTagNameNS(CTL_NS, "soap-request").item(0);
        if (this.opts.getMode() == 2 && this.prevLog != null) {
            for (Element request_e : DomUtils.getElementsByTagName(this.prevLog, "soap-request")) {
                if (!request_e.getAttribute("id").equals(this.fnPath + id)) continue;
                this.logger.println(DomUtils.serializeNode(request_e));
                this.logger.flush();
                Element response_e = DomUtils.getElementByTagName(request_e, "response");
                Element content_e = DomUtils.getElementByTagName(response_e, "content");
                return content_e.getChildNodes();
            }
        }
        String logTag = "<soap-request id=\"" + this.fnPath + id + "\">\n";
        logTag = logTag + DomUtils.serializeNode(request) + "\n";
        Exception ex = null;
        Element response = null;
        Element parserInstruction = null;
        NodeList nl = request.getChildNodes();
        long elapsedTime = 0L;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || n.getNamespaceURI().equals(CTL_NS)) continue;
            parserInstruction = (Element)n;
        }
        try {
            Date before = new Date();
            URLConnection uc = TECore.build_soap_request(request);
            response = this.parse(uc, parserInstruction);
            Date after = new Date();
            elapsedTime = after.getTime() - before.getTime();
            Element content = DomUtils.getElementByTagName(response, "content");
            if (content != null) {
                nl = content.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node n = nl.item(i);
                    if (n.getNodeType() != 1) continue;
                    Document doc = response.getOwnerDocument();
                    Comment comm = doc.createComment("Response received in [" + elapsedTime + "] milliseconds");
                    n.appendChild(comm);
                }
            }
            logTag = logTag + DomUtils.serializeNode(response) + "\n";
            jlogger.log(Level.FINE, DomUtils.serializeNode(response));
        }
        catch (Exception e) {
            ex = e;
        }
        logTag = logTag + "<!-- elapsed time :" + elapsedTime + " (milliseconds) -->";
        logTag = logTag + "</soap-request>";
        if (this.logger != null) {
            this.logger.println(logTag);
            this.logger.flush();
        }
        if (ex == null) {
            String text;
            Element parser = DomUtils.getElementByTagName(response, "parser");
            if (parser != null && (text = parser.getTextContent()).length() > 0) {
                this.out.println(parser.getTextContent());
            }
            Element content = DomUtils.getElementByTagName(response, "content");
            return content.getChildNodes();
        }
        throw ex;
    }

    public static URLConnection build_soap_request(Node xml) throws Exception {
        String sUrl = null;
        String method = "POST";
        String charset = ((Element)xml).getAttribute("charset").isEmpty() ? ((Element)xml).getAttribute("charset") : "UTF-8";
        String version = ((Element)xml).getAttribute("version");
        String action = "";
        Object contentType = "";
        Element body = null;
        NodeList nl = xml.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            if (n.getLocalName().equals("url")) {
                sUrl = n.getTextContent();
                continue;
            }
            if (n.getLocalName().equals("action")) {
                action = n.getTextContent();
                continue;
            }
            if (!n.getLocalName().equals("body")) continue;
            body = (Element)n;
        }
        List<Element> headerBloks = DomUtils.getElementsByTagNameNS(xml, CTL_NS, HEADER_BLOCKS);
        URLConnection uc = new URL(sUrl).openConnection();
        if (uc instanceof HttpURLConnection) {
            ((HttpURLConnection)uc).setRequestMethod(method);
        }
        uc.setDoOutput(true);
        byte[] bytes = null;
        bytes = SoapUtils.getSoapMessageAsByte(version, headerBloks, body, charset);
        uc.setRequestProperty("User-Agent", "Team Engine 1.2");
        uc.setRequestProperty("Cache-Control", "no-cache");
        uc.setRequestProperty("Pragma", "no-cache");
        uc.setRequestProperty("charset", charset);
        uc.setRequestProperty("Content-Length", Integer.toString(bytes.length));
        if (version.equals(SOAP_V_1_1)) {
            uc.setRequestProperty("Accept", "text/xml");
            uc.setRequestProperty("SOAPAction", action);
            contentType = "text/xml";
            if (!charset.isEmpty()) {
                contentType = (String)contentType + "; charset=" + charset;
            }
            uc.setRequestProperty("Content-Type", (String)contentType);
        } else {
            uc.setRequestProperty("Accept", "application/soap+xml");
            contentType = "application/soap+xml";
            if (!charset.isEmpty()) {
                contentType = (String)contentType + "; charset=" + charset;
            }
            if (!action.isEmpty()) {
                contentType = (String)contentType + "; action=" + action;
            }
            uc.setRequestProperty("Content-Type", (String)contentType);
        }
        OutputStream os = uc.getOutputStream();
        os.write(bytes);
        return uc;
    }

    public NodeList request(Document ctlRequest, String id) throws Throwable {
        Element request = (Element)ctlRequest.getElementsByTagNameNS(CTL_NS, "request").item(0);
        if (this.opts.getMode() == 2 && this.prevLog != null) {
            for (Element request_e : DomUtils.getElementsByTagName(this.prevLog, "request")) {
                if (!request_e.getAttribute("id").equals(this.fnPath + id)) continue;
                this.logger.println(DomUtils.serializeNode(request_e));
                this.logger.flush();
                Element response_e = DomUtils.getElementByTagName(request_e, "response");
                Element content_e = DomUtils.getElementByTagName(response_e, "content");
                return content_e.getChildNodes();
            }
        }
        String logTag = "<request id=\"" + this.fnPath + id + "\">\n";
        logTag = logTag + DomUtils.serializeNode(request) + "\n";
        long elapsedTime = 0L;
        Exception ex = null;
        Element response = null;
        Element parserInstruction = null;
        NodeList nl = request.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || n.getNamespaceURI().equals(CTL_NS)) continue;
            parserInstruction = (Element)n;
        }
        try {
            Date before = new Date();
            URLConnection uc = this.build_request(request);
            response = this.parse(uc, parserInstruction);
            Date after = new Date();
            elapsedTime = after.getTime() - before.getTime();
            Element content = DomUtils.getElementByTagName(response, "content");
            if (content != null) {
                nl = content.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node n = nl.item(i);
                    if (n.getNodeType() != 1) continue;
                    Document doc = response.getOwnerDocument();
                    Comment comm = doc.createComment("Response received in [" + elapsedTime + "] milliseconds");
                    n.appendChild(comm);
                }
            }
            logTag = logTag + DomUtils.serializeNode(response) + "\n";
        }
        catch (Exception e) {
            ex = e;
        }
        logTag = logTag + "</request>";
        if (this.logger != null) {
            this.logger.println(logTag);
            this.logger.flush();
        }
        if (ex == null) {
            String text;
            Element parser = DomUtils.getElementByTagName(response, "parser");
            if (parser != null && (text = parser.getTextContent()).length() > 0) {
                this.out.println(parser.getTextContent());
            }
            Element content = DomUtils.getElementByTagName(response, "content");
            return content.getChildNodes();
        }
        throw ex;
    }

    public URLConnection build_request(Node xml) throws Exception {
        Node body = null;
        ArrayList<String[]> headers = new ArrayList<String[]>();
        ArrayList<Node> parts = new ArrayList<Node>();
        Object sUrl = null;
        Object sParams = "";
        String method = "GET";
        String charset = "UTF-8";
        boolean multipart = false;
        NodeList nl = xml.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            if (n.getLocalName().equals("url")) {
                sUrl = n.getTextContent();
                continue;
            }
            if (n.getLocalName().equals("method")) {
                method = n.getTextContent().toUpperCase();
                continue;
            }
            if (n.getLocalName().equals("header")) {
                headers.add(new String[]{((Element)n).getAttribute("name"), n.getTextContent()});
                continue;
            }
            if (n.getLocalName().equals("param")) {
                if (((String)sParams).length() > 0) {
                    sParams = (String)sParams + "&";
                }
                sParams = (String)sParams + ((Element)n).getAttribute("name") + "=" + n.getTextContent();
                continue;
            }
            if (n.getLocalName().equals("dynamicParam")) {
                String name = null;
                String val = null;
                NodeList dpnl = n.getChildNodes();
                for (int j = 0; j < dpnl.getLength(); ++j) {
                    Node dpn = dpnl.item(j);
                    if (dpn.getNodeType() != 1) continue;
                    if (dpn.getLocalName().equals("name")) {
                        name = dpn.getTextContent();
                        continue;
                    }
                    if (!dpn.getLocalName().equals("value")) continue;
                    val = dpn.getTextContent();
                }
                if (name == null || val == null) continue;
                if (((String)sParams).length() > 0) {
                    sParams = (String)sParams + "&";
                }
                sParams = (String)sParams + name + "=" + val;
                continue;
            }
            if (n.getLocalName().equals("body")) {
                body = n;
                continue;
            }
            if (!n.getLocalName().equals("part")) continue;
            parts.add(n);
        }
        if (method.equals("GET") && ((String)sParams).length() > 0 && sUrl != null) {
            if (((String)sUrl).indexOf("?") == -1) {
                sUrl = (String)sUrl + "?";
            } else if (!((String)sUrl).endsWith("?") && !((String)sUrl).endsWith("&")) {
                sUrl = (String)sUrl + "&";
            }
            sUrl = (String)sUrl + (String)sParams;
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer t2 = tf.newTransformer();
        URLConnection uc = new URL((String)sUrl).openConnection();
        if (uc instanceof HttpURLConnection) {
            HttpURLConnection httpUc = (HttpURLConnection)uc;
            httpUc.setRequestMethod(method);
            boolean redirect = this.checkForRedirect(httpUc);
            if (redirect) {
                String redirectURL = httpUc.getHeaderField("Location");
                uc = new URL(redirectURL).openConnection();
                if (uc instanceof HttpURLConnection) {
                    ((HttpURLConnection)uc).setRequestMethod(method);
                }
            } else {
                uc = new URL((String)sUrl).openConnection();
            }
        }
        if (method.equals("POST") || method.equals("PUT")) {
            String mid;
            uc.setDoOutput(true);
            byte[] bytes = null;
            Object mime = null;
            if (body == null) {
                bytes = ((String)sParams).getBytes();
                mime = "application/x-www-form-urlencoded";
            } else {
                String bodyContent = "";
                NodeList children = body.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    if (children.item(i).getNodeType() != 1) continue;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    t2.transform(new DOMSource(children.item(i)), new StreamResult(baos));
                    bodyContent = baos.toString();
                    bytes = baos.toByteArray();
                    if (mime != null) break;
                    mime = "application/xml; charset=" + charset;
                    break;
                }
                if (bytes == null) {
                    bytes = body.getTextContent().getBytes();
                    mime = "text/plain";
                }
                if (parts.size() > 0) {
                    String prefix = "--";
                    String boundary = "7bdc3bba-e2c9-11db-8314-0800200c9a66";
                    String newline = "\r\n";
                    multipart = true;
                    ByteArrayOutputStream contentBytes = new ByteArrayOutputStream();
                    String bodyPart = prefix + boundary + newline;
                    bodyPart = bodyPart + "Content-Type: " + (String)mime + newline + newline;
                    bodyPart = bodyPart + bodyContent;
                    TECore.writeBytes(contentBytes, bodyPart.getBytes(charset));
                    for (int i = 0; i < parts.size(); ++i) {
                        Object contentType;
                        Element currentPart = (Element)parts.get(i);
                        String cid = currentPart.getAttribute("cid");
                        if (cid.indexOf("cid:") != -1) {
                            cid = cid.substring(cid.indexOf("cid:") + "cid:".length());
                        }
                        if (((String)(contentType = currentPart.getAttribute("content-type"))).equals("application/xml")) {
                            contentType = "application/xml; charset=" + charset;
                        }
                        if (contentType == null || ((String)contentType).isEmpty()) {
                            contentType = "application/octet-stream";
                        }
                        String partHeaders = newline + prefix + boundary + newline;
                        partHeaders = partHeaders + "Content-Type: " + (String)contentType + newline;
                        partHeaders = partHeaders + "Content-ID: <" + cid + ">" + newline + newline;
                        TECore.writeBytes(contentBytes, partHeaders.getBytes(charset));
                        NodeList files = currentPart.getElementsByTagNameNS(CTL_NS, "file");
                        if (files.getLength() > 0) {
                            File contentFile = TECore.getFile(files);
                            FileInputStream is = new FileInputStream(contentFile);
                            long length = contentFile.length();
                            byte[] fileBytes = new byte[(int)length];
                            int numRead = 0;
                            for (int offset = 0; offset < fileBytes.length && (numRead = ((InputStream)is).read(fileBytes, offset, fileBytes.length - offset)) >= 0; offset += numRead) {
                            }
                            ((InputStream)is).close();
                            TECore.writeBytes(contentBytes, fileBytes);
                            continue;
                        }
                        if (currentPart.getFirstChild() instanceof Text) {
                            TECore.writeBytes(contentBytes, currentPart.getTextContent().getBytes(charset));
                            continue;
                        }
                        TECore.writeBytes(contentBytes, DomUtils.serializeNode(currentPart.getFirstChild()).getBytes(charset));
                    }
                    String endingBoundary = newline + prefix + boundary + prefix + newline;
                    TECore.writeBytes(contentBytes, endingBoundary.getBytes(charset));
                    bytes = contentBytes.toByteArray();
                    mime = "multipart/related; type=\"" + (String)mime + "\"; boundary=\"" + boundary + "\"";
                }
            }
            if (body != null && (mid = ((Element)body).getAttribute("mid")) != null && !mid.isEmpty()) {
                if (mid.indexOf("mid:") != -1) {
                    mid = mid.substring(mid.indexOf("mid:") + "mid:".length());
                }
                uc.setRequestProperty("Message-ID", "<" + mid + ">");
            }
            uc.setRequestProperty("Content-Type", (String)mime);
            uc.setRequestProperty("Content-Length", Integer.toString(bytes.length));
            for (int i = 0; i < headers.size(); ++i) {
                String[] header = (String[])headers.get(i);
                if (multipart && header[0].toLowerCase().equals("content-type")) continue;
                uc.setRequestProperty(header[0], header[1]);
            }
            OutputStream os = uc.getOutputStream();
            os.write(bytes);
        } else {
            for (int i = 0; i < headers.size(); ++i) {
                String[] header = (String[])headers.get(i);
                uc.setRequestProperty(header[0], header[1]);
            }
        }
        return uc;
    }

    public static void writeBytes(ByteArrayOutputStream baos, byte[] bytes) {
        baos.write(bytes, 0, bytes.length);
    }

    public Element parse(Document parse_instruction, String xsl_version) throws Throwable {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setExpandEntityReferences(false);
        javax.xml.parsers.DocumentBuilder db = dbf.newDocumentBuilder();
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer t2 = null;
        Node content = null;
        Document parser_instruction = null;
        Element parse_element = (Element)parse_instruction.getElementsByTagNameNS(CTL_NS, "parse").item(0);
        NodeList children = parse_element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element e = (Element)children.item(i);
            if (e.getNamespaceURI().equals(XSL_NS) && e.getLocalName().equals("output")) {
                Document doc = db.newDocument();
                Element transform = doc.createElementNS(XSL_NS, "transform");
                transform.setAttribute("version", xsl_version);
                doc.appendChild(transform);
                Element output = doc.createElementNS(XSL_NS, "output");
                NamedNodeMap atts = e.getAttributes();
                for (int j = 0; j < atts.getLength(); ++j) {
                    Attr a = (Attr)atts.item(i);
                    output.setAttribute(a.getName(), a.getValue());
                }
                transform.appendChild(output);
                Element template = doc.createElementNS(XSL_NS, "template");
                template.setAttribute("match", "node()|@*");
                transform.appendChild(template);
                Element copy = doc.createElementNS(XSL_NS, "copy");
                template.appendChild(copy);
                Element apply = doc.createElementNS(XSL_NS, "apply-templates");
                apply.setAttribute("select", "node()|@*");
                copy.appendChild(apply);
                t2 = tf.newTransformer(new DOMSource(doc));
                continue;
            }
            if (e.getLocalName().equals("content")) {
                NodeList children2 = e.getChildNodes();
                for (int j = 0; j < children2.getLength(); ++j) {
                    if (children2.item(j).getNodeType() != 1) continue;
                    content = children2.item(j);
                }
                if (content != null) continue;
                content = children2.item(0);
                continue;
            }
            parser_instruction = db.newDocument();
            tf.newTransformer().transform(new DOMSource(e), new DOMResult(parser_instruction));
        }
        if (t2 == null) {
            t2 = tf.newTransformer();
        }
        File temp = File.createTempFile("$te_", ".xml");
        if (content != null && content.getNodeType() == 3) {
            RandomAccessFile raf = new RandomAccessFile(temp, "rw");
            raf.writeBytes(((Text)content).getTextContent());
            raf.close();
        } else {
            t2.transform(new DOMSource(content), new StreamResult(temp));
        }
        URLConnection uc = temp.toURI().toURL().openConnection();
        Element result = this.parse(uc, parser_instruction);
        temp.delete();
        return result;
    }

    public Element parse(URLConnection uc, Node instruction) throws Throwable {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setExpandEntityReferences(false);
        javax.xml.parsers.DocumentBuilder db = dbf.newDocumentBuilder();
        Document response_doc = db.newDocument();
        return this.parse(uc, instruction, response_doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element parse(URLConnection uc, Node instruction, Document response_doc) throws Exception {
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer idt = tf.newTransformer();
        Element parser_e = response_doc.createElement("parser");
        Element response_e = response_doc.createElement("response");
        Element content_e = response_doc.createElement("content");
        if (instruction == null) {
            InputStream is = null;
            uc.connect();
            String contentType = uc.getContentType();
            try {
                is = URLConnectionUtils.getInputStream(uc);
                if (contentType != null && contentType.contains("xml")) {
                    idt.transform(new StreamSource(is), new DOMResult(content_e));
                }
                content_e.setTextContent(IOUtils.inputStreamToString(is));
            }
            finally {
                if (null != is) {
                    is.close();
                }
            }
        } else {
            Object return_object;
            Method method;
            Element instruction_e = instruction instanceof Element ? (Element)instruction : ((Document)instruction).getDocumentElement();
            String key = "{" + instruction_e.getNamespaceURI() + "}" + instruction_e.getLocalName();
            ParserEntry pe = this.index.getParser(key);
            Object instance = null;
            if (pe.isInitialized() && (instance = this.parserInstances.get(key)) == null) {
                try {
                    TEClassLoader cl = this.engine.getClassLoader(this.opts.getSourcesName());
                    instance = Misc.makeInstance(pe.getClassName(), pe.getClassParams(), cl);
                }
                catch (Exception e) {
                    throw new Exception("Can't instantiate parser " + pe.getName(), e);
                }
                this.parserInstances.put(key, instance);
            }
            if ((method = this.parserMethods.get(key)) == null) {
                TEClassLoader cl = this.engine.getClassLoader(this.opts.getSourcesName());
                method = Misc.getMethod(pe.getClassName(), pe.getMethod(), cl, 3, 4);
                this.parserMethods.put(key, method);
            }
            StringWriter swLogger = new StringWriter();
            PrintWriter pwLogger = new PrintWriter(swLogger);
            int arg_count = method.getParameterTypes().length;
            Object[] args = new Object[arg_count];
            args[0] = uc;
            args[1] = instruction_e;
            args[2] = pwLogger;
            if (arg_count > 3) {
                args[3] = this;
            }
            try {
                if (LOGR.isLoggable(Level.FINER)) {
                    LOGR.finer("Invoking method " + method.toGenericString() + "size args[] = " + args.length + "\n args[0]: " + args[0].toString() + "\n args[1]:\n" + DomUtils.serializeNode((Node)args[1]));
                }
                return_object = method.invoke(instance, args);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                String msg = "Error invoking parser " + pe.getId() + "\n" + cause.getClass().getName();
                if (cause.getMessage() != null) {
                    msg = msg + ": " + cause.getMessage();
                }
                jlogger.log(Level.SEVERE, msg, e);
                throw new RuntimeException("Parser " + pe.getId() + " threw an exception.", cause);
            }
            pwLogger.close();
            if (return_object instanceof Node) {
                idt.transform(new DOMSource((Node)return_object), new DOMResult(content_e));
            } else if (return_object != null) {
                content_e.appendChild(response_doc.createTextNode(return_object.toString()));
            }
            parser_e.setAttribute("prefix", instruction_e.getPrefix());
            parser_e.setAttribute("local-name", instruction_e.getLocalName());
            parser_e.setAttribute("namespace-uri", instruction_e.getNamespaceURI());
            parser_e.setTextContent(swLogger.toString());
        }
        response_e.appendChild(parser_e);
        response_e.appendChild(content_e);
        return response_e;
    }

    public Node message(String message, String id) {
        String formatted_message = this.indent + message.trim().replaceAll("\n", "\n" + this.indent);
        String messageTrim = message.trim().replaceAll("\n", "\n" + this.indent);
        if (!(messageTrim.contains("Clause") || messageTrim.contains("Purpose") || messageTrim.contains("TestName"))) {
            this.out.println(formatted_message);
            messageTest = message;
        } else {
            if (messageTrim.contains("TestName")) {
                TESTNAME = messageTrim.replace("TestName : ", "");
                if (rootTestName != null && rootTestName.size() > 0) {
                    for (int i = 0; i < rootTestName.size(); ++i) {
                        if (!messageTrim.contains(rootTestName.get(i))) continue;
                        rootNo = i + 1;
                    }
                }
            } else if (messageTrim.contains("Clause")) {
                Clause = messageTrim.replace("Clause : ", "");
            } else {
                Purpose = messageTrim.replace("Purpose : ", "");
            }
            if (rootNo != 0 && !"".equals(Clause) && !"".equals(Purpose)) {
                mainRootElementClause.appendChild(RecordTestResult.getClause());
                Clause = "";
                Purpose = "";
                rootNo = 0;
            }
        }
        if (this.logger != null) {
            this.logger.println("<message id=\"" + id + "\"><![CDATA[" + message + "]]></message>");
        }
        return null;
    }

    public void putLogCache(String id, Document xmlToCache) {
        if (this.logger != null) {
            String xmlString = DomUtils.serializeNode(xmlToCache);
            this.logger.println("<cache id=\"" + id + "\">" + xmlString + "</cache>");
        }
    }

    public Element getLogCache(String id) {
        Element child_e = null;
        if (this.prevLog != null) {
            for (Element cache_e : DomUtils.getElementsByTagName(this.prevLog, "cache")) {
                if (!cache_e.getAttribute("id").equals(id)) continue;
                child_e = DomUtils.getChildElement(cache_e);
            }
        }
        if (this.suiteLog != null && child_e == null) {
            for (Element cache_e : DomUtils.getElementsByTagName(this.suiteLog, "cache")) {
                if (!cache_e.getAttribute("id").equals(id)) continue;
                child_e = DomUtils.getChildElement(cache_e);
            }
        }
        return child_e;
    }

    public Node form(Document ctlForm, String id) throws Exception {
        if (this.opts.getMode() == 2 && this.prevLog != null) {
            for (Element e : DomUtils.getElementsByTagName(this.prevLog, "formresults")) {
                if (!e.getAttribute("id").equals(this.fnPath + id)) continue;
                this.logger.println(DomUtils.serializeNode(e));
                this.logger.flush();
                return DomUtils.getChildElement(e);
            }
        }
        String name = Thread.currentThread().getName();
        Element form = (Element)ctlForm.getElementsByTagNameNS(CTL_NS, "form").item(0);
        NamedNodeMap attrs = form.getAttributes();
        Attr attr = (Attr)attrs.getNamedItem("name");
        if (attr != null) {
            name = attr.getValue();
        }
        for (Element parseInstruction : DomUtils.getElementsByTagNameNS(form, CTL_NS, "parse")) {
            String key = parseInstruction.getAttribute("file");
            this.formParsers.put(key, DomUtils.getChildElement(parseInstruction));
        }
        boolean hasFiles = false;
        List<Element> inputs = DomUtils.getElementsByTagName(form, "input");
        inputs.addAll(DomUtils.getElementsByTagNameNS(form, "http://www.w3.org/1999/xhtml", "input"));
        for (Element input : inputs) {
            if (!input.getAttribute("type").toLowerCase().equals("file")) continue;
            hasFiles = true;
            break;
        }
        attr = (Attr)attrs.getNamedItem("method");
        String method = "get";
        if (attr != null) {
            method = attr.getValue().toLowerCase();
        } else if (hasFiles) {
            method = "post";
        }
        this.imageHandler.saveImages(form);
        XsltTransformer formTransformer = this.engine.getFormExecutable().load();
        formTransformer.setSource(new DOMSource(ctlForm));
        formTransformer.setParameter(new net.sf.saxon.s9api.QName("title"), new XdmAtomicValue(name));
        formTransformer.setParameter(new net.sf.saxon.s9api.QName("web"), new XdmAtomicValue(this.web ? "yes" : "no"));
        formTransformer.setParameter(new net.sf.saxon.s9api.QName("files"), new XdmAtomicValue(hasFiles ? "yes" : "no"));
        formTransformer.setParameter(new net.sf.saxon.s9api.QName("thread"), new XdmAtomicValue(Long.toString(Thread.currentThread().getId())));
        formTransformer.setParameter(new net.sf.saxon.s9api.QName("method"), new XdmAtomicValue(method));
        formTransformer.setParameter(new net.sf.saxon.s9api.QName("base"), new XdmAtomicValue(this.opts.getBaseURI()));
        formTransformer.setParameter(new net.sf.saxon.s9api.QName("action"), new XdmAtomicValue(this.getTestServletURL()));
        StringWriter sw = new StringWriter();
        Serializer serializer = new Serializer();
        serializer.setOutputWriter(sw);
        serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        formTransformer.setDestination(serializer);
        formTransformer.transform();
        this.formHtml = sw.toString();
        if (LOGR.isLoggable(Level.FINE)) {
            LOGR.fine(this.formHtml);
        }
        if (!this.recordedForms.isEmpty()) {
            RecordedForm.create(this.recordedForms.next(), this);
        } else if (!this.web) {
            int width = 700;
            int height = 500;
            attr = (Attr)attrs.getNamedItem("width");
            if (attr != null) {
                width = Integer.parseInt(attr.getValue());
            }
            if ((attr = (Attr)attrs.getNamedItem("height")) != null) {
                height = Integer.parseInt(attr.getValue());
            }
            SwingForm.create(name, width, height, this);
        }
        while (this.formResults == null) {
            if (this.stop) {
                this.formParsers.clear();
                throw new Exception("Execution was stopped by the user.");
            }
            Thread.sleep(250L);
        }
        Document doc = this.formResults;
        if (LOGR.isLoggable(Level.FINE)) {
            LOGR.fine(DomUtils.serializeNode(doc));
        }
        this.formResults = null;
        this.formParsers.clear();
        if (this.logger != null) {
            this.logger.println("<formresults id=\"" + this.fnPath + id + "\">");
            this.logger.println(DomUtils.serializeNode(doc));
            this.logger.println("</formresults>");
        }
        return doc;
    }

    public void setIndentLevel(int level) {
        this.indent = "";
        for (int i = 0; i < level; ++i) {
            this.indent = this.indent + INDENT;
        }
    }

    public String getOutput() {
        String output = this.threadOutput.toString();
        this.threadOutput.reset();
        return output;
    }

    public void stopThread() throws Exception {
        this.stop = true;
        while (!this.threadComplete) {
            Thread.sleep(100L);
        }
    }

    public boolean isThreadComplete() {
        return this.threadComplete;
    }

    @Override
    public void run() {
        this.threadComplete = false;
        try {
            this.opts.getLogDir().mkdir();
            this.threadOutput = new ByteArrayOutputStream();
            this.out = new PrintStream(this.threadOutput);
            this.execute();
            this.out.close();
        }
        catch (Exception e) {
            jlogger.log(Level.SEVERE, "", e);
        }
        this.threadComplete = true;
    }

    public File getLogDir() {
        return this.opts.getLogDir();
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    public String getTestPath() {
        return this.testPath;
    }

    public String getTestRunDirectory() {
        String logDirURI = this.opts.getLogDir().toURI().toString();
        return logDirURI + this.opts.getSessionId();
    }

    private void setTestPath(String testPath) {
        this.testPath = testPath;
    }

    public boolean isWeb() {
        return this.web;
    }

    public void setWeb(boolean web) {
        this.web = web;
    }

    public Object getFunctionInstance(Integer key) {
        return this.functionInstances.get(key);
    }

    public Object putFunctionInstance(Integer key, Object instance) {
        return this.functionInstances.put(key, instance);
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Index getIndex() {
        return this.index;
    }

    public RuntimeOptions getOpts() {
        return this.opts;
    }

    public String getTestServletURL() {
        return this.testServletURL;
    }

    public void setTestServletURL(String testServletURL) {
        this.testServletURL = testServletURL;
    }

    public boolean earlHtmlReport(String outputDir) {
        TEPath tpath = new TEPath(outputDir);
        if (!tpath.isValid()) {
            System.out.println("ViewLog Error: Invalid log file name " + outputDir);
            return false;
        }
        EarlToHtmlTransformation earlToHtml = new EarlToHtmlTransformation();
        earlToHtml.earlHtmlReport(outputDir);
        return true;
    }

    private Map<String, String> extractTestInputs(Document userInput, RuntimeOptions runOpts) {
        Map<String, String> inputMap;
        block5: {
            block4: {
                inputMap = new HashMap<String, String>();
                if (null == this.userInputs) break block4;
                NodeList values = this.userInputs.getDocumentElement().getElementsByTagName("value");
                if (values.getLength() == 0) {
                    inputMap = Collections.emptyMap();
                } else {
                    for (int i = 0; i < values.getLength(); ++i) {
                        Element value = (Element)values.item(i);
                        inputMap.put(value.getAttribute("key"), value.getTextContent());
                    }
                }
                break block5;
            }
            if (null == this.opts.getParams()) break block5;
            ArrayList<String> runParams = this.opts.getParams();
            for (String param : runParams) {
                String[] kvp = param.split("=");
                inputMap.put(kvp[0], kvp[1]);
            }
        }
        return inputMap;
    }

    private boolean checkForRedirect(HttpURLConnection conn) throws IOException {
        int status = conn.getResponseCode();
        return status != 200 && (status == 302 || status == 301 || status == 303);
    }

    public Document findXMLResource(String name) {
        URL url = this.getClass().getResource(name);
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        docFactory.setExpandEntityReferences(false);
        Document doc = null;
        try {
            javax.xml.parsers.DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            doc = docBuilder.parse(url.toURI().toString());
        }
        catch (Exception e) {
            LOGR.log(Level.WARNING, "Failed to parse classpath resource " + name, e);
        }
        return doc;
    }

    static {
        TESTNAME = "";
        rootNo = 0;
        Clause = "";
        Purpose = "";
        rootTestName = new ArrayList();
    }
}

