/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.parsers;

import com.occamlab.te.ErrorHandlerImpl;
import com.occamlab.te.util.DomUtils;
import com.occamlab.te.util.Misc;
import com.occamlab.te.util.SoapUtils;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;

public class SoapParser {
    public static final String SOAP_11_NAMESPACE = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String SOAP_12_NAMESPACE = "http://www.w3.org/2003/05/soap-envelope";

    public Document parse(URLConnection uc, Element instruction, PrintWriter logger) throws Exception {
        HttpURLConnection huc = (HttpURLConnection)uc;
        int responsecode = huc.getResponseCode();
        InputStream soapMessage = null;
        if (responsecode == 200) {
            soapMessage = huc.getInputStream();
        } else if (responsecode == 202) {
            soapMessage = huc.getInputStream();
        } else if (responsecode == 301 || responsecode == 302 || responsecode == 307) {
            soapMessage = huc.getErrorStream();
        } else if (responsecode == 303) {
            soapMessage = huc.getErrorStream();
        } else if (responsecode >= 400) {
            soapMessage = huc.getErrorStream();
        }
        return this.parse(soapMessage, instruction, logger);
    }

    private Document parse(Object xml, Element instruction, PrintWriter logger) throws Exception {
        Document soapMessage = null;
        String returnType = instruction.getAttribute("return");
        ErrorHandlerImpl eh = new ErrorHandlerImpl("Parsing", logger);
        if (xml instanceof InputStream) {
            soapMessage = SoapUtils.getSOAPMessage((InputStream)xml);
        } else if (xml instanceof Document) {
            soapMessage = (Document)xml;
        } else {
            throw new Exception("Error: Invalid xml object");
        }
        if (soapMessage != null && this.isSoapFault(soapMessage)) {
            return this.parseSoapFault(soapMessage, logger);
        }
        eh.setRole("Validation");
        this.validateSoapMessage(soapMessage, eh);
        int error_count = eh.getErrorCount();
        int warning_count = eh.getWarningCount();
        if (error_count > 0 || warning_count > 0) {
            Object msg = "";
            if (error_count > 0) {
                msg = (String)msg + error_count + " validation error" + (error_count == 1 ? "" : "s");
                if (warning_count > 0) {
                    msg = (String)msg + " and ";
                }
            }
            if (warning_count > 0) {
                msg = (String)msg + warning_count + " warning" + (warning_count == 1 ? "" : "s");
            }
            msg = (String)msg + " detected.";
            logger.println((String)msg);
        }
        if (error_count > 0) {
            soapMessage = null;
        }
        if (soapMessage != null && returnType.equals("content")) {
            return SoapUtils.getSoapBody(soapMessage);
        }
        return soapMessage;
    }

    private void validateSoapMessage(Document soapMessage, ErrorHandler eh) throws Exception {
        String namespace = soapMessage.getDocumentElement().getNamespaceURI();
        if (namespace == null) {
            throw new Exception("Error: SOAP message cannot be validated. The returned response may be an HTML response: " + DomUtils.serializeNode(soapMessage));
        }
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema soap_schema = null;
        soap_schema = namespace.equals(SOAP_12_NAMESPACE) ? sf.newSchema(Misc.getResourceAsFile("com/occamlab/te/schemas/soap12.xsd")) : sf.newSchema(Misc.getResourceAsFile("com/occamlab/te/schemas/soap11.xsd"));
        Validator soap_validator = soap_schema.newValidator();
        soap_validator.setErrorHandler(eh);
        soap_validator.validate(new DOMSource(soapMessage));
    }

    private boolean isSoapFault(Document soapMessage) throws Exception {
        Element faultElement = DomUtils.getElementByTagNameNS(soapMessage, SOAP_12_NAMESPACE, "Fault");
        if (faultElement != null) {
            return true;
        }
        faultElement = DomUtils.getElementByTagNameNS(soapMessage, SOAP_11_NAMESPACE, "Fault");
        return faultElement != null;
    }

    private Document parseSoapFault(Document soapMessage, PrintWriter logger) throws Exception {
        String namespace = soapMessage.getDocumentElement().getNamespaceURI();
        if (namespace.equals(SOAP_12_NAMESPACE)) {
            this.parseSoap12Fault(soapMessage, logger);
        } else {
            this.parseSoap11Fault(soapMessage, logger);
        }
        return soapMessage;
    }

    private void parseSoap11Fault(Document soapMessage, PrintWriter logger) throws Exception {
        Element envelope = soapMessage.getDocumentElement();
        Element element = DomUtils.getElementByTagName(envelope, "faultcode");
        if (element == null) {
            element = DomUtils.getElementByTagNameNS(envelope, SOAP_11_NAMESPACE, "faultcode");
        }
        String faultcode = element.getTextContent();
        element = DomUtils.getElementByTagName(envelope, "faultstring");
        if (element == null) {
            element = DomUtils.getElementByTagNameNS(envelope, SOAP_11_NAMESPACE, "faultstring");
        }
        String faultstring = element.getTextContent();
        String msg = "SOAP Fault received - [code:" + faultcode + "][fault string:" + faultstring + "]";
        logger.println(msg);
    }

    private void parseSoap12Fault(Document soapMessage, PrintWriter logger) throws Exception {
        Element reason;
        Element text;
        Element envelope = soapMessage.getDocumentElement();
        Element code = DomUtils.getElementByTagNameNS(envelope, SOAP_12_NAMESPACE, "Code");
        String value = DomUtils.getElementByTagNameNS(code, SOAP_12_NAMESPACE, "Value").getTextContent();
        String msg = "SOAP Fault received - [code:" + value + "]";
        Element subCode = DomUtils.getElementByTagNameNS(code, SOAP_12_NAMESPACE, "Subcode");
        if (subCode != null) {
            value = DomUtils.getElementByTagNameNS(subCode, SOAP_12_NAMESPACE, "Value").getTextContent();
            msg = msg + "[subcode:" + value + "]";
        }
        if ((text = DomUtils.getElementByTagNameNS(reason = DomUtils.getElementByTagNameNS(envelope, SOAP_12_NAMESPACE, "Reason"), SOAP_12_NAMESPACE, "Text")) != null) {
            value = text.getTextContent();
            msg = msg + "[reason:" + value + "]";
        }
        logger.println(msg);
    }
}

