/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.parsers.xml;

import com.google.common.collect.ImmutableList;
import com.occamlab.te.parsers.xml.SchemaLoader;
import com.occamlab.te.parsers.xml.SchemaSupplier;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class XsdSchemaLoader
implements SchemaLoader {
    private static final Logger LOGGER = Logger.getLogger(XsdSchemaLoader.class.getName());
    private final SchemaFactory schemaFactory;

    public XsdSchemaLoader() {
        String property_name = "javax.xml.validation.SchemaFactory:http://www.w3.org/2001/XMLSchema";
        String oldprop = System.getProperty(property_name);
        System.setProperty(property_name, "org.apache.xerces.jaxp.validation.XMLSchemaFactory");
        this.schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            this.schemaFactory.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
        }
        catch (Exception e) {
            LOGGER.warning("Unable to set feature '*/schema-full-checking'");
        }
        if (oldprop == null) {
            System.clearProperty(property_name);
        } else {
            System.setProperty(property_name, oldprop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema loadSchema(ImmutableList<SchemaSupplier> suppliers) throws SAXException {
        LOGGER.fine("Loading unified schema from suppliers: " + suppliers);
        Source[] schemaSources = new Source[suppliers.size()];
        for (int i = 0; i < suppliers.size(); ++i) {
            schemaSources[i] = ((SchemaSupplier)suppliers.get(i)).makeSource();
        }
        XsdSchemaLoader xsdSchemaLoader = this;
        synchronized (xsdSchemaLoader) {
            return this.schemaFactory.newSchema(schemaSources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema defaultSchema() throws SAXException {
        XsdSchemaLoader xsdSchemaLoader = this;
        synchronized (xsdSchemaLoader) {
            return this.schemaFactory.newSchema();
        }
    }
}

