/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.util;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TEPath
implements Path {
    private static Path tmpdir = null;
    private static Path te_install = null;
    private static Path te_base = null;
    private static Path te_build = null;
    private static Path user_home = null;
    Path vpath = null;
    private static Logger jlogger = Logger.getLogger("com.occamlab.te.util.TEPath");

    public TEPath(String arg) {
        jlogger.setLevel(Level.INFO);
        String stmp = null;
        if (te_base == null) {
            stmp = System.getProperty("TE_BASE");
            if (stmp == null) {
                stmp = System.getenv("TE_BASE");
            }
            if (stmp == null) {
                stmp = "/TE_BASE";
            }
            te_base = Paths.get(stmp, new String[0]);
        }
        if (tmpdir == null) {
            stmp = System.getProperty("java.io.tmpdir");
            if (stmp == null) {
                stmp = te_base.toString();
            }
            tmpdir = Paths.get(stmp, new String[0]);
        }
        if (te_install == null) {
            stmp = System.getProperty("TE_INSTALL");
            if (stmp == null) {
                stmp = System.getenv("TE_INSTALL");
            }
            if (stmp == null) {
                stmp = te_base.toString();
            }
            te_install = Paths.get(stmp, new String[0]);
        }
        if (te_build == null) {
            stmp = System.getenv("TE_BUILD");
            if (stmp == null) {
                stmp = Paths.get("", new String[0]).toFile().getAbsolutePath();
            }
            te_build = Paths.get(stmp, new String[0]);
        }
        if (user_home == null) {
            stmp = System.getProperty("user.home");
            if (stmp == null) {
                stmp = tmpdir.toString();
            }
            user_home = Paths.get(stmp, new String[0]);
        }
        Path path1 = Paths.get(arg, new String[0]);
        Path path2 = path1.normalize();
        Path path3 = null;
        try {
            path3 = path2.toAbsolutePath();
        }
        catch (SecurityException e) {
            jlogger.log(Level.WARNING, e.getMessage(), e.getCause());
            path3 = Paths.get(new String(), new String[0]);
        }
        catch (IOError e) {
            jlogger.log(Level.WARNING, e.getMessage(), e.getCause());
            path3 = path2;
        }
        this.vpath = this.validate(path3) ? path3 : Paths.get(new String(), new String[0]);
    }

    @Override
    public int compareTo(Path arg) {
        int i = this.vpath.compareTo(arg);
        return i;
    }

    @Override
    public boolean endsWith(Path arg) {
        boolean i = this.vpath.endsWith(arg);
        return i;
    }

    @Override
    public boolean endsWith(String arg) {
        boolean i = this.vpath.endsWith(arg);
        return i;
    }

    @Override
    public boolean equals(Object arg) {
        boolean i = this.vpath.equals(arg);
        return i;
    }

    @Override
    public Path getFileName() {
        Path i = this.vpath.getFileName();
        return i;
    }

    @Override
    public FileSystem getFileSystem() {
        FileSystem i = this.vpath.getFileSystem();
        return i;
    }

    @Override
    public Path getName(int arg) {
        Path i = this.vpath.getName(arg);
        return i;
    }

    @Override
    public int getNameCount() {
        int i = this.vpath.getNameCount();
        return i;
    }

    @Override
    public Path getParent() {
        Path i = this.vpath.getParent();
        return i;
    }

    @Override
    public Path getRoot() {
        Path i = this.vpath.getRoot();
        return i;
    }

    @Override
    public int hashCode() {
        int i = this.vpath.hashCode();
        return i;
    }

    @Override
    public boolean isAbsolute() {
        boolean i = this.vpath.isAbsolute();
        return i;
    }

    @Override
    public Iterator<Path> iterator() {
        Iterator<Path> i = this.vpath.iterator();
        return i;
    }

    @Override
    public Path normalize() {
        Path i = this.vpath.normalize();
        return i;
    }

    @Override
    public WatchKey register(WatchService service, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException("Register operation is not supported by TEPath.");
    }

    @Override
    public WatchKey register(WatchService service, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException("Register operation is not supported by TEPath.");
    }

    @Override
    public Path relativize(Path arg) {
        Path i = this.vpath.relativize(arg);
        return i;
    }

    @Override
    public Path resolve(Path arg) {
        Path i = this.vpath.resolve(arg);
        return i;
    }

    @Override
    public Path resolve(String arg) {
        Path i = this.vpath.resolve(arg);
        return i;
    }

    @Override
    public Path resolveSibling(Path arg) {
        Path i = this.vpath.resolveSibling(arg);
        return i;
    }

    @Override
    public Path resolveSibling(String arg) {
        Path i = this.vpath.resolveSibling(arg);
        return i;
    }

    @Override
    public boolean startsWith(Path arg) {
        boolean i = this.vpath.startsWith(arg);
        return i;
    }

    @Override
    public boolean startsWith(String arg) {
        boolean i = this.vpath.startsWith(arg);
        return i;
    }

    @Override
    public Path subpath(int begin, int end) {
        Path i = this.vpath.subpath(begin, end);
        return i;
    }

    @Override
    public Path toAbsolutePath() {
        Path i = this.vpath.toAbsolutePath();
        return i;
    }

    @Override
    public File toFile() {
        File i = this.vpath.toFile();
        return i;
    }

    @Override
    public Path toRealPath(LinkOption ... arg) throws IOException {
        Path i = this.vpath.toRealPath(arg);
        return i;
    }

    @Override
    public String toString() {
        String i = this.vpath.toString();
        return i;
    }

    @Override
    public URI toUri() {
        URI i = this.vpath.toUri();
        return i;
    }

    public boolean isValid() {
        if (this.vpath != null && this.validate(this.vpath)) {
            return true;
        }
        jlogger.log(Level.WARNING, "TEPath: Invalid path = " + this.vpath);
        return false;
    }

    private boolean validate(Path arg1) {
        if (arg1 == null) {
            jlogger.warning("TEPATH Invalid Path: <null>");
            return false;
        }
        if (arg1.toString().isEmpty()) {
            jlogger.warning("TEPATH Invalid Path: <empty>");
            return false;
        }
        Path tpath = arg1.normalize();
        try {
            tpath = tpath.toAbsolutePath();
        }
        catch (SecurityException e) {
            jlogger.warning("TEPATH Invalid Path - file system error: " + tpath);
            return false;
        }
        catch (IOError e) {
            jlogger.log(Level.WARNING, e.getMessage(), e.getCause());
            tpath = arg1.normalize();
        }
        boolean valid = false;
        if (tpath.startsWith(te_base)) {
            valid = true;
        }
        if (tpath.startsWith(te_install)) {
            valid = true;
        }
        if (tpath.startsWith(tmpdir)) {
            valid = true;
        }
        if (tpath.startsWith(te_build)) {
            valid = true;
        }
        if (tpath.startsWith(user_home)) {
            valid = true;
        }
        if (tpath.startsWith("c:\\Windows")) {
            valid = false;
        }
        if (tpath.startsWith("C:\\Windows")) {
            valid = false;
        }
        if (tpath.startsWith("/etc")) {
            valid = false;
        }
        if (tpath.startsWith("/bin")) {
            valid = false;
        }
        if (tpath.startsWith("/usr/bin")) {
            valid = false;
        }
        if (!valid) {
            jlogger.warning("TEPATH Invalid Path: " + arg1.toString());
        }
        return valid;
    }
}

