/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public abstract class SequenceWriter
extends SequenceReceiver {
    private Receiver outputter = null;
    private TinyBuilder builder = null;
    private int level = 0;
    private boolean inStartTag = false;

    public abstract void write(Item var1) throws XPathException;

    public boolean hasOpenNodes() {
        return this.level != 0;
    }

    public void startDocument(int properties) throws XPathException {
        if (this.outputter == null) {
            this.createTree();
        }
        if (this.level++ == 0) {
            this.outputter.startDocument(properties);
        }
    }

    private void createTree() throws XPathException {
        this.builder = new TinyBuilder();
        this.builder.setPipelineConfiguration(this.getPipelineConfiguration());
        this.builder.setSystemId(this.getSystemId());
        NamespaceReducer reducer = new NamespaceReducer();
        reducer.setUnderlyingReceiver(this.builder);
        reducer.setPipelineConfiguration(this.getPipelineConfiguration());
        ComplexContentOutputter cco = new ComplexContentOutputter();
        cco.setHostLanguage(this.getPipelineConfiguration().getHostLanguage());
        cco.setPipelineConfiguration(this.getPipelineConfiguration());
        cco.setReceiver(reducer);
        this.outputter = cco;
        this.outputter.setSystemId(this.systemId);
        this.outputter.setPipelineConfiguration(this.getPipelineConfiguration());
        this.outputter.open();
    }

    protected boolean adviseReuse() {
        return this.builder != null && this.builder.getTree().getNumberOfNodes() < 20000;
    }

    public void endDocument() throws XPathException {
        if (--this.level == 0) {
            this.outputter.endDocument();
            DocumentInfo doc = (DocumentInfo)this.builder.getCurrentRoot();
            this.append(doc, 0, 2);
        }
        this.previousAtomic = false;
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.outputter == null) {
            this.createTree();
        }
        this.outputter.startElement(nameCode, typeCode, locationId, properties);
        ++this.level;
        this.inStartTag = true;
        this.previousAtomic = false;
    }

    public void endElement() throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        this.outputter.endElement();
        if (--this.level == 0) {
            NodeInfo element = this.builder.getCurrentRoot();
            this.append(element, 0, 2);
        }
        this.previousAtomic = false;
    }

    public void namespace(int nscode, int properties) throws XPathException {
        if (this.level == 0) {
            NamePool namePool = this.getNamePool();
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeKind((short)13);
            o.setNameCode(namePool.allocate("", "", namePool.getPrefixFromNamespaceCode(nscode)));
            o.setStringValue(namePool.getURIFromNamespaceCode(nscode));
            this.append(o, 0, 2);
        } else {
            this.outputter.namespace(nscode, properties);
        }
        this.previousAtomic = false;
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.level == 0) {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeKind((short)2);
            o.setNameCode(nameCode);
            o.setStringValue(value);
            o.setTypeAnnotation(typeCode);
            this.append(o, locationId, 2);
        } else {
            this.outputter.attribute(nameCode, typeCode, value, locationId, properties);
        }
        this.previousAtomic = false;
    }

    public void startContent() throws XPathException {
        this.inStartTag = false;
        this.outputter.startContent();
        this.previousAtomic = false;
    }

    public void characters(CharSequence s2, int locationId, int properties) throws XPathException {
        if (this.level == 0) {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeKind((short)3);
            o.setStringValue(s2);
            this.append(o, locationId, 2);
        } else if (s2.length() > 0) {
            if (this.inStartTag) {
                this.startContent();
            }
            this.outputter.characters(s2, locationId, properties);
        }
        this.previousAtomic = false;
    }

    public void comment(CharSequence comment, int locationId, int properties) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.level == 0) {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeKind((short)8);
            o.setStringValue(comment);
            this.append(o, locationId, 2);
        } else {
            this.outputter.comment(comment, locationId, properties);
        }
        this.previousAtomic = false;
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
        if (this.level == 0) {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNameCode(this.getNamePool().allocate("", "", target));
            o.setNodeKind((short)7);
            o.setStringValue(data);
            this.append(o, locationId, 2);
        } else {
            this.outputter.processingInstruction(target, data, locationId, properties);
        }
        this.previousAtomic = false;
    }

    public void close() throws XPathException {
        this.previousAtomic = false;
        if (this.outputter != null) {
            this.outputter.close();
        }
    }

    public void append(Item item, int locationId, int copyNamespaces) throws XPathException {
        if (item == null) {
            return;
        }
        if (this.level == 0) {
            this.write(item);
            this.previousAtomic = false;
        } else if (item instanceof AtomicValue) {
            if (this.previousAtomic) {
                this.outputter.characters(" ", 0, 0);
            }
            this.outputter.characters(item.getStringValueCS(), 0, 0);
            this.previousAtomic = true;
        } else {
            ((NodeInfo)item).copy(this.outputter, 2, true, locationId);
            this.previousAtomic = false;
        }
    }
}

