/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Arrays;
import java.util.HashMap;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class XSLDecimalFormat
extends StyleElement {
    boolean prepared = false;
    String name;
    String decimalSeparator;
    String groupingSeparator;
    String infinity;
    String minusSign;
    String NaN;
    String percent;
    String perMille;
    String zeroDigit;
    String digit;
    String patternSeparator;
    static int[] zeroDigits = new int[]{48, 1632, 1776, 2406, 2534, 2662, 2790, 2918, 3046, 3174, 3302, 3430, 3664, 3792, 3872, 4160, 6112, 6160, 6470, 6608, 65296, 66720, 120782, 120792, 120802, 120812, 120822};

    public void prepareAttributes() throws XPathException {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f == "name") {
                this.name = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f == "decimal-separator") {
                this.decimalSeparator = atts.getValue(a);
                continue;
            }
            if (f == "grouping-separator") {
                this.groupingSeparator = atts.getValue(a);
                continue;
            }
            if (f == "infinity") {
                this.infinity = atts.getValue(a);
                continue;
            }
            if (f == "minus-sign") {
                this.minusSign = atts.getValue(a);
                continue;
            }
            if (f == "NaN") {
                this.NaN = atts.getValue(a);
                continue;
            }
            if (f == "percent") {
                this.percent = atts.getValue(a);
                continue;
            }
            if (f == "per-mille") {
                this.perMille = atts.getValue(a);
                continue;
            }
            if (f == "zero-digit") {
                this.zeroDigit = atts.getValue(a);
                continue;
            }
            if (f == "digit") {
                this.digit = atts.getValue(a);
                continue;
            }
            if (f == "pattern-separator") {
                this.patternSeparator = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
    }

    public void validate() throws XPathException {
        this.checkTopLevel(null);
        this.checkEmpty();
    }

    public DecimalSymbols makeDecimalFormatSymbols() throws XPathException {
        DecimalSymbols d = new DecimalSymbols();
        DecimalFormatManager.setDefaults(d);
        if (this.decimalSeparator != null) {
            d.decimalSeparator = this.toChar(this.decimalSeparator);
        }
        if (this.groupingSeparator != null) {
            d.groupingSeparator = this.toChar(this.groupingSeparator);
        }
        if (this.infinity != null) {
            d.infinity = this.infinity;
        }
        if (this.minusSign != null) {
            d.minusSign = this.toChar(this.minusSign);
        }
        if (this.NaN != null) {
            d.NaN = this.NaN;
        }
        if (this.percent != null) {
            d.percent = this.toChar(this.percent);
        }
        if (this.perMille != null) {
            d.permill = this.toChar(this.perMille);
        }
        if (this.zeroDigit != null) {
            d.zeroDigit = this.toChar(this.zeroDigit);
            this.checkZeroDigit();
        }
        if (this.digit != null) {
            d.digit = this.toChar(this.digit);
        }
        if (this.patternSeparator != null) {
            d.patternSeparator = this.toChar(this.patternSeparator);
        }
        this.checkDistinctRoles(d);
        return d;
    }

    private void checkDistinctRoles(DecimalSymbols dfs) throws XPathException {
        HashMap<Integer, String> map = new HashMap<Integer, String>(20);
        Integer c = new Integer(dfs.decimalSeparator);
        map.put(c, "decimal-separator");
        c = new Integer(dfs.groupingSeparator);
        if (map.get(c) != null) {
            this.duplicate("grouping-separator", (String)map.get(c));
        }
        map.put(c, "grouping-separator");
        c = new Integer(dfs.percent);
        if (map.get(c) != null) {
            this.duplicate("percent", (String)map.get(c));
        }
        map.put(c, "percent");
        c = new Integer(dfs.permill);
        if (map.get(c) != null) {
            this.duplicate("per-mille", (String)map.get(c));
        }
        map.put(c, "per-mille");
        c = new Integer(dfs.zeroDigit);
        if (map.get(c) != null) {
            this.duplicate("zero-digit", (String)map.get(c));
        }
        map.put(c, "zero-digit");
        c = new Integer(dfs.digit);
        if (map.get(c) != null) {
            this.duplicate("digit", (String)map.get(c));
        }
        map.put(c, "digit");
        c = new Integer(dfs.patternSeparator);
        if (map.get(c) != null) {
            this.duplicate("pattern-separator", (String)map.get(c));
        }
        map.put(c, "pattern-separator");
    }

    private void duplicate(String role1, String role2) throws XPathException {
        this.compileError("The same character is used as the " + role1 + " and as the " + role2, "XTSE1300");
    }

    public void checkZeroDigit() throws XPathException {
        int d = this.zeroDigit.length() == 1 ? this.zeroDigit.charAt(0) : StringValue.expand(this.zeroDigit)[0];
        if (Arrays.binarySearch(zeroDigits, d) < 0) {
            this.compileError("The value of the zero-digit attribute must be a Unicode digit with value zero", "XTSE1295");
        }
    }

    public void register() throws XPathException {
        this.prepareAttributes();
        DecimalSymbols d = this.makeDecimalFormatSymbols();
        DecimalFormatManager dfm = this.getPrincipalStylesheet().getDecimalFormatManager();
        if (this.name == null) {
            try {
                dfm.setDefaultDecimalFormat(d, this.getPrecedence());
            }
            catch (XPathException err) {
                this.compileError(err.getMessage(), err.getErrorCodeLocalPart());
            }
        } else {
            try {
                StructuredQName formatName = this.makeQName(this.name);
                try {
                    dfm.setNamedDecimalFormat(formatName, d, this.getPrecedence());
                }
                catch (XPathException err) {
                    this.compileError(err.getMessage(), err.getErrorCodeLocalPart());
                }
            }
            catch (XPathException err) {
                this.compileError("Invalid decimal format name. " + err.getMessage(), "XTSE0020");
            }
            catch (NamespaceException err) {
                this.compileError("Invalid decimal format name. " + err.getMessage(), "XTSE0280");
            }
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        return null;
    }

    private int toChar(String s2) throws XPathException {
        int[] e = StringValue.expand(s2);
        if (e.length != 1) {
            this.compileError("Attribute \"" + s2 + "\" should be a single character", "XTSE0020");
        }
        return e[0];
    }
}

