/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.compose;

import java.util.Iterator;
import java.util.Set;
import org.apache.jena.JenaRuntime;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.compose.Polyadic;
import org.apache.jena.graph.impl.SimpleEventManager;
import org.apache.jena.util.CollectionFactory;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;

public class MultiUnion
extends Polyadic {
    private boolean optimising = JenaRuntime.getSystemProperty("jena.union.optimise", "yes").equals("yes");

    public MultiUnion() {
    }

    public MultiUnion(Graph[] graphs) {
        super(graphs);
    }

    public MultiUnion(Iterator<Graph> graphs) {
        super(graphs);
    }

    private boolean optimiseOne() {
        return this.optimising && this.m_subGraphs.size() == 1;
    }

    @Override
    public void performAdd(Triple t2) {
        this.getRequiredBaseGraph().add(t2);
    }

    @Override
    public void performDelete(Triple t2) {
        this.getRequiredBaseGraph().delete(t2);
    }

    @Override
    public boolean graphBaseContains(Triple t2) {
        for (Graph m_subGraph : this.m_subGraphs) {
            if (!m_subGraph.contains(t2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(Triple t2) {
        ExtendedIterator<Triple> found = this.optimiseOne() ? this.singleGraphFind(t2) : this.multiGraphFind(t2);
        return SimpleEventManager.notifyingRemove(this, found);
    }

    private ExtendedIterator<Triple> singleGraphFind(Triple t2) {
        return ((Graph)this.m_subGraphs.get(0)).find(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedIterator<Triple> multiGraphFind(Triple t2) {
        Set<Triple> seen = CollectionFactory.createHashedSet();
        ExtendedIterator<Object> result = NullIterator.instance();
        boolean finished = false;
        try {
            for (Graph m_subGraph : this.m_subGraphs) {
                ExtendedIterator<Triple> newTriples = MultiUnion.recording(MultiUnion.rejecting(m_subGraph.find(t2), seen), seen);
                result = result.andThen(newTriples);
            }
            finished = true;
            Iterator iterator = result;
            return iterator;
        }
        finally {
            if (!finished) {
                result.close();
            }
        }
    }

    @Override
    public void addGraph(Graph graph) {
        if (!this.m_subGraphs.contains(graph)) {
            this.m_subGraphs.add(graph);
        }
    }
}

