/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.jena.JenaRuntime;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.shared.JenaException;
import org.apache.jena.util.FileManagerImpl;
import org.apache.jena.util.FileUtils;
import org.apache.jena.vocabulary.LocationMappingVocab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationMapper {
    static Logger log = LoggerFactory.getLogger(LocationMapper.class);
    public static final String DEFAULT_PATH = "file:location-mapping.rdf;file:location-mapping.n3;file:location-mapping.ttl;file:etc/location-mapping.rdf;file:etc/location-mapping.n3;file:etc/location-mapping.ttl";
    public static final String GlobalMapperSystemProperty1 = "http://jena.hpl.hp.com/2004/08/LocationMap";
    public static final String GlobalMapperSystemProperty2 = "LocationMap";
    static String s_globalMapperPath = null;
    Map<String, String> altLocations = new HashMap<String, String>();
    Map<String, String> altPrefixes = new HashMap<String, String>();
    static LocationMapper theMapper = null;

    public static LocationMapper getInternal() {
        if (theMapper == null) {
            theMapper = new LocationMapper();
            if (LocationMapper.getGlobalConfigPath() != null) {
                theMapper.initFromPath(LocationMapper.getGlobalConfigPath(), false);
            }
        }
        return theMapper;
    }

    @Deprecated
    public static LocationMapper get() {
        return LocationMapper.getInternal();
    }

    public static void setGlobalLocationMapper(LocationMapper globalLocationMapper) {
        theMapper = globalLocationMapper;
    }

    public static LocationMapper makeGlobal() {
        LocationMapper lMap = new LocationMapper();
        if (LocationMapper.getGlobalConfigPath() != null) {
            lMap.initFromPath(LocationMapper.getGlobalConfigPath(), false);
        }
        return lMap;
    }

    @Deprecated
    public LocationMapper() {
    }

    @Deprecated
    public LocationMapper(LocationMapper locMapper) {
        this.altLocations.putAll(locMapper.altLocations);
        this.altPrefixes.putAll(locMapper.altPrefixes);
    }

    @Deprecated
    public LocationMapper(Model model) {
        this.processConfig(model);
    }

    @Deprecated
    public LocationMapper(String config) {
        this.initFromPath(config, true);
    }

    private void initFromPath(String configPath, boolean configMustExist) {
        if (configPath == null || configPath.length() == 0) {
            log.warn("Null configuration");
            return;
        }
        FileManagerImpl fm = new FileManagerImpl();
        fm.addLocatorFile();
        fm.addLocatorClassLoader(fm.getClass().getClassLoader());
        try {
            String uri;
            String uriConfig = null;
            InputStream in = null;
            StringTokenizer pathElems = new StringTokenizer(configPath, ";");
            while (pathElems.hasMoreTokens() && (uri = pathElems.nextToken()) != null && uri.length() != 0) {
                in = fm.openNoMap(uri);
                if (in == null) continue;
                uriConfig = uri;
                break;
            }
            if (in == null) {
                if (!configMustExist) {
                    log.debug("Failed to find configuration: " + configPath);
                }
                return;
            }
            String syntax = FileUtils.guessLang(uriConfig);
            Model model = ModelFactory.createDefaultModel();
            model.read(in, uriConfig, syntax);
            this.processConfig(model);
        }
        catch (JenaException ex) {
            LoggerFactory.getLogger(LocationMapper.class).warn("Error in configuration file: " + ex.getMessage());
        }
    }

    public String altMapping(String uri) {
        return this.altMapping(uri, uri);
    }

    public String altMapping(String uri, String otherwise) {
        if (this.altLocations.containsKey(uri)) {
            return this.altLocations.get(uri);
        }
        String newStart = null;
        String oldStart = null;
        for (String prefix : this.altPrefixes.keySet()) {
            if (!uri.startsWith(prefix)) continue;
            String s2 = this.altPrefixes.get(prefix);
            if (newStart != null && newStart.length() >= s2.length()) continue;
            oldStart = prefix;
            newStart = s2;
        }
        if (newStart != null) {
            return newStart + uri.substring(oldStart.length());
        }
        return otherwise;
    }

    public void addAltEntry(String uri, String alt) {
        this.altLocations.put(uri, alt);
    }

    public void addAltPrefix(String uriPrefix, String altPrefix) {
        this.altPrefixes.put(uriPrefix, altPrefix);
    }

    public Iterator<String> listAltEntries() {
        return this.altLocations.keySet().iterator();
    }

    public Iterator<String> listAltPrefixes() {
        return this.altPrefixes.keySet().iterator();
    }

    public void removeAltEntry(String uri) {
        this.altLocations.remove(uri);
    }

    public void removeAltPrefix(String uriPrefix) {
        this.altPrefixes.remove(uriPrefix);
    }

    public String getAltEntry(String uri) {
        return this.altLocations.get(uri);
    }

    public String getAltPrefix(String uriPrefix) {
        return this.altPrefixes.get(uriPrefix);
    }

    private static String getGlobalConfigPath() {
        if (s_globalMapperPath == null) {
            s_globalMapperPath = JenaRuntime.getSystemProperty(GlobalMapperSystemProperty1, null);
        }
        if (s_globalMapperPath == null) {
            s_globalMapperPath = JenaRuntime.getSystemProperty(GlobalMapperSystemProperty2, null);
        }
        if (s_globalMapperPath == null) {
            s_globalMapperPath = DEFAULT_PATH;
        }
        return s_globalMapperPath;
    }

    public int hashCode() {
        String v;
        int x = 0;
        for (String k : this.altLocations.keySet()) {
            v = this.altLocations.get(k);
            x = x ^ k.hashCode() ^ v.hashCode();
        }
        for (String k : this.altPrefixes.keySet()) {
            v = this.altPrefixes.get(k);
            x = x ^ k.hashCode() ^ v.hashCode();
        }
        return x;
    }

    public boolean equals(Object obj) {
        String v;
        if (!(obj instanceof LocationMapper)) {
            return false;
        }
        LocationMapper other = (LocationMapper)obj;
        if (this.altLocations.size() != other.altLocations.size()) {
            return false;
        }
        if (this.altPrefixes.size() != other.altPrefixes.size()) {
            return false;
        }
        for (String k : this.altLocations.keySet()) {
            v = this.altLocations.get(k);
            if (other.altLocations.get(k).equals(v)) continue;
            return false;
        }
        for (String k : this.altPrefixes.keySet()) {
            v = this.altPrefixes.get(k);
            if (other.altPrefixes.get(k).equals(v)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String v;
        Object s2 = "";
        for (String k : this.altLocations.keySet()) {
            v = this.altLocations.get(k);
            s2 = (String)s2 + "(Loc:" + k + "=>" + v + ") ";
        }
        for (String k : this.altPrefixes.keySet()) {
            v = this.altPrefixes.get(k);
            s2 = (String)s2 + "(Prefix:" + k + "=>" + v + ") ";
        }
        return s2;
    }

    public Model toModel() {
        Model m4 = ModelFactory.createDefaultModel();
        m4.setNsPrefix("lmap", "http://jena.hpl.hp.com/2004/08/location-mapping#");
        this.toModel(m4);
        return m4;
    }

    public void toModel(Model model) {
        String v;
        String k;
        Resource e;
        Resource r;
        for (String s1 : this.altLocations.keySet()) {
            r = model.createResource();
            e = model.createResource();
            model.add(r, LocationMappingVocab.mapping, e);
            k = s1;
            v = this.altLocations.get(k);
            model.add(e, LocationMappingVocab.name, k);
            model.add(e, LocationMappingVocab.altName, v);
        }
        for (String s2 : this.altPrefixes.keySet()) {
            r = model.createResource();
            e = model.createResource();
            model.add(r, LocationMappingVocab.mapping, e);
            k = s2;
            v = this.altPrefixes.get(k);
            model.add(e, LocationMappingVocab.prefix, k);
            model.add(e, LocationMappingVocab.altPrefix, v);
        }
    }

    public void processConfig(Model m4) {
        StmtIterator mappings = m4.listStatements(null, LocationMappingVocab.mapping, (RDFNode)null);
        while (mappings.hasNext()) {
            Statement s2 = mappings.nextStatement();
            Resource mapping = s2.getResource();
            if (mapping.hasProperty(LocationMappingVocab.name)) {
                try {
                    String name = mapping.getRequiredProperty(LocationMappingVocab.name).getString();
                    String altName = mapping.getRequiredProperty(LocationMappingVocab.altName).getString();
                    this.addAltEntry(name, altName);
                    log.debug("Mapping: " + name + " => " + altName);
                }
                catch (JenaException ex) {
                    log.warn("Error processing name mapping: " + ex.getMessage());
                    return;
                }
            }
            if (!mapping.hasProperty(LocationMappingVocab.prefix)) continue;
            try {
                String prefix = mapping.getRequiredProperty(LocationMappingVocab.prefix).getString();
                String altPrefix = mapping.getRequiredProperty(LocationMappingVocab.altPrefix).getString();
                this.addAltPrefix(prefix, altPrefix);
                log.debug("Prefix mapping: " + prefix + " => " + altPrefix);
            }
            catch (JenaException ex) {
                log.warn("Error processing prefix mapping: " + ex.getMessage());
                return;
            }
        }
    }
}

