/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.datum;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.datum.CTABLEV2;
import org.locationtech.proj4j.datum.NTV1;
import org.locationtech.proj4j.util.FloatPolarCoordinate;
import org.locationtech.proj4j.util.IntPolarCoordinate;
import org.locationtech.proj4j.util.PolarCoordinate;
import org.locationtech.proj4j.util.ProjectionMath;

public final class Grid
implements Serializable {
    private String gridName;
    private String fileName;
    private String format;
    private int gridOffset;
    static final int MAX_TRY = 9;
    static final double TOL = 1.0E-12;
    ConversionTable table;
    private Grid next;
    private Grid child;

    public static void mergeGridFile(String name, List<Grid> gridList) throws IOException {
        gridList.add(Grid.gridinfoInit(name));
    }

    public static void shift(List<Grid> grids, boolean inverse, ProjCoordinate in) {
        PolarCoordinate input = new PolarCoordinate(in.x, in.y);
        PolarCoordinate output = new PolarCoordinate(Double.NaN, Double.NaN);
        for (Grid grid : grids) {
            ConversionTable table = grid.table;
            double epsilon = (Math.abs(table.del.phi) + Math.abs(table.del.lam)) / 10000.0;
            if (table.ll.phi - epsilon > input.phi || table.ll.lam - epsilon > input.lam || table.ll.phi + (double)(table.lim.phi - 1) * table.del.phi + epsilon < input.phi || table.ll.lam + (double)(table.lim.lam - 1) * table.del.lam + epsilon < input.lam) continue;
            while (grid.child != null) {
                Grid child = grid.child;
                while (child != null) {
                    ConversionTable t2 = child.table;
                    double epsilon0 = (Math.abs(t2.del.phi) + Math.abs(t2.del.lam)) / 10000.0;
                    if (!(t2.ll.phi - epsilon0 > input.phi || t2.ll.lam - epsilon0 > input.lam || t2.ll.phi + (double)(t2.lim.phi - 1) * t2.del.phi + epsilon0 < input.phi) && !(t2.ll.lam + (double)(t2.lim.lam - 1) * t2.del.lam + epsilon0 < input.lam)) break;
                    child = child.next;
                }
                if (child == null) break;
                grid = child;
            }
            if (grid.table.cvs == null) {
                // empty if block
            }
            output = Grid.nad_cvt(input, inverse, table);
        }
        if (!Double.isNaN(output.lam)) {
            in.x = output.lam;
            in.y = output.phi;
        }
    }

    private static PolarCoordinate nad_cvt(PolarCoordinate in, boolean inverse, ConversionTable table) {
        if (Double.isNaN(in.lam)) {
            return in;
        }
        PolarCoordinate tb = new PolarCoordinate(in);
        tb.lam -= table.ll.lam;
        tb.phi -= table.ll.phi;
        tb.lam = ProjectionMath.normalizeLongitude(tb.lam - Math.PI) + Math.PI;
        PolarCoordinate t2 = Grid.nad_intr(tb, table);
        if (inverse) {
            PolarCoordinate del = new PolarCoordinate(Double.NaN, Double.NaN);
            PolarCoordinate dif = new PolarCoordinate(Double.NaN, Double.NaN);
            int i = 9;
            if (Double.isNaN(t2.lam)) {
                return t2;
            }
            t2.lam = tb.lam + t2.lam;
            t2.phi = tb.phi - t2.phi;
            do {
                del = Grid.nad_intr(t2, table);
                if (Double.isNaN(del.lam)) break;
                dif.lam = t2.lam - del.lam - tb.lam;
                t2.lam -= dif.lam;
                dif.phi = t2.phi + del.phi - tb.phi;
                t2.phi -= dif.phi;
            } while (i-- > 0 && Math.abs(dif.lam) > 1.0E-12 && Math.abs(dif.phi) > 1.0E-12);
            if (i < 0) {
                t2.phi = Double.NaN;
                t2.lam = Double.NaN;
                return t2;
            }
            in.lam = ProjectionMath.normalizeLongitude(t2.lam + table.ll.lam);
            in.phi = t2.phi + table.ll.phi;
        } else if (Double.isNaN(t2.lam)) {
            in = t2;
        } else {
            in.lam -= t2.lam;
            in.phi += t2.phi;
        }
        return in;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PolarCoordinate nad_intr(PolarCoordinate t2, ConversionTable table) {
        double m01;
        double m10;
        int in;
        t2 = new PolarCoordinate(t2);
        PolarCoordinate val = new PolarCoordinate(Double.NaN, Double.NaN);
        IntPolarCoordinate indx = new IntPolarCoordinate((int)Math.floor(t2.lam /= table.del.lam), (int)Math.floor(t2.phi /= table.del.phi));
        PolarCoordinate frct = new PolarCoordinate(t2.lam - (double)indx.lam, t2.phi - (double)indx.phi);
        if (indx.lam < 0) {
            if (indx.lam != -1 || !(frct.lam > 0.99999999999)) return val;
            ++indx.lam;
            frct.lam = 0.0;
        } else {
            in = indx.lam + 1;
            if (in >= table.lim.lam) {
                if (in != table.lim.lam || !(frct.lam < 1.0E-11)) return val;
                --indx.lam;
                frct.lam = 1.0;
            }
        }
        if (indx.phi < 0) {
            if (indx.phi != -1 || !(frct.phi > 0.99999999999)) return val;
            ++indx.phi;
            frct.phi = 0.0;
        } else {
            in = indx.phi + 1;
            if (in >= table.lim.phi) {
                if (in != table.lim.phi || !(frct.phi < 1.0E-11)) return val;
                --indx.phi;
                frct.phi = 1.0;
            }
        }
        int index = indx.phi * table.lim.lam + indx.lam;
        FloatPolarCoordinate f00 = table.cvs[index++];
        FloatPolarCoordinate f10 = table.cvs[index];
        index += table.lim.lam;
        FloatPolarCoordinate f11 = table.cvs[index--];
        FloatPolarCoordinate f01 = table.cvs[index];
        double m11 = m10 = frct.lam;
        double m00 = m01 = 1.0 - frct.lam;
        val.lam = m00 * (double)f00.lam + m10 * (double)f10.lam + (m01 *= frct.phi) * (double)f01.lam + (m11 *= frct.phi) * (double)f11.lam;
        val.phi = m00 * (double)f00.phi + m10 * (double)f10.phi + m01 * (double)f01.phi + m11 * (double)f11.phi;
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Grid> fromNadGrids(String grids) throws IOException {
        ArrayList<Grid> gridlist = new ArrayList<Grid>();
        Class<Grid> clazz = Grid.class;
        synchronized (Grid.class) {
            for (String gridName : grids.split(",")) {
                boolean optional = gridName.startsWith("@");
                if (optional) {
                    gridName = gridName.substring(1);
                }
                try {
                    Grid.mergeGridFile(gridName, gridlist);
                }
                catch (IOException e) {
                    if (optional) continue;
                    throw e;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return gridlist;
        }
    }

    private static Grid gridinfoInit(String gridName) throws IOException {
        Grid grid = new Grid();
        grid.gridName = gridName;
        grid.format = "missing";
        grid.gridOffset = 0;
        try (DataInputStream gridDefinition = Grid.resolveGridDefinition(gridName);){
            if (gridDefinition == null) {
                throw new IOException("Unknown grid: " + gridName);
            }
            byte[] header = new byte[160];
            gridDefinition.mark(header.length);
            gridDefinition.readFully(header);
            gridDefinition.reset();
            if (CTABLEV2.testHeader(header)) {
                grid.format = "ctable2";
                gridDefinition.mark(1024);
                grid.table = CTABLEV2.init(gridDefinition);
                gridDefinition.reset();
                CTABLEV2.load(gridDefinition, grid);
            }
            if (NTV1.testHeader(header)) {
                grid.format = "ntv1";
                gridDefinition.mark(1024);
                grid.table = NTV1.init(gridDefinition);
                gridDefinition.reset();
                NTV1.load(gridDefinition, grid);
            }
        }
        return grid;
    }

    private static DataInputStream resolveGridDefinition(String gridName) throws IOException {
        File file = new File(gridName);
        if (file.exists()) {
            return new DataInputStream(new FileInputStream(file));
        }
        InputStream resource = Grid.class.getResourceAsStream("/proj4/nad/" + gridName);
        if (resource != null) {
            return new DataInputStream(resource);
        }
        return null;
    }

    public int hashCode() {
        int nameHash = this.gridName == null ? 0 : this.gridName.hashCode();
        int fileHash = this.fileName == null ? 0 : this.fileName.hashCode();
        int formatHash = this.format == null ? 0 : this.format.hashCode();
        int tableHash = this.table == null ? 0 : this.table.hashCode();
        int nextHash = this.next == null ? 0 : this.next.hashCode();
        int childHash = this.next == null ? 0 : this.next.hashCode();
        return nameHash | 7 * fileHash | 11 * formatHash | 17 * tableHash | 23 * nextHash | 31 * childHash;
    }

    public boolean equals(Object that) {
        if (that instanceof Grid) {
            Grid g2 = (Grid)that;
            if (this.gridName == null && g2.gridName != null) {
                return false;
            }
            if (!this.gridName.equals(g2.gridName)) {
                return false;
            }
            if (this.fileName == null && g2.fileName != null) {
                return false;
            }
            if (!this.fileName.equals(g2.fileName)) {
                return false;
            }
            if (this.format == null && g2.format != null) {
                return false;
            }
            if (!this.format.equals(g2.format)) {
                return false;
            }
            if (this.table == null && g2.table != null) {
                return false;
            }
            if (!this.table.equals(g2.table)) {
                return false;
            }
            if (this.next == null && g2.next != null) {
                return false;
            }
            if (!this.next.equals(g2.next)) {
                return false;
            }
            if (this.child == null && g2.child != null) {
                return false;
            }
            return this.child.equals(g2.child);
        }
        return false;
    }

    public String toString() {
        return "Grid[" + this.gridName + "; " + this.format + "]";
    }

    public static final class ConversionTable
    implements Serializable {
        public String id;
        public PolarCoordinate del;
        public PolarCoordinate ll;
        public IntPolarCoordinate lim;
        public FloatPolarCoordinate[] cvs;

        public String toString() {
            return String.format("Grid: %s", this.id);
        }

        public int hashCode() {
            int idHash = this.id == null ? 0 : this.id.hashCode();
            int delHash = this.del == null ? 0 : this.del.hashCode();
            int llHash = this.ll == null ? 0 : this.ll.hashCode();
            int cvsHash = Arrays.hashCode(this.cvs);
            return idHash | 11 * delHash | 23 * llHash | 37 * cvsHash;
        }

        public boolean equals(Object that) {
            if (that instanceof ConversionTable) {
                ConversionTable ct = (ConversionTable)that;
                if (this.id == null && ct.id != null) {
                    return false;
                }
                if (!this.id.equals(ct.id)) {
                    return false;
                }
                if (this.del == null && ct.del != null) {
                    return false;
                }
                if (!this.del.equals(ct.del)) {
                    return false;
                }
                if (this.ll == null && ct.ll != null) {
                    return false;
                }
                if (!this.ll.equals(ct.ll)) {
                    return false;
                }
                return Arrays.equals(this.cvs, ct.cvs);
            }
            return false;
        }
    }
}

