/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.wcs20;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.value.TextFragmentValue;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.opengis.cite.wcs20.GeometryTransformer;

public class Utils {
    private static GeometryTransformer geometryTransformer;
    private static DecimalFormat df;

    public static boolean checkCoordinatesWithCrsTransformation(Object low1, Object low2, Object high1, Object high2, Object posList, Object srcCrs, Object targetCrs) {
        String low1String = Utils.getStringvalue(low1);
        String low2String = Utils.getStringvalue(low2);
        String high1String = Utils.getStringvalue(high1);
        String high2String = Utils.getStringvalue(high2);
        String posListString = Utils.getStringvalue(posList);
        String srcCrsString = Utils.getStringvalue(srcCrs);
        String targetCrsString = Utils.getStringvalue(targetCrs);
        geometryTransformer = new GeometryTransformer(targetCrsString, srcCrsString);
        List<Double> xyList = Utils.createXyList(posListString);
        return Utils.containsWithTransformation(low1String, low2String, xyList) && Utils.containsWithTransformation(high1String, high2String, xyList);
    }

    private static List<Double> createXyList(String posListString) {
        String[] xyArray = posListString.split(" ");
        ArrayList<Double> xyList = new ArrayList<Double>(xyArray.length);
        for (String xy : xyArray) {
            xyList.add(Double.parseDouble(xy));
        }
        return xyList;
    }

    private static boolean containsWithTransformation(String x, String y, List<Double> xyList) {
        Point point = Utils.createPoint(x, y);
        Point transformedPoint = geometryTransformer.transform(point);
        String transformedX = df.format(transformedPoint.getX());
        String transformedY = df.format(transformedPoint.getY());
        return Utils.contains(transformedX, xyList) && Utils.contains(transformedY, xyList);
    }

    private static boolean contains(String xy, List<Double> xyList) {
        return xyList.stream().anyMatch(x -> df.format(x).equals(xy));
    }

    private static Point createPoint(String x, String y) {
        Coordinate c = new Coordinate(Double.parseDouble(x), Double.parseDouble(y));
        Coordinate[] coordinateArray = new Coordinate[]{c};
        CoordinateArraySequence coordinateSequence = new CoordinateArraySequence(coordinateArray);
        Point point = new Point((CoordinateSequence)coordinateSequence, geometryTransformer.getGeometryFactory());
        return point;
    }

    private static String getStringvalue(Object o) {
        if (o instanceof ArrayList) {
            Object firstListItem;
            ArrayList list = (ArrayList)o;
            if (list.size() > 0 && (firstListItem = list.get(0)) instanceof NodeInfo) {
                String value = ((NodeInfo)firstListItem).getStringValue();
                return value;
            }
        } else if (o instanceof TextFragmentValue) {
            return ((TextFragmentValue)o).getStringValue();
        }
        return null;
    }

    static {
        df = new DecimalFormat("#.############");
    }
}

