/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.citation;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import org.geotoolkit.lang.Static;
import org.geotoolkit.metadata.iso.DefaultIdentifier;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.geotoolkit.metadata.iso.citation.CitationConstant;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.metadata.iso.citation.DefaultContact;
import org.geotoolkit.metadata.iso.citation.DefaultOnlineResource;
import org.geotoolkit.metadata.iso.citation.DefaultResponsibleParty;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.xml.IdentifierSpace;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.util.InternationalString;

public final class Citations
extends Static {
    public static final Citation ISO;
    public static final Citation OGC;
    public static final Citation OPEN_GIS;
    public static final Citation ESRI;
    public static final Citation ORACLE;
    public static final Citation POSTGIS;
    public static final Citation GEOTOOLKIT;
    public static final Citation GEOTOOLS;
    public static final Citation WMS;
    public static final Citation NETCDF;
    public static final Citation NETCDF_CF;
    public static final Citation GEOTIFF;
    public static final Citation JAI;
    public static final IdentifierSpace<Integer> EPSG;
    public static final IdentifierSpace<Integer> IGNF;
    public static final IdentifierSpace<String> AUTO;
    public static final IdentifierSpace<String> AUTO2;
    public static final IdentifierSpace<String> CRS;
    public static final IdentifierSpace<URI> URN_OGC;
    public static final IdentifierSpace<URI> HTTP_OGC;
    public static final IdentifierSpace<String> PROJ4;
    public static final IdentifierSpace<String> ISBN;
    public static final IdentifierSpace<String> ISSN;
    public static final Citation UNKNOWN;
    private static final Citation[] AUTHORITIES;

    private Citations() {
    }

    public static Citation fromName(String string) {
        if (string == null || (string = string.trim()).isEmpty()) {
            return null;
        }
        for (int i = 0; i < AUTHORITIES.length; ++i) {
            Citation citation = AUTHORITIES[i];
            if (!Citations.titleMatches(citation, string)) continue;
            return citation;
        }
        return new DefaultCitation(string);
    }

    public static boolean titleMatches(Citation citation, Citation citation2) {
        ArgumentChecks.ensureNonNull((String)"c1", (Object)citation);
        ArgumentChecks.ensureNonNull((String)"c2", (Object)citation2);
        return org.geotoolkit.internal.Citations.titleMatches((Citation)citation, (Citation)citation2);
    }

    public static boolean titleMatches(Citation citation, String string) {
        ArgumentChecks.ensureNonNull((String)"citation", (Object)citation);
        ArgumentChecks.ensureNonNull((String)"title", (Object)string);
        return org.geotoolkit.internal.Citations.titleMatches((Citation)citation, (String)string);
    }

    public static boolean identifierMatches(Citation citation, Citation citation2) {
        ArgumentChecks.ensureNonNull((String)"c1", (Object)citation);
        ArgumentChecks.ensureNonNull((String)"c2", (Object)citation2);
        return org.geotoolkit.internal.Citations.identifierMatches((Citation)citation, (Citation)citation2);
    }

    public static boolean identifierMatches(Citation citation, String string) {
        ArgumentChecks.ensureNonNull((String)"citation", (Object)citation);
        ArgumentChecks.ensureNonNull((String)"identifier", (Object)string);
        return org.geotoolkit.internal.Citations.identifierMatches((Citation)citation, (String)string);
    }

    public static String getIdentifier(Citation citation) {
        return org.geotoolkit.internal.Citations.getIdentifier((Citation)citation);
    }

    static {
        MetadataEntity metadataEntity = new CitationConstant.Authority<Integer>(DefaultResponsibleParty.ISO, "ISO", "ISO");
        ((CitationConstant)metadataEntity).setAlternateTitle("ISO");
        ((CitationConstant)metadataEntity).setPresentationForm(PresentationForm.DOCUMENT_DIGITAL);
        metadataEntity.freeze();
        ISO = metadataEntity;
        metadataEntity = new CitationConstant(DefaultResponsibleParty.OGC, "OGC", "OGC");
        ((CitationConstant)metadataEntity).setAlternateTitle("OGC");
        ((CitationConstant)metadataEntity).setPresentationForm(PresentationForm.DOCUMENT_DIGITAL);
        metadataEntity.freeze();
        OGC = metadataEntity;
        metadataEntity = new CitationConstant(DefaultResponsibleParty.OPEN_GIS, "OPEN_GIS", null);
        ((DefaultCitation)metadataEntity).setPresentationForms(OGC.getPresentationForms());
        ((DefaultCitation)metadataEntity).setAlternateTitles(OGC.getAlternateTitles());
        ((DefaultCitation)metadataEntity).setIdentifiers(OGC.getIdentifiers());
        ((DefaultCitation)metadataEntity).getIdentifiers().add(new DefaultIdentifier("OpenGIS"));
        metadataEntity.freeze();
        OPEN_GIS = metadataEntity;
        metadataEntity = new CitationConstant(DefaultResponsibleParty.ESRI, "ESRI", "ESRI");
        metadataEntity.freeze();
        ESRI = metadataEntity;
        metadataEntity = new CitationConstant(DefaultResponsibleParty.ORACLE, "ORACLE", "Oracle");
        metadataEntity.freeze();
        ORACLE = metadataEntity;
        metadataEntity = new CitationConstant(DefaultResponsibleParty.POSTGIS, "POSTGIS", "PostGIS");
        metadataEntity.freeze();
        POSTGIS = metadataEntity;
        metadataEntity = new CitationConstant(DefaultResponsibleParty.GEOTOOLKIT, "GEOTOOLKIT", "Geotk");
        metadataEntity.freeze();
        GEOTOOLKIT = metadataEntity;
        metadataEntity = new CitationConstant(DefaultResponsibleParty.GEOTOOLS, "GEOTOOLS", "GeoTools");
        metadataEntity.freeze();
        GEOTOOLS = metadataEntity;
        metadataEntity = new CitationConstant("Web Map Service", "WMS", "WMS");
        ((DefaultCitation)metadataEntity).setAlternateTitles(Arrays.asList(new SimpleInternationalString("WMS 1.3.0"), new SimpleInternationalString("OGC 04-024"), new SimpleInternationalString("ISO 19128")));
        ((DefaultCitation)metadataEntity).setCitedResponsibleParties(Arrays.asList(DefaultResponsibleParty.OGC, DefaultResponsibleParty.OGC(Role.PUBLISHER, DefaultOnlineResource.WMS)));
        ((CitationConstant)metadataEntity).setPresentationForm(PresentationForm.DOCUMENT_DIGITAL);
        metadataEntity.freeze();
        WMS = metadataEntity;
        metadataEntity = new CitationConstant(DefaultResponsibleParty.NETCDF, "NETCDF", "NetCDF");
        ((CitationConstant)metadataEntity).setPresentationForm(PresentationForm.DOCUMENT_DIGITAL);
        metadataEntity.freeze();
        NETCDF = metadataEntity;
        metadataEntity = new CitationConstant(DefaultResponsibleParty.NETCDF, "NETCDF_CF", "NetCDF-CF");
        ((CitationConstant)metadataEntity).setPresentationForm(PresentationForm.DOCUMENT_DIGITAL);
        ((DefaultCitation)metadataEntity).setTitle((InternationalString)new SimpleInternationalString("NetCDF Climate and Forecast (CF) Metadata Convention"));
        metadataEntity.freeze();
        NETCDF_CF = metadataEntity;
        metadataEntity = new CitationConstant(DefaultResponsibleParty.GEOTIFF, "GEOTIFF", "GeoTIFF");
        ((CitationConstant)metadataEntity).setPresentationForm(PresentationForm.DOCUMENT_DIGITAL);
        metadataEntity.freeze();
        GEOTIFF = metadataEntity;
        metadataEntity = new CitationConstant("Java Advanced Imaging", "JAI", "JAI");
        ((CitationConstant)metadataEntity).setAlternateTitle("JAI");
        ((DefaultCitation)metadataEntity).setCitedResponsibleParties(Collections.singleton(DefaultResponsibleParty.SUN_MICROSYSTEMS));
        metadataEntity.freeze();
        JAI = metadataEntity;
        metadataEntity = new CitationConstant.Authority<Integer>(DefaultResponsibleParty.EPSG, "EPSG", "EPSG");
        ((CitationConstant)metadataEntity).setAlternateTitle("EPSG");
        ((CitationConstant)metadataEntity).setPresentationForm(PresentationForm.TABLE_DIGITAL);
        metadataEntity.freeze();
        EPSG = metadataEntity;
        metadataEntity = new DefaultResponsibleParty(Role.RESOURCE_PROVIDER);
        ((DefaultResponsibleParty)metadataEntity).setOrganisationName((InternationalString)new SimpleInternationalString("Institut G\u00e9ographique National"));
        ((DefaultResponsibleParty)metadataEntity).setContactInfo(new DefaultContact(new DefaultOnlineResource(URI.create("http://www.ign.fr"))));
        CitationConstant.Authority<Integer> authority = new CitationConstant.Authority<Integer>((ResponsibleParty)((Object)metadataEntity), "IGNF", "IGNF");
        authority.getPresentationForms().add(PresentationForm.TABLE_DIGITAL);
        authority.freeze();
        IGNF = authority;
        metadataEntity = new CitationConstant.Authority("Automatic Projections", "AUTO", "AUTO");
        ((DefaultCitation)metadataEntity).setCitedResponsibleParties(Arrays.asList(DefaultResponsibleParty.OGC, DefaultResponsibleParty.OGC(Role.PUBLISHER, OnLineFunction.DOWNLOAD, "http://www.opengis.org/docs/01-068r3.pdf")));
        ((CitationConstant)metadataEntity).setPresentationForm(PresentationForm.DOCUMENT_DIGITAL);
        metadataEntity.freeze();
        AUTO = metadataEntity;
        metadataEntity = new CitationConstant.Authority("Automatic Projections", "AUTO2", "AUTO2");
        ((DefaultCitation)metadataEntity).setCitedResponsibleParties(Arrays.asList(DefaultResponsibleParty.OGC, DefaultResponsibleParty.OGC(Role.PUBLISHER, DefaultOnlineResource.WMS)));
        ((CitationConstant)metadataEntity).setPresentationForm(PresentationForm.DOCUMENT_DIGITAL);
        metadataEntity.freeze();
        AUTO2 = metadataEntity;
        metadataEntity = new CitationConstant.Authority("Web Map Service CRS", "CRS", "CRS");
        ((DefaultCitation)metadataEntity).getIdentifiers().add(new DefaultIdentifier("OGC"));
        ((DefaultCitation)metadataEntity).setCitedResponsibleParties(AUTO2.getCitedResponsibleParties());
        ((CitationConstant)metadataEntity).setPresentationForm(PresentationForm.DOCUMENT_DIGITAL);
        metadataEntity.freeze();
        CRS = metadataEntity;
        metadataEntity = new CitationConstant.Authority("URN in OGC namespace", "URN_OGC", "urn:ogc:def");
        ((DefaultCitation)metadataEntity).getIdentifiers().add(new DefaultIdentifier("urn:x-ogc:def"));
        ((DefaultCitation)metadataEntity).setCitedResponsibleParties(Collections.singleton(DefaultResponsibleParty.OGC));
        ((CitationConstant)metadataEntity).setPresentationForm(PresentationForm.DOCUMENT_DIGITAL);
        metadataEntity.freeze();
        URN_OGC = metadataEntity;
        metadataEntity = new CitationConstant.Authority("URL in OGC namespace", "HTTP_OGC", "http://www.opengis.net");
        ((DefaultCitation)metadataEntity).setCitedResponsibleParties(Collections.singleton(DefaultResponsibleParty.OGC));
        ((CitationConstant)metadataEntity).setPresentationForm(PresentationForm.DOCUMENT_DIGITAL);
        metadataEntity.freeze();
        HTTP_OGC = metadataEntity;
        metadataEntity = new CitationConstant.Authority(DefaultResponsibleParty.PROJ4, "PROJ4", "PROJ4");
        ((CitationConstant)metadataEntity).setPresentationForm(PresentationForm.DOCUMENT_DIGITAL);
        metadataEntity.freeze();
        PROJ4 = metadataEntity;
        ISBN = DefaultCitation.ISBN;
        ISSN = DefaultCitation.ISSN;
        metadataEntity = new CitationConstant(Vocabulary.formatInternational((int)309), "UNKNOWN", null);
        metadataEntity.freeze();
        UNKNOWN = metadataEntity;
        AUTHORITIES = new Citation[]{OGC, OPEN_GIS, ESRI, ORACLE, POSTGIS, GEOTOOLKIT, GEOTOOLS, WMS, NETCDF, GEOTIFF, JAI, EPSG, AUTO, AUTO2, CRS, URN_OGC, HTTP_OGC, UNKNOWN};
    }
}

