/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.citation;

import java.net.URI;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.geotoolkit.metadata.iso.citation.DefaultContact;
import org.geotoolkit.metadata.iso.citation.DefaultOnlineResource;
import org.geotoolkit.util.SimpleInternationalString;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.util.InternationalString;

@ThreadSafe
@XmlType(name="CI_ResponsibleParty_Type", propOrder={"individualName", "organisationName", "positionName", "contactInfo", "role"})
@XmlRootElement(name="CI_ResponsibleParty")
public class DefaultResponsibleParty
extends MetadataEntity
implements ResponsibleParty {
    private static final long serialVersionUID = -2477962229031486552L;
    static final ResponsibleParty ISO;
    static final ResponsibleParty OGC;
    @Deprecated
    public static final ResponsibleParty OPEN_GIS;
    @Deprecated
    public static final ResponsibleParty EPSG;
    static final ResponsibleParty NETCDF;
    static final ResponsibleParty GEOTIFF;
    static final ResponsibleParty PROJ4;
    @Deprecated
    public static final ResponsibleParty ESRI;
    static final ResponsibleParty ORACLE;
    static final ResponsibleParty POSTGIS;
    static final ResponsibleParty SUN_MICROSYSTEMS;
    @Deprecated
    public static final ResponsibleParty GEOTOOLKIT;
    static final ResponsibleParty GEOTOOLS;
    private String individualName;
    private InternationalString organisationName;
    private InternationalString positionName;
    private Contact contactInfo;
    private Role role;

    static ResponsibleParty OGC(Role role, OnlineResource onlineResource) {
        DefaultResponsibleParty defaultResponsibleParty = new DefaultResponsibleParty(role);
        defaultResponsibleParty.setOrganisationName(OGC.getOrganisationName());
        if (onlineResource != null) {
            DefaultContact defaultContact = new DefaultContact(onlineResource);
            defaultContact.freeze();
            defaultResponsibleParty.setContactInfo(defaultContact);
        }
        defaultResponsibleParty.freeze();
        return defaultResponsibleParty;
    }

    static ResponsibleParty OGC(Role role, OnLineFunction onLineFunction, URI uRI) {
        DefaultOnlineResource defaultOnlineResource = new DefaultOnlineResource(uRI);
        defaultOnlineResource.setFunction(onLineFunction);
        defaultOnlineResource.freeze();
        return DefaultResponsibleParty.OGC(role, defaultOnlineResource);
    }

    static ResponsibleParty OGC(Role role, OnLineFunction onLineFunction, String string) {
        return DefaultResponsibleParty.OGC(role, onLineFunction, URI.create(string));
    }

    public DefaultResponsibleParty() {
    }

    public DefaultResponsibleParty(ResponsibleParty responsibleParty) {
        super(responsibleParty);
    }

    public DefaultResponsibleParty(Role role) {
        if (role != null) {
            this.setRole(role);
        }
    }

    public static DefaultResponsibleParty castOrCopy(ResponsibleParty responsibleParty) {
        return responsibleParty == null || responsibleParty instanceof DefaultResponsibleParty ? (DefaultResponsibleParty)responsibleParty : new DefaultResponsibleParty(responsibleParty);
    }

    @Override
    @XmlElement(name="individualName")
    public synchronized String getIndividualName() {
        return this.individualName;
    }

    public synchronized void setIndividualName(String string) {
        this.checkWritePermission();
        this.individualName = string;
    }

    @Override
    @XmlElement(name="organisationName")
    public synchronized InternationalString getOrganisationName() {
        return this.organisationName;
    }

    public synchronized void setOrganisationName(InternationalString internationalString) {
        this.checkWritePermission();
        this.organisationName = internationalString;
    }

    @Override
    @XmlElement(name="positionName")
    public synchronized InternationalString getPositionName() {
        return this.positionName;
    }

    public synchronized void setPositionName(InternationalString internationalString) {
        this.checkWritePermission();
        this.positionName = internationalString;
    }

    @Override
    @XmlElement(name="contactInfo")
    public synchronized Contact getContactInfo() {
        return this.contactInfo;
    }

    public synchronized void setContactInfo(Contact contact) {
        this.checkWritePermission();
        this.contactInfo = contact;
    }

    @Override
    @XmlElement(name="role", required=true)
    public synchronized Role getRole() {
        return this.role;
    }

    public synchronized void setRole(Role role) {
        this.checkWritePermission();
        this.role = role;
    }

    static {
        DefaultResponsibleParty defaultResponsibleParty = new DefaultResponsibleParty(Role.RESOURCE_PROVIDER);
        defaultResponsibleParty.setOrganisationName((InternationalString)new SimpleInternationalString("International Organization for Standardization"));
        defaultResponsibleParty.setContactInfo(DefaultContact.ISO);
        defaultResponsibleParty.freeze();
        ISO = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.RESOURCE_PROVIDER);
        defaultResponsibleParty.setOrganisationName((InternationalString)new SimpleInternationalString("Open Geospatial Consortium"));
        defaultResponsibleParty.setContactInfo(DefaultContact.OGC);
        defaultResponsibleParty.freeze();
        OGC = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.RESOURCE_PROVIDER);
        defaultResponsibleParty.setOrganisationName((InternationalString)new SimpleInternationalString("OpenGIS consortium"));
        defaultResponsibleParty.setContactInfo(DefaultContact.OPEN_GIS);
        defaultResponsibleParty.freeze();
        OPEN_GIS = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
        defaultResponsibleParty.setOrganisationName((InternationalString)new SimpleInternationalString("European Petroleum Survey Group"));
        defaultResponsibleParty.setContactInfo(DefaultContact.EPSG);
        defaultResponsibleParty.freeze();
        EPSG = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
        defaultResponsibleParty.setOrganisationName((InternationalString)new SimpleInternationalString("NETCDF"));
        defaultResponsibleParty.setContactInfo(DefaultContact.NETCDF);
        defaultResponsibleParty.freeze();
        NETCDF = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
        defaultResponsibleParty.setOrganisationName((InternationalString)new SimpleInternationalString("GeoTIFF"));
        defaultResponsibleParty.setContactInfo(DefaultContact.GEOTIFF);
        defaultResponsibleParty.freeze();
        GEOTIFF = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
        defaultResponsibleParty.setOrganisationName((InternationalString)new SimpleInternationalString("PROJ4"));
        defaultResponsibleParty.setContactInfo(DefaultContact.PROJ4);
        defaultResponsibleParty.freeze();
        PROJ4 = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.OWNER);
        defaultResponsibleParty.setOrganisationName((InternationalString)new SimpleInternationalString("ESRI"));
        defaultResponsibleParty.setContactInfo(DefaultContact.ESRI);
        defaultResponsibleParty.freeze();
        ESRI = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.OWNER);
        defaultResponsibleParty.setOrganisationName((InternationalString)new SimpleInternationalString("Oracle"));
        defaultResponsibleParty.setContactInfo(DefaultContact.ORACLE);
        defaultResponsibleParty.freeze();
        ORACLE = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
        defaultResponsibleParty.setOrganisationName((InternationalString)new SimpleInternationalString("PostGIS"));
        defaultResponsibleParty.setContactInfo(DefaultContact.POSTGIS);
        defaultResponsibleParty.freeze();
        POSTGIS = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
        defaultResponsibleParty.setOrganisationName((InternationalString)new SimpleInternationalString("Sun Microsystems"));
        defaultResponsibleParty.setContactInfo(DefaultContact.SUN_MICROSYSTEMS);
        defaultResponsibleParty.freeze();
        SUN_MICROSYSTEMS = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
        defaultResponsibleParty.setOrganisationName((InternationalString)new SimpleInternationalString("Geotoolkit.org"));
        defaultResponsibleParty.setContactInfo(DefaultContact.GEOTOOLKIT);
        defaultResponsibleParty.freeze();
        GEOTOOLKIT = defaultResponsibleParty;
        defaultResponsibleParty = new DefaultResponsibleParty(Role.PRINCIPAL_INVESTIGATOR);
        defaultResponsibleParty.setOrganisationName((InternationalString)new SimpleInternationalString("GeoTools"));
        defaultResponsibleParty.setContactInfo(DefaultContact.GEOTOOLS);
        defaultResponsibleParty.freeze();
        GEOTOOLS = defaultResponsibleParty;
    }
}

