/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.evpull.EmptyEventIterator;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.BooleanFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TailCallReturner;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class Choose
extends Instruction {
    private Expression[] conditions;
    private Expression[] actions;

    public Choose(Expression[] conditions, Expression[] actions) {
        this.conditions = conditions;
        this.actions = actions;
        if (conditions.length != actions.length) {
            throw new IllegalArgumentException("Choose: unequal length arguments");
        }
        for (int i = 0; i < conditions.length; ++i) {
            this.adoptChildExpression(conditions[i]);
            this.adoptChildExpression(actions[i]);
        }
    }

    public static Expression makeConditional(Expression condition, Expression thenExp, Expression elseExp) {
        if (Literal.isEmptySequence(elseExp)) {
            Expression[] conditions = new Expression[]{condition};
            Expression[] actions = new Expression[]{thenExp};
            return new Choose(conditions, actions);
        }
        Expression[] conditions = new Expression[]{condition, new Literal(BooleanValue.TRUE)};
        Expression[] actions = new Expression[]{thenExp, elseExp};
        return new Choose(conditions, actions);
    }

    public static Expression makeConditional(Expression condition, Expression thenExp) {
        Expression[] conditions = new Expression[]{condition};
        Expression[] actions = new Expression[]{thenExp};
        return new Choose(conditions, actions);
    }

    public static boolean isSingleBranchChoice(Expression exp) {
        return exp instanceof Choose && ((Choose)exp).conditions.length == 1;
    }

    public Expression[] getConditions() {
        return this.conditions;
    }

    public Expression[] getActions() {
        return this.actions;
    }

    public int getInstructionNameCode() {
        return this.conditions.length == 1 ? 150 : 135;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        Expression[] a;
        Expression[] c;
        int i;
        for (i = 0; i < this.conditions.length; ++i) {
            this.conditions[i] = visitor.simplify(this.conditions[i]);
            try {
                this.actions[i] = visitor.simplify(this.actions[i]);
                continue;
            }
            catch (XPathException err) {
                if (err.isTypeError()) {
                    throw err;
                }
                this.actions[i] = new ErrorExpression(err);
            }
        }
        for (i = 0; i < this.conditions.length; ++i) {
            if (!Literal.isConstantBoolean(this.conditions[i], false)) continue;
            if (this.conditions.length == 1) {
                return new Literal(EmptySequence.getInstance());
            }
            c = new Expression[this.conditions.length - 1];
            a = new Expression[this.conditions.length - 1];
            if (i != 0) {
                System.arraycopy(this.conditions, 0, c, 0, i);
                System.arraycopy(this.actions, 0, a, 0, i);
            }
            if (i != this.conditions.length) {
                System.arraycopy(this.conditions, i + 1, c, i, this.conditions.length - i - 1);
                System.arraycopy(this.actions, i + 1, a, i, this.actions.length - i - 1);
            }
            this.conditions = c;
            this.actions = a;
            --i;
        }
        for (i = 0; i < this.conditions.length - 1; ++i) {
            if (!Literal.isConstantBoolean(this.conditions[i], true)) continue;
            if (i == 0) {
                return this.actions[0];
            }
            c = new Expression[i + 1];
            a = new Expression[i + 1];
            System.arraycopy(this.conditions, 0, c, 0, i + 1);
            System.arraycopy(this.actions, 0, a, 0, i + 1);
            break;
        }
        if (this.conditions.length == 1 && Literal.isConstantBoolean(this.conditions[0], true)) {
            return this.actions[0];
        }
        if (Literal.isEmptySequence(this.actions[this.actions.length - 1])) {
            if (this.conditions.length == 1) {
                return new Literal(EmptySequence.getInstance());
            }
            Expression[] c2 = new Expression[this.conditions.length - 1];
            System.arraycopy(this.conditions, 0, c2, 0, this.conditions.length - 1);
            Expression[] a2 = new Expression[this.actions.length - 1];
            System.arraycopy(this.actions, 0, a2, 0, this.actions.length - 1);
        }
        if (Literal.isConstantBoolean(this.conditions[this.conditions.length - 1], true) && this.actions[this.actions.length - 1] instanceof Choose) {
            Choose choose2 = (Choose)this.actions[this.actions.length - 1];
            int newLen = this.conditions.length + choose2.conditions.length - 1;
            Expression[] c2 = new Expression[newLen];
            Expression[] a2 = new Expression[newLen];
            System.arraycopy(this.conditions, 0, c2, 0, this.conditions.length - 1);
            System.arraycopy(this.actions, 0, a2, 0, this.actions.length - 1);
            System.arraycopy(choose2.conditions, 0, c2, this.conditions.length - 1, choose2.conditions.length);
            System.arraycopy(choose2.actions, 0, a2, this.actions.length - 1, choose2.actions.length);
            this.conditions = c2;
            this.actions = a2;
        }
        if (this.conditions.length == 2 && Literal.isConstantBoolean(this.actions[0], true) && Literal.isConstantBoolean(this.actions[1], false) && Literal.isConstantBoolean(this.conditions[1], true)) {
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            if (th.isSubType(this.conditions[0].getItemType(th), BuiltInAtomicType.BOOLEAN) && this.conditions[0].getCardinality() == 16384) {
                return this.conditions[0];
            }
            return SystemFunction.makeSystemFunction("boolean", new Expression[]{this.conditions[0]});
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        int i;
        for (i = 0; i < this.conditions.length; ++i) {
            this.conditions[i] = visitor.typeCheck(this.conditions[i], contextItemType);
            XPathException err = TypeChecker.ebvError(this.conditions[i], visitor.getConfiguration().getTypeHierarchy());
            if (err == null) continue;
            err.setLocator(this.conditions[i]);
            throw err;
        }
        for (i = 0; i < this.actions.length; ++i) {
            try {
                this.actions[i] = visitor.typeCheck(this.actions[i], contextItemType);
                continue;
            }
            catch (XPathException err) {
                if (err.isTypeError()) {
                    throw err;
                }
                this.actions[i] = new ErrorExpression(err);
            }
        }
        return this.simplify(visitor);
    }

    public boolean implementsStaticTypeCheck() {
        return true;
    }

    public Expression staticTypeCheck(SequenceType req, boolean backwardsCompatible, RoleLocator role, ExpressionVisitor visitor) throws XPathException {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i] = TypeChecker.staticTypeCheck(this.actions[i], req, backwardsCompatible, role, visitor);
        }
        if (!Literal.isConstantBoolean(this.conditions[this.conditions.length - 1], true) && !Cardinality.allowsZero(req.getCardinality())) {
            String cond = this.conditions.length == 1 ? "the condition is not" : "none of the conditions is";
            XPathException err = new XPathException("Conditional expession: If " + cond + " satisfied, an empty sequence will be returned, " + "but this is not allowed as the " + role.getMessage());
            err.setErrorCode(role.getErrorCode());
            err.setIsTypeError(true);
            throw err;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        int i;
        for (i = 0; i < this.conditions.length; ++i) {
            boolean b;
            this.conditions[i] = visitor.optimize(this.conditions[i], contextItemType);
            Expression ebv = BooleanFn.rewriteEffectiveBooleanValue(this.conditions[i], visitor, contextItemType);
            if (ebv != null && ebv != this.conditions[i]) {
                this.conditions[i] = ebv;
                this.adoptChildExpression(ebv);
            }
            if (!(this.conditions[i] instanceof Literal) || ((Literal)this.conditions[i]).getValue() instanceof BooleanValue) continue;
            try {
                b = ((Literal)this.conditions[i]).getValue().effectiveBooleanValue();
            }
            catch (XPathException err) {
                err.setLocator(this);
                throw err;
            }
            this.conditions[i] = new Literal(BooleanValue.get(b));
        }
        for (i = 0; i < this.actions.length; ++i) {
            try {
                this.actions[i] = visitor.optimize(this.actions[i], contextItemType);
                continue;
            }
            catch (XPathException err) {
                if (err.isTypeError()) {
                    throw err;
                }
                this.actions[i] = new ErrorExpression(err);
            }
        }
        if (this.actions.length == 0) {
            return Literal.makeEmptySequence();
        }
        Expression e = visitor.getConfiguration().getOptimizer().trySwitch(this, visitor.getStaticContext());
        return e.simplify(visitor);
    }

    public Expression copy() {
        Expression[] c2 = new Expression[this.conditions.length];
        Expression[] a2 = new Expression[this.conditions.length];
        for (int c = 0; c < this.conditions.length; ++c) {
            c2[c] = this.conditions[c].copy();
            a2[c] = this.actions[c].copy();
        }
        return new Choose(c2, a2);
    }

    public int getImplementationMethod() {
        int m3 = 6;
        if (!Cardinality.allowsMany(this.getCardinality())) {
            m3 |= 1;
        }
        return m3;
    }

    public int markTailFunctionCalls(StructuredQName qName, int arity) {
        int result = 0;
        for (int i = 0; i < this.actions.length; ++i) {
            result = Math.max(result, this.actions[i].markTailFunctionCalls(qName, arity));
        }
        return result;
    }

    public ItemType getItemType(TypeHierarchy th) {
        ItemType type = this.actions[0].getItemType(th);
        for (int i = 1; i < this.actions.length; ++i) {
            type = Type.getCommonSuperType(type, this.actions[i].getItemType(th), th);
        }
        return type;
    }

    public int computeCardinality() {
        int card = 0;
        boolean includesTrue = false;
        for (int i = 0; i < this.actions.length; ++i) {
            card = Cardinality.union(card, this.actions[i].getCardinality());
            if (!Literal.isConstantBoolean(this.conditions[i], true)) continue;
            includesTrue = true;
        }
        if (!includesTrue) {
            card = Cardinality.union(card, 8192);
        }
        return card;
    }

    public int computeSpecialProperties() {
        int props = this.actions[0].getSpecialProperties();
        for (int i = 1; i < this.actions.length; ++i) {
            props &= this.actions[i].getSpecialProperties();
        }
        return props;
    }

    public final boolean createsNewNodes() {
        for (int i = 0; i < this.actions.length; ++i) {
            int props = this.actions[i].getSpecialProperties();
            if ((props & 0x400000) != 0) continue;
            return true;
        }
        return false;
    }

    public Iterator iterateSubExpressions() {
        int i;
        ArrayList<Expression> list = new ArrayList<Expression>(this.conditions.length + this.actions.length);
        for (i = 0; i < this.conditions.length; ++i) {
            list.add(this.conditions[i]);
        }
        for (i = 0; i < this.actions.length; ++i) {
            list.add(this.actions[i]);
        }
        return list.iterator();
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        int i;
        boolean found = false;
        for (i = 0; i < this.conditions.length; ++i) {
            if (this.conditions[i] != original) continue;
            this.conditions[i] = replacement;
            found = true;
        }
        for (i = 0; i < this.actions.length; ++i) {
            if (this.actions[i] != original) continue;
            this.actions[i] = replacement;
            found = true;
        }
        return found;
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
        if (offer.action == 13 || offer.action == 12 || offer.action == 14) {
            int i;
            for (i = 0; i < this.conditions.length; ++i) {
                this.conditions[i] = this.doPromotion(this.conditions[i], offer);
            }
            for (i = 0; i < this.actions.length; ++i) {
                this.actions[i] = this.doPromotion(this.actions[i], offer);
            }
        } else {
            this.conditions[0] = this.doPromotion(this.conditions[0], offer);
        }
    }

    public void checkPermittedContents(SchemaType parentType, StaticContext env, boolean whole) throws XPathException {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].checkPermittedContents(parentType, env, whole);
        }
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        for (int i = 0; i < this.conditions.length; ++i) {
            this.conditions[i].addToPathMap(pathMap, pathMapNodeSet);
        }
        PathMap.PathMapNodeSet result = new PathMap.PathMapNodeSet();
        for (int i = 0; i < this.actions.length; ++i) {
            PathMap.PathMapNodeSet temp = this.actions[i].addToPathMap(pathMap, pathMapNodeSet);
            result.addNodeSet(temp);
        }
        return result;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("choose");
        for (int i = 0; i < this.conditions.length; ++i) {
            out.startSubsidiaryElement("when");
            this.conditions[i].explain(out);
            out.endSubsidiaryElement();
            out.startSubsidiaryElement("then");
            this.actions[i].explain(out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            boolean b;
            try {
                b = this.conditions[i].effectiveBooleanValue(context);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.conditions[i]);
                throw e;
            }
            if (!b) continue;
            if (this.actions[i] instanceof TailCallReturner) {
                return ((TailCallReturner)((Object)this.actions[i])).processLeavingTail(context);
            }
            this.actions[i].process(context);
            return null;
        }
        return null;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            boolean b;
            try {
                b = this.conditions[i].effectiveBooleanValue(context);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this);
                throw e;
            }
            if (!b) continue;
            return this.actions[i].evaluateItem(context);
        }
        return null;
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            boolean b;
            try {
                b = this.conditions[i].effectiveBooleanValue(context);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this);
                throw e;
            }
            if (!b) continue;
            return this.actions[i].iterate(context);
        }
        return EmptyIterator.getInstance();
    }

    public EventIterator iterateEvents(XPathContext context) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            boolean b;
            try {
                b = this.conditions[i].effectiveBooleanValue(context);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this);
                throw e;
            }
            if (!b) continue;
            return this.actions[i].iterateEvents(context);
        }
        return EmptyEventIterator.getInstance();
    }
}

