/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.derby.iapi.error.ShutdownException;
import org.apache.derby.iapi.services.i18n.BundleFinder;

public final class MessageService {
    private static final Locale EN = new Locale("en", "US");
    private static BundleFinder finder;

    private MessageService() {
    }

    public static ResourceBundle getBundleForLocale(Locale locale, String string) {
        try {
            return MessageService.getBundleWithEnDefault("org.apache.derby.loc.m" + MessageService.hashString50(string), locale);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static void setFinder(BundleFinder bundleFinder) {
        finder = bundleFinder;
    }

    public static String getTextMessage(String string) {
        return MessageService.getCompleteMessage(string, null);
    }

    public static String getTextMessage(String string, Object object) {
        return MessageService.getCompleteMessage(string, new Object[]{object});
    }

    public static String getTextMessage(String string, Object object, Object object2) {
        return MessageService.getCompleteMessage(string, new Object[]{object, object2});
    }

    public static String getTextMessage(String string, Object object, Object object2, Object object3) {
        return MessageService.getCompleteMessage(string, new Object[]{object, object2, object3});
    }

    public static String getTextMessage(String string, Object object, Object object2, Object object3, Object object4) {
        return MessageService.getCompleteMessage(string, new Object[]{object, object2, object3, object4});
    }

    public static String getTextMessage(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        return MessageService.getCompleteMessage(string, new Object[]{object, object2, object3, object4, object5});
    }

    public static String getTextMessage(String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14) {
        return MessageService.getCompleteMessage(string, new Object[]{object, object2, object3, object4, object5, object6, object7, object8, object9, object10, object11, object12, object13, object14});
    }

    public static String getCompleteMessage(String string, Object[] objectArray) {
        try {
            return MessageService.formatMessage(MessageService.getBundle(string), string, objectArray, true);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        return MessageService.formatMessage(MessageService.getBundleForLocale(EN, string), string, objectArray, false);
    }

    public static void getLocalizedMessage(int n, short s2, String string, String string2, int n2, int n3, int n4, int n5, int n6, int n7, String string3, String string4, String string5, String string6, String[] stringArray, int[] nArray) {
        Object object;
        Object[] objectArray;
        int n8 = string6.indexOf("_");
        Locale locale = EN;
        if (n8 != -1) {
            int n9 = string6.lastIndexOf("_");
            objectArray = string6.substring(0, n8);
            if (n9 == n8) {
                object = string6.substring(n8 + 1);
                locale = new Locale((String)objectArray, (String)object);
            } else {
                object = string6.substring(n8 + 1, n9);
                String string7 = string6.substring(n9 + 1);
                locale = new Locale((String)objectArray, (String)object, string7);
            }
        }
        String string8 = string4;
        objectArray = null;
        if (string != null && string.length() > 0) {
            int n10;
            object = string.toCharArray();
            int n11 = 0;
            int n12 = -1;
            for (n10 = 0; n10 < ((char[])object).length; ++n10) {
                if (object[n10] != '\u0014') continue;
                ++n11;
                n12 = n10;
            }
            if (n11 == 0) {
                string8 = new String((char[])object);
            } else {
                string8 = new String((char[])object, n12 + 1, ((char[])object).length - n12 - 1);
                objectArray = new Object[n11];
                n10 = 0;
                int n13 = 0;
                for (int i = 0; i < n12 + 1; ++i) {
                    if (i != n12 && object[i] != '\u0014') continue;
                    objectArray[n13++] = new String((char[])object, n10, i - n10);
                    n10 = i + 1;
                }
            }
        }
        try {
            stringArray[0] = MessageService.formatMessage(MessageService.getBundleForLocale(locale, string8), string8, objectArray, true);
            nArray[0] = 0;
            return;
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        stringArray[0] = MessageService.formatMessage(MessageService.getBundleForLocale(EN, string8), string8, objectArray, false);
        nArray[0] = 0;
    }

    public static String getLocalizedMessage(Locale locale, String string, Object[] objectArray) {
        String string2 = null;
        try {
            string2 = MessageService.formatMessage(MessageService.getBundleForLocale(locale, string), string, objectArray, true);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        string2 = MessageService.formatMessage(MessageService.getBundleForLocale(EN, string), string, objectArray, false);
        return string2;
    }

    public static String getProperty(String string, String string2) {
        ResourceBundle resourceBundle = MessageService.getBundle(string);
        try {
            if (resourceBundle != null) {
                return resourceBundle.getString(string.concat(".").concat(string2));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    public static String formatMessage(ResourceBundle resourceBundle, String string, Object[] objectArray, boolean bl) {
        block12: {
            if (objectArray == null) {
                objectArray = new Object[]{};
            }
            if (resourceBundle != null) {
                try {
                    string = resourceBundle.getString(string);
                    try {
                        return MessageFormat.format(string, objectArray);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    if (!bl) break block12;
                    throw missingResourceException;
                }
            }
        }
        if (string == null) {
            string = "UNKNOWN";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = objectArray.length;
        if (n > 0) {
            stringBuffer.append(" : ");
        }
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append('[');
            stringBuffer.append(i);
            stringBuffer.append("] ");
            if (objectArray[i] == null) {
                stringBuffer.append("null");
                continue;
            }
            stringBuffer.append(objectArray[i].toString());
        }
        return stringBuffer.toString();
    }

    private static ResourceBundle getBundle(String string) {
        ResourceBundle resourceBundle = null;
        if (finder != null) {
            resourceBundle = finder.getBundle(string);
        }
        if (resourceBundle == null) {
            resourceBundle = MessageService.getBundleForLocale(Locale.getDefault(), string);
        }
        return resourceBundle;
    }

    public static ResourceBundle getBundleWithEnDefault(String string, Locale locale) {
        try {
            return ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            return ResourceBundle.getBundle(string, EN);
        }
    }

    public static int hashString50(String string) {
        int n = 0;
        int n2 = string.length();
        if (n2 > 5) {
            n2 = 5;
        }
        for (int i = 0; i < n2; ++i) {
            n += string.charAt(i);
        }
        return n %= 50;
    }
}

