/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.AggregateAliasInfo;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.catalog.types.UDTAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.IdUtil;

public final class AliasDescriptor
extends TupleDescriptor
implements PrivilegedSQLObject,
Provider,
Dependent {
    private final UUID aliasID;
    private final String aliasName;
    private final UUID schemaID;
    private final String javaClassName;
    private final char aliasType;
    private final char nameSpace;
    private final boolean systemAlias;
    private final AliasInfo aliasInfo;
    private final String specificName;
    private final SchemaDescriptor schemaDescriptor;

    public AliasDescriptor(DataDictionary dataDictionary, UUID uUID, String string, UUID uUID2, String string2, char c, char c2, boolean bl, AliasInfo aliasInfo, String string3) throws StandardException {
        super(dataDictionary);
        this.aliasID = uUID;
        this.aliasName = string;
        this.schemaID = uUID2;
        this.schemaDescriptor = dataDictionary.getSchemaDescriptor(uUID2, null);
        this.javaClassName = string2;
        this.aliasType = c;
        this.nameSpace = c2;
        this.systemAlias = bl;
        this.aliasInfo = aliasInfo;
        if (string3 == null) {
            string3 = dataDictionary.getSystemSQLName();
        }
        this.specificName = string3;
    }

    public UUID getUUID() {
        return this.aliasID;
    }

    public String getObjectTypeName() {
        if (this.aliasInfo instanceof UDTAliasInfo) {
            return "TYPE";
        }
        if (this.aliasInfo instanceof AggregateAliasInfo) {
            return "DERBY AGGREGATE";
        }
        return null;
    }

    public UUID getSchemaUUID() {
        return this.schemaID;
    }

    public final SchemaDescriptor getSchemaDescriptor() {
        return this.schemaDescriptor;
    }

    public final String getName() {
        return this.aliasName;
    }

    public String getSchemaName() {
        return this.schemaDescriptor.getSchemaName();
    }

    public String getQualifiedName() {
        return IdUtil.mkQualifiedName(this.getSchemaName(), this.aliasName);
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public char getAliasType() {
        return this.aliasType;
    }

    public char getNameSpace() {
        return this.nameSpace;
    }

    public boolean getSystemAlias() {
        return this.systemAlias;
    }

    public AliasInfo getAliasInfo() {
        return this.aliasInfo;
    }

    public String toString() {
        return "";
    }

    public boolean equals(Object object) {
        if (!(object instanceof AliasDescriptor)) {
            return false;
        }
        AliasDescriptor aliasDescriptor = (AliasDescriptor)object;
        return this.aliasID.equals(aliasDescriptor.getUUID());
    }

    public int hashCode() {
        return this.aliasID.hashCode();
    }

    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(136);
    }

    public String getObjectName() {
        return this.aliasName;
    }

    public UUID getObjectID() {
        return this.aliasID;
    }

    public String getClassType() {
        return "Alias";
    }

    public String getDescriptorType() {
        return AliasDescriptor.getAliasType(this.aliasType);
    }

    public static final String getAliasType(char c) {
        switch (c) {
            case 'P': {
                return "PROCEDURE";
            }
            case 'F': {
                return "FUNCTION";
            }
            case 'S': {
                return "SYNONYM";
            }
            case 'A': {
                return "TYPE";
            }
            case 'G': {
                return "DERBY AGGREGATE";
            }
        }
        return null;
    }

    public String getDescriptorName() {
        return this.aliasName;
    }

    public String getSpecificName() {
        return this.specificName;
    }

    public boolean isPersistent() {
        return !this.getSchemaUUID().toString().equals("c013800d-00fb-2642-07ec-000000134f30");
    }

    public boolean isTableFunction() {
        if (this.getAliasType() != 'F') {
            return false;
        }
        RoutineAliasInfo routineAliasInfo = (RoutineAliasInfo)this.getAliasInfo();
        return routineAliasInfo.getReturnType().isRowMultiSet();
    }

    public void drop(LanguageConnectionContext languageConnectionContext) throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        int n = 0;
        switch (this.getAliasType()) {
            case 'F': 
            case 'P': {
                n = 6;
                break;
            }
            case 'S': {
                n = 43;
                break;
            }
            case 'A': {
                n = 50;
                break;
            }
            case 'G': {
                n = 51;
            }
        }
        dependencyManager.invalidateFor(this, n, languageConnectionContext);
        if (this.getAliasType() == 'S') {
            SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.schemaID, transactionController);
            DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
            TableDescriptor tableDescriptor = dataDescriptorGenerator.newTableDescriptor(this.aliasName, schemaDescriptor, 4, 'R');
            dataDictionary.dropTableDescriptor(tableDescriptor, schemaDescriptor, transactionController);
        } else {
            dataDictionary.dropAllRoutinePermDescriptors(this.getUUID(), transactionController);
        }
        dataDictionary.dropAliasDescriptor(this, transactionController);
    }

    public synchronized boolean isValid() {
        return true;
    }

    public void prepareToInvalidate(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
        switch (n) {
            default: 
        }
        throw StandardException.newException("X0Y30.S", (Object)dependencyManager.getActionString(n), (Object)provider.getObjectName(), (Object)this.getQualifiedName());
    }

    public void makeInvalid(int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
    }
}

