/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLDecimal;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedPreparedStatement;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.Util;

public class EmbedCallableStatement
extends EmbedPreparedStatement
implements CallableStatement {
    private boolean hasReturnOutputParameter;
    protected boolean wasNull;

    public EmbedCallableStatement(EmbedConnection embedConnection, String string, int n, int n2, int n3) throws SQLException {
        super(embedConnection, string, false, n, n2, n3, 2, null, null);
        ParameterValueSet parameterValueSet = this.getParms();
        this.hasReturnOutputParameter = parameterValueSet.hasReturnOutputParameter();
    }

    protected void checkRequiresCallableStatement(Activation activation) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean executeStatement(Activation activation, boolean bl, boolean bl2) throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.wasNull = false;
            try {
                this.getParms().validate();
            }
            catch (StandardException standardException) {
                throw EmbedResultSet.noStateChangeException(standardException);
            }
            boolean bl3 = super.executeStatement(activation, bl, bl2 && !this.hasReturnOutputParameter);
            ParameterValueSet parameterValueSet = this.getParms();
            if (this.hasReturnOutputParameter) {
                boolean bl4 = this.results.next();
                try {
                    DataValueDescriptor dataValueDescriptor = parameterValueSet.getReturnValueForSet();
                    dataValueDescriptor.setValueFromResultSet(this.results, 1, true);
                }
                catch (StandardException standardException) {
                    throw EmbedResultSet.noStateChangeException(standardException);
                }
                finally {
                    this.results.close();
                    this.results = null;
                }
                bl3 = false;
            }
            return bl3;
        }
    }

    public final void registerOutParameter(int n, int n2) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().registerOutParameter(n - 1, n2, -1);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.checkStatus();
        if (n3 < 0) {
            throw this.newSQLException("XJ044.S", new Integer(n3));
        }
        try {
            this.getParms().registerOutParameter(n - 1, n2, n3);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.registerOutParameter(n, n2);
    }

    public boolean wasNull() throws SQLException {
        this.checkStatus();
        return this.wasNull;
    }

    public String getString(int n) throws SQLException {
        this.checkStatus();
        try {
            String string = this.getParms().getParameterForGet(n - 1).getString();
            this.wasNull = string == null;
            return string;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
            boolean bl = dataValueDescriptor.getBoolean();
            this.wasNull = !bl && dataValueDescriptor.isNull();
            return bl;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public byte getByte(int n) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
            byte by = dataValueDescriptor.getByte();
            this.wasNull = by == 0 && dataValueDescriptor.isNull();
            return by;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public short getShort(int n) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
            short s2 = dataValueDescriptor.getShort();
            this.wasNull = s2 == 0 && dataValueDescriptor.isNull();
            return s2;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public int getInt(int n) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
            int n2 = dataValueDescriptor.getInt();
            this.wasNull = n2 == 0 && dataValueDescriptor.isNull();
            return n2;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public long getLong(int n) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
            long l = dataValueDescriptor.getLong();
            this.wasNull = l == 0L && dataValueDescriptor.isNull();
            return l;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            return SQLDecimal.getBigDecimal(dataValueDescriptor);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public final BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n2, 5);
        }
        return bigDecimal;
    }

    public float getFloat(int n) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
            float f = dataValueDescriptor.getFloat();
            this.wasNull = (double)f == 0.0 && dataValueDescriptor.isNull();
            return f;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public double getDouble(int n) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dataValueDescriptor = this.getParms().getParameterForGet(n - 1);
            double d = dataValueDescriptor.getDouble();
            this.wasNull = d == 0.0 && dataValueDescriptor.isNull();
            return d;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public byte[] getBytes(int n) throws SQLException {
        this.checkStatus();
        try {
            byte[] byArray = this.getParms().getParameterForGet(n - 1).getBytes();
            this.wasNull = byArray == null;
            return byArray;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.checkStatus();
        try {
            Date date = this.getParms().getParameterForGet(n - 1).getDate(calendar);
            this.wasNull = date == null;
            return date;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.checkStatus();
        try {
            Time time = this.getParms().getParameterForGet(n - 1).getTime(calendar);
            this.wasNull = time == null;
            return time;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.checkStatus();
        try {
            Timestamp timestamp = this.getParms().getParameterForGet(n - 1).getTimestamp(calendar);
            this.wasNull = timestamp == null;
            return timestamp;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public Date getDate(int n) throws SQLException {
        return this.getDate(n, this.getCal());
    }

    public Time getTime(int n) throws SQLException {
        return this.getTime(n, this.getCal());
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, this.getCal());
    }

    public final Object getObject(int n) throws SQLException {
        this.checkStatus();
        try {
            Object object = this.getParms().getParameterForGet(n - 1).getObject();
            this.wasNull = object == null;
            return object;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    public URL getURL(int n) throws SQLException {
        throw Util.notImplemented();
    }

    public void setURL(String string, URL uRL) throws SQLException {
        throw Util.notImplemented();
    }

    public URL getURL(String string) throws SQLException {
        throw Util.notImplemented();
    }

    public Blob getBlob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null || object instanceof Blob) {
            return (Blob)object;
        }
        throw this.newSQLException("22005", Blob.class.getName(), Util.typeName(this.getParameterJDBCType(n)));
    }

    public Clob getClob(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null || object instanceof Clob) {
            return (Clob)object;
        }
        throw this.newSQLException("22005", Clob.class.getName(), Util.typeName(this.getParameterJDBCType(n)));
    }

    public void addBatch() throws SQLException {
        this.checkStatus();
        ParameterValueSet parameterValueSet = this.getParms();
        int n = parameterValueSet.getParameterCount();
        block4: for (int i = 1; i <= n; ++i) {
            switch (parameterValueSet.getParameterMode(i)) {
                case 0: 
                case 1: {
                    continue block4;
                }
                case 2: 
                case 4: {
                    throw this.newSQLException("XJ04C.S");
                }
            }
        }
        super.addBatch();
    }
}

