/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.impl.services.monitor.BaseMonitor;

public final class FileMonitor
extends BaseMonitor {
    private File home;
    private ProductVersionHolder engineVersion;

    public FileMonitor() {
        this.initialize(true);
        this.applicationProperties = this.readApplicationProperties();
    }

    public FileMonitor(Properties properties, PrintWriter printWriter) {
        this.runWithState(properties, printWriter);
    }

    private InputStream PBapplicationPropertiesStream() throws IOException {
        File file = FileUtil.newFile(this.home, "derby.properties");
        if (!file.exists()) {
            return null;
        }
        return new FileInputStream(file);
    }

    public Object getEnvironment() {
        return this.home;
    }

    private static ThreadGroup createDaemonGroup() {
        try {
            ThreadGroup threadGroup = new ThreadGroup("derby.daemons");
            threadGroup.setDaemon(true);
            return threadGroup;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    private boolean PBinitialize(boolean bl) {
        String string;
        if (!bl) {
            this.daemonGroup = FileMonitor.createDaemonGroup();
        }
        InputStream inputStream = this.getClass().getResourceAsStream("/org/apache/derby/info/DBMS.properties");
        this.engineVersion = ProductVersionHolder.getProductVersionHolderFromMyEnv(inputStream);
        try {
            string = System.getProperty("derby.system.home");
        }
        catch (SecurityException securityException) {
            string = null;
        }
        if (string != null) {
            this.home = new File(string);
            if (this.home.exists()) {
                if (!this.home.isDirectory()) {
                    this.report("derby.system.home=" + string + " does not represent a directory");
                    return false;
                }
            } else if (!bl) {
                boolean bl2 = false;
                try {
                    bl2 = this.home.mkdir() || this.home.mkdirs();
                }
                catch (SecurityException securityException) {
                    return false;
                }
                if (bl2) {
                    FileUtil.limitAccessToOwner(this.home);
                }
            }
        }
        return true;
    }

    private String PBgetJVMProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    final boolean initialize(final boolean bl) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return FileMonitor.this.PBinitialize(bl);
            }
        });
    }

    final Properties getDefaultModuleProperties() {
        return (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return FileMonitor.super.getDefaultModuleProperties();
            }
        });
    }

    public final String getJVMProperty(final String string) {
        if (!string.startsWith("derby.")) {
            return this.PBgetJVMProperty(string);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return FileMonitor.this.PBgetJVMProperty(string);
            }
        });
    }

    public final synchronized Thread getDaemonThread(final Runnable runnable, final String string, final boolean bl) {
        return (Thread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return FileMonitor.super.getDaemonThread(runnable, string, bl);
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    if (FileMonitor.this.daemonGroup != null && FileMonitor.this.daemonGroup.isDestroyed()) {
                        FileMonitor.this.daemonGroup = FileMonitor.createDaemonGroup();
                        return FileMonitor.super.getDaemonThread(runnable, string, bl);
                    }
                    throw illegalThreadStateException;
                }
            }
        });
    }

    public final void setThreadPriority(final int n) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FileMonitor.super.setThreadPriority(n);
                return null;
            }
        });
    }

    final InputStream applicationPropertiesStream() throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return FileMonitor.this.PBapplicationPropertiesStream();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    public final ProductVersionHolder getEngineVersion() {
        return this.engineVersion;
    }
}

