/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry.complex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.geotoolkit.geometry.isoonjts.JTSUtils;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.AbstractJTSGeometry;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.JTSGeometry;
import org.geotoolkit.internal.jaxb.GeometryAdapter;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.complex.Complex;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class JTSComplex<T extends Geometry>
extends AbstractJTSGeometry
implements Complex {
    @XmlElement(name="curveMember", namespace="http://www.opengis.net/gml")
    @XmlJavaTypeAdapter(value=GeometryAdapter.class)
    private List<T> elements = new ArrayList<T>(){

        @Override
        public boolean add(T o) {
            JTSComplex.this.invalidateCachedJTSPeer();
            return super.add(o);
        }

        @Override
        public boolean remove(Object o) {
            JTSComplex.this.invalidateCachedJTSPeer();
            return super.remove(o);
        }
    };
    protected Set setViewOfElements = JTSComplex.listAsSet(this.elements);
    private Set subComplexes = new HashSet();

    public JTSComplex() {
        this(null);
    }

    public JTSComplex(CoordinateReferenceSystem crs) {
        super(crs);
    }

    protected List<T> getElementList() {
        return this.elements;
    }

    @Override
    public final boolean isMaximal() {
        return false;
    }

    @Override
    public final Complex[] getSuperComplexes() {
        return null;
    }

    @Override
    public final Complex[] getSubComplexes() {
        Complex[] result = new Complex[this.subComplexes.size()];
        this.subComplexes.toArray(result);
        return result;
    }

    public final Set getSubComplexSet() {
        return this.subComplexes;
    }

    public final Collection<Primitive> getElements() {
        return this.setViewOfElements;
    }

    @Override
    protected final com.vividsolutions.jts.geom.Geometry computeJTSPeer() {
        ArrayList<com.vividsolutions.jts.geom.Geometry> subParts = new ArrayList<com.vividsolutions.jts.geom.Geometry>();
        for (JTSGeometry prim : this.elements) {
            subParts.add(prim.getJTSGeometry());
        }
        return JTSUtils.GEOMETRY_FACTORY.buildGeometry(subParts);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("elements:").append('\n');
        for (Geometry g2 : this.elements) {
            sb.append(g2).append('\n');
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof JTSComplex && super.equals(object)) {
            JTSComplex that = (JTSComplex)object;
            return Utilities.equals(this.elements, that.elements);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 59 * hash + (this.elements != null ? ((Object)this.elements).hashCode() : 0);
        return hash;
    }
}

