/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.gml.xml.FeatureCollection;
import org.geotoolkit.gml.xml.v311.AbstractFeatureType;
import org.geotoolkit.gml.xml.v311.BoundingShapeType;
import org.geotoolkit.gml.xml.v311.DirectPositionType;
import org.geotoolkit.gml.xml.v311.EnvelopeType;
import org.geotoolkit.gml.xml.v311.FeatureArrayPropertyType;
import org.geotoolkit.gml.xml.v311.FeatureCollectionType;
import org.geotoolkit.gml.xml.v311.FeaturePropertyType;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractFeatureCollectionType", propOrder={"featureMember", "featureMembers"})
@XmlSeeAlso(value={FeatureCollectionType.class})
public abstract class AbstractFeatureCollectionType
extends AbstractFeatureType
implements FeatureCollection {
    private List<FeaturePropertyType> featureMember;
    private FeatureArrayPropertyType featureMembers;

    public AbstractFeatureCollectionType() {
    }

    public AbstractFeatureCollectionType(String id) {
        super(id, null, null);
    }

    public AbstractFeatureCollectionType(String id, String name, String description, List<FeaturePropertyType> featureMember) {
        super(id, name, description);
        this.featureMember = featureMember;
    }

    public List<FeaturePropertyType> getFeatureMember() {
        if (this.featureMember == null) {
            this.featureMember = new ArrayList<FeaturePropertyType>();
        }
        return this.featureMember;
    }

    public void addFeatureMember(FeaturePropertyType feature) {
        if (this.featureMember == null) {
            this.featureMember = new ArrayList<FeaturePropertyType>();
        }
        this.featureMember.add(feature);
    }

    public boolean containsFeature(String featureId) {
        if (this.featureMember != null) {
            for (FeaturePropertyType feat : this.featureMember) {
                if (feat.getHref() == null || !feat.getHref().equals(featureId)) continue;
                return true;
            }
        }
        return false;
    }

    public FeatureArrayPropertyType getFeatureMembers() {
        return this.featureMembers;
    }

    public void setFeatureMembers(FeatureArrayPropertyType value) {
        this.featureMembers = value;
    }

    @Override
    public void computeBounds() {
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double maxx = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        for (FeaturePropertyType memberProp : this.featureMember) {
            BoundingShapeType bound;
            AbstractFeatureType member = memberProp.getAbstractFeature();
            if (member == null || (bound = member.getBoundedBy()) == null || bound.getEnvelope() == null) continue;
            if (bound.getEnvelope().getLowerCorner() != null && bound.getEnvelope().getLowerCorner().getValue() != null && bound.getEnvelope().getLowerCorner().getValue().size() > 1) {
                List<Double> lower = bound.getEnvelope().getLowerCorner().getValue();
                if (lower.get(0) < minx) {
                    minx = lower.get(0);
                }
                if (lower.get(1) < miny) {
                    miny = lower.get(1);
                }
            }
            if (bound.getEnvelope().getUpperCorner() == null || bound.getEnvelope().getUpperCorner().getValue() == null || bound.getEnvelope().getUpperCorner().getValue().size() <= 1) continue;
            List<Double> upper = bound.getEnvelope().getUpperCorner().getValue();
            if (upper.get(0) > maxx) {
                maxx = upper.get(0);
            }
            if (!(upper.get(1) > maxy)) continue;
            maxy = upper.get(1);
        }
        if (minx == Double.MAX_VALUE) {
            minx = -180.0;
        }
        if (miny == Double.MAX_VALUE) {
            miny = -90.0;
        }
        if (maxx == -1.7976931348623157E308) {
            maxx = 180.0;
        }
        if (maxy == -1.7976931348623157E308) {
            maxy = 90.0;
        }
        EnvelopeType env = new EnvelopeType(null, new DirectPositionType(minx, miny), new DirectPositionType(maxx, maxy), "EPSG:4326");
        env.setSrsDimension(2);
        env.setAxisLabels("Y X");
        this.setBoundedBy(new BoundingShapeType(env));
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractFeatureCollectionType && super.equals(object, mode)) {
            AbstractFeatureCollectionType that = (AbstractFeatureCollectionType)object;
            return Utilities.equals(this.featureMember, that.featureMember) && Utilities.equals(this.featureMembers, that.featureMembers);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (this.featureMember != null ? ((Object)this.featureMember).hashCode() : 0);
        hash = 23 * hash + (this.featureMembers != null ? this.featureMembers.hashCode() : 0);
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder(super.toString());
        if (this.featureMember != null && this.featureMember.size() > 0) {
            s2.append("featureMember:").append('\n');
            for (FeaturePropertyType fp : this.featureMember) {
                s2.append(fp).append('\n');
            }
        }
        if (this.featureMembers != null) {
            s2.append("featureMembers:").append(this.featureMembers).append('\n');
        }
        return s2.toString();
    }
}

